/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.adapt.com.bitzi.util;

import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Vector;
import jonelo.jacksum.JacksumAPI;
import jonelo.jacksum.algorithm.AbstractChecksum;

public class TigerTree
extends MessageDigest {
    private static final int BLOCKSIZE = 1024;
    private static final int HASHSIZE = 24;
    private final byte[] buffer = new byte[1024];
    private int bufferOffset = 0;
    private long byteCount = 0L;
    private AbstractChecksum tiger;
    private Vector nodes;

    public TigerTree(String string) throws NoSuchAlgorithmException {
        super(string);
        this.tiger = JacksumAPI.getChecksumInstance(string);
        this.nodes = new Vector();
    }

    protected int engineGetDigestLength() {
        return 24;
    }

    protected void engineUpdate(byte by) {
        ++this.byteCount;
        this.buffer[this.bufferOffset++] = by;
        if (this.bufferOffset == 1024) {
            this.blockUpdate();
            this.bufferOffset = 0;
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        this.byteCount += (long)n2;
        while (n2 >= (n3 = 1024 - this.bufferOffset)) {
            System.arraycopy(byArray, n, this.buffer, this.bufferOffset, n3);
            this.bufferOffset += n3;
            this.blockUpdate();
            n2 -= n3;
            n += n3;
            this.bufferOffset = 0;
        }
        System.arraycopy(byArray, n, this.buffer, this.bufferOffset, n2);
        this.bufferOffset += n2;
    }

    protected byte[] engineDigest() {
        byte[] byArray = new byte[24];
        try {
            this.engineDigest(byArray, 0, 24);
        }
        catch (DigestException digestException) {
            return null;
        }
        return byArray;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < 24) {
            throw new DigestException();
        }
        this.blockUpdate();
        while (this.nodes.size() > 1) {
            Vector<byte[]> vector = new Vector<byte[]>();
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                byte[] byArray2 = (byte[])enumeration.nextElement();
                if (enumeration.hasMoreElements()) {
                    byte[] byArray3 = (byte[])enumeration.nextElement();
                    this.tiger.reset();
                    this.tiger.update((byte)1);
                    this.tiger.update(byArray2);
                    this.tiger.update(byArray3);
                    vector.addElement(this.tiger.getByteArray());
                    continue;
                }
                vector.addElement(byArray2);
            }
            this.nodes = vector;
        }
        System.arraycopy(this.nodes.elementAt(0), 0, byArray, n, 24);
        this.engineReset();
        return 24;
    }

    protected void engineReset() {
        this.bufferOffset = 0;
        this.byteCount = 0L;
        this.nodes = new Vector();
        this.tiger.reset();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void blockUpdate() {
        this.tiger.reset();
        this.tiger.update((byte)0);
        this.tiger.update(this.buffer, 0, this.bufferOffset);
        if (this.bufferOffset == 0 && this.nodes.size() > 0) {
            return;
        }
        this.nodes.addElement(this.tiger.getByteArray());
    }
}

