package CParse::ParameterDeclaration;

use 5.6.0;
use strict;
use warnings;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;
    my $specifiers = shift;
    my $declarator = shift;
    my $self = {specifiers => $specifiers,
                declarator => $declarator,
               };
    bless $self, $class;
    return $self;
  }

sub specifiers
  {
    my $self = shift;
    return $self->{specifiers};
  }

sub dump_c
  {
    my $self = shift;

    my $str = join(' ', map {$_->dump_c} @{$self->{specifiers}});
    if (defined $self->{declarator})
      {
        $str .= " " if length $str;
        $str .= $self->{declarator}->dump_c;
      }

    return $str;
  }

sub get_type
  {
    my $self = shift;

    my $namespace = shift;

    my $storage_class;
    my @attributes;
    my @specifiers;

    foreach my $specifier (@{$self->{specifiers}})
      {
        if ($specifier->isa('CParse::StorageClass'))
          {
            if ($storage_class)
              {
                die "multiple storage class specifiers\n";
              }
            $storage_class = $specifier;
          }
        elsif ($specifier->isa('CParse::AttributeList'))
          {
            push @attributes, $specifier->attributes;
          }
        else
          {
            push @specifiers, $specifier;
          }
      }

    if ($storage_class and $storage_class->class ne 'register')
      {
        die "parameter declarations cannot have a storage class other than 'register'\n";
      }

    my $type = $self->{declarator}->get_decl_type($namespace, \@specifiers, \@attributes, 1);
    return $type;
  }

sub get_identifier
  {
    my $self = shift;
    return $self->{declarator}->get_identifier;
  }

1;
