/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class MapConstraintsTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testConstrainedBiMapIllegal() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testConstrainedBiMapIllegal();
}

public void testConstrainedBiMapLegal() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testConstrainedBiMapLegal();
}

public void testConstrainedMapIllegal() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testConstrainedMapIllegal();
}

public void testConstrainedMapLegal() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testConstrainedMapLegal();
}

public void testConstrainedMultimapIllegal() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testConstrainedMultimapIllegal();
}

public void testConstrainedMultimapLegal() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testConstrainedMultimapLegal();
}

public void testConstrainedMultimapQueue() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testConstrainedMultimapQueue();
}

public void testConstrainedTypePreservingList() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testConstrainedTypePreservingList();
}

public void testConstrainedTypePreservingRandomAccessList() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testConstrainedTypePreservingRandomAccessList();
}

public void testConstrainedTypePreservingSet() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testConstrainedTypePreservingSet();
}

public void testConstrainedTypePreservingSortedSet() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testConstrainedTypePreservingSortedSet();
}

public void testMapEntrySetContainsNefariousEntry() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testMapEntrySetContainsNefariousEntry();
}

public void testMapEntrySetToArray() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testMapEntrySetToArray();
}

public void testMultimapAsMapEntriesContainsNefariousEntry() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testMultimapAsMapEntriesContainsNefariousEntry();
}

public void testMultimapAsMapEntriesRemoveNefariousEntry() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testMultimapAsMapEntriesRemoveNefariousEntry();
}

public void testMultimapAsMapEntriesToArray() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testMultimapAsMapEntriesToArray();
}

public void testMultimapAsMapValuesToArray() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testMultimapAsMapValuesToArray();
}

public void testMultimapEntriesContainsNefariousEntry() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testMultimapEntriesContainsNefariousEntry();
}

public void testMultimapEntriesRemoveNefariousEntry() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testMultimapEntriesRemoveNefariousEntry();
}

public void testNefariousMapPutAll() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testNefariousMapPutAll();
}

public void testNefariousMultimapGetAddAll() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testNefariousMultimapGetAddAll();
}

public void testNefariousMultimapPutAllIterable() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testNefariousMultimapPutAllIterable();
}

public void testNefariousMultimapPutAllMultimap() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testNefariousMultimapPutAllMultimap();
}

public void testNotNull() throws Exception {
  com.google.common.collect.MapConstraintsTest testCase = new com.google.common.collect.MapConstraintsTest();
  testCase.testNotNull();
}
}
