//**************************************************************************************************
//                                         CmdGnuCapFO.hpp                                         *
//                                        -----------------                                        *
// Description : This class contains values associated with the GNU-Cap FOURIER command. It        *
//               inherits from the class CmdBase.                                                  *
// Started     : 2008-03-11                                                                        *
// Last Update : 2015-03-07                                                                        *
// Copyright   : (C) 2008 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef CMDGCPFO_HPP
#define CMDGCPFO_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "base/CmdBase.hpp"
#include "utility/CnvtType.hpp"

// wxWidgets Includes

#include <wx/tokenzr.h>

//**************************************************************************************************

class CmdGnuCapFO : public CmdBase
{
  private :

    virtual  bool  bValidate( void );

  public :

    wxString    m_osStart;  // The sweep start value
    wxString    m_osStop;   // The sweep stop  value
    wxString    m_osStep;   // The sweep step  value
    eTypeInitC  m_eInitC;   // The sweep scale type
    wxString    m_osTempC;  // The analysis temperature

                   CmdGnuCapFO( void );
    virtual       ~CmdGnuCapFO( );

    virtual  bool  bSetDefaults( void );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

             void  Print( const wxString & rosPrefix=wxT("  ") );
};

//**************************************************************************************************

#endif // CMDGCPFO_HPP
