// Code generated by "./generator ./com.deepin.system.display"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package display

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type Display interface {
	display // interface com.deepin.system.Display
	proxy.Object
}

type objectDisplay struct {
	interfaceDisplay // interface com.deepin.system.Display
	proxy.ImplObject
}

func NewDisplay(conn *dbus.Conn) Display {
	obj := new(objectDisplay)
	obj.ImplObject.Init_(conn, "com.deepin.system.Display", "/com/deepin/system/Display")
	return obj
}

type display interface {
	GoGetConfig(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetConfig(flags dbus.Flags) (string, error)
	GoSetConfig(flags dbus.Flags, ch chan *dbus.Call, cfgStr string) *dbus.Call
	SetConfig(flags dbus.Flags, cfgStr string) error
	GoSetBacklightBrightness(flags dbus.Flags, ch chan *dbus.Call, brightness float64) *dbus.Call
	SetBacklightBrightness(flags dbus.Flags, brightness float64) error
	ConnectConfigUpdated(cb func(updateAt string)) (dbusutil.SignalHandlerId, error)
	ConnectBacklightBrightnessUpdated(cb func(brightness float64)) (dbusutil.SignalHandlerId, error)
	AutoBacklightEnabled() proxy.PropBool
	SupportLabc() proxy.PropBool
}

type interfaceDisplay struct{}

func (v *interfaceDisplay) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDisplay) GetInterfaceName_() string {
	return "com.deepin.system.Display"
}

// method GetConfig

func (v *interfaceDisplay) GoGetConfig(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetConfig", flags, ch)
}

func (*interfaceDisplay) StoreGetConfig(call *dbus.Call) (cfgStr string, err error) {
	err = call.Store(&cfgStr)
	return
}

func (v *interfaceDisplay) GetConfig(flags dbus.Flags) (string, error) {
	return v.StoreGetConfig(
		<-v.GoGetConfig(flags, make(chan *dbus.Call, 1)).Done)
}

// method SetConfig

func (v *interfaceDisplay) GoSetConfig(flags dbus.Flags, ch chan *dbus.Call, cfgStr string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetConfig", flags, ch, cfgStr)
}

func (v *interfaceDisplay) SetConfig(flags dbus.Flags, cfgStr string) error {
	return (<-v.GoSetConfig(flags, make(chan *dbus.Call, 1), cfgStr).Done).Err
}

// method SetBacklightBrightness

func (v *interfaceDisplay) GoSetBacklightBrightness(flags dbus.Flags, ch chan *dbus.Call, brightness float64) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetBacklightBrightness", flags, ch, brightness)
}

func (v *interfaceDisplay) SetBacklightBrightness(flags dbus.Flags, brightness float64) error {
	return (<-v.GoSetBacklightBrightness(flags, make(chan *dbus.Call, 1), brightness).Done).Err
}

// signal ConfigUpdated

func (v *interfaceDisplay) ConnectConfigUpdated(cb func(updateAt string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ConfigUpdated", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ConfigUpdated",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var updateAt string
		err := dbus.Store(sig.Body, &updateAt)
		if err == nil {
			cb(updateAt)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal BacklightBrightnessUpdated

func (v *interfaceDisplay) ConnectBacklightBrightnessUpdated(cb func(brightness float64)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "BacklightBrightnessUpdated", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".BacklightBrightnessUpdated",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var brightness float64
		err := dbus.Store(sig.Body, &brightness)
		if err == nil {
			cb(brightness)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property AutoBacklightEnabled b

func (v *interfaceDisplay) AutoBacklightEnabled() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "AutoBacklightEnabled",
	}
}

// property SupportLabc b

func (v *interfaceDisplay) SupportLabc() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "SupportLabc",
	}
}
