% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBResult.R
\name{dbColumnInfo}
\alias{dbColumnInfo}
\title{Information about result types}
\usage{
dbColumnInfo(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbColumnInfo()}
returns a data frame
with at least two columns \code{"name"} and \code{"type"} (in that order)
(and optional columns that start with a dot).
The \code{"name"} and \code{"type"} columns contain the names and types
of the R columns of the data frame that is returned from \code{\link[=dbFetch]{dbFetch()}}.
The \code{"type"} column is of type \code{character} and only for information.
Do not compute on the \code{"type"} column, instead use \code{dbFetch(res, n = 0)}
to create a zero-row data frame initialized with the correct data types.

An attempt to query columns for a closed result set raises an error.
}
\description{
Produces a data.frame that describes the output of a query. The data.frame
should have as many rows as there are output fields in the result set, and
each column in the data.frame describes an aspect of the result set
field (field name, type, etc.)
}
\section{Specification}{



A column named \code{row_names} is treated like any other column.

The column names are always consistent
with the data returned by \code{dbFetch()}.
If the query returns unnamed columns,
unique
non-empty and non-\code{NA} names are assigned.
In the case of a duplicate column name, the first occurrence
retains the original name, and unique names are assigned for
the other occurrences.
Column names that correspond to SQL or R keywords are left unchanged.

}

\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

rs <- dbSendQuery(con, "SELECT 1 AS a, 2 AS b")
dbColumnInfo(rs)
dbFetch(rs)

dbClearResult(rs)
dbDisconnect(con)
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbFetch}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsReadOnly}},
  \code{\link{dbIsValid}}, \code{\link{dbQuoteIdentifier}},
  \code{\link{dbQuoteLiteral}},
  \code{\link{dbQuoteString}},
  \code{\link{dbUnquoteIdentifier}}
}
\concept{DBIResult generics}
