#ifndef _INPUT_STATS_H
#define _INPUT_STATS_H 1

#include <string>
#include <vector>

#include "thread.h"

class Input;

// A thread that regularly writes out input statistics, ie. a list of all inputs
// with some information about each. Very similar to StatsThread, but for inputs instead
// of clients.

class InputStatsThread : public Thread {
public:
	// Does not take ownership of the inputs.
	InputStatsThread(const std::string &stats_file, int stats_interval, const std::vector<Input*> &inputs);

private:
	virtual void do_work();

	std::string stats_file;
	int stats_interval;
	std::vector<Input*> inputs;
};
	
#endif  // !defined(_INPUT_STATS_H)
