#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
# generated by wxGlade 0.5 on Wed Aug 22 22:23:34 2007 from /home/pmartino/Desktop/bibus-cvs/bibus/wxg/RefDisplayDates.wxg

import wx,time,BIB

class RefDisplay(wx.Panel):
	def __init__(self, *args, **kwds):
		# begin wxGlade: RefDisplay.__init__
		kwds["style"] = wx.TAB_TRAVERSAL
		wx.Panel.__init__(self, *args, **kwds)
		self.RefDisplay = wx.TextCtrl(self, -1, "", style=wx.TE_MULTILINE|wx.TE_READONLY|wx.TE_RICH)

		self.__set_properties()
		self.__do_layout()
		# end wxGlade
		self.bibframe = None	# we need the main bibus bibframe for callback and self.db

	def __set_properties(self):
		# begin wxGlade: RefDisplay.__set_properties
		pass
		# end wxGlade

	def __do_layout(self):
		# begin wxGlade: RefDisplay.__do_layout
		sizer_1 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_1.Add(self.RefDisplay, 1, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		self.SetSizer(sizer_1)
		sizer_1.Fit(self)
		# end wxGlade

	def Clear(self):
		self.RefDisplay.Clear()
		
	def resetFormat(self,format): # not used
		return

	def display(self,ref):
		"""Display the reference ref
		If ref = '' => clear the display
		"""
		self.Clear()
		if ref:
			creator,date,user_modif,date_modif = self.bibframe.db.getModifs(ref[0])
			datestr = time.strftime("%c",time.gmtime(date)).decode('utf-8')
			datemodifstr = time.strftime("%c",time.gmtime(date_modif)).decode('utf-8')
			if not date: datestr = _("Unknown")
			if not date_modif: datemodifstr = _("Unknown")
			#
			for key,text in ((_("Creator"),creator),(_("Date"),datestr),(_("Modified by"),user_modif),(_("Date"),datemodifstr)):
				self.RefDisplay.SetDefaultStyle(wx.TextAttr(BIB.KEY_COLOR))
				self.RefDisplay.AppendText("""%s: """ %key)
				self.RefDisplay.SetDefaultStyle(wx.TextAttr(BIB.TEXT_COLOR))
				self.RefDisplay.AppendText("""%s\n""" %text)
			self.RefDisplay.ShowPosition(0)

# end of class RefDisplay



