//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _spin2root_11.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/spin2rootlist.h>

using namespace std;
using namespace bagel;

void Spin2RootList::spin2root11(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[11] = {1.228656404428239e+00,4.133614840751959e-01,2.468970227713630e+00,4.157560380221757e+00,6.329131509235837e+00,
    9.034596893726338e+00,1.234961473959550e+01,1.639136462970140e+01,2.135592744416855e+01,2.762028176062326e+01,3.615053452651031e+01};
  constexpr double aw[11] = {2.042298206737100e-01,5.346870889797332e-02,2.397505363313079e-01,1.275366664230726e-01,3.448179997208018e-02,
    4.847808279860225e-03,3.434460627001003e-04,1.126206465273459e-05,1.448603376823788e-07,5.236471089249789e-10,2.267015586277396e-13};
  constexpr double x[4224] = {  6.405040805205209e-02, -1.241632252839919e-03,  1.744920262589409e-05, -2.075682350617113e-07,  2.155276774910879e-09,
 -1.921050233799215e-11,  1.346776587790941e-13, -4.654162361252815e-16, -6.175428323284265e-18,  1.719804674608798e-19, -2.600547457099512e-21,  2.995885048753496e-23,
  1.856283958225036e-01, -3.380555044406864e-03,  4.150580356579074e-05, -3.771347788117756e-07,  2.105430496138172e-09,  5.057630923176073e-12, -3.172435873090006e-13,
  4.643866312209574e-15, -3.810544067118313e-17,  3.780473330210369e-20,  4.572411223222051e-21, -8.575397480195370e-23,  3.589443229296737e-01, -5.932794574791955e-03,
  5.770841733348637e-05, -2.649157208286073e-07, -2.146204907741106e-09,  5.610150581379870e-11, -4.639815888701601e-13, -1.290837548274091e-15,  8.309071511603987e-17,
 -9.610465502829200e-19,  7.877254084841601e-22,  1.404196828964657e-22,  5.736146696554910e-01, -8.276135081292272e-03,  5.408621467509343e-05,  1.445954291444838e-07,
 -6.467296695019686e-09,  3.811859726409423e-11,  5.186522328860007e-13, -1.018827673043316e-14,  1.589085522086856e-17,  1.471786024347516e-18, -1.683099543679199e-20,
 -8.508233749963903e-23,  8.164761759106853e-01, -9.822368520266835e-03,  2.828869372537432e-05,  5.802221666157151e-07, -5.010126286206030e-09, -5.208415189744961e-11,
  9.018311885762502e-13,  4.087364731680075e-15, -1.609777903404111e-16,  1.868797809117324e-20,  2.761442184243570e-20, -1.260855274724767e-22,  1.072240381473576e+00,
 -1.016445497502468e-02, -1.038173660585840e-05,  6.972936168102904e-07,  1.840752990033297e-09, -8.514237370879399e-11, -3.625696049661964e-13,  1.255347211806197e-14,
  7.402700061335446e-17, -2.027302765931545e-18, -1.557077863672458e-20,  3.452900221378909e-22,  1.324328789542820e+00, -9.190503085412503e-03, -4.522093555716328e-05,
  3.866335138406041e-07,  6.890660007660219e-09, -5.243781916047059e-12, -9.943979739890047e-13, -5.758790524323226e-15,  1.199525641359552e-16,  1.785131757996191e-18,
 -8.367685035136836e-21, -3.767925223514806e-22,  1.555893295423888e+00, -7.131228913415624e-03, -6.097377746920349e-05, -1.077000999460827e-07,  4.885235490272618e-09,
  6.563779663214571e-11,  8.268980662059022e-14, -8.533818356838903e-15, -1.134360663720647e-16,  5.939198713916742e-21,  1.887950227079357e-20,  2.316216365943536e-22,
  1.750987073245455e+00, -4.518332136797516e-03, -5.261692004602594e-05, -4.004592368404165e-07, -7.588315339324723e-10,  3.311011768430942e-11,  5.956985429597384e-13,
  4.863558009877875e-15, -7.003059922864896e-18, -8.346576054102388e-19, -1.267744720117058e-20, -7.946293269703027e-23,  1.895808593097042e+00, -2.053183411068789e-03,
 -2.867248995841711e-05, -3.258815114720027e-07, -3.012645848521252e-09, -1.993172924656751e-11, -2.539682979872959e-14,  1.898153600359940e-15,  3.872444085419001e-17,
  4.894034395080661e-19,  4.203252241981752e-21,  1.391657944429037e-23,  1.979915440510606e+00, -4.140810982298310e-04, -6.344104847881178e-06, -8.515416561068780e-08,
 -1.052646149884486e-09, -1.220047591231630e-11, -1.334465035273721e-13, -1.373738194264562e-15, -1.317296273217220e-17, -1.146182187138488e-19, -8.487802770335031e-22,
 -4.219232463757866e-24,  5.934808163406841e-02, -1.111443754202168e-03,  1.515316739548201e-05, -1.759866331855620e-07,  1.802240251789007e-09, -1.615188591485898e-11,
  1.196809071718562e-13, -5.816818806245751e-16, -1.571201087611857e-18,  9.082327249067600e-20, -1.536964673629643e-21,  1.901756600857905e-23,  1.727424217496608e-01,
 -3.066033198747689e-03,  3.718442043337661e-05, -3.430105978097377e-07,  2.140274209981835e-09, -1.131315464775870e-12, -2.038695783675512e-13,  3.474889270531619e-15,
 -3.425552947067646e-17,  1.567582175370208e-19,  1.642379581448538e-21, -4.915614996743695e-23,  3.361156289962663e-01, -5.484345655487875e-03,  5.435843869833224e-05,
 -2.908910787550677e-07, -1.137039189715479e-09,  4.480119816146108e-11, -4.679968561484151e-13,  8.309242866373879e-16,  5.028616538480903e-17, -8.344476364877035e-19,
  4.891597516505899e-21,  5.133792692091180e-23,  5.413840959207780e-01, -7.838202029007903e-03,  5.522758714873812e-05,  4.779860180820462e-08, -5.603067844953176e-09,
  4.724463776748521e-11,  2.475108890419139e-13, -8.966295996688365e-15,  5.630246819248150e-17,  7.718423571487870e-19, -1.710719310009464e-20,  5.985734733348757e-23,
  7.776813993583237e-01, -9.569642437511865e-03,  3.473990266968234e-05,  4.929311889746208e-07, -5.829078706331991e-09, -2.964103387085013e-11,  9.457006359203456e-13,
 -8.542195288423834e-16, -1.422647593212105e-16,  9.586947468456199e-19,  1.830067891938641e-20, -2.744646083243149e-22,  1.031469981200219e+00, -1.021366996777627e-02,
 -1.894890201964785e-06,  7.127735193564622e-07,  8.044418637483184e-11, -8.942934945789192e-11,  1.044668676654121e-14,  1.366642302108796e-14, -6.169692413905681e-18,
 -2.311918894270869e-18,  1.865207556705824e-21,  4.166849667488664e-22,  1.286875250980822e+00, -9.531854534705004e-03, -3.992762067388811e-05,  4.947020851978994e-07,
  6.536550543538633e-09, -3.055428092242178e-11, -1.092895205474833e-12, -9.895624573104866e-16,  1.741414099066834e-16,  1.115281726610272e-18, -2.488287977868951e-20,
 -3.427798255643871e-22,  1.526386621946916e+00, -7.622759917052854e-03, -6.175376546460647e-05, -1.901502125458491e-08,  6.196383755408284e-09,  6.435069409611299e-11,
 -2.058931441608627e-13, -1.199541103243248e-14, -9.729733149195001e-17,  9.493239096971434e-19,  2.764814504884934e-20,  1.426945185847370e-22,  1.732041220670699e+00,
 -4.958640341898247e-03, -5.747078524060539e-05, -4.064806773408184e-07,  5.710708111939348e-11,  4.898429684240886e-11,  7.234901184458085e-13,  4.054803112294776e-15,
 -4.689087093379494e-17, -1.396276530926287e-18, -1.487720514719273e-20, -6.499285271091323e-24,  1.887111135670781e+00, -2.299055493641598e-03, -3.288548839736330e-05,
 -3.772852294433562e-07, -3.412273592663876e-09, -1.974598282203473e-11,  4.798528477175330e-14,  3.452528983936924e-15,  5.946139436641912e-17,  6.632916125166569e-19,
  4.277904552527525e-21, -1.572269849548862e-23,  1.978150708550004e+00, -4.692274005830577e-04, -7.475662765734653e-06, -1.041365805600918e-07, -1.332061703921007e-09,
 -1.591645709584170e-11, -1.784817138806161e-13, -1.868191532049544e-15, -1.795223666366848e-17, -1.519313708170275e-19, -1.002951195699160e-21, -2.257371859653296e-24,
  5.513204324670543e-02, -9.981991287979042e-04,  1.320417284871084e-05, -1.495846319995946e-07,  1.506588731793804e-09, -1.347803605182616e-11,  1.031055985327190e-13,
 -5.900238016042794e-16,  7.710863087609376e-19,  4.366658843610325e-20, -8.748097111747251e-22,  1.159698616746455e-23,  1.610479884883811e-01, -2.784443480743352e-03,
  3.327223694790537e-05, -3.091821439730957e-07,  2.075983552176721e-09, -4.974918023205430e-12, -1.210023579536698e-13,  2.477963820467594e-15, -2.787434825851708e-17,
  1.874449656665778e-19,  7.511898218880292e-23, -2.398101804027820e-23,  3.150255218978923e-01, -5.063686008022387e-03,  5.078621070468611e-05, -3.025149416681123e-07,
 -3.506227696239635e-10,  3.400397955676574e-11, -4.264297488717083e-13,  2.000461075058989e-15,  2.413890630343165e-17, -6.121520535965122e-19,  5.828096540783413e-21,
 -3.003511075760387e-24,  5.109165071366656e-01, -7.395537532526069e-03,  5.529527901667618e-05, -3.405000013074723e-08, -4.617963601115892e-09,  5.039692401510419e-11,
  2.495151744003965e-14, -6.845366886288030e-15,  7.264057264201439e-17,  1.647981384655482e-19, -1.278183399198652e-20,  1.237698589191313e-22,  7.399938430548817e-01,
 -9.269685147292575e-03,  4.007987342131695e-05,  3.961396237692137e-07, -6.199375462979909e-09, -7.709327914635833e-12,  8.641020636589883e-13, -4.737732143521398e-15,
 -9.761214120257649e-17,  1.437265195728720e-18,  5.576921600951720e-21, -2.821993521178839e-22,  9.906390064406656e-01, -1.019472928283967e-02,  6.607487827092373e-06,
  6.998942829881943e-07, -1.675077101301365e-09, -8.468453777626769e-11,  3.781361564356022e-13,  1.218657982374616e-14, -8.380603036539649e-17, -1.891711523808413e-18,
  1.830703142830033e-20,  3.028153134963072e-22,  1.248149025410338e+00, -9.825807559103126e-03, -3.338846659221296e-05,  5.929753841377230e-07,  5.664310314642542e-09,
 -5.645701136296255e-11, -1.038078091103902e-12,  5.006694818623641e-15,  1.932022000193079e-16, -1.283712024893079e-19, -3.565076019905818e-20, -1.176709769372201e-22,
  1.494908582342570e+00, -8.115921867698378e-03, -6.134581733822094e-05,  9.003470047908061e-08,  7.405121994515367e-09,  5.506642525812514e-11, -5.786398538572542e-13,
 -1.433983473160834e-14, -4.223960651892352e-17,  2.119444048900533e-18,  2.904831787827670e-20, -1.050586977593079e-22,  1.711256362238889e+00, -5.437821400604022e-03,
 -6.230758867985426e-05, -3.967511291926637e-07,  1.218538677369495e-09,  6.749039400998819e-11,  8.076505436782240e-13,  1.637067941819666e-15, -1.075566552895852e-16,
 -1.953636541798934e-18, -1.170530327678981e-20,  1.702222919952968e-22,  1.877358723051350e+00, -2.581206657705464e-03, -3.775321931573508e-05, -4.349413611952971e-07,
 -3.786637461274030e-09, -1.719608042630718e-11,  1.751074174019698e-13,  5.768038694747609e-15,  8.609929586161528e-17,  8.028958940640778e-19,  2.163836481307288e-21,
 -9.017169240776587e-23,  1.976145728536690e+00, -5.344193777461405e-04, -8.864489978127131e-06, -1.282479616660546e-07, -1.697821472316322e-09, -2.089797983950709e-11,
 -2.397118487629459e-13, -2.538026708264190e-15, -2.415419646296012e-17, -1.924398210884314e-19, -9.696254660126800e-22,  5.111895915350599e-24,  5.133969765180112e-02,
 -8.993556569385738e-04,  1.154531460644265e-05, -1.275067988063991e-07,  1.260454949234154e-09, -1.119772746675638e-11,  8.712385373370541e-14, -5.460492688067704e-16,
  1.821678264021985e-18,  1.731850421938211e-20, -4.770974233188527e-22,  6.845883388161001e-24,  1.504198585646042e-01, -2.532550137521451e-03,  2.975761134681400e-05,
 -2.768983245849346e-07,  1.952570119126452e-09, -7.140961692765038e-12, -6.309888234740384e-14,  1.692783623834678e-15, -2.127946211778309e-17,  1.743851442097004e-19,
 -6.197619156883368e-22, -9.052973126391201e-24,  2.955602951773526e-01, -4.671964235572559e-03,  4.714306828489933e-05, -3.032199639831586e-07,  2.320212323141702e-10,
  2.451033550718317e-11, -3.625991482314941e-13,  2.464470675500612e-15,  6.181355090620994e-18, -3.905660734902131e-19,  5.078114160620880e-21, -2.696031239860700e-23,
  4.822148212630341e-01, -6.955989275987112e-03,  5.447655527621436e-05, -9.990177761624530e-08, -3.618193260483083e-09,  4.896060899947301e-11, -1.339242339828075e-13,
 -4.513690180079528e-15,  7.072049676056444e-17, -2.341941364598621e-19, -7.178679961184918e-21,  1.228238048897177e-22,  7.035840999626958e-01, -8.931722333166889e-03,
  4.423683350601659e-05,  2.967920822829523e-07, -6.158540268866004e-09,  1.113304686669907e-11,  6.956659641273376e-13, -7.013462518151376e-15, -4.465432665567521e-17,
  1.434327705473238e-18, -5.041970275192257e-21, -1.898182635994818e-22,  9.500181928509587e-01, -1.010885504133159e-02,  1.479141949632282e-05,  6.601464254380233e-07,
 -3.252188922653100e-09, -7.187491646090612e-11,  6.727179720756386e-13,  8.578869680529463e-15, -1.360827528118045e-16, -9.563391337841010e-19,  2.677012053508732e-20,
  7.275757986621022e-23,  1.208358697063280e+00, -1.006300610305672e-02, -2.577047448740138e-05,  6.732776536262818e-07,  4.300942629149776e-09, -7.900427394682876e-11,
 -8.140239374467842e-13,  1.083554381264262e-14,  1.625332073004252e-16, -1.561658170291547e-18, -3.353955130192483e-20,  2.189466317544182e-22,  1.461473151340597e+00,
 -8.600274434414875e-03, -5.952098705326046e-05,  2.164344499979363e-07,  8.334592148405874e-09,  3.628633135344749e-11, -9.860909246937982e-13, -1.426147116291599e-14,
  5.294489715452305e-17,  3.087304999542638e-18,  1.672472601189169e-20, -4.617211599188332e-22,  1.688478613977676e+00, -5.954885247934801e-03, -6.690364347591615e-05,
 -3.653951438761113e-07,  2.763599412259166e-09,  8.696736530395967e-11,  7.941925603175218e-13, -3.001241431470402e-15, -1.838151077594045e-16, -2.194271732679807e-18,
  1.770161268167672e-21,  4.566503976958704e-22,  1.866395303067912e+00, -2.905163920918402e-03, -4.334647832869715e-05, -4.979897342445082e-07, -4.073727575553325e-09,
 -1.071703211570667e-11,  3.795940834422017e-13,  8.992496129759107e-15,  1.152738049113946e-16,  7.724586927305229e-19, -4.776599410026831e-21, -2.403837686694915e-22,
  1.973855775785571e+00, -6.119869295718272e-04, -1.058133157489427e-05, -1.590951841288376e-07, -2.179547641533921e-09, -2.759783626445543e-11, -3.226887518701538e-13,
 -3.428595990623775e-15, -3.168569586325281e-17, -2.220706821256829e-19, -3.652437096894894e-22,  2.549820331441338e-23,  4.791777201441172e-02, -8.127869304211748e-04,
  1.012920030207536e-05, -1.090226201931312e-07,  1.056207737296088e-09, -9.283182486034953e-12,  7.272116769149521e-14, -4.809343898393604e-16,  2.165190104383370e-18,
  3.288280110649508e-21, -2.457304150419152e-22,  3.908495371484656e-24,  1.407454704176034e-01, -2.307260581452263e-03,  2.661733947747422e-05, -2.468672340715841e-07,
  1.798072655969120e-09, -8.157892499272127e-12, -2.432814545662870e-14,  1.106892829222418e-15, -1.551850591295160e-17,  1.443220187507480e-19, -8.273978512525763e-22,
 -1.319945490428927e-24,  2.776038170989032e-01, -4.309276836442739e-03,  4.354141269565666e-05, -2.960350890772640e-07,  6.408588625566238e-10,  1.664671897411982e-11,
 -2.926732522092056e-13,  2.474024423625783e-15, -4.532660831414222e-18, -2.135870457478077e-19,  3.736992847792933e-21, -3.177113722570180e-23,  4.552536035716656e-01,
 -6.525883177200101e-03,  5.296202910991224e-05, -1.501722962846481e-07, -2.680077776866853e-09,  4.447603431088353e-11, -2.302284515849202e-13, -2.430861132559676e-15,
  5.834800174030382e-17, -4.218296221453466e-19, -2.450868086643940e-21,  8.923483838479488e-23,  6.685852206038996e-01, -8.565234293418536e-03,  4.721721680447291e-05,
  2.008747951176920e-07, -5.785464326312184e-09,  2.535699117902411e-11,  4.866847952981225e-13, -7.669355535032416e-15,  1.663478083455891e-18,  1.101362531411653e-18,
 -1.072153606511152e-20, -6.925370642617606e-23,  9.098682212774826e-01, -9.959824434609207e-03,  2.235657168143956e-05,  5.975611239620999e-07, -4.511428990779065e-09,
 -5.336360681810237e-11,  8.482743129861813e-13,  3.882056887437876e-15, -1.511059427679582e-16,  1.088593230743837e-19,  2.487600018396681e-20, -1.472000474828065e-22,
  1.167746999383592e+00, -1.023580914559671e-02, -1.733352772826863e-05,  7.285035410327372e-07,  2.552851498532781e-09, -9.437301805341793e-11, -4.479745527754366e-13,
  1.490263118255351e-14,  8.533137202481289e-17, -2.619717275008723e-18, -1.737894013231888e-20,  4.886341702813842e-22,  1.426139428706169e+00, -9.063740322493567e-03,
 -5.610422880858607e-05,  3.541769019648367e-07,  8.792750475835584e-09,  8.125959521984747e-12, -1.344323689315824e-12, -1.070557108502018e-14,  1.703329009008756e-16,
  3.253318495678734e-18, -1.049807878964834e-20, -7.421925974762468e-22,  1.663562088405294e+00, -6.506762938443441e-03, -7.096243539807149e-05, -3.062685993830235e-07,
  4.683006465172404e-09,  1.042834702266191e-10,  6.162861012835710e-13, -1.008861075901084e-14, -2.558358365214655e-16, -1.628233546300303e-18,  2.873016435560507e-20,
  7.542690211024001e-22,  1.854041675329617e+00, -3.276959926088984e-03, -4.971865017352896e-05, -5.642956904809792e-07, -4.174314034251422e-09,  1.855330110964043e-12,
  6.868059615717703e-13,  1.306482916254482e-14,  1.365074811183231e-16,  3.040156021527794e-19, -2.045123733939264e-20, -4.877869587218314e-22,  1.971225539624069e+00,
 -7.049118412496252e-04, -1.271938232162874e-05, -1.988391829922984e-07, -2.817349370583957e-09, -3.661637189589929e-11, -4.340907448892631e-13, -4.570427097068812e-15,
 -3.957111028039943e-17, -2.025459748838690e-19,  1.701040608797056e-21,  7.538016406906831e-23,  4.482079350774817e-02, -7.367126417687353e-04,  8.916492907160397e-06,
 -9.351821403196982e-08,  8.869471136614384e-10, -7.691589892938705e-12,  6.023104682434334e-14, -4.113516941782281e-16,  2.142574033066336e-18, -3.693581944058884e-21,
 -1.163599287697828e-22,  2.116654277741900e-24,  1.319242175246488e-01, -2.105694974787541e-03,  2.382208716425356e-05, -2.194254710030114e-07,  1.631316009689727e-09,
 -8.421395886860145e-12,  4.478259466148986e-16,  6.870069526287880e-16, -1.092108843450959e-17,  1.112816784408775e-19, -8.007731614958283e-22,  1.984645095947762e-24,
  2.610411501567251e-01, -3.974957966609516e-03,  4.006032812556995e-05, -2.834763417193032e-07,  9.090514337470217e-10,  1.043130271329466e-11, -2.263970882505224e-13,
  2.232111222646803e-15, -9.861005142923592e-18, -9.120427820374040e-20,  2.413721407201328e-21, -2.753870917267478e-23,  4.299851076347236e-01, -6.110058642737333e-03,
  5.093100128890493e-05, -1.862571239572077e-07, -1.850296137692165e-09,  3.833023731019007e-11, -2.745295181106065e-13, -8.186526984283382e-16,  4.223530657094133e-17,
 -4.532372372916382e-19,  5.890705484187138e-22,  4.943737061928526e-23,  6.350928593348864e-01, -8.179385909799686e-03,  4.909090287006349e-05,  1.129266566066137e-07,
 -5.178738848724702e-09,  3.450010216386204e-11,  2.780333669928133e-13, -7.068582223867333e-15,  3.314251930634723e-17,  6.421576556151172e-19, -1.155715059301678e-20,
  2.401344001390500e-23,  8.704302132313823e-01, -9.753589818079405e-03,  2.906264866364187e-05,  5.179734705023889e-07, -5.369095447080102e-09, -3.223693003279674e-11,
  8.911476719176132e-13, -7.140004198137866e-16, -1.312441577739731e-16,  9.314655430539610e-19,  1.542349735748096e-20, -2.610339188163379e-22,  1.126582579898301e+00,
 -1.033896134116860e-02, -8.410191432031301e-06,  7.538115931407873e-07,  5.928873164369487e-10, -9.989941731971433e-11, -7.351551544253170e-15,  1.603445876612621e-14,
 -1.598295943899758e-17, -2.852720173417999e-18,  6.045377977083788e-21,  5.317482576910524e-22,  1.389017094995878e+00, -9.493181527478214e-03, -5.101056608410705e-05,
  4.943185738375344e-07,  8.611978398821962e-09, -2.701525275649348e-11, -1.551120134267604e-12, -3.527568105792924e-15,  2.718067621736205e-16,  2.162106540636938e-18,
 -4.377762070351703e-20, -7.010536536090132e-22,  1.636378374442849e+00, -7.087726351150788e-03, -7.411696350981644e-05, -2.139647934703810e-07,  6.888726911972418e-09,
  1.147148987483169e-10,  2.123519569814598e-13, -1.892335372817480e-14, -2.853173503134087e-16,  2.291119090073777e-19,  6.453903277741453e-20,  8.034303232076685e-22,
  1.840093859657209e+00, -3.702921441495525e-03, -5.688644564578367e-05, -6.297589442216782e-07, -3.940173192132613e-09,  2.322539835262096e-11,  1.114027188016010e-12,
  1.740303799701117e-14,  1.267494435139753e-16, -1.031967154865687e-18, -4.855144291764914e-20, -7.869602086568023e-22,  1.968186110213880e+00, -8.170370608912296e-04,
 -1.540204372125088e-05, -2.503876117860081e-07, -3.664990106060877e-09, -4.871938275308842e-11, -5.807482539577342e-13, -5.932239405214799e-15, -4.460263142313983e-17,
 -4.113697396739464e-20,  7.185915151062669e-21,  1.884674656904803e-22,  4.200982523641340e-02, -6.696395229916309e-04,  7.874588859756964e-06, -8.048295184790096e-08,
  7.466772367771137e-10, -6.376662283300184e-12,  4.964762154535908e-14, -3.456555248759078e-16,  1.944886825454251e-18, -6.848864307205334e-21, -4.939166371109647e-23,
  1.017096902881362e-24,  1.238665242743224e-01, -1.925219749111498e-03,  2.134004787872289e-05, -1.946653791280917e-07,  1.464364526850577e-09, -8.215819014112798e-12,
  1.535067102137525e-14,  3.956442578050292e-16, -7.466812751591179e-18,  8.137084861204783e-20, -6.887697825776960e-22,  2.832150847598093e-24,  2.457611070276931e-01,
 -3.667820903696739e-03,  3.675186576598507e-05, -2.675371567303735e-07,  1.068209701953613e-09,  5.709680391780318e-12, -1.686896124553755e-13,  1.880404776387966e-15,
 -1.168082764743502e-17, -1.693426802608255e-20,  1.349665756912956e-21, -2.072858581357700e-23,  4.063449768786006e-01, -5.711998346976130e-03,  4.854241061902009e-05,
 -2.100922473219319e-07, -1.150708966560664e-09,  3.160436418597792e-11, -2.809293339767824e-13,  2.799872049222260e-16,  2.677250860451558e-17, -3.964123830952515e-19,
  2.018173803624241e-21,  1.737607467016338e-23,  6.031674356412414e-01, -7.782592353111211e-03,  4.997263015748521e-05,  3.588451288591485e-08, -4.437341722237281e-09,
  3.893594522480789e-11,  9.781752524498601e-14, -5.724215204382651e-15,  4.835357100366176e-17,  2.178688070159631e-19, -9.327158843804904e-21,  6.950511010558131e-23,
  8.319181054156474e-01, -9.497727813407714e-03,  3.474534679608593e-05,  4.280571897230349e-07, -5.803885487370372e-09, -1.152919401146077e-11,  8.181156268976801e-13,
 -4.281155888531652e-15, -8.943617800711098e-17,  1.313563690882604e-18,  3.757826260509269e-21, -2.513367380827161e-22,  1.085149489457799e+00, -1.037004981072037e-02,
  6.269121823533086e-07,  7.474547151088857e-07, -1.371191007649217e-09, -9.483820301261599e-11,  4.196005657800403e-13,  1.396989630942721e-14, -1.090702123733436e-16,
 -2.187958304222101e-18,  2.569035328333115e-20,  3.277967205127872e-22,  1.350269004233260e+00, -9.875250602859407e-03, -4.427642271253066e-05,  6.257500186024912e-07,
  7.696740188103807e-09, -6.438609759677677e-11, -1.519151852955677e-12,  6.023266682256826e-15,  3.116284554946734e-16, -9.679949238515217e-20, -6.573625290777084e-20,
 -2.332318124037558e-22,  1.606828212544641e+00, -7.688883438772953e-03, -7.594715076672328e-05, -8.531229858853526e-08,  9.185841649192718e-09,  1.124484457593658e-10,
 -4.401568593946596e-13, -2.735957947511358e-14, -2.229646886701910e-16,  3.410831600284696e-18,  9.062699931125202e-20,  2.628981554806790e-22,  1.824322675527681e+00,
 -4.189267568391349e-03, -6.480130390239915e-05, -6.874596223819270e-07, -3.166660025139951e-09,  5.621831321588557e-11,  1.649425621753817e-12,  2.041792229057391e-14,
  4.569012974630734e-17, -3.728934296137074e-18, -8.724364327900693e-20, -9.082372401178392e-22,  1.964650988268814e+00, -9.533481590546049e-04, -1.879330327287902e-05,
 -3.176392215185326e-07, -4.793042314550523e-09, -6.481078092979264e-11, -7.665502550506729e-13, -7.308242168784735e-15, -3.839968704868785e-17,  4.704932152182156e-19,
  2.012565378229005e-20,  4.276040112682307e-22,  3.945141831760938e-02, -6.103121853395768e-04,  6.976466873544494e-06, -6.949480867630339e-08,  6.303108094385009e-10,
 -5.294466447697502e-12,  4.080123264987666e-14, -2.876710754009701e-16,  1.671585494344649e-18, -8.137587272016525e-21, -1.917462785116215e-23,  4.552710864960302e-25,
  1.164928375110087e-01, -1.763457338280875e-03,  1.913929391855886e-05, -1.725267468478587e-07,  1.304500902121130e-09, -7.738943768596920e-12,  2.348746270679813e-14,
  1.985028981229007e-16, -5.003282109366656e-18,  5.631563119891404e-20, -5.641201619054040e-22,  2.849167252914385e-24,  2.316579403803944e-01, -3.386349872702871e-03,
  3.364707093552305e-05, -2.497350862373069e-07,  1.145963100077048e-09,  2.250475118172439e-12, -1.212983863087959e-13,  1.505621350934137e-15, -1.151998661186624e-17,
  2.084593983270082e-20,  5.899773144597995e-22, -1.374328682573783e-23,  3.842573135385152e-01, -5.334010804396296e-03,  4.593051894399181e-05, -2.238089803405560e-07,
 -5.849632185578333e-10,  2.504034515741831e-11, -2.631233368592076e-13,  9.250302673311833e-16,  1.407633923567265e-17, -3.070810129339104e-19,  2.308154592534874e-21,
 -1.825984858434959e-24,  5.728377303522341e-01, -7.382236058359205e-03,  5.000322923996430e-05, -2.880692946937279e-08, -3.647203628219264e-09,  3.953990268182370e-11,
 -4.009623904035890e-14, -4.117144778073189e-15,  5.025928795938314e-17, -9.000854831894446e-20, -6.021264462950034e-21,  7.618459480030790e-23,  7.945134087190338e-01,
 -9.200807768095197e-03,  3.932058238448659e-05,  3.343711643611627e-07, -5.849315127481521e-09,  6.387930056075612e-12,  6.653725214241728e-13, -6.377852979840215e-15,
 -4.190919791074665e-17,  1.265325722977301e-18, -5.507614930322658e-21, -1.612893761851387e-22,  1.043735416020303e+00, -1.032966962166096e-02,  9.404258025056763e-06,
  7.110137458084807e-07, -3.137886568691908e-09, -8.053339233855820e-11,  7.516038725641489e-13,  9.440510444494929e-15, -1.666924229223881e-16, -9.635805189841939e-19,
  3.319673355777084e-20,  1.096807530761440e-23,  1.310109946810210e+00, -1.019744284113228e-02, -3.607724212673136e-05,  7.366925049115897e-07,  6.063825562019807e-09,
 -9.771671902278363e-11, -1.215090966654086e-12,  1.542394635844933e-14,  2.601587999019281e-16, -2.730220934564573e-18, -6.080561847460418e-20,  4.639970470936669e-22,
  1.574854787015112e+00, -8.297891239906921e-03, -7.601744372404443e-05,  7.880568707130746e-08,  1.126352804170795e-08,  9.202432602304364e-11, -1.282622873329538e-12,
 -3.182573470989419e-14, -3.495648943215985e-17,  6.948653998558975e-18,  7.732477054478431e-20, -9.548638571247952e-22,  1.806475452910779e+00, -4.741436996424655e-03,
 -7.331021317854726e-05, -7.267848904369648e-07, -1.599889992591775e-09,  1.026801854143763e-10,  2.216182004923994e-12,  1.898506464692067e-14, -1.602187193405314e-16,
 -7.918678309954609e-18, -1.179536364817686e-19, -3.057981936668962e-22,  1.960510783177515e+00, -1.120350336657760e-03, -2.311131457013751e-05, -4.057690146617283e-07,
 -6.290432778645411e-09, -8.578017438823713e-11, -9.844849837185874e-13, -8.067263505804216e-15, -1.412725544241885e-18,  1.768024519877254e-18,  4.811030200468279e-20,
  8.905902654846852e-22,  3.711674328937256e-02, -5.576724717154738e-04,  6.199709774913518e-06, -6.020637894266188e-08,  5.335914119847703e-10, -4.406124936982034e-12,
  3.345043607976509e-14, -2.389776233111100e-16,  1.369560254067121e-18, -8.499077250959596e-21,  3.241150560576598e-24,  7.620432962831407e-25,  1.097326105079415e-01,
 -1.618281002605589e-03,  1.718920098041115e-05, -1.528607490005659e-07,  1.155723123271693e-09, -7.124915747159969e-12,  2.707926935123939e-14,  6.673574066835682e-17,
 -3.350190308540706e-18,  3.647582957063582e-20, -4.179466783835873e-22,  4.261013449900720e-24,  2.186323575064688e-01, -3.128846426159605e-03,  3.076127268977473e-05,
 -2.311841793783341e-07,  1.165063901946574e-09, -1.956241686239957e-13, -8.416283000233279e-14,  1.152498927773279e-15, -1.046919655314327e-17,  3.474028069735854e-20,
  1.710658679843259e-22, -4.544793616957221e-24,  3.636389719456755e-01, -4.977432714748100e-03,  4.320409589914061e-05, -2.294954520187053e-07, -1.449859367337205e-10,
  1.907751067658527e-11, -2.324528683513416e-13,  1.216102832211187e-15,  4.642103326844003e-18, -2.184983123328927e-19,  2.101989931316461e-21, -4.326446548220506e-24,
  5.441053265221897e-01, -6.984525416976984e-03,  4.933324216891855e-05, -8.092406752384896e-08, -2.874445351163092e-09,  3.737147431578502e-11, -1.336412195390670e-13,
 -2.600728669639155e-15,  4.347474248795267e-17, -2.656804411414867e-19, -2.807123344772536e-21,  7.056736278793691e-23,  7.583624925599631e-01, -8.871769270850488e-03,
  4.277835734946277e-05,  2.426089149211164e-07, -5.576943217463480e-09,  2.010263162736136e-11,  4.744916986384616e-13, -7.044482336544024e-15, -1.721744491228633e-18,
  9.375559904801815e-19, -9.997541961411711e-21, -4.027193125271935e-23,  1.002619884880783e+00, -1.022127604497630e-02,  1.758542734608285e-05,  6.489810177236378e-07,
 -4.549976404510812e-09, -5.994860916223176e-11,  9.378525944546957e-13,  3.803500450108636e-15, -1.781203018072112e-16,  2.929001710380493e-19,  2.790536974862493e-20,
 -2.230876542591387e-22,  1.268801048884652e+00, -1.044920820780622e-02, -2.672399129544033e-05,  8.166570025023373e-07,  3.857270001681542e-09, -1.208621231068662e-10,
 -6.845049077376158e-13,  2.175818766999554e-14,  1.246985049649917e-16, -4.573136597956465e-18, -2.744773296034038e-20,  9.939007289082877e-22,  1.540457426279129e+00,
 -8.899056929067072e-03, -7.393598500952557e-05,  2.717713830081981e-07,  1.272440170482032e-08,  5.067151196917137e-11, -2.148140916333408e-12, -2.845211950286954e-14,
  2.569638503829467e-16,  8.790297896188186e-18,  5.254977347838099e-21, -2.237340245947689e-21,  1.786281121955862e+00, -5.363063855031730e-03, -8.210763049132505e-05,
 -7.328977797832545e-07,  1.024424274676440e-09,  1.613720403378809e-10,  2.626612842536956e-12,  8.386569718288902e-15, -5.292728220228798e-16, -1.242133594525559e-17,
 -9.200082230250277e-20,  1.783989658939446e-21,  1.955626163954790e+00, -1.326567868661577e-03, -2.864540580156638e-05, -5.215005277009908e-07, -8.260330955352358e-09,
 -1.120493207627216e-10, -1.198283396233110e-12, -6.634225839899664e-15,  1.081430568907217e-16,  4.681184147399528e-18,  1.032189024197946e-19,  1.668178083346149e-21,
  3.498086948696465e-02, -5.108259877048458e-04,  5.525685245678882e-06, -5.233246653745375e-08,  4.529794209161710e-10, -3.678938425033952e-12,  2.732729357109303e-14,
 -1.999341954547177e-16,  1.077554980134733e-18, -7.284490164140211e-21,  7.089956039002227e-23,  2.602724166228035e-24,  1.035233261074718e-01, -1.487800952161415e-03,
  1.546123459371866e-05, -1.354734223203150e-07,  1.019817342663464e-09, -6.463596097970033e-12,  2.762384020832220e-14, -2.225154887407780e-17, -2.281962231242016e-18,
  2.476749338359029e-20, -1.273541998183693e-22,  9.772702756527690e-24,  2.065920283247424e-01, -2.893537146488256e-03,  2.809845242845675e-05, -2.126738992246725e-07,
  1.143375615451828e-09, -1.864951679386915e-12, -5.638675247188480e-14,  8.386603472925695e-16, -9.106977284158605e-18,  4.172604221509197e-20,  2.965990355709667e-22,
  1.171910276748878e-23,  3.444030451138937e-01, -4.642828078552873e-03,  4.044787326963758e-05, -2.290541519773305e-07,  1.835917123368745e-10,  1.391734464412306e-11,
 -1.973903155779053e-13,  1.254859900212627e-15, -1.722383280679689e-18, -1.341663038206617e-19,  2.257782988269471e-21,  1.529543053046755e-23,  5.169493760423632e-01,
 -6.594470123416919e-03,  4.811024617570424e-05, -1.211320756372290e-07, -2.164215591871167e-09,  3.343798363216041e-11, -1.885418940372942e-13, -1.378108988490814e-15,
  3.264841686903750e-17, -3.142655484960519e-19,  4.689955744872629e-22,  8.326760804403618e-23,  7.235762108699630e-01, -8.519379868901483e-03,  4.516936707491840e-05,
  1.571461781011960e-07, -5.076899501354954e-09,  2.914564411384037e-11,  2.809897517488656e-13, -6.637912904667403e-15,  2.475270173142260e-17,  5.405460056617296e-19,
 -8.886578111005533e-21,  9.232040879589111e-23,  9.620636129405267e-01, -1.005076217397800e-02,  2.490086869019879e-05,  5.678373954924184e-07, -5.518498574907399e-09,
 -3.678931753603009e-11,  9.675539968763567e-13, -1.533065037547690e-15, -1.500807064132721e-16,  1.190972700236990e-18,  1.691054072233462e-20, -2.351661740121240e-22,
  1.226639931088811e+00, -1.062293987978577e-02, -1.663588856136353e-05,  8.583560336127605e-07,  1.326758263254708e-09, -1.296860714005775e-10, -4.515320605313730e-14,
  2.299248432975431e-14, -4.852224638561163e-17, -4.733142259906718e-18,  2.019720821549538e-20,  1.098415290078782e-21,  1.503703840675083e+00, -9.473981187761989e-03,
 -6.942950812639895e-05,  4.804176488260756e-07,  1.316378088914426e-08, -9.225750614310256e-12, -2.782993332533544e-12, -1.532964917932410e-14,  5.518450292324159e-16,
  6.876612016409164e-18, -1.016221581712134e-19, -2.314708136192221e-21,  1.763460189310995e+00, -6.054557573342697e-03, -9.068633547773468e-05, -6.872224577185448e-07,
  4.889551342380476e-09,  2.248810693471795e-10,  2.553207720462458e-12, -1.620320602963582e-14, -1.014759132720641e-15, -1.352179542352981e-17,  6.438488799170145e-20,
  5.514682075453304e-21,  1.949818522306058e+00, -1.583190694361430e-03, -3.577556866625728e-05, -6.732100942097800e-07, -1.080115393997347e-08, -1.424581059877054e-10,
 -1.303663166218824e-12,  4.801032436709794e-16,  3.712621746394850e-16,  1.056325140982670e-17,  1.979712834039765e-19,  2.627218154673376e-21,  3.302216608456638e-02,
 -4.690146233753306e-04,  4.938863964539935e-06, -4.563962729306938e-08,  3.855249530594854e-10, -3.086581093252044e-12,  2.217790640192560e-14, -1.688258226200828e-16,
  9.018074828409294e-19, -1.286642804710790e-21,  2.513983866070931e-22,  5.620328165594326e-24,  9.780958502188640e-02, -1.370346001621262e-03,  1.392930578694104e-05,
 -1.201548486267445e-07,  8.970854736927999e-10, -5.815539729723833e-12,  2.611111930507145e-14, -8.099919739600412e-17, -1.355202026272476e-18,  3.084892463976330e-20,
  4.975891909750361e-22,  1.868170737066475e-23,  1.954517265239604e-01, -2.678650151194030e-03,  2.565468108097310e-05, -1.947443995651607e-07,  1.094281940569301e-09,
 -2.967872878409776e-12, -3.673433088002335e-14,  5.749516894429691e-16, -7.208582993852557e-18,  7.036182331358979e-20,  1.297923509177095e-21,  3.370472029543754e-23,
  3.264615870110373e-01, -4.330170213996194e-03,  3.772523218097284e-05, -2.241355229004164e-07,  4.173622314577596e-10,  9.591585564729171e-12, -1.636171742619170e-13,
  1.141806722492844e-15, -4.672845974789398e-18, -2.017394989367079e-20,  3.709007182874904e-21,  5.130485447457672e-23,  4.913312873188831e-01, -6.215941988840448e-03,
  4.647013821828311e-05, -1.506664331099623e-07, -1.543264678674478e-09,  2.855785379445200e-11, -2.141331401422329e-13, -5.030116252309512e-16,  2.264516524338352e-17,
 -2.121202001054581e-19,  4.915554293876524e-21,  1.203609253072542e-22,  6.902314558803833e-01, -8.151816456955969e-03,  4.658799355433655e-05,  8.088412519997207e-08,
 -4.441073155272293e-09,  3.376433414502533e-11,  1.087115090724544e-13, -5.592739909781200e-15,  3.915561379818421e-17,  3.059173197354918e-19, -1.904077928385297e-21,
  2.200542939079801e-22,  9.222999511488867e-01, -9.825847893950315e-03,  3.116488538223842e-05,  4.748930089754805e-07, -6.028170037205675e-09, -1.458199446611635e-11,
  8.646635968516520e-13, -5.536722220275806e-15, -9.711063943675475e-17,  1.708297250179549e-18,  1.042895581808636e-20, -3.664257704826309e-23,  1.183947482815479e+00,
 -1.071466145867546e-02, -6.293444672874338e-06,  8.589893030474592e-07, -1.227200174701602e-09, -1.233693082286012e-10,  5.529280212240463e-13,  1.896101607555172e-14,
 -1.931959216675934e-16, -3.014487366519655e-18,  6.384012783579261e-20,  8.408119035789142e-22,  1.464738561539539e+00, -1.000281482738342e-02, -6.241892429786071e-05,
  6.858255797582173e-07,  1.228774648724237e-08, -7.897671915785604e-11, -2.934418662333375e-12,  5.329600203591906e-15,  7.053682701743748e-16,  1.208276594755242e-18,
 -1.674250286047725e-19, -3.596186248297902e-22,  1.737741102965203e+00, -6.811342580325466e-03, -9.830499421067064e-05, -5.699050369654443e-07,  9.942427593602801e-09,
  2.766254432935552e-10,  1.578363235504750e-12, -5.542281430943428e-14, -1.386263157206468e-15, -4.973094250723624e-18,  3.867089715908360e-19,  8.668186882313127e-21,
  1.942857739585616e+00, -1.904874684839232e-03, -4.499044797692821e-05, -8.704880252050425e-07, -1.395345940783461e-08, -1.718303754756982e-10, -1.054460486679394e-12,
  2.021112418713547e-14,  9.236131189680024e-16,  2.095725468308179e-17,  3.227725439872574e-19,  2.718088543086725e-21,  3.122180288613440e-02, -4.315940624345275e-04,
  4.426251118572476e-06, -3.993770934977731e-08,  3.287500966349748e-10, -2.607736566262179e-12,  1.786466229692498e-14, -1.382466841674193e-16,  1.101492154722394e-18,
  1.424081893615628e-20,  5.284733153064906e-22,  5.964000548386299e-24,  9.254227123960018e-02, -1.264443603353656e-03,  1.256983755888017e-05, -1.066987629607657e-07,
  7.868373049671040e-10, -5.219783513131206e-12,  2.344023166760128e-14, -1.010369463558129e-16,  3.274278962184971e-19,  6.871333992281270e-20,  1.404486546418152e-21,
  1.948289773981854e-23,  1.851332141377351e-01, -2.482467586031083e-03,  2.342069929095230e-05, -1.777536110679414e-07,  1.027289004225216e-09, -3.679603256419034e-12,
 -2.339467368535172e-14,  3.980046236903081e-16, -3.343668069941382e-18,  1.558941574156228e-19,  3.015231754843148e-21,  3.786318596005920e-23,  3.097276533770540e-01,
 -4.039000093340097e-03,  3.508134098007403e-05, -2.161258619104776e-07,  5.724293735984592e-10,  6.031994989370419e-12, -1.336169899150269e-13,  1.014195317802710e-15,
 -2.113879389105135e-18,  1.803705494067866e-19,  6.388793305865989e-21,  5.944436276517318e-23,  4.671990532349893e-01, -5.851791064132586e-03,  4.453192159264784e-05,
 -1.710720313880743e-07, -1.024241340174204e-09,  2.332609822339400e-11, -2.188874230649482e-13,  1.482337710645057e-16,  1.989063780235105e-17,  9.660749505484917e-20,
  1.051758690587450e-20,  1.174045983642409e-22,  6.583741082852809e-01, -7.776386053159597e-03,  4.715486462690038e-05,  1.532044148372120e-08, -3.751605440200607e-09,
  3.464598465533343e-11, -2.867549393042940e-14, -4.157842400783205e-15,  5.134258638934217e-17,  4.444112974826286e-19,  9.041958772709221e-21,  2.456240780319805e-22,
  8.835289544494151e-01, -9.555388732644244e-03,  3.627876780453515e-05,  3.771784192652529e-07, -6.126411158142575e-09,  4.018143814020815e-12,  6.759513529314201e-13,
 -7.578798363297866e-15, -2.787456656791779e-17,  2.158871397537919e-18,  1.340345975941422e-20,  1.348245751862718e-22,  1.141052713504323e+00, -1.072429332367078e-02,
  3.817988101242939e-06,  8.205028715349041e-07, -3.522846431480679e-09, -1.045077265563350e-10,  9.848671855241501e-13,  1.160019675574494e-14, -2.479852869794892e-16,
  1.492271809053707e-19,  9.064257519534030e-20,  3.280553788239829e-22,  1.423785251623857e+00, -1.046604879323225e-02, -5.307366398974754e-05,  8.660634540029222e-07,
  1.002922361781343e-08, -1.450672501877515e-10, -2.471788081981875e-12,  2.732526572346837e-14,  6.323428984759432e-16, -4.943372769615845e-18, -1.190579941726276e-19,
  2.483129788495200e-21,  1.708883925413460e+00, -7.622002782439493e-03, -1.040018027944125e-04, -3.651266722302602e-07,  1.570188476697830e-08,  2.908312293814423e-10,
 -5.958194388769726e-13, -9.891707699746593e-14, -1.195746019417990e-15,  1.791510312598065e-17,  7.365138781932422e-19,  5.660930871420835e-21,  1.934446524353546e+00,
 -2.310645917252608e-03, -5.689300676519836e-05, -1.122348911281780e-06, -1.757673848119381e-08, -1.862153091046882e-10,  5.760184775534475e-14,  6.452736654799625e-14,
  1.933245517448544e-15,  3.550689078780608e-17,  3.738549997772043e-19, -1.650941075523419e-21,  2.956333258557692e-02, -3.980154621359317e-04,  3.976909562583507e-06,
 -3.507288699549336e-08,  2.805925031103631e-10, -2.220821940850315e-12,  1.459589670299760e-14, -9.030132496251344e-17,  2.041843415794226e-18,  3.866838082761637e-20,
  6.185888105647366e-22, -4.365052101120677e-24,  8.767779705078922e-02, -1.168800163817725e-03,  1.136164023428168e-05, -9.491487257747092e-08,  6.878554878625243e-10,
 -4.687272642286914e-12,  2.121536658768726e-14, -3.876276931915778e-17,  3.969617369867912e-18,  1.360275789860480e-19,  1.734158903415802e-21, -1.207509822618155e-23,
  1.755649525853948e-01, -2.303360515436879e-03,  2.138375833706647e-05, -1.619325835394405e-07,  9.489476735096298e-10, -4.113347953362487e-12, -1.272273388645201e-14,
  4.067459375254104e-16,  4.743705623270051e-18,  2.978943460390932e-19,  3.625479928401898e-21, -2.599107482348506e-23,  2.941167594270637e-01, -3.768559621753249e-03,
  3.254622683008049e-05, -2.061664966233487e-07,  6.632941292531411e-10,  3.166186019345545e-12, -1.048137983926283e-13,  1.103871479557170e-15,  9.443462698739167e-18,
  4.677849295315078e-19,  7.187253714808297e-21, -5.108994233729490e-23,  4.444910493654841e-01, -5.503992128790301e-03,  4.239520781331035e-05, -1.840103696857318e-07,
 -6.095195209782299e-10,  1.820086642861689e-11, -2.046742817194672e-13,  9.298303611351279e-16,  3.188484037299291e-17,  5.840643624866618e-19,  1.249132261308595e-20,
 -7.222140982690301e-23,  6.280228345456640e-01, -7.399379954881362e-03,  4.700120138385803e-05, -3.923530569300459e-08, -3.073964983847003e-09,  3.276414908944655e-11,
 -1.190809329150894e-13, -2.170662855054961e-15,  7.601137131477417e-17,  9.676446524069684e-19,  1.501288545788554e-20, -4.713677649091487e-23,  8.459141876461556e-01,
 -9.248708937935241e-03,  4.022208113743827e-05,  2.806071789219583e-07, -5.901210501509489e-09,  1.766948717954409e-11,  4.637404038360107e-13, -7.113548735853019e-15,
  6.066773098849655e-17,  2.776386105858071e-18,  1.535465042563169e-20, -1.624682821124585e-22,  1.098277435133160e+00, -1.065547351947208e-02,  1.326127783155975e-05,
  7.487949732390125e-07, -5.354844229322595e-09, -7.783953064662059e-11,  1.204468339522334e-12,  4.464737319587755e-15, -1.760368190020223e-16,  3.816405778433851e-18,
  8.533960317668252e-20, -6.930138871833720e-22,  1.381141234541725e+00, -1.084657910334332e-02, -4.182347763733772e-05,  1.000395952200648e-06,  6.607641867331121e-09,
 -1.931136930204119e-10, -1.455294514016606e-12,  4.403987036164414e-14,  3.996540058094962e-16, -7.056243571584481e-18,  1.849330477222621e-20,  3.137343052692996e-21,
  1.676710735764799e+00, -8.466840315017925e-03, -1.066892495207022e-04, -6.915024652878503e-08,  2.113212142206429e-08,  2.397796587455538e-10, -3.761749600983349e-12,
 -1.208710819271773e-13,  1.078513308574470e-17,  4.903496714862149e-17,  7.165126503066871e-19, -8.395773682206138e-21,  1.924201236421827e+00, -2.824722535072152e-03,
 -7.216920317913808e-05, -1.432539905549585e-06, -2.109937729128256e-08, -1.548838058407426e-10,  2.941421940589847e-12,  1.493865973840630e-13,  3.431302902133357e-15,
  4.527528553180000e-17, -8.979033470613348e-21, -1.881322645487605e-20,  2.803233919889470e-02, -3.678106187095327e-04,  3.581565719487309e-06, -3.092041421085277e-08,
  2.395184644367089e-10, -1.892037502183183e-12,  1.322150496595782e-14,  1.328221836899518e-18,  3.773336370117149e-18,  5.276358995830631e-20, -1.139877564913160e-22,
 -3.174065769934216e-23,  8.317742407783904e-02, -1.082282804620622e-03,  1.028569165264727e-05, -8.463153202363665e-08,  5.992087945149868e-10, -4.171817099617443e-12,
  2.272838983574981e-14,  1.778014358112670e-16,  9.805502797463338e-18,  1.740451263089800e-19, -4.423735218710057e-22, -9.538089662915871e-23,  1.666816998231502e-01,
 -2.139811438111806e-03,  1.952890937939825e-05, -1.474198300447379e-07,  8.646838002177286e-10, -4.254062138326693e-12,  2.578561632657390e-15,  7.534867242514530e-16,
  1.742842448343547e-17,  3.773294649184734e-19, -9.119207649676615e-22, -1.980684805787083e-22,  2.795478519144539e-01, -3.517901402909802e-03,  3.013758272082032e-05,
 -1.951725373750519e-07,  7.042152862016848e-10,  1.073063527976588e-12, -6.679317991209520e-14,  1.722402704667736e-15,  3.026202605231155e-17,  6.355502513044793e-19,
 -1.005439194733031e-21, -3.528540186665774e-22,  4.231392196867266e-01, -5.173802768686522e-03,  4.013974731847113e-05, -1.911062317414623e-07, -2.918251544388571e-10,
  1.373900023853045e-11, -1.605756193748158e-13,  2.369848840624474e-15,  6.005676211598923e-17,  8.967026129228197e-19, -4.876883999082055e-22, -5.684858373626972e-22,
  5.991732359516313e-01, -7.026041045264496e-03,  4.625635483625908e-05, -8.334703201201734e-08, -2.450613199217911e-09,  2.948775569630942e-11, -1.398196528120224e-13,
  9.199335890244316e-16,  1.194430283985497e-16,  1.331222448904875e-18, -2.583900670605633e-21, -8.334551326653290e-22,  8.095820052461331e-01, -8.915037803033035e-03,
  4.303629889773574e-05,  1.895570920561125e-07, -5.451117359287302e-09,  2.672446364612304e-11,  3.074595377480769e-13, -3.483116227547213e-15,  1.676432704941819e-16,
  2.982073019751869e-18, -1.316115165868782e-20, -1.268598977870442e-21,  1.055922430731344e+00, -1.051500559673778e-02,  2.168655860307096e-05,  6.522666614066309e-07,
 -6.615107940059689e-09, -4.792017348393929e-11,  1.275484897066751e-12,  1.600611448088193e-15,  1.105031044566017e-17,  6.123089480649706e-18,  1.596020138610042e-20,
 -2.614035318635296e-21,  1.337163910033959e+00, -1.113165432527629e-02, -2.931679300555740e-05,  1.073764679317100e-06,  2.502490606754710e-09, -2.120218397356043e-10,
 -7.893107167492001e-14,  5.313644124852599e-14,  1.856133212209238e-16, -4.347865893892039e-18,  8.891578476236330e-20, -6.803263068761771e-22,  1.641139639330191e+00,
 -9.317598622393205e-03, -1.053510971258088e-04,  3.012957754085730e-07,  2.475852619131421e-08,  1.107285527576587e-10, -6.842386808263632e-12, -8.782119396568621e-14,
  2.149792054397783e-15,  6.446481276483253e-17, -8.837191851874567e-20, -2.773300057548737e-20,  1.911630394605198e+00, -3.476779577099411e-03, -9.147055647351552e-05,
 -1.789411470309222e-06, -2.308195553050129e-08, -2.023479335837016e-11,  8.893913971580312e-12,  2.830164920939313e-13,  4.767628377433772e-15,  1.837478482566741e-17,
 -1.628633643220214e-18, -5.885714933516608e-20,  2.661614014998638e-02, -3.405798865625688e-04,  3.232322297188951e-06, -2.737332426060291e-08,  2.049314852068048e-10,
 -1.558986482922279e-12,  1.520946472927487e-14,  1.482134613474782e-16,  5.156311123767320e-18,  9.502581978941210e-21, -2.314060883466240e-21, -6.748818069167087e-23,
  7.900665392139782e-02, -1.003902737508142e-03,  9.324986234576067e-06, -7.567964255431440e-08,  5.218371286639123e-10, -3.525709552979564e-12,  3.296016597603166e-14,
  5.782519623738420e-16,  1.444353628492159e-17,  3.965780756738020e-20, -7.083114818220881e-21, -2.041316370813826e-22,  1.584240363041795e-01, -1.990427524495610e-03,
  1.784010694224344e-05, -1.342537152875970e-07,  7.823067922080573e-10, -3.864180559015919e-12,  3.335747995509994e-14,  1.500407315566947e-15,  2.763849502731100e-17,
  9.865631109354956e-20, -1.469368169203402e-20, -4.236250610843073e-22,  2.659438864796194e-01, -3.285976320877137e-03,  2.786359314228505e-05, -1.838018737421366e-07,
  7.142040381421833e-10,  1.781628036297770e-13, -1.835013213962672e-15,  3.011622231317385e-15,  4.759128337059991e-17,  1.653925661243756e-19, -2.544518429055050e-20,
 -7.498524698176427e-22,  4.030716344108583e-01, -4.861917613650265e-03,  3.782691865164941e-05, -1.937597471100116e-07, -4.896458011684373e-11,  1.092688796696663e-11,
 -6.282869858041490e-14,  4.743846046744677e-15,  8.418491447883973e-17,  1.817049710659042e-19, -4.006997398183424e-20, -1.217226915750083e-21,  5.718019557321474e-01,
 -6.660613717120363e-03,  4.503984673341863e-05, -1.180040550809489e-07, -1.889917635728235e-09,  2.691454146959840e-11, -5.399449315605092e-14,  5.398785871752442e-15,
  1.538573333097311e-16,  1.849937142463202e-19, -6.235176715641772e-20, -1.862533276423094e-21,  7.746228046202562e-01, -8.563088265464846e-03,  4.480655189642710e-05,
  1.069950126253293e-07, -4.847207044397661e-09,  3.363172259704161e-11,  2.996850552623152e-13,  3.361075611831213e-15,  2.479030218301773e-16,  8.798397695733144e-19,
 -1.033653963472685e-19, -2.808316089284832e-21,  1.014256343033103e+00, -1.031206558264687e-02,  2.885251756416199e-05,  5.404394980014165e-07, -7.262698198651317e-09,
 -1.652903840252141e-11,  1.357758570876665e-12,  5.337080223400324e-15,  2.088172875034160e-16,  3.754877014458895e-18, -1.514996199754624e-19, -4.925301663167760e-21,
  1.292250368496426e+00, -1.131428767444851e-02, -1.633023792257801e-05,  1.080294406636022e-06, -1.633442348248400e-09, -1.955147222030816e-10,  1.472527332635139e-12,
  5.708890666317367e-14,  6.893922726484895e-17, -3.268588967849162e-18, -8.276917243926030e-20, -7.135194851686306e-21,  1.602216177641535e+00, -1.013910403377530e-02,
 -9.931643992572378e-05,  7.055568134784813e-07,  2.518072844810035e-08, -7.316659192143494e-11, -8.009238184254211e-12,  1.480641599684237e-14,  4.079816123318247e-15,
  3.320931656737147e-17, -1.515099770002065e-18, -3.304801133789069e-20,  1.896114960837082e+00, -4.300654832180506e-03, -1.151270343530862e-04, -2.147355874327940e-06,
 -2.062063011793086e-08,  3.055717292990210e-10,  1.893022097689745e-11,  4.276078366407655e-13,  3.493204233141823e-15, -1.137076299516302e-16, -5.320180584010948e-18,
 -1.043531221379968e-19,  2.530353312979692e-02, -3.159817188313512e-04,  2.922555799113032e-06, -2.432228216814098e-08,  1.778330646937676e-10, -1.125988742131191e-12,
  2.155784007251999e-14,  2.946176457297744e-16,  3.060408555761839e-18, -1.478249159976535e-19, -5.572950382171514e-21, -6.875236498532174e-23,  7.513468480782427e-02,
 -9.327985794784806e-04,  8.464756438482076e-06, -6.784494328326888e-08,  4.608117783461813e-10, -2.489240098968618e-12,  5.533869232872340e-14,  9.898224951601917e-16,
  8.435118720257833e-18, -4.397322954669098e-19, -1.695269711304547e-20, -2.084848856984588e-22,  1.507378577480531e-01, -1.853943572572708e-03,  1.630179770786968e-05,
 -1.222955007089170e-07,  7.169445061525321e-10, -2.461250325101469e-12,  8.725194407174745e-14,  2.289241279973248e-15,  1.576111051819381e-17, -8.961332560940288e-19,
 -3.519014270808292e-20, -4.336173000351735e-22,  2.532321045243045e-01, -3.071695392006205e-03,  2.572672986242188e-05, -1.723167409650500e-07,  7.250389928487393e-10,
  1.314909406936090e-12,  1.029091563756388e-13,  4.364369093469613e-15,  2.664177019771634e-17, -1.572887132691950e-18, -6.173554549336892e-20, -7.692407464703167e-22,
  3.842144716381869e-01, -4.568599727746110e-03,  3.550418393429847e-05, -1.928262215222143e-07,  1.668031629958685e-10,  1.130958911181786e-11,  1.058473260721072e-13,
  7.120988551754514e-15,  4.792978861354117e-17, -2.592173787426282e-18, -9.910840716560526e-20, -1.256022980611674e-21,  5.458704980944633e-01, -6.306432447347059e-03,
  4.346006580111041e-05, -1.439455368592057e-07, -1.349515795813136e-09,  2.797375521524011e-11,  1.626800401050370e-13,  9.775330635340185e-15,  9.419929754580317e-17,
 -4.110108702933091e-18, -1.533405247613081e-19, -1.948558522859948e-21,  7.410936975504061e-01, -8.200764646188203e-03,  4.564874938866125e-05,  3.525973471383216e-08,
 -4.090392491573716e-09,  4.284429985376839e-11,  5.024362029429614e-13,  1.074310893390171e-14,  1.728200687283332e-16, -5.973829815813787e-18, -2.408308923836486e-19,
 -2.951187144053750e-21,  9.735079872530684e-01, -1.005729310986067e-02,  3.463557254937275e-05,  4.234276941786617e-07, -7.251067568370699e-09,  1.867761166734757e-11,
  1.610148532178604e-12,  1.256413004672704e-14,  1.792524564438166e-16, -6.964405313752688e-18, -3.852391384795063e-19, -4.934758374403686e-21,  1.246813036332961e+00,
 -1.139380173918126e-02, -3.644843216733167e-06,  1.025343371813082e-06, -5.060162799808543e-09, -1.408913736482083e-10,  3.075658254915711e-12,  5.607180388628394e-14,
 -1.967181233901829e-16, -1.415482076530093e-17, -4.794321273033585e-19, -9.413297974222843e-21,  1.560133760261786e+00, -1.089309692259847e-02, -8.851348355120142e-05,
  1.086713650284869e-06,  2.190795339602878e-08, -2.450405889054713e-10, -5.685910888760837e-12,  1.501888981038645e-13,  3.873188513427793e-15, -5.174881755166580e-17,
 -2.562121672721108e-18, -9.734702105100153e-21,  1.876900031466729e+00, -5.329707238579433e-03, -1.425817149111969e-04, -2.399476020401801e-06, -8.952965543991242e-09,
  9.107307639016414e-10,  3.150797586579834e-11,  4.239061684916688e-13, -5.512861312172707e-15, -4.129825733731537e-16, -9.138739681018045e-18, -3.040957039168399e-20,
  2.408458493292148e-02, -2.937218857884543e-04,  2.647116268055038e-06, -2.162607515549547e-08,  1.611856754266015e-10, -5.051239045343938e-13,  3.004286757979977e-14,
  2.596855709849853e-16, -6.802928281105100e-18, -4.068308868671765e-19, -6.446363394111320e-21,  6.104474287625238e-23,  7.153394298985799e-02, -8.682150110491548e-04,
  7.693472462749995e-06, -6.078833611531300e-08,  4.266304491584391e-10, -8.177180030708323e-13,  8.343305335603350e-14,  8.613344717170279e-16, -2.120794209439707e-17,
 -1.227528644017593e-18, -1.962102385082852e-20,  1.841693327794163e-22,  1.435738892035050e-01, -1.729207257214701e-03,  1.490188347700916e-05, -1.110820768139636e-07,
  6.939820289440742e-10,  4.186564031073662e-13,  1.514443345860374e-13,  1.976054294008912e-15, -4.518818587117293e-17, -2.533021420742619e-18, -4.083466755187836e-20,
  3.779333158762449e-22,  2.413441369666030e-01, -2.873952465116177e-03,  2.372995111892347e-05, -1.603291049390946e-07,  7.861429264206890e-10,  5.276719487490983e-12,
  2.248153467723123e-13,  3.781448065718379e-15, -8.040722477526158e-17, -4.452590322850731e-18, -7.204760627072963e-20,  6.537090522860106e-22,  3.664935731436975e-01,
 -4.293758112615158e-03,  3.321438355687833e-05, -1.881402935713808e-07,  4.349712898701808e-10,  1.629999385927500e-11,  3.066972277240884e-13,  6.309778695269860e-15,
 -1.265698696536283e-16, -7.234259495497429e-18, -1.165996802417298e-19,  1.031464792721997e-21,  5.213287296628355e-01, -5.965983997202960e-03,  4.162257999367776e-05,
 -1.607528604792251e-07, -7.278127681980348e-10,  3.532056467843328e-11,  4.470868357648033e-13,  9.103269934172580e-15, -1.795084726029172e-16, -1.130634070468959e-17,
 -1.813451544169000e-19,  1.558166321532024e-21,  7.090222198676333e-01, -7.834924848142442e-03,  4.570988761314788e-05, -2.256600507874079e-08, -3.086430032647443e-09,
  5.886671866754571e-11,  8.338372536404576e-13,  1.076803993523420e-14, -2.389217053089649e-16, -1.722222462369376e-17, -2.836375631961784e-19,  2.348117783788639e-21,
  9.338624354471050e-01, -9.761813631906837e-03,  3.904007705026240e-05,  3.126258510088926e-07, -6.460634761918004e-09,  6.184373080010514e-11,  1.981264193986235e-12,
  1.096909674074841e-14, -3.882345874325474e-16, -2.513919386779085e-17, -4.634878506623894e-19,  3.443893950507600e-21,  1.201255248495571e+00, -1.137530589241855e-02,
  8.094916559323682e-06,  9.263623345598319e-07, -7.018877271883715e-09, -4.956822599238520e-11,  4.450353203479896e-12,  3.722114343494653e-14, -1.133133634029574e-15,
 -3.933876015661085e-17, -6.859706696531482e-19,  3.690009490793585e-21,  1.515235617743206e+00, -1.154349618144928e-02, -7.355104929155279e-05,  1.392272689082440e-06,
  1.604562462861870e-08, -3.194696940208284e-10, -1.678479135624501e-13,  2.244311172073329e-13,  1.743935113893237e-16, -1.501760072912571e-16, -2.007480038505785e-18,
  3.857183400158821e-20,  1.853116280209760e+00, -6.586301875719531e-03, -1.714910104441729e-04, -2.352443839350738e-06,  1.761452326399521e-08,  1.773184398420535e-09,
  3.817859091435800e-11, -5.845995057978897e-14, -2.647148853064821e-14, -7.099857560047261e-16, -2.561735086536682e-18,  4.009584400690070e-19,  2.295046888405993e-02,
 -2.735396681883005e-04,  2.402875989364715e-06, -1.908690781334072e-08,  1.586920848377351e-10,  2.634655498937449e-13,  3.176384090286355e-14, -2.319593071559103e-16,
 -2.467939897284889e-17, -5.240425685532235e-19,  3.102234032165486e-21,  4.022832378598388e-22,  6.817972170997924e-02, -8.094695309462408e-04,  7.004799523972583e-06,
 -5.397803815810361e-08,  4.316662290913452e-10,  1.351805702452490e-12,  9.048935466065664e-14, -6.451658668370431e-16, -7.525941215609078e-17, -1.586837755278221e-18,
  9.289086127773170e-21,  1.219403232862874e-21,  1.368873171116734e-01, -1.615133369186483e-03,  1.363647860864754e-05, -9.969920338467496e-08,  7.419445950781860e-10,
  4.459700445844551e-12,  1.709100150459728e-13, -1.180977718982377e-15, -1.569768355024762e-16, -3.287864731316777e-18,  1.893063681520948e-20,  2.526205856545490e-21,
  2.302161363490330e-01, -2.691584746740924e-03,  2.188598510469140e-05, -1.465846900548538e-07,  9.520130188648949e-10,  1.148646506607440e-11,  2.671971757726752e-13,
 -1.802191026471210e-15, -2.772121221316007e-16, -5.798655179796618e-18,  3.265835313721520e-20,  4.440839726593132e-21,  3.498358754453678e-01, -4.036927838555257e-03,
  3.101064775883842e-05, -1.781243559110627e-07,  8.453969604215343e-10,  2.505407206890855e-11,  3.820334050472976e-13, -2.631528648283459e-15, -4.464006084196254e-16,
 -9.438318509953417e-18,  5.161262931559658e-20,  7.167952023544879e-21,  4.981183342571701e-01, -5.640859619960651e-03,  3.964907296613532e-05, -1.660938540289277e-07,
  1.014303268256005e-10,  4.803982700579043e-11,  5.518140307839557e-13, -4.284619034595071e-15, -6.795456727935354e-16, -1.478914819472149e-17,  7.734738126351748e-20,
  1.108167001320722e-20,  6.784111058521181e-01, -7.471071464644298e-03,  4.518539766830414e-05, -6.136396008204065e-08, -1.691707218564655e-09,  8.099043458596827e-11,
  9.216466475115589e-13, -8.579994702083491e-15, -1.006202623976018e-15, -2.284316734221700e-17,  1.099776144249712e-19,  1.693701895019373e-20,  8.954612463745868e-01,
 -9.436133104527974e-03,  4.222075084531162e-05,  2.218015593704513e-07, -4.734608435754647e-09,  1.107247435799398e-10,  1.956169275994850e-12, -1.889556851291101e-14,
 -1.540308627499468e-15, -3.492130573324131e-17,  1.429889593428871e-19,  2.636950126383931e-20,  1.155951201753429e+00, -1.126802654661518e-02,  1.852428626174223e-05,
  8.121947781515168e-07, -6.885105080504155e-09,  6.416864953211216e-11,  4.738660511301397e-12, -2.614132565648163e-14, -2.920350604321968e-15, -5.394115077693991e-17,
  2.410118506267570e-19,  4.249355075133514e-20,  1.467996161176469e+00, -1.206118767605512e-02, -5.550923995372489e-05,  1.599747959847466e-06,  1.010532428274281e-08,
 -2.529053865576543e-10,  5.295834691937445e-12,  1.324611597958992e-13, -6.094410771232738e-15, -1.770723911213006e-16,  1.188231832651557e-18,  1.103453156998255e-19,
  1.823859142771442e+00, -8.063348231535579e-03, -1.967040992531721e-04, -1.739696963412380e-06,  6.151436438977610e-08,  2.550850048682328e-09,  2.095547634353990e-11,
 -1.288272670879597e-12, -4.788214437534425e-14, -2.705919757977225e-16,  2.872397343866216e-17,  9.466462198565623e-19,  2.189336740489396e-02, -2.551890162438159e-04,
  2.189365238875885e-06, -1.646828092864983e-08,  1.705296955247338e-10,  8.430237425666182e-13,  1.178022628334776e-14, -1.258486174725216e-15, -3.608634152637328e-17,
  5.385533814999584e-20,  2.741663312616571e-20,  6.047724532972348e-22,  6.504998741881038e-02, -7.559018985884191e-04,  6.399747493627356e-06, -4.674875722535122e-08,
  4.773449221429222e-10,  2.987389417283616e-12,  3.133841900321622e-14, -3.771070505358103e-15, -1.098465798299825e-16,  1.618146308230912e-19,  8.311379347240697e-20,
  1.839565924453531e-21,  1.306376856983666e-01, -1.510617168329266e-03,  1.251492200896149e-05, -8.691442774335362e-08,  8.661195315804046e-10,  7.499126869846423e-12,
  5.223024029116474e-14, -7.693280754748268e-15, -2.288282807047194e-16,  3.273386612433098e-19,  1.722853626740826e-19,  3.832239885580257e-21,  2.197892239302537e-01,
 -2.523254426870590e-03,  2.022697643577634e-05, -1.292037108140625e-07,  1.235850603295633e-09,  1.611824039965730e-11,  6.553914698397006e-14, -1.330552529912861e-14,
 -4.045323433067687e-16,  5.450083096099403e-19,  3.033130976062780e-19,  6.791185447800863e-21,  3.341711756147148e-01, -3.797121614315558e-03,  2.897231639557240e-05,
 -1.601490192376381e-07,  1.422631243170528e-09,  3.144232752055080e-11,  6.429443212171920e-14, -2.121776678526323e-14, -6.552797466762860e-16,  7.864616383497018e-19,
  4.908578639608007e-19,  1.108241471062765e-20,  4.761767984371932e-01, -5.331534659404891e-03,  3.769949037447734e-05, -1.561559086305632e-07,  1.170322059123485e-09,
  5.694307307015195e-11,  5.808953619472051e-14, -3.280956556441417e-14, -1.010843709001074e-15,  9.787936012257407e-19,  7.611562625245819e-19,  1.737650465573908e-20,
  6.492446443721521e-01, -7.112863687501427e-03,  4.434357218687072e-05, -7.442722990574977e-08,  1.080519317973794e-10,  9.590077855058988e-11,  1.229581609419932e-13,
 -5.133623417937985e-14, -1.526223804294520e-15,  1.031694382557589e-18,  1.163794637151969e-18,  2.701808625362146e-20,  8.584075259369441e-01, -9.088824911330345e-03,
  4.450842486682526e-05,  1.660205515272427e-07, -2.126852054961615e-09,  1.446970227768878e-10,  5.713917446946007e-13, -8.445753574974988e-14, -2.345078113337735e-15,
  1.356083803143640e-18,  1.802901989686008e-18,  4.305539789895928e-20,  1.111234743721998e+00, -1.108258405625222e-02,  2.767083629681906e-05,  7.180189370833183e-07,
 -4.585352679655004e-09,  1.569312006192014e-10,  2.444974183207714e-12, -1.443259843567132e-13, -4.115939713383199e-15,  6.013829954731817e-18,  2.996537061600986e-18,
  7.292999148625300e-20,  1.418988279046465e+00, -1.242606019163335e-02, -3.548436440799549e-05,  1.728668423036834e-06,  6.481775804343446e-09, -1.086381963118881e-10,
  5.443027761025581e-12, -1.445853469560116e-13, -1.025133984966148e-14, -1.244301673564293e-17,  7.366214628288878e-18,  1.497922006090894e-19,  1.788355134908005e+00,
 -9.699773404123552e-03, -2.099440806105536e-04, -3.354061713639538e-07,  1.137411471183718e-07,  2.448687664142028e-09, -3.599156089329562e-11, -2.676538475028020e-12,
 -2.761111550295944e-14,  1.600297615143122e-15,  5.763084734044099e-17, -6.157605070218686e-20,  2.090645680944800e-02, -2.384168752239638e-04,  2.008684704602022e-06,
 -1.360378237466826e-08,  1.867277410365637e-10,  5.829250914597694e-13, -3.755927667016902e-14, -2.126672534598489e-15, -9.367268006393287e-18,  1.509092678033292e-18,
  3.810516441374745e-20, -3.903482802791863e-22,  6.212541224974143e-02, -7.068134210855455e-04,  5.886576933468127e-06, -3.863511487486706e-08,  5.341262353548389e-10,
  2.107071463167347e-12, -1.172075980964662e-13, -6.417597557051339e-15, -2.881920428744157e-17,  4.580205562563844e-18,  1.158562963234587e-19, -1.177912499946680e-21,
  1.247891979433537e-01, -1.414422681101997e-03,  1.156003180155059e-05, -7.187600741806024e-08,  1.007156037102384e-09,  5.406056762060962e-12, -2.527627735260186e-13,
 -1.321801817408820e-14, -6.090725729435697e-17,  9.507609987652487e-18,  2.412342513430792e-19, -2.423975250467234e-21,  2.100105250409766e-01, -2.367279919300114e-03,
  1.880568135079391e-05, -1.069175454942209e-07,  1.536632455386329e-09,  1.187263104400360e-11, -4.656179756803268e-13, -2.309881789786139e-14, -1.094279459388583e-16,
  1.675862888146731e-17,  4.273091606853267e-19, -4.223290550703903e-21,  3.194346834591577e-01, -3.572596113582051e-03,  2.720747348678411e-05, -1.325150916162905e-07,
  2.007214907407508e-09,  2.366973121825167e-11, -7.872094574609495e-13, -3.713122857203863e-14, -1.798760147538606e-16,  2.713450963592280e-17,  6.970902102684869e-19,
 -6.738985170849566e-21,  4.554425457353375e-01, -5.037030656077138e-03,  3.597479202967994e-05, -1.286194717572529e-07,  2.230835322487421e-09,  4.393424887697446e-11,
 -1.258552013451533e-12, -5.743521302614650e-14, -2.796981805447422e-16,  4.206061795496134e-17,  1.092339950892443e-18, -1.026171499319547e-20,  6.214972618730342e-01,
 -6.761514233257795e-03,  4.352306605867905e-05, -5.777792959139496e-08,  1.912111677786802e-09,  7.649200579087653e-11, -1.916540164035830e-12, -8.859111831458259e-14,
 -4.192404739966931e-16,  6.433557320032559e-17,  1.694190009493150e-18, -1.535714013853142e-20,  8.227764524283497e-01, -8.725146841899466e-03,  4.639185553016276e-05,
  1.549370839559284e-07,  6.711261206008411e-10,  1.221797500422144e-10, -2.718152072190772e-12, -1.415786773658933e-13, -6.246882248320877e-16,  1.005903182494952e-16,
  2.678087072992508e-18, -2.335123894199347e-20,  1.067400280555999e+00, -1.082774829547281e-02,  3.595639723466970e-05,  6.713206235301168e-07, -1.259856366449334e-09,
  1.534042878423371e-10, -3.209720542668126e-12, -2.439381871222619e-13, -1.103130480250420e-15,  1.724112404882186e-16,  4.512612885621399e-18, -3.926475432828387e-20,
  1.368849985129971e+00, -1.262532448928261e-02, -1.417213596110180e-05,  1.820066056517375e-06,  5.102426921880548e-09, -6.174940448493541e-11, -2.794448874704244e-12,
 -4.120710980717011e-13, -4.151362028656022e-15,  3.702024266169630e-16,  9.894346312997793e-18, -1.090942594027061e-19,  1.746219485174999e+00, -1.136120183653929e-02,
 -2.016578544735455e-04,  1.802863455279803e-06,  1.477714275591813e-07,  6.538709169391057e-10, -1.117354934221226e-10, -2.246705374028254e-12,  6.343542805839060e-14,
  3.024487745704904e-15, -7.786523583274854e-18, -2.872148727540320e-18,  1.998396672460653e-02, -2.229491218191171e-04,  1.863536065018001e-06, -1.059196766450822e-08,
  1.846205139042753e-10, -1.007665203725246e-12, -9.139756798027404e-14, -1.330248666643167e-15,  6.313086263471581e-17,  2.128397237091307e-18, -2.026783452788073e-20,
 -2.109991644572001e-21,  5.938961523384267e-02, -6.614281023077182e-04,  5.474960639852244e-06, -2.996553997296139e-08,  5.337935925486934e-10, -2.786489681967138e-12,
 -2.797352746641547e-13, -4.010930612729047e-15,  1.913956085965825e-16,  6.469042858766836e-18, -6.142514668582371e-20, -6.419011872207357e-21,  1.193113992730387e-01,
 -1.325113077729130e-03,  1.079636368853825e-05, -5.535130519484464e-08,  1.025053933627255e-09, -4.947981841630635e-12, -5.876747246681593e-13, -8.250315346346512e-15,
  3.968274640290534e-16,  1.345950489179142e-17, -1.272569974244332e-19, -1.337728888034924e-20,  2.008347780896259e-01, -2.221535537569714e-03,  1.767545640306883e-05,
 -8.125781088872008e-08,  1.610649598370337e-09, -6.799638641207202e-12, -1.051151298236966e-12, -1.439071872011963e-14,  6.990400293310021e-16,  2.380547527762975e-17,
 -2.238395569781219e-19, -2.372452002440462e-20,  3.055703550938644e-01, -3.360723535908806e-03,  2.582131653017409e-05, -9.799094904700089e-08,  2.208555802396651e-09,
 -7.280522944462911e-12, -1.728638378154886e-12, -2.307509118134909e-14,  1.133000513760467e-15,  3.872898887223262e-17, -3.618838993790103e-19, -3.876814485658948e-20,
  4.358611726418317e-01, -4.754745867611683e-03,  3.466770577078524e-05, -8.808217107861794e-08,  2.678890659674286e-09, -4.919715922550944e-12, -2.714166498700856e-12,
 -3.558191902493474e-14,  1.763636566525628e-15,  6.041463567385156e-17, -5.613081743282920e-19, -6.090718748177719e-20,  5.951440448507630e-01, -6.415487109895922e-03,
  4.305338105232184e-05, -1.828369674919487e-08,  2.783820946731952e-09,  1.759597931322923e-12, -4.158563143838565e-12, -5.471042700497797e-14,  2.721886350495924e-15,
  9.309414964586770e-17, -8.638644539772755e-19, -9.492469710813238e-20,  7.886303753622411e-01, -8.346236473552569e-03,  4.838101212207724e-05,  1.803403433818682e-07,
  2.146191458812185e-09,  1.110573514583483e-11, -6.293958065763232e-12, -8.739688189555336e-14,  4.305195413033623e-15,  1.462280980888136e-16, -1.377184334060105e-18,
 -1.517511127770362e-19,  1.024715385413581e+00, -1.050802195813082e-02,  4.397265219831807e-05,  6.692125782766010e-07,  4.924086291672634e-10, -2.761458275548751e-12,
 -9.392958295015676e-12, -1.526976418200524e-13,  7.289951178507462e-15,  2.471650794668846e-16, -2.485868782090206e-18, -2.628827239226159e-19,  1.318262039455072e+00,
 -1.265008803035139e-02,  8.094955213345446e-06,  1.884169593692877e-06,  2.245575960306108e-09, -2.676393884483052e-10, -1.374361847312835e-11, -2.738954087114660e-13,
  1.373764710126390e-14,  5.158857376233608e-16, -6.212641262679647e-18, -5.775774626213263e-19,  1.697741927384857e+00, -1.284777129315447e-02, -1.659236863921632e-04,
  4.110076804030524e-06,  1.305204762465134e-07, -2.461337839535891e-09, -1.318091498908296e-10,  1.201647423824384e-12,  1.343507568962744e-13,  7.928531396481753e-17,
 -1.286263526931632e-16, -1.349705826787497e-18,  1.912124967090654e-02, -2.085013802484104e-04,  1.753081983618633e-06, -7.926189726576420e-09,  1.409599074137857e-10,
 -3.359249824602961e-12, -9.102265018159394e-14,  1.577107625922980e-15,  1.030759052131793e-16, -4.384321034776713e-19, -9.674811297064462e-20, -5.580665918211396e-22,
  5.682942106036320e-02, -6.189283068721629e-04,  5.163528771113924e-06, -2.225870928974264e-08,  4.062139018924455e-10, -9.971384771513364e-12, -2.779050611105515e-13,
  4.810763819631982e-15,  3.128301864261115e-16, -1.334320142896164e-18, -2.943199076120809e-19, -1.701202782929201e-21,  1.141798591858556e-01, -1.241132982772830e-03,
  1.022466411839111e-05, -4.055601544126836e-08,  7.754350300899495e-10, -2.000573398987679e-11, -5.818199307506685e-13,  1.006105709289789e-14,  6.495223335713684e-16,
 -2.784860027465012e-18, -6.133106926340837e-19, -3.554652762756734e-21,  1.922258607214162e-01, -2.083613868589078e-03,  1.684581248739735e-05, -5.802845758396743e-08,
  1.205775362250953e-09, -3.365616484498281e-11, -1.036394672003463e-12,  1.790782732275346e-14,  1.145893288150358e-15, -4.958465998469826e-18, -1.087446841769513e-18,
 -6.319874494634533e-21,  2.925339688375957e-01, -3.158282292237434e-03,  2.484494955480406e-05, -6.620420085499649e-08,  1.621742984545556e-09, -5.131986605143141e-11,
 -1.697085296013421e-12,  2.933335510500100e-14,  1.859235284597187e-15, -8.175019930406049e-18, -1.776087861621678e-18, -1.033579686021163e-20,  4.173911666876901e-01,
 -4.480935113664060e-03,  3.385258332036499e-05, -4.974718794360472e-08,  1.888892214509943e-09, -7.391553136250902e-11, -2.655132430193170e-12,  4.603088827419890e-14,
  2.893236526870644e-15, -1.308109611397887e-17, -2.787574818493634e-18, -1.616982852482111e-20,  5.701705869306527e-01, -6.071214776920815e-03,  4.308390092915820e-05,
  2.080811755965683e-08,  1.759347523845320e-09, -1.039344837382680e-10, -4.062915005392520e-12,  7.108848852265868e-14,  4.450489749350847e-15, -2.113385334934403e-17,
 -4.336655477321656e-18, -2.476434709817766e-20,  7.560340073005876e-01, -7.949987513119204e-03,  5.073039904088739e-05,  2.077530026215993e-07,  7.581867520976724e-10,
 -1.495932758973799e-10, -6.173771460775953e-12,  1.107610948388214e-13,  6.977368110346536e-15, -3.618029061570973e-17, -6.911282378980340e-18, -3.749586558206124e-20,
  9.834377973626786e-01, -1.012407333441545e-02,  5.200635324751634e-05,  6.635154599933586e-07, -1.996666473509438e-09, -2.461737184927238e-10, -9.334816195004696e-12,
  1.809642847387063e-13,  1.163957033513366e-14, -7.099281889268654e-17, -1.189891445444203e-17, -5.406286436074059e-20,  1.267934572122045e+00, -1.249480932995325e-02,
  3.068132449552426e-05,  1.857834182840746e-06, -6.707550190813159e-09, -6.256247602097746e-10, -1.309415171144114e-11,  3.661436959041228e-13,  2.198207536997087e-14,
 -1.898170592278308e-16, -2.508982804617152e-17, -3.627899271308425e-20,  1.644052320097729e+00, -1.394714213857169e-02, -1.062023962331008e-04,  5.652566427510768e-06,
  5.477385174647585e-08, -4.768994855722887e-09, -4.477812328592273e-11,  4.543791498423286e-12,  4.659816229012141e-14, -4.451033565387716e-15, -5.405705294859635e-17,
  4.375068827023105e-18,  1.831473761810811e-02, -1.948246172767927e-04,  1.668954501124565e-06, -6.305734391035266e-09,  5.727358775008194e-11, -4.682289834308168e-12,
 -8.301282905954284e-15,  3.901617791786181e-15,  2.292381072823289e-17, -3.572169373806664e-18, -3.131963544581868e-20,  3.193774660654181e-21,  5.443476603943263e-02,
 -5.785952098849948e-04,  4.927837082829324e-06, -1.765231418419055e-08,  1.563620463515343e-10, -1.401862710989062e-11, -2.622609861325061e-14,  1.185837172330971e-14,
  6.900890225601205e-17, -1.086307276111242e-17, -9.488277683489174e-20,  9.733514059611706e-21,  1.093760918631479e-01, -1.161106140233366e-03,  9.797129777817154e-06,
 -3.197348050521407e-08,  2.696312912868578e-10, -2.850111526700165e-11, -5.742845990237960e-14,  2.466963131922601e-14,  1.414105266423697e-16, -2.262452128572778e-17,
 -1.963312475140997e-19,  2.034184533185654e-20,  1.841569139676744e-01, -1.951363568717245e-03,  1.623926932817901e-05, -4.523253164596758e-08,  3.441548343149892e-10,
 -4.883229073117292e-11, -1.073638642096658e-13,  4.361612483307471e-14,  2.446378151375285e-16, -4.008613258852662e-17, -3.442378486196856e-19,  3.622088105845967e-20,
  2.802938313789821e-01, -2.962349916520391e-03,  2.416618371594953e-05, -5.028858648635291e-08,  2.863815419448249e-10, -7.622990373146838e-11, -1.832407329142707e-13,
  7.089161362416323e-14,  3.857193463441039e-16, -6.541132031153947e-17, -5.523714970372326e-19,  5.951381190666993e-20,  4.000058391650329e-01, -4.212120481900445e-03,
  3.337857419639211e-05, -3.420038950488293e-08, -7.282700436609826e-11, -1.129094730534680e-10, -2.917274243062590e-13,  1.103423195716108e-13,  5.751310574171009e-16,
 -1.025426707490800e-16, -8.422775240935778e-19,  9.419683013748744e-20,  5.465770810177507e-01, -5.725254170355187e-03,  4.341923991509398e-05,  2.797565596931062e-08,
 -1.057371928499207e-09, -1.633555465756694e-10, -4.272295505920300e-13,  1.691486677095656e-13,  8.268917740132198e-16, -1.592570936072974e-16, -1.246081343547684e-18,
  1.483054538945079e-19,  7.250614667810005e-01, -7.534238668321154e-03,  5.317531383769242e-05,  1.893727360907460e-07, -3.345799102154779e-09, -2.384065559155936e-10,
 -5.141845781817774e-13,  2.621851650172629e-13,  1.149087812168523e-15, -2.529762767868665e-16, -1.800100090454946e-18,  2.404756454528502e-19,  9.438226870305507e-01,
 -9.677158703240022e-03,  5.958135331511140e-05,  5.824262085786724e-07, -8.554373922564526e-09, -3.728957547388964e-10, -7.089373726403017e-14,  4.258990399939098e-13,
  1.443046785412348e-15, -4.312264347953403e-16, -2.439910232228354e-18,  4.245173907879676e-19,  1.218583489648439e+00, -1.216304640106932e-02,  5.187584453108180e-05,
  1.638107633308501e-06, -2.117250675260429e-08, -7.502833394962686e-10,  4.687408075531332e-12,  7.852837729206058e-13, -4.207192776111592e-18, -8.706783041082679e-16,
 -1.539076268504897e-18,  9.254915738969579e-19,  1.587005375006587e+00, -1.451794761935696e-02, -3.632878480898543e-05,  5.751841650287867e-06, -4.082765730136407e-08,
 -4.301610331499425e-09,  7.855907512239434e-11,  3.450058502399556e-12, -1.041404490456070e-13, -2.702912155718352e-15,  1.230251352844906e-16,  1.975559956110379e-18,
  1.756167593211457e-02, -1.817670804430211e-04,  1.595760269486436e-06, -6.112264132927097e-09, -2.960019214479426e-11, -3.608084278503078e-12,  9.180974073919693e-14,
  2.620114827222391e-15, -9.354954667481144e-17, -2.030133755797526e-18,  9.518508506958643e-20,  1.457087833730816e-21,  5.219792137307514e-02, -5.399982620199919e-04,
  4.721965967926473e-06, -1.731503368085311e-08, -1.036797182641161e-10, -1.078010343925529e-11,  2.777447877415165e-13,  7.943081507142060e-15, -2.847604655354769e-16,
 -6.147827954166089e-18,  2.900811353053343e-19,  4.411917171982418e-21,  1.048860386297035e-01, -1.084233128387250e-03,  9.420921720880796e-06, -3.206020424053471e-08,
 -2.588264492154363e-10, -2.184084252710028e-11,  5.739369022260690e-13,  1.645598275791584e-14, -5.939159634425835e-16, -1.271652852547157e-17,  6.061914692402933e-19,
  9.122035327419370e-21,  1.766078859992484e-01, -1.823600034510953e-03,  1.569796989983272e-05, -4.726545806591374e-08, -5.605116910558035e-10, -3.721778729232229e-11,
  1.006295576530916e-12,  2.891412202370012e-14, -1.054255646181811e-15, -2.229861164058249e-17,  1.079239973202489e-18,  1.597814443251622e-20,  2.688272280615646e-01,
 -2.771470471055341e-03,  2.354097013613592e-05, -5.747055210583887e-08, -1.123569014076220e-09, -5.761028632140074e-11,  1.620803180450598e-12,  4.656912964796290e-14,
 -1.724127259271046e-15, -3.582975942830908e-17,  1.772780367265694e-18,  2.560907412234418e-20,  3.836885642050085e-01, -3.946922196975386e-03,  3.288828908793052e-05,
 -5.276799634094219e-08, -2.154679142614436e-09, -8.419222301399228e-11,  2.502646742046230e-12,  7.150544452612797e-14, -2.709465853503553e-15, -5.487610478738735e-17,
  2.804266665485965e-18,  3.900345429019569e-20,  5.243721700987096e-01, -5.377088970510199e-03,  4.354820020723029e-05, -1.404083873267370e-08, -4.050619088837529e-09,
 -1.191010340271124e-10,  3.824865424580502e-12,  1.073010881530031e-13, -4.218108805019983e-15, -8.213805424225966e-17,  4.409383962056912e-18,  5.765240446170380e-20,
  6.957879564452123e-01, -7.101010740229102e-03,  5.497383247802292e-05,  9.948667989473423e-08, -7.657051488794500e-09, -1.668852227347538e-10,  5.995854013192795e-12,
  1.603030575884328e-13, -6.712905460448117e-15, -1.223837411013505e-16,  7.127288391017677e-18,  8.331711712084154e-20,  9.061076095948631e-01, -9.175425738202021e-03,
  6.551374125472040e-05,  3.897658465267795e-07, -1.509677131615070e-08, -2.403822732811124e-10,  1.024500978538548e-11,  2.411436268610792e-13, -1.145956793668726e-14,
 -1.829269976908944e-16,  1.247023227425309e-17,  1.135327248820973e-19,  1.170876273732358e+00, -1.167623426395195e-02,  6.904482543641919e-05,  1.192530445192942e-06,
 -3.339049468273807e-08, -4.014195201773319e-10,  2.231924459281096e-11,  3.467611145307863e-13, -2.352960978340540e-14, -2.442231719380077e-16,  2.635058371008605e-17,
  7.953266388700680e-20,  1.528766166722350e+00, -1.454933489273736e-02,  2.633826136203396e-05,  4.538052929104481e-06, -1.023777759882409e-07, -1.687461196598040e-09,
  1.210574387344299e-10, -4.360314392353829e-13, -1.094278950965828e-13,  2.079600487675809e-15,  7.718429794819214e-17, -3.161299290883381e-18,  1.685965774433227e-02,
 -1.693070477460971e-04,  1.517630115821354e-06, -7.025175514202496e-09, -7.571862221910239e-11, -9.022183278893201e-13,  1.178430445157532e-13, -7.632447780797571e-16,
 -9.481871351576130e-17,  1.746609998819674e-18,  6.527896900054104e-20, -2.296669254025913e-21,  5.011210574619528e-02, -5.030955958597913e-04,  4.498448613438120e-06,
 -2.028124255725878e-08, -2.404889791130821e-10, -2.594651178915990e-12,  3.562577252942971e-13, -2.337255080043444e-15, -2.875482475532239e-16,  5.335381496070736e-18,
  1.977330624914662e-19, -7.011448735743035e-21,  1.006972680005532e-01, -1.010502773578456e-03,  8.999687995307404e-06, -3.883320950694531e-08, -5.328263084853739e-10,
 -4.930560669044068e-12,  7.351796572915473e-13, -4.923861547790139e-15, -5.961431761042593e-16,  1.119042113278819e-17,  4.091486032724006e-19, -1.469181736164234e-20,
  1.695607834301821e-01, -1.700484457724200e-03,  1.505723462096786e-05, -6.067602326592795e-08, -1.019484001232170e-09, -7.590614195816098e-12,  1.285738648018206e-12,
 -8.877036749086607e-15, -1.048878403765350e-15,  2.002639185085194e-17,  7.177556440224839e-19, -2.625610995037233e-20,  2.581131064307819e-01, -2.586279035527259e-03,
  2.271320258007601e-05, -8.223081572200046e-08, -1.816565445937585e-09, -9.974301664500931e-12,  2.061296133143246e-12, -1.486170460002210e-14, -1.693610098884992e-15,
  3.312690371320772e-17,  1.153800345519946e-18, -4.334649070185210e-20,  3.684221114671676e-01, -3.687038983712056e-03,  3.200462895340907e-05, -9.696111878511295e-08,
 -3.131138179616838e-09, -1.091319362296901e-11,  3.155920236050697e-12, -2.419526048395413e-14, -2.612748596876480e-15,  5.289248881232352e-17,  1.767657243860974e-18,
 -6.901334389230650e-20,  5.035577697784257e-01, -5.030623853305118e-03,  4.293047953579595e-05, -9.219472992723913e-08, -5.357112908541685e-09, -7.966535580260604e-12,
  4.747815682761455e-12, -3.976025024669396e-14, -3.955842096526068e-15,  8.420964212519315e-17,  2.645417090350989e-18, -1.093993177275026e-19,  6.682678520201001e-01,
 -6.658724623559128e-03,  5.535082293476509e-05, -4.085199232828873e-08, -9.327506730721985e-09,  4.562880770612820e-12,  7.218211131317642e-12, -6.890724578565754e-14,
 -6.017468315968856e-15,  1.384591039605685e-16,  3.936594780208344e-18, -1.785421223838442e-19,  8.704775892543216e-01, -8.636983750373275e-03,  6.863064131598008e-05,
  1.246224563673802e-07, -1.712594710066764e-08,  4.248407181326881e-11,  1.156343938578263e-11, -1.354766207792399e-13, -9.441982989463691e-15,  2.484324678804708e-16,
  5.862796755491808e-18, -3.153105875965182e-19,  1.125353310405980e+00, -1.107612745624091e-02,  7.998429255164220e-05,  6.248960802765099e-07, -3.572417430742757e-08,
  1.645809874512252e-10,  2.154816586384186e-11, -3.580054674308934e-13, -1.566267079960680e-14,  5.515869125037249e-16,  7.870008874421942e-18, -6.639926272163132e-19,
  1.471293673174510e+00, -1.415023431120099e-02,  7.033802505247591e-05,  2.777644142933219e-06, -1.097581619773301e-07,  7.593276806646054e-10,  7.372611979655564e-11,
 -2.418600550473014e-12, -1.230511267149992e-14,  2.501842223226475e-15, -4.235648123476126e-17, -1.441753694519676e-18,  1.620614802520925e-02, -1.575242418259987e-04,
  1.425928527890813e-06, -8.239915386558791e-09, -6.868805144033320e-11,  1.397674944913420e-12,  6.583537023534093e-14, -2.495058111783238e-15, -1.037345011591526e-17,
  2.288787736062556e-18, -3.098863967921079e-20, -1.403059370316202e-21,  4.817006320630496e-02, -4.681480224959824e-04,  4.231679101773737e-06, -2.411792301398809e-08,
 -2.166533149370125e-10,  4.346816245065411e-12,  1.980818578069148e-13, -7.571909739936094e-15, -3.059833044034164e-17,  6.944578812718050e-18, -9.504798676315716e-20,
 -4.243636237355437e-21,  9.679609350120945e-02, -9.405158294217656e-04,  8.482180094936818e-06, -4.726868720197506e-08, -4.754171007391304e-10,  9.356060530251127e-12,
  4.056498745159798e-13, -1.571861079485424e-14, -6.056110861741010e-17,  1.440941823291327e-17, -2.006236714697873e-19, -8.759592782860401e-21,  1.629947562021289e-01,
 -1.583217636840082e-03,  1.423129952937910e-05, -7.666839361832070e-08, -8.990933192018168e-10,  1.729752870178018e-11,  7.015074726683786e-13, -2.771919624438377e-14,
 -9.905584918498023e-17,  2.538367020463456e-17, -3.622598782482364e-19, -1.530996742212694e-20,  2.481244551135054e-01, -2.409013390859177e-03,  2.155355023793209e-05,
 -1.104390056800893e-07, -1.581170399318561e-09,  2.970352883347545e-11,  1.106766645144489e-12, -4.493416413860441e-14, -1.424447310089613e-16,  4.105898360893892e-17,
 -6.064678820567663e-19, -2.447520411238768e-20,  3.541774678922612e-01, -3.436499350709095e-03,  3.054565217895726e-05, -1.450643168026079e-07, -2.686929930300713e-09,
  4.934689962301001e-11,  1.655983060264876e-12, -6.979641689546955e-14, -1.804130590124876e-16,  6.350239342610372e-17, -9.836772171237782e-19, -3.718156591508326e-20,
  4.841131294406696e-01, -4.693037167434984e-03,  4.132309220630646e-05, -1.735867524693852e-07, -4.527295128600462e-09,  8.160978440078062e-11,  2.407939345482108e-12,
 -1.069857493786970e-13, -1.831249330276592e-16,  9.650296283212303e-17, -1.598387058209537e-18, -5.489431695503603e-20,  6.425119607601973e-01, -6.220352546811170e-03,
  5.399606927055875e-05, -1.809303665637612e-07, -7.750354143060839e-09,  1.381958577877779e-10,  3.469476818967840e-12, -1.666521347667400e-13, -5.575019206985701e-17,
  1.476370341998673e-16, -2.697927517456758e-18, -7.974440250239462e-20,  8.370308376932051e-01, -8.086460954379123e-03,  6.855415361942239e-05, -1.293040850872573e-07,
 -1.394593605578619e-08,  2.495637421206537e-10,  5.053446576235816e-12, -2.754880726664697e-13,  5.672677542353032e-16,  2.339271581992998e-16, -5.000830202912611e-18,
 -1.128080595318143e-19,  1.082362858503123e+00, -1.041556256704288e-02,  8.424193793804290e-05,  1.035595366401026e-07, -2.828419232696123e-08,  5.240061591776880e-10,
  7.619915992897138e-12, -5.323202738668649e-13,  3.748609351717641e-15,  3.965834732158039e-16, -1.145087879782465e-17, -1.261335565522799e-19,  1.415989267264018e+00,
 -1.348239288789436e-02,  9.388276769609720e-05,  1.216252884184725e-06, -8.228895819025414e-08,  1.741108645128737e-09,  1.125727495091668e-11, -1.767236972491797e-12,
  4.018701521879272e-14,  4.080293589183118e-16, -4.534226896743513e-17,  8.514741567716791e-19,  1.559821666465969e-02, -1.465284480567701e-04,  1.321591441368951e-06,
 -9.053002088896472e-09, -3.050211744375273e-11,  2.167254165602209e-12,  1.517658687665117e-15, -1.826317195332619e-15,  4.120556099676186e-17,  5.004347121576268e-19,
 -4.364640243509282e-20,  5.774251620121025e-22,  4.636327221481762e-02, -4.355032510074981e-04,  3.924974981110093e-06, -2.670201669689741e-08, -9.905964191569076e-11,
  6.644108408596078e-12,  3.235611852976891e-15, -5.520955924705314e-15,  1.253873291797530e-16,  1.496986794832352e-18, -1.324255263684684e-19,  1.773632426210156e-21,
  9.316599226103381e-02, -8.750396808060161e-04,  7.876797994458670e-06, -5.299752436444572e-08, -2.259346407606932e-10,  1.400151875051933e-11,  2.305892384255003e-15,
 -1.138987146538096e-14,  2.613886611096150e-16,  3.035071181683537e-18, -2.747486300858968e-19,  3.751794122712128e-21,  1.568834549594473e-01, -1.473260943753327e-03,
  1.323863007508588e-05, -8.763221433134586e-08, -4.463592842562546e-10,  2.518257796373546e-11, -6.827181575695656e-15, -1.990261799163977e-14,  4.636783572539207e-16,
  5.163308433313626e-18, -4.839152876446311e-19,  6.793706596711736e-21,  2.388243265871947e-01, -2.242263720238363e-03,  2.009961223708942e-05, -1.299634513304287e-07,
 -8.209874871392674e-10,  4.181391386973856e-11, -3.467814535930225e-14, -3.184408679845245e-14,  7.576194693776139e-16,  7.930370667373890e-18, -7.824865114914874e-19,
  1.141236496103415e-20,  3.409082568388275e-01, -3.199742290679390e-03,  2.858470788040800e-05, -1.786525750226703e-07, -1.456438279358190e-09,  6.677134961933465e-11,
 -1.019948316005324e-13, -4.854611287789085e-14,  1.189116372254123e-15,  1.133634564116939e-17, -1.209401995425910e-18,  1.858000850500600e-20,  4.659874023415913e-01,
 -4.371876548562993e-03,  3.886673250496884e-05, -2.308202790023297e-07, -2.551515280243677e-09,  1.054791815146110e-10, -2.531604482940504e-13, -7.238896032795503e-14,
  1.847637412275438e-15,  1.515724605157500e-17, -1.835441244507597e-18,  3.029521655356852e-20,  6.184780654130765e-01, -5.798944993419598e-03,  5.118251217629257e-05,
 -2.798360291899540e-07, -4.515021465905612e-09,  1.693209098556202e-10, -5.956995274845186e-13, -1.080142819117949e-13,  2.929710378382167e-15,  1.824973525794244e-17,
 -2.799995509100482e-18,  5.121277121595991e-20,  8.057672166946923e-01, -7.547618036044591e-03,  6.584286311700943e-05, -3.084200581059296e-07, -8.328534473824138e-09,
  2.865920510600253e-10, -1.445824083492262e-12, -1.657564007063048e-13,  4.956525013063472e-15,  1.518046962080688e-17, -4.406604952544045e-18,  9.441856920624877e-20,
  1.042046591139678e+00, -9.743512140686398e-03,  8.313444513305015e-05, -2.598969816206957e-07, -1.706839521588330e-08,  5.515250283929022e-10, -4.104582009908486e-12,
 -2.736664437464942e-13,  9.840944856766398e-15, -2.778848012866630e-17, -7.323172466176845e-18,  2.094764860329795e-19,  1.363626176685468e+00, -1.269266398636958e-02,
  1.017352295191788e-04,  1.787431106762658e-07, -4.800381209665171e-08,  1.565823990727318e-09, -2.004919627268424e-11, -5.166238987772626e-13,  3.205201165050498e-14,
 -5.970263511029784e-16, -6.631977672981685e-18,  6.617197875304116e-19,  1.503255286208633e-02, -1.363953251403450e-04,  1.211423206354903e-06, -9.206895828607789e-09,
  9.866606925985997e-12,  1.745101728958541e-12, -3.050482935772812e-14, -4.951941449807650e-16,  3.551514147227674e-17, -5.881132916077339e-19, -1.020063052556284e-20,
  6.875797177047602e-22,  4.468200449032379e-02, -4.054021923267838e-04,  3.599316592731648e-06, -2.726378290007780e-08,  2.451328805064477e-11,  5.337858098640558e-12,
 -9.329931440789302e-14, -1.481362887826838e-15,  1.075178008553127e-16, -1.793875542235805e-18, -3.053298366171700e-20,  2.084545038293472e-21,  8.978777524726407e-02,
 -8.146097972529491e-04,  7.228134838805102e-06, -5.446003349484422e-08,  3.388410060237231e-11,  1.120961415835677e-11, -1.959655776403407e-13, -3.005013324761270e-15,
  2.223100525962457e-16, -3.753403325363335e-18, -6.197265606698290e-20,  4.319467503730224e-21,  1.511954472119347e-01, -1.371642253665790e-03,  1.216034198687489e-05,
 -9.091194053698419e-08,  1.947634281655944e-11,  2.006325557624486e-11, -3.510452031380358e-13, -5.121723732646635e-15,  3.896841911932011e-16, -6.692476763707835e-18,
 -1.056257047674499e-19,  7.593572648064849e-21,  2.301667548555084e-01, -2.087866412304535e-03,  1.848798055373615e-05, -1.367066354572583e-07, -5.067313237698768e-11,
  3.309757805518811e-11, -5.803798781851500e-13, -7.905165910150774e-15,  6.261072596721612e-16, -1.100983143392482e-17, -1.627529209430897e-19,  1.224481240210650e-20,
  3.285526364408303e-01, -2.979937446688348e-03,  2.634362520508652e-05, -1.917880673198140e-07, -2.328414401745478e-10,  5.240031437379981e-11, -9.230944718184093e-13,
 -1.143433015889664e-14,  9.597343452697764e-16, -1.743315531790510e-17, -2.340253285257142e-19,  1.884780256573283e-20,  4.491034468425261e-01, -4.072560814953369e-03,
  3.591890209571131e-05, -2.556648691188759e-07, -6.318137974691366e-10,  8.183155371867761e-11, -1.454262329709440e-12, -1.573378689781201e-14,  1.441353922934567e-15,
 -2.739237714781223e-17, -3.167275417450425e-19,  2.842327921396033e-20,  5.960785319936185e-01, -5.403897115002160e-03,  4.749792589978612e-05, -3.265983979707182e-07,
 -1.461654197720712e-09,  1.292782933731987e-10, -2.334978499199173e-12, -2.051491744409924e-14,  2.171108027226398e-15, -4.404811473484446e-17, -3.935555556972448e-19,
  4.290661669461666e-20,  7.766041431746766e-01, -7.037527818612234e-03,  6.152178444630741e-05, -3.989665926531281e-07, -3.228607477617428e-09,  2.136204583283767e-10,
 -3.977505260065764e-12, -2.390590980339309e-14,  3.374840085187943e-15, -7.578375096022389e-17, -3.788713588276784e-19,  6.620971733901251e-20,  1.004377435932597e+00,
 -9.094761120882750e-03,  7.871814749434721e-05, -4.520929468729550e-07, -7.469625492490972e-09,  3.941415496381507e-10, -7.809888471307570e-12, -1.386437281250982e-14,
  5.674075441796311e-15, -1.528054982576534e-16,  2.491012276021123e-19,  1.050069808096256e-19,  1.314481338610803e+00, -1.188106618294631e-02,  1.002115451877047e-04,
 -3.680259348760058e-07, -2.215891959290791e-08,  1.006449096766811e-09, -2.348233857995612e-11,  1.586246377318151e-13,  1.095085318217433e-14, -4.795647398290626e-16,
  8.113852630648880e-18,  6.887925253875526e-20,  1.450566155070405e-02, -1.271408076017793e-04,  1.102902663704635e-06, -8.812263657119446e-09,  3.689902258493049e-11,
  9.539316915270740e-13, -3.190878856008791e-14,  2.731936952925687e-16,  1.279384682947671e-17, -5.562499447392133e-19,  7.713746513825889e-21,  1.424340865266111e-22,
  4.311593179862038e-02, -3.779023748651137e-04,  3.277609894016023e-06, -2.614709852333694e-08,  1.072569966790910e-10,  2.925518874654507e-12, -9.710529055388814e-14,
  8.397730405952422e-16,  3.849093297337675e-17, -1.684904650986388e-18,  2.356739186201155e-20,  4.254441976803859e-22,  8.664088052718714e-02, -7.593742944607279e-04,
  6.584390842498343e-06, -5.239573535459095e-08,  2.078180259412267e-10,  6.166730421046855e-12, -2.023884767533200e-13,  1.777655180997676e-15,  7.879580189378227e-17,
 -3.486739658565348e-18,  4.943522786547536e-20,  8.605764613848440e-22,  1.458965781160442e-01, -1.278690620833312e-03,  1.108294858332437e-05, -8.787439115336323e-08,
  3.311522725188429e-10,  1.108872795989115e-11, -3.586712485908178e-13,  3.219386092050058e-15,  1.361140548760086e-16, -6.118925922323556e-18,  8.844856603578034e-20,
  1.459251137572714e-21,  2.221007475873766e-01, -1.946493103464023e-03,  1.686191083403258e-05, -1.330180804714389e-07,  4.641155334237213e-10,  1.838787560586959e-11,
 -5.845744132407571e-13,  5.400923957318016e-15,  2.141834329204021e-16, -9.846058269208584e-18,  1.461521410971087e-19,  2.231484733444674e-21,  3.170398141233994e-01,
 -2.778386090943261e-03,  2.405033659858610e-05, -1.883873918416021e-07,  5.830422456758204e-10,  2.926477158206241e-11, -9.125731020292451e-13,  8.756622603630549e-15,
  3.186642357561109e-16, -1.512097084013828e-17,  2.326865554474002e-19,  3.172001860647944e-21,  4.333683808376256e-01, -3.797541706614027e-03,  3.283792563124191e-05,
 -2.546453206166028e-07,  6.430313024908325e-10,  4.590803075335588e-11, -1.402879678055264e-12,  1.414745114077611e-14,  4.579381841142019e-16, -2.276080942121921e-17,
  3.679876642771234e-19,  4.213366477761031e-21,  5.751977611717765e-01, -5.039811742456224e-03,  4.351365152640099e-05, -3.324184074326508e-07,  5.512034220103387e-10,
  7.270020059121146e-11, -2.179101812771523e-12,  2.349227504625177e-14,  6.433439728547696e-16, -3.437477799207811e-17,  5.959785049271976e-19,  5.051837463060984e-21,
  7.494072044042707e-01, -6.565091465892265e-03,  5.654826352402380e-05, -4.216720891995811e-07,  8.735704022420328e-11,  1.198229866502757e-10, -3.539305487594911e-12,
  4.192247341630109e-14,  8.819755156690173e-16, -5.357299307455617e-17,  1.031855947237020e-18,  4.366840601146562e-21,  9.692213616490913e-01, -8.488214586857537e-03,
  7.280348259054543e-05, -5.185542209175730e-07, -1.407311372532684e-09,  2.177256680022612e-10, -6.429488550653472e-12,  8.814841697644851e-14,  1.092684052784838e-15,
 -9.011877175828339e-17,  2.077600390823230e-18, -5.092817263797664e-21,  1.268525757760561e+00, -1.110172568258459e-02,  9.423848531913887e-05, -5.901170641582069e-07,
 -7.160649388570094e-09,  5.221030318039756e-10, -1.627543135591754e-11,  2.962453942726988e-13, -4.883894257174834e-16, -1.706870965078914e-16,  6.138287132607220e-18,
 -1.001843491150577e-19,  1.401409079013460e-02, -1.187293432308582e-04,  1.001201256211415e-06, -8.107640648212009e-09,  4.910809495098938e-11,  3.099834984384949e-13,
 -2.107463007886738e-14,  4.276367325154349e-16, -1.102191642785253e-18, -2.194747650621827e-19,  7.415981789016595e-21, -9.515767154125924e-23,  4.165482294891872e-02,
 -3.529037108502939e-04,  2.975688496798904e-06, -2.407967937858231e-08,  1.448737140096349e-10,  9.673335104653228e-13, -6.405409080585781e-14,  1.300280114979763e-15,
 -3.512603373804503e-18, -6.612372945778942e-19,  2.246534275776008e-20, -2.908525846439062e-22,  8.370484164898803e-02, -7.091498776051901e-04,  5.978863329209436e-06,
 -4.832717726195190e-08,  2.876448330932716e-10,  2.090356491236424e-12, -1.332338951583603e-13,  2.706748114079331e-15, -7.836930276417907e-18, -1.356690405086009e-18,
  4.649543825159545e-20, -6.104629416032894e-22,  1.409526101314988e-01, -1.194140933473707e-03,  1.006614992523595e-05, -8.123231342289901e-08,  4.759222685616679e-10,
  3.877167742184098e-12, -2.354186511268632e-13,  4.789590469876689e-15, -1.518412294848247e-17, -2.351285575195763e-18,  8.160640990356075e-20, -1.093029005704180e-21,
  2.145746655668726e-01, -1.817833149606569e-03,  1.532008143745737e-05, -1.233508813228793e-07,  7.065932520231757e-10,  6.662728844977118e-12, -3.820829011822660e-13,
  7.793027925777963e-15, -2.761990280418569e-17, -3.717099392670662e-18,  1.313280798679831e-19, -1.807500874007937e-21,  3.062970310802687e-01, -2.594830176628159e-03,
  2.186138495138604e-05, -1.754680331605018e-07,  9.732470376367048e-10,  1.102228679278003e-11, -5.929208521596842e-13,  1.214531679030610e-14, -4.914855187373723e-17,
 -5.567038805746104e-18,  2.016853253627024e-19, -2.879428628364040e-21,  4.186845926526450e-01, -3.546827718292150e-03,  2.986870697319970e-05, -2.386850750059163e-07,
  1.262316984206283e-09,  1.799699247854133e-11, -9.036772263957241e-13,  1.864609128564506e-14, -8.816289783613174e-17, -8.079022999772355e-18,  3.035020689182344e-19,
 -4.553861311592782e-21,  5.557098044278278e-01, -4.707415409017023e-03,  3.961700698186144e-05, -3.145561608153571e-07,  1.543287019926492e-09,  2.964626171785796e-11,
 -1.385654812465759e-12,  2.895146585366152e-14, -1.644900546084986e-16, -1.153144356326139e-17,  4.579325195306643e-19, -7.364219687055021e-21,  7.240198021876829e-01,
 -6.132767567176988e-03,  5.156190233435996e-05, -4.052814960723271e-07,  1.739420432441414e-09,  5.065654086816797e-11, -2.204010779399457e-12,  4.709872713582230e-14,
 -3.344024463532017e-16, -1.629864568946454e-17,  7.117687872485911e-19, -1.268003826523295e-20,  9.363937814883601e-01, -7.930779306732335e-03,  6.656466210279262e-05,
 -5.137418374739737e-07,  1.613754676637750e-09,  9.453722394495939e-11, -3.851501252149206e-12,  8.606757479807774e-14, -8.156647995771849e-16, -2.207827974792566e-17,
  1.187620891034613e-18, -2.507923912457292e-20,  1.225579961488998e+00, -1.037742173827145e-02,  8.675299990527330e-05, -6.396434230962470e-07,  1.945338178749023e-11,
  2.250682770505362e-10, -8.835001380947191e-12,  2.211515245293028e-13, -3.253884688168128e-15, -9.487379672739368e-18,  2.173151750941673e-18, -6.856429692815586e-20,
  1.355459573441181e-02, -1.110952302472018e-04,  9.087502997829751e-07, -7.295870794867348e-09,  5.117491540904912e-11, -6.157739964941573e-14, -1.042504312470481e-14,
  3.143840183482844e-16, -4.754222479400389e-18, -1.329465455737526e-20,  2.982092096230097e-21, -8.643460078059410e-23,  4.028904602517477e-02, -3.302136344334446e-04,
  2.701040867499332e-06, -2.167852898795814e-08,  1.516579190246892e-10, -1.622269576313879e-13, -3.171700217777410e-14,  9.535679392088729e-16, -1.446362387555202e-17,
 -3.795470795147813e-20,  8.987904930506376e-21, -2.617796543679617e-22,  8.096034446076729e-02, -6.635582632922909e-04,  5.427436114350700e-06, -4.353934432901685e-08,
  3.033190744312878e-10, -2.598041077416209e-13, -6.606317068208328e-14,  1.977322011499799e-15, -3.013517850348816e-17, -7.097702873713624e-20,  1.845198415077884e-20,
 -5.415949904861818e-22,  1.363311194200917e-01, -1.117377315924044e-03,  9.138735656771094e-06, -7.326038703280388e-08,  5.072864086558683e-10, -2.766311354949517e-13,
 -1.169229244653044e-13,  3.479498553531211e-15, -5.339545338818280e-17, -1.054648889986233e-19,  3.200712812500013e-20, -9.500497696448101e-22,  2.075393606459388e-01,
 -1.700993900172156e-03,  1.391068288551183e-05, -1.114064554881104e-07,  7.649006963550668e-10, -8.011270971925471e-14, -1.900869644779309e-13,  5.618295491553607e-15,
 -8.704747950825893e-17, -1.271166758725005e-19,  5.066176017607084e-20, -1.527625312555364e-21,  2.962545471269398e-01, -2.428084554418891e-03,  1.985427453958132e-05,
 -1.587951328759411e-07,  1.077415264555950e-09,  5.594029944969801e-13, -2.953910756347195e-13,  8.665186572686046e-15, -1.360430706439336e-16, -1.051667336520336e-19,
  7.600841605390318e-20, -2.343064636719621e-21,  4.049575532125106e-01, -3.318971048074266e-03,  2.713419460064237e-05, -2.166178023909802e-07,  1.445148652661621e-09,
  2.060099655738230e-12, -4.504312088102101e-13,  1.311296262231817e-14, -2.097112291256681e-16,  3.133862764494044e-20,  1.105935490755632e-19, -3.518936666329409e-21,
  5.374907474816205e-01, -4.405123640475666e-03,  3.600492100335156e-05, -2.866659408133234e-07,  1.865024532668643e-09,  5.250414882515002e-12, -6.896061787568351e-13,
  1.994517279368820e-14, -3.275758644453197e-16,  4.648774608493989e-19,  1.585299343737765e-19, -5.292018280422351e-21,  7.002836694816209e-01, -5.739192293477947e-03,
  4.689079341797533e-05, -3.717983543056070e-07,  2.322487990154693e-09,  1.200390754631584e-11, -1.090294242458004e-12,  3.144204937448574e-14, -5.377954403632896e-16,
  1.753016758151616e-18,  2.259722526870746e-19, -8.175912523886592e-21,  9.056974271819920e-01, -7.422367781740236e-03,  6.060290257525987e-05, -4.770584589461782e-07,
  2.758009565713404e-09,  2.761301112921525e-11, -1.872931412939284e-12,  5.441095233281649e-14, -9.971024372362796e-16,  6.191035883388556e-18,  3.140331008946936e-19,
 -1.346369920692738e-20,  1.185410085576694e+00, -9.713818484513744e-03,  7.919561645380078e-05, -6.129476064452016e-07,  2.841605608222289e-09,  7.572414021537318e-11,
 -4.061925517486278e-12,  1.233455475112210e-13, -2.621154674651880e-15,  3.186027443626566e-17,  2.241595252148090e-19, -2.364950800373396e-20,  1.312421976517349e-02,
 -1.041616783844780e-04,  8.260354002618301e-07, -6.497834067936553e-09,  4.806611235253387e-11, -2.231222548724410e-13, -3.698349168846102e-15,  1.711386485465219e-16,
 -3.855462388483608e-18,  4.601940139228755e-20,  3.707145561101936e-22, -3.415746412651474e-23,  3.900981819658488e-02, -3.096050999673093e-04,  2.455239182691802e-06,
 -1.931117642153371e-08,  1.426957326404062e-10, -6.546221486507209e-13, -1.132358049643730e-14,  5.186659676232392e-16, -1.168743960215385e-17,  1.401886628617455e-19,
  1.095141941561574e-21, -1.029456570534170e-22,  7.838975674861240e-02, -6.221470291878321e-04,  4.933678825647092e-06, -3.879707916945350e-08,  2.861943715121097e-10,
 -1.288217891382084e-12, -2.380706854484972e-14,  1.074089158533371e-15, -2.421457452019786e-17,  2.926909734504279e-19,  2.175545649404522e-21, -2.113336032645486e-22,
  1.320024553171078e-01, -1.047647207979029e-03,  8.307716244199035e-06, -6.531085474118012e-08,  4.805972827224760e-10, -2.103244945893164e-12, -4.264718163825037e-14,
  1.886338833192503e-15, -4.256311926945565e-17,  5.201361461166718e-19,  3.588970171009208e-21, -3.665534408631837e-22,  2.009497809101106e-01, -1.594849383439910e-03,
  1.264651270951980e-05, -9.938085304391606e-08,  7.288165770764605e-10, -3.062386848954390e-12, -7.034509163116571e-14,  3.037063584533235e-15, -6.863311124947729e-17,
  8.513412947229772e-19,  5.264797813999672e-21, -5.801274897063093e-22,  2.868482210249106e-01, -2.276580745807933e-03,  1.805149062713052e-05, -1.417784069157319e-07,
  1.034866723933988e-09, -4.097404375920091e-12, -1.111284583578883e-13,  4.664461838752765e-15, -1.056889120338557e-16,  1.337635876120364e-18,  7.008052409492268e-21,
 -8.702525634050987e-22,  3.920999081300497e-01, -3.111902184876666e-03,  2.467328106999090e-05, -1.936417188746129e-07,  1.404162064448437e-09, -5.077732060398747e-12,
 -1.725012045751889e-13,  7.014828800053765e-15, -1.596648862922771e-16,  2.076649155522089e-18,  8.287155142294630e-21, -1.266053928209202e-21,  5.204252654245277e-01,
 -4.130333954732018e-03,  3.274499310417310e-05, -2.567156143164119e-07,  1.843833639059852e-09, -5.733847894155170e-12, -2.689521319411855e-13,  1.056772675149631e-14,
 -2.424256092542303e-16,  3.274865291204382e-18,  7.566277888421025e-21, -1.814782000519122e-21,  6.780498022307414e-01, -5.381270193333963e-03,  4.265622546672924e-05,
 -3.338740881800893e-07,  2.362580459037399e-09, -5.437904233639774e-12, -4.324354443501203e-13,  1.639723272177882e-14, -3.815239817445440e-16,  5.447233232153445e-18,
 -2.505742205424385e-22, -2.588699574238854e-21,  8.769424433127792e-01, -6.959664764827044e-03,  5.515454958536783e-05, -4.304981143096172e-07,  2.966645203614574e-09,
 -2.392889724100101e-12, -7.509980612181076e-13,  2.754658036544009e-14, -6.592713297759095e-16,  1.028642200684616e-17, -3.736433103934285e-20, -3.618762085626494e-21,
  1.147776563402954e+00, -9.108816247882815e-03,  7.214868784926403e-05, -5.596452333971834e-07,  3.616577732945392e-09,  1.128461462437811e-11, -1.607079445177926e-12,
  5.800879029461788e-14, -1.490522045904256e-15,  2.770049231061256e-17, -2.833605568666760e-19, -3.013954612889662e-21  };
  constexpr double w[4224] = {  2.592112408570730e-04, -1.636983230508309e-05,  6.462652885834532e-07, -2.033759635188462e-08,  5.560148337459566e-10,
 -1.376482781420306e-11,  3.159275278930872e-13, -6.823612106014866e-15,  1.401087892277714e-16, -2.754943265162563e-18,  5.215884828378525e-20, -9.545684297557428e-22,
  1.935649564413746e-03, -1.707264739650432e-04,  9.333468892249855e-06, -3.988948377511693e-07,  1.451041328913834e-08, -4.690227236239065e-10,  1.381968401194546e-11,
 -3.774462104018282e-13,  9.668093229638106e-15, -2.342483195522413e-16,  5.403686565607813e-18, -1.192353261174079e-19,  6.338498305660362e-03, -7.849048174940407e-04,
  5.787546081796529e-05, -3.232737907342903e-06,  1.499649762536006e-07, -6.059658544036774e-09,  2.194967326882222e-10, -7.264322772156578e-12,  2.226291348083833e-13,
 -6.381154658523792e-15,  1.723640060277513e-16, -4.411373689735019e-18,  1.376529883001802e-02, -2.307514999791169e-03,  2.209900891574434e-04, -1.556532365184300e-05,
  8.901725798300448e-07, -4.354237637482999e-08,  1.880365845179719e-09, -7.322494441968321e-11,  2.610325478516005e-12, -8.614013423065938e-14,  2.654169244138026e-15,
 -7.682639214754414e-17,  2.304191196534662e-02, -4.986662449687051e-03,  5.974636184975671e-04, -5.137027144536240e-05,  3.517303628161258e-06, -2.027228434274166e-07,
  1.017716701697015e-08, -4.553716276689361e-10,  1.846114975862289e-11, -6.865018033353226e-13,  2.363965682226746e-14, -7.588625494852184e-16,  3.193133333604744e-02,
 -8.509928887186369e-03,  1.230440965701665e-03, -1.252684457854196e-04,  9.995488556747885e-06, -6.623886607178944e-07,  3.779368710720586e-08, -1.902555973048911e-09,
  8.600157071298142e-11, -3.537267579140974e-12,  1.337468120446095e-13, -4.682503187302479e-15,  3.797700663147466e-02, -1.193239939911500e-02,  2.011941613436686e-03,
 -2.355684024544146e-04,  2.134835972222249e-05, -1.589269979427473e-06,  1.008892144132130e-07, -5.602680355382598e-09,  2.772573206310871e-10, -1.239870620753222e-11,
  5.065412672515682e-13, -1.905030917580151e-14,  3.927697765230832e-02, -1.399270476841898e-02,  2.663595682480810e-03, -3.487237776283499e-04,  3.500713699032032e-05,
 -2.862218399561672e-06,  1.980279782656013e-07, -1.190299477968328e-08,  6.336030423603096e-10, -3.030632028988804e-11,  1.317537116589291e-12, -5.247456129996260e-14,
  3.494855681870513e-02, -1.363778708605003e-02,  2.842483738582971e-03, -4.049443839305325e-04,  4.393943817876885e-05, -3.858762977849178e-06,  2.851082589836861e-07,
 -1.820507381787390e-08,  1.024535969912251e-09, -5.158482450726723e-11,  2.351252492087418e-12, -9.781460730112330e-14,  2.527742601980152e-02, -1.047770124325184e-02,
  2.322746855083402e-03, -3.506505210863816e-04,  4.014457335750342e-05, -3.704075223729501e-06,  2.864108382556932e-07, -1.906973271038966e-08,  1.115341654331254e-09,
 -5.818471968468520e-11,  2.740191688418427e-12, -1.174725572090738e-13,  1.163629666623764e-02, -4.983036953517106e-03,  1.142708354452664e-03, -1.781225811286497e-04,
  2.100795947281984e-05, -1.992294628823016e-06,  1.579934837838571e-07, -1.076707164798159e-08,  6.433692620776467e-10, -3.423120172087475e-11,  1.641635647774296e-12,
 -7.156050512442274e-14,  2.027154419968643e-04, -1.204321376373476e-05,  4.476833905953021e-07, -1.328865463558933e-08,  3.433409760370423e-10, -8.047710535308409e-12,
  1.751822289450101e-13, -3.594094929343547e-15,  7.019816193777421e-17, -1.314684450997379e-18,  2.373604567246003e-20, -4.147251790994492e-22,  1.376523653005708e-03,
 -1.118702687541217e-04,  5.680054210608228e-06, -2.268022414679247e-07,  7.742961112222835e-09, -2.357326921809709e-10,  6.561749575501914e-12, -1.697405225723259e-13,
  4.127235562387109e-15, -9.511742682875944e-17,  2.090916795177447e-18, -4.404178318056691e-20,  3.926625564154262e-03, -4.439258947160069e-04,  3.024781573531450e-05,
 -1.573608973873483e-06,  6.838249896487963e-08, -2.600175645068462e-09,  8.896292594054184e-11, -2.789913258270142e-12,  8.124661351219319e-14, -2.218350745954984e-15,
  5.720852636975465e-17, -1.400820731218926e-18,  7.159224025739072e-03, -1.097736607811036e-03,  9.730385328718777e-05, -6.395243107098755e-06,  3.433832224685936e-07,
 -1.584714248709943e-08,  6.483120943334859e-10, -2.400031714481279e-11,  8.158142395757328e-13, -2.574044494355107e-14,  7.601707429212890e-16, -2.113732658454706e-17,
  9.782104624563248e-03, -1.955432710342826e-03,  2.183892353976165e-04, -1.763136656774770e-05,  1.140108468978768e-06, -6.235255221860464e-08,  2.982108374681864e-09,
 -1.275551151013385e-10,  4.958301707564520e-12, -1.772638622611426e-13,  5.882594496464919e-15, -1.823942754303061e-16,  1.088479680982115e-02, -2.718665059869306e-03,
  3.705469451556111e-04, -3.576749057532691e-05,  2.719159597779665e-06, -1.723921473206189e-07,  9.443488271465752e-09, -4.578200852582680e-10,  1.998414028443540e-11,
 -7.956424677305717e-13,  2.918420809613996e-14, -9.931925693084662e-16,  1.037169594274648e-02, -3.104789519921968e-03,  5.002224288460770e-04, -5.619230457538367e-05,
  4.903926054158134e-06, -3.526973513614865e-07,  2.169217518750567e-08, -1.170010539572652e-09,  5.636018859136536e-11, -2.458212779057942e-12,  9.812597584443316e-14,
 -3.611728590530848e-15,  8.712037040453974e-03, -3.004735172526405e-03,  5.542579317097837e-04, -7.049456467397039e-05,  6.891886251288711e-06, -5.500061215586044e-07,
  3.721728825231751e-08, -2.191810840617258e-09,  1.144947526169627e-10, -5.382014629518619e-12,  2.302387401582188e-13, -9.034205213849178e-15,  6.485840011940228e-03,
 -2.483924510384091e-03,  5.080982202568955e-04, -7.113249171621481e-05,  7.595592100122839e-06, -6.572995337279710e-07,  4.791311378095951e-08, -3.021594966248990e-09,
  1.681098551243784e-10, -8.375126060074868e-12,  3.780215913704161e-13, -1.558441675241537e-14,  4.102459171632157e-03, -1.685815010136109e-03,  3.704001803339368e-04,
 -5.544893213802589e-05,  6.298842748602066e-06, -5.770148398068153e-07,  4.432092942837823e-08, -2.932879621321244e-09,  1.705633341233154e-10, -8.851040054619653e-12,
  4.147981485523305e-13, -1.770173852448008e-14,  1.745968640670685e-03, -7.455174213048740e-04,  1.704358141514239e-04, -2.648820322211967e-05,  3.115251943060546e-06,
 -2.946514189223605e-07,  2.330809462920305e-08, -1.584675765989647e-09,  9.447922009627356e-11, -5.016314989405912e-12,  2.400907348192052e-13, -1.044613646548545e-14,
  1.608129811889547e-04, -9.017114782290586e-06,  3.165251489240195e-07, -8.884546128080356e-09,  2.174266811796052e-10, -4.835082328777373e-12,  1.000068009484083e-13,
 -1.952294830179437e-15,  3.632912036014581e-17, -6.489886417203505e-19,  1.118888773585784e-20, -1.868781953937475e-22,  1.005248759910577e-03, -7.552003718160317e-05,
  3.570037645530571e-06, -1.334585166551787e-07,  4.283694385043891e-09, -1.230279538934525e-10,  3.239577061916122e-12, -7.946541091735455e-14,  1.836068310891932e-15,
 -4.028507155024197e-17,  8.445362663777682e-19, -1.699190493396103e-20,  2.537151706316448e-03, -2.621883947717542e-04,  1.652725511503624e-05, -8.015945059922941e-07,
  3.265695230141216e-08, -1.169235118441117e-09,  3.780386375712940e-11, -1.123758854609207e-12,  3.110292508293147e-14, -8.090397310853415e-16,  1.991930181831771e-17,
 -4.665924296524087e-19,  3.944956218197600e-03, -5.524238150392066e-04,  4.528818898352032e-05, -2.775877376079564e-06,  1.398557681241505e-07, -6.085881087160335e-09,
  2.357082919570277e-10, -8.289253120518233e-12,  2.684704048242210e-13, -8.092464963220709e-15,  2.288616726964578e-16, -6.107650989738598e-18,  4.453239414434830e-03,
 -8.189659054448347e-04,  8.502792329043040e-05, -6.431311316992441e-06,  3.919725289989951e-07, -2.030361348008226e-08,  9.234653538710675e-10, -3.769556483601930e-11,
  1.402643192924225e-12, -4.813201779563187e-14,  1.536881958749223e-15, -4.595397042514390e-17,  3.998780956268211e-03, -9.308813161624304e-04,  1.191008399673857e-04,
 -1.086160640817070e-05,  7.842860867666758e-07, -4.743594200472053e-08,  2.488295620925160e-09, -1.158922466301080e-10,  4.873874314898492e-12, -1.874295815043556e-13,
  6.655628298208222e-15, -2.197422962473724e-16,  3.040103587503936e-03, -8.620695754464039e-04,  1.320863520590710e-04, -1.417802536282110e-05,  1.187251689329431e-06,
 -8.222909343571601e-08,  4.885470745041066e-09, -2.552463697993308e-10,  1.193871089154289e-11, -5.067044154504910e-13,  1.972011137683283e-14, -7.089403538221164e-16,
  2.047275655527652e-03, -6.802683086101687e-04,  1.210807637050781e-04, -1.490485964346377e-05,  1.414427811232759e-06, -1.098517657827145e-07,  7.250645193346450e-09,
 -4.173582244300207e-10,  2.134763972185341e-11, -9.841679105342564e-13,  4.135172876480619e-14, -1.595811716089356e-15,  1.251628559071510e-03, -4.689233308698862e-04,
  9.385565971069047e-05, -1.287766939448846e-05,  1.349972554346378e-06, -1.148690954077569e-07,  8.244909728724197e-09, -5.126374801016874e-10,  2.815162810532534e-11,
 -1.385738252342450e-12,  6.185648078050297e-14, -2.524114716997635e-15,  6.793951872955147e-04, -2.763384094761891e-04,  6.008489775999716e-05, -8.907066867806485e-06,
  1.002712484192832e-06, -9.109403260685548e-08,  6.943633171498760e-09, -4.562553227019660e-10,  2.636153955564154e-11, -1.359763923520981e-12,  6.336981724451972e-14,
 -2.690406314088465e-15,  2.638396350362955e-04, -1.122836440425978e-04,  2.557946881668622e-05, -3.962004481137322e-06,  4.644835647127372e-07, -4.380106629239634e-08,
  3.455110179421794e-09, -2.342873428383812e-10,  1.393369868833160e-11, -7.380732203464937e-13,  3.524781938200745e-14, -1.530418340545188e-15,  1.292084664400920e-04,
 -6.858817365388524e-06,  2.279691898743972e-07, -6.065394971996831e-09,  1.408962610354090e-10, -2.978379527810072e-12,  5.863953747235053e-14, -1.091044934989566e-15,
  1.937292513732353e-17, -3.305893061831702e-19,  5.449855881130915e-21, -8.712045123845230e-23,  7.515752650404983e-04, -5.236346079708896e-05,  2.310442796731466e-06,
 -8.103166336847968e-08,  2.449777807210845e-09, -6.647788301608933e-11,  1.658284631325975e-12, -3.862033552022997e-14,  8.488776420360290e-16, -1.774926274559303e-17,
  3.551617295772286e-19, -6.830788463688251e-21,  1.702457379875726e-03, -1.610671089677782e-04,  9.406160133543303e-06, -4.258370003571176e-07,  1.628077799218253e-08,
 -5.493243297296655e-10,  1.679499866245158e-11, -4.734765573600699e-13,  1.245977390398553e-14, -3.088456567817212e-16,  7.260925354658124e-18, -1.627142586674331e-19,
  2.292523912214547e-03, -2.929044424685289e-04,  2.220274698802105e-05, -1.268926958993060e-06,  5.997716387272257e-08, -2.460262410076156e-09,  9.017762971258579e-11,
 -3.011352132835197e-12,  9.288214279775431e-14, -2.673190362942002e-15,  7.235122098266978e-17, -1.851867736167359e-18,  2.166925160153080e-03, -3.653381988073418e-04,
  3.518340619056504e-05, -2.488742245716971e-06,  1.427362330461071e-07, -6.992061784034958e-09,  3.019929491225201e-10, -1.174737238358009e-11,  4.178365861420508e-13,
 -1.374310725594489e-14,  4.216430177722280e-16, -1.214132576155347e-17,  1.582629656627135e-03, -3.415483310277596e-04,  4.086076046394899e-05, -3.509186669816073e-06,
  2.399809210689585e-07, -1.381110710923660e-08,  6.920749685546137e-10, -3.089654675206834e-11,  1.249180898320586e-12, -4.630526022582357e-14,  1.588730367685635e-15,
 -5.079208261966536e-17,  9.592571589467052e-04, -2.561136316490383e-04,  3.713927668405251e-05, -3.793595989533982e-06,  3.037174562049530e-07, -2.019151034521409e-08,
  1.155439729580989e-09, -5.831590447115798e-11,  2.641839190577450e-12, -1.088515049367470e-13,  4.121213126055763e-15, -1.444107035198655e-16,  5.123847840767118e-04,
 -1.631391625803005e-04,  2.788794964657113e-05, -3.309175840151575e-06,  3.037331286763545e-07, -2.288389749469359e-08,  1.469071268972474e-09, -8.243551716118689e-11,
  4.118856767513647e-12, -1.858249960808991e-13,  7.653187523817694e-15, -2.899326774759982e-16,  2.524977417196695e-04, -9.218943959017922e-05,  1.799179291751733e-05,
 -2.411938723409911e-06,  2.475471887416875e-07, -2.066100148684768e-08,  1.457047223579945e-09, -8.914202260050899e-11,  4.823197038491315e-12, -2.341997041596181e-13,
  1.032347031444517e-14, -4.164018089269609e-16,  1.151870761510169e-04, -4.628557095681968e-05,  9.941065458677028e-06, -1.456896403230549e-06,  1.622931211619917e-07,
 -1.460242118266412e-08,  1.103266606391248e-09, -7.190737983946439e-11,  4.123721897531737e-12, -2.112457599619372e-13,  9.782288438576998e-15, -4.128774967850914e-16,
  4.019522578082580e-05, -1.704032471484013e-05,  3.866296359964145e-06, -5.965384980197386e-07,  6.968127170231257e-08, -6.548698144856701e-09,  5.149357894608093e-10,
 -3.481366133631653e-11,  2.064706320185019e-12, -1.090828773712189e-13,  5.196638462409270e-15, -2.251117961376509e-16,  1.050084379834399e-04, -5.291956261025153e-06,
  1.669668277831001e-07, -4.220383391701572e-09,  9.324798217283985e-11, -1.877228334038458e-12,  3.524175402630646e-14, -6.259497934073901e-16,  1.062144060367935e-17,
 -1.733791083782058e-19,  2.736592785807958e-21, -4.192225388729284e-23,  5.737533040355946e-04, -3.719172076941836e-05,  1.535484289888582e-06, -5.062841989142369e-08,
  1.444291210040332e-09, -3.709113150547462e-11,  8.777570028362495e-13, -1.943383825982958e-14,  4.068258430905961e-16, -8.114732431332628e-18,  1.551295493258844e-19,
 -2.854417477001114e-21,  1.181630262496349e-03, -1.025418079702060e-04,  5.556842012243748e-06, -2.351470004875109e-07,  8.446820282835969e-09, -2.688466152810872e-10,
  7.779140754923517e-12, -2.081267609815365e-13,  5.210303917078367e-15, -1.231249316312029e-16,  2.764935575324214e-18, -5.929073680963973e-20,  1.398626531950668e-03,
 -1.629740053375709e-04,  1.142464168809811e-05, -6.089381409832471e-07,  2.700503290794459e-08, -1.044247376226573e-09,  3.622051845432497e-11, -1.148329992801043e-12,
  3.372223161982752e-14, -9.263638266779397e-16,  2.398521872650955e-17, -5.885218586924344e-19,  1.122818039352181e-03, -1.730379310116185e-04,  1.543109289597710e-05,
 -1.019433372599609e-06,  5.495215996462370e-08, -2.542756634825288e-09,  1.041701375786912e-10, -3.857126296188327e-12,  1.309897354241069e-13, -4.124785949068499e-15,
  1.214517799222798e-16, -3.363931320839205e-18,  6.739163965426786e-04, -1.341456318247228e-04,  1.495289044470837e-05, -1.205816241007112e-06,  7.789837195253337e-08,
 -4.255815770276441e-09,  2.032774145933257e-10, -8.680654424962095e-12,  3.367485445162865e-13, -1.200958125056129e-14,  3.973943306296520e-16, -1.228059892781905e-17,
  3.265269991538735e-04, -8.157389130650373e-05,  1.114146429346777e-05, -1.078596465672918e-06,  8.226720439998668e-08, -5.233071207201663e-09,  2.875860674128106e-10,
 -1.398383645911182e-11,  6.120407995673954e-13, -2.442428303117670e-14,  8.976185756296485e-16, -3.059415182393086e-17,  1.372734601592080e-04, -4.162888441738377e-05,
  6.800343533549376e-06, -7.744738691131713e-07,  6.849360749844304e-08, -4.989188621550744e-09,  3.105712758628590e-10, -1.694211504212138e-11,  8.248015334591219e-13,
 -3.633052872113341e-14,  1.463484713381366e-15, -5.431809833202255e-17,  5.355921575444792e-05, -1.897173911410016e-05,  3.595749512519060e-06, -4.693153522812302e-07,
  4.701208610023278e-08, -3.838108492795452e-09,  2.652800758949301e-10, -1.593422649381242e-11,  8.477514192685393e-13, -4.053215315731879e-14,  1.761372415845862e-15,
 -7.011993163179577e-17,  2.007198123828878e-05, -7.949450704601381e-06,  1.682754419188895e-06, -2.433201010943456e-07,  2.677385740200574e-08, -2.382119857786148e-09,
  1.781427449251590e-10, -1.150235517095729e-11,  6.539806604572125e-13, -3.323738675471969e-14,  1.527962400884391e-15, -6.405848758509512e-17,  6.181366452885660e-06,
 -2.608756737897042e-06,  5.891320928661476e-07, -9.049385843003471e-08,  1.052657499956919e-08, -9.854663117957661e-10,  7.720981535853693e-11, -5.202459335221739e-12,
  3.075771819427194e-13, -1.620233489132929e-14,  7.697488177324394e-16, -3.325878375300565e-17,  8.622372139693316e-05, -4.136018423548909e-06,  1.241691575784244e-07,
 -2.988152109126726e-09,  6.291829124529676e-11, -1.208430701169422e-12,  2.166728971800857e-14, -3.679449633711752e-16,  5.975065714600499e-18, -9.342553176824770e-20,
  1.413677941737895e-21, -2.077830873033643e-23,  4.461950495844457e-04, -2.699492743240481e-05,  1.045374126730287e-06, -3.247137007730408e-08,  8.756500435965884e-10,
 -2.131614044272527e-11,  4.792513396819900e-13, -1.010050502826576e-14,  2.016176645495723e-16, -3.840530801377798e-18,  7.021150811043937e-20, -1.237057547801853e-21,
  8.452786149705354e-04, -6.742795676229219e-05,  3.396694218910484e-06, -1.345575876411393e-07,  4.547261860383840e-09, -1.366795458672825e-10,  3.746455095372805e-12,
 -9.520209919657498e-14,  2.268827842917359e-15, -5.114255320297848e-17,  1.097515088411370e-18, -2.252877772304314e-20,  8.918523110004119e-04, -9.478749032822011e-05,
  6.148323540137200e-06, -3.057822299148779e-07,  1.272865056516864e-08, -4.641179757759812e-10,  1.523658573556151e-11, -4.586450600993282e-13,  1.282302119776888e-14,
 -3.361781164807047e-16,  8.325075623118958e-18, -1.957665685044424e-19,  6.170172909921019e-04, -8.671038981490806e-05,  7.152013640695607e-06, -4.408771400100067e-07,
  2.231802189768263e-08, -9.746968669899531e-10,  3.784358753295852e-11, -1.332646166719005e-12,  4.317252602772852e-14, -1.300334302741774e-15,  3.671001633358203e-17,
 -9.770604654346370e-19,  3.080798745184802e-04, -5.629628019133431e-05,  5.828753313520483e-06, -4.402464376736765e-07,  2.680770214979721e-08, -1.387503906036119e-09,
  6.305087202573124e-11, -2.570789644696175e-12,  9.551932114237935e-14, -3.271800071917297e-15,  1.042389701709742e-16, -3.108655680028063e-18,  1.200457162560981e-04,
 -2.788509434967010e-05,  3.570374957483925e-06, -3.263135705240718e-07,  2.363043289228911e-08, -1.433841427364966e-09,  7.546149879611799e-11, -3.525912736646837e-12,
  1.487312254956987e-13, -5.735365880118533e-15,  2.041592532001679e-16, -6.754536055694195e-18,  3.955276611948219e-05, -1.134959491028702e-05,  1.762286450411676e-06,
 -1.917589685373004e-07,  1.627604710555394e-08, -1.142191102407840e-09,  6.872374789822014e-11, -3.634042255261273e-12,  1.719245267304092e-13, -7.375502178708806e-15,
  2.899359106785716e-16, -1.052075386104171e-17,  1.202037246474819e-05, -4.109263420228804e-06,  7.529064791282732e-07, -9.529451628803519e-08,  9.284244409240831e-09,
 -7.391338047855488e-10,  4.993143091207780e-11, -2.937228906596054e-12,  1.533148662631191e-13, -7.202930268940462e-15,  3.080105847308215e-16, -1.208155656918437e-17,
  3.611552473122307e-06, -1.405702048605667e-06,  2.924843055874715e-07, -4.162782118930585e-08,  4.515048378171575e-09, -3.964902739893210e-10,  2.929987504990988e-11,
 -1.871402863700051e-12,  1.053493313804177e-13, -5.305658639866131e-15,  2.418752240290783e-16, -1.006275836325345e-17,  9.610295863881265e-07, -4.034421705083151e-07,
  9.061012012434166e-08, -1.384625647350436e-08,  1.602911078562243e-09, -1.493922731654804e-10,  1.165643563793399e-11, -7.824175679569389e-13,  4.609330876573470e-14,
 -2.420031949276659e-15,  1.146167111399710e-16, -4.937995173898108e-18,  7.146120535119033e-05, -3.270651877593352e-06,  9.363673161635490e-08, -2.149704628777681e-09,
  4.321509279039823e-11, -7.931969967203648e-13,  1.360460473745769e-14, -2.212075485459413e-16,  3.442502042547092e-18, -5.162719868855052e-20,  7.498388473335403e-22,
 -1.058686923425066e-23,  3.527716236820955e-04, -1.998115295984246e-05,  7.275014130083550e-07, -2.133111318888767e-08,  5.447282753431243e-10, -1.258954307924930e-11,
  2.693021234037995e-13, -5.409837267056549e-15,  1.030919231115566e-16, -1.877412614615122e-18,  3.285545781338676e-20, -5.548090839508519e-22,  6.211948916412008e-04,
 -4.565629263112391e-05,  2.141993560266094e-06, -7.956262285153304e-08,  2.533049068761412e-09, -7.198864087323710e-11,  1.871226634564370e-12, -4.520401685678669e-14,
  1.026344084159724e-15, -2.208331060510656e-17,  4.531368486841654e-19, -8.908154286051919e-21,  5.919334807716467e-04, -5.741135695717776e-05,  3.448734070685778e-06,
 -1.601698327898640e-07,  6.262246790481984e-09, -2.154192805762046e-10,  6.696033443557184e-12, -1.914251879497665e-13,  5.096199218087969e-15, -1.275167442123126e-16,
  3.020177527778398e-18, -6.805623227581080e-20,  3.580568144087349e-04, -4.580004881745552e-05,  3.491630426504543e-06, -2.007391536602308e-07,  9.538521529540208e-09,
 -3.929843763733963e-10,  1.445268748302606e-11, -4.837453676980233e-13,  1.493997169180762e-14, -4.301108074299884e-16,  1.163366543905941e-17, -2.973084187740596e-19,
  1.507596340967583e-04, -2.518159691507572e-05,  2.415440378546943e-06, -1.705213608829763e-07,  9.769324287079156e-09, -4.782145978267409e-10,  2.064088487092128e-11,
 -8.022988304713119e-13,  2.850808803532344e-14, -9.364499197582051e-16,  2.868366239142094e-17, -8.243029303634164e-19,  4.767279845524712e-05, -1.023221088838198e-05,
  1.222725662224531e-06, -1.051160798593675e-07,  7.204309813146767e-09, -4.157911976198723e-10,  2.090093650308892e-11, -9.361156339474440e-13,  3.796901287098139e-14,
 -1.411729475723412e-15,  4.857236851378033e-17, -1.556786603350506e-18,  1.230593865649831e-05, -3.317807119906128e-06,  4.869661463023013e-07, -5.039163202946900e-08,
  4.088288341752125e-09, -2.754072231484850e-10,  1.596488867697103e-11, -8.158967184323816e-13,  3.740779674546280e-14, -1.559012244932849e-15,  5.966697191200488e-17,
 -2.112115708475281e-18,  2.873126218599234e-06, -9.421861442147000e-07,  1.660183343578661e-07, -2.028614835077683e-08,  1.914805772891978e-09, -1.481425950113117e-10,
  9.751375616416252e-12, -5.602392629979597e-13,  2.861872425256728e-14, -1.318224700584374e-15,  5.535511458081606e-17, -2.135337369241768e-18,  6.746549041590334e-07,
 -2.571516875807671e-07,  5.242125845066239e-08, -7.322660549991706e-09,  7.809144952164408e-10, -6.753540550776453e-11,  4.922029517274604e-12, -3.104369033678386e-13,
  1.727625058692181e-14, -8.609887424856335e-16,  3.887507707944310e-17, -1.603127101000727e-18,  1.513401979368326e-07, -6.313252915929974e-08,  1.408753825935373e-08,
 -2.139701024966551e-09,  2.463173920634429e-10, -2.283872656434590e-11,  1.773551763520894e-12, -1.185249317903066e-13,  6.954155051072229e-15, -3.637396608501065e-16,
  1.716703763518162e-17, -7.371961011347328e-19,  5.972854646396629e-05, -2.614089359054199e-06,  7.151762167362392e-08, -1.569336325594172e-09,  3.017229240107476e-11,
 -5.300949839117325e-13,  8.710168555600756e-15, -1.357973996657776e-16,  2.027907437687786e-18, -2.920736621831218e-20,  4.076590763922585e-22, -5.534949385352039e-24,
  2.830524077472270e-04, -1.505395455728748e-05,  5.165242452979152e-07, -1.432413186926988e-08,  3.469915767591360e-10, -7.625654143995312e-12,  1.554165576533294e-13,
 -2.979693096360372e-15,  5.427314174241902e-17, -9.459569864538142e-19,  1.586316095120932e-20, -2.569708097850817e-22,  4.676409374510113e-04, -3.174582504432127e-05,
  1.389772932506568e-06, -4.848382749460352e-08,  1.456312226860011e-09, -3.918266029167721e-11,  9.669122803251473e-13, -2.222743609880610e-14,  4.812175194109640e-16,
 -9.890800444460273e-18,  1.941867683094339e-19, -3.658092178639869e-21,  4.073297292696586e-04, -3.608488125809814e-05,  2.009693874112812e-06, -8.724732362364942e-08,
  3.206622146774427e-09, -1.041387250944069e-10,  3.066635221579972e-12, -8.329638502649073e-14,  2.112271204252778e-15, -5.045584188389305e-17,  1.143096721431769e-18,
 -2.468458236139811e-20,  2.184721942620685e-04, -2.540236856774603e-05,  1.789549069789522e-06, -9.594339553047224e-08,  4.278767310309274e-09, -1.662686729362215e-10,
  5.790558914061202e-12, -1.841573740794051e-13,  5.419850091189212e-15, -1.490725869596256e-16,  3.861106790816110e-18, -9.468968568980190e-20,  7.869537193701196e-05,
 -1.196942837866608e-05,  1.061463338369115e-06, -6.992718145438723e-08,  3.763845984578843e-09, -1.740160862762705e-10,  7.124868614015253e-12, -2.636687813792410e-13,
  8.948349549558522e-15, -2.815311935180174e-16,  8.279986047438204e-18, -2.290009120854270e-19,  2.043095105820723e-05, -4.027295847415853e-06,  4.473166390473905e-07,
 -3.605254852028038e-08,  2.331817159417521e-09, -1.276727609179781e-10,  6.115129644698363e-12, -2.619394245955118e-13,  1.019375313275918e-14, -3.646917172377423e-16,
  1.210421406592823e-17, -3.751159818568454e-19,  4.147291000662864e-06, -1.042800191073735e-06,  1.438647177481163e-07, -1.409176857909534e-08,  1.088377832071679e-09,
 -7.012814180860931e-11,  3.903809735062845e-12, -1.922412565311641e-13,  8.518330363193830e-15, -3.440031612105892e-16,  1.278740062548614e-17, -4.405884946280415e-19,
  7.362697894635922e-07, -2.300024473060175e-07,  3.875131171075918e-08, -4.549019378393694e-09,  4.142316111767975e-10, -3.102780833455487e-11,  1.983459683250815e-12,
 -1.109617289333492e-13,  5.532262938614520e-15, -2.492216392138701e-16,  1.025388948155175e-17, -3.881995218875442e-19,  1.316788412207905e-07, -4.893587380271496e-08,
  9.735155838158635e-09, -1.330145456940775e-09,  1.390582761443268e-10, -1.181273773577810e-11,  8.471195814604619e-13, -5.265221837490096e-14,  2.891453232593123e-15,
 -1.423636803736771e-16,  6.357130262564580e-18, -2.595129226045685e-19,  2.419704154863464e-08, -1.001736481144426e-08,  2.218103706633578e-09, -3.344882359189101e-10,
  3.825280289203979e-11, -3.525523784855606e-12,  2.722692037326132e-13, -1.810351544931535e-14,  1.057231993162077e-15, -5.506105352208741e-17,  2.588307045016375e-18,
 -1.107384320598183e-19,  5.030781098355652e-05, -2.109807540190248e-06,  5.526581503518794e-08, -1.161209072603068e-09,  2.138699426313481e-11, -3.602157359494999e-13,
  5.678228328187041e-15, -8.500158345981906e-17,  1.219538597250190e-18, -1.688959637252830e-20,  2.268223864240200e-22, -2.963410622828273e-24,  2.301318088330444e-04,
 -1.152533929264236e-05,  3.734995936401210e-07, -9.814907946985440e-09,  2.259156007888668e-10, -4.728160766377395e-12,  9.193995698123247e-14, -1.684482342177750e-15,
  2.936054815360228e-17, -4.903197087050884e-19,  7.887031252399015e-21, -1.226765027757376e-22,  3.596991089783985e-04, -2.261105093427635e-05,  9.254856011937683e-07,
 -3.037524584828020e-08,  8.620757762710864e-10, -2.198738746595358e-11,  5.157069379744684e-13, -1.129293081862625e-14,  2.333431765352194e-16, -4.585214397466451e-18,
  8.619582160635606e-20, -1.556949580986816e-21,  2.895656720339712e-04, -2.345875594524603e-05,  1.212906356596519e-06, -4.927900504087375e-08,  1.704275947144690e-09,
 -5.229758676036672e-11,  1.460007421732815e-12, -3.770110791768529e-14,  9.110831290679930e-16, -2.078360376315118e-17,  4.505248390391658e-19, -9.325052571206986e-21,
  1.395663141446569e-04, -1.473856953864179e-05,  9.596503304852645e-07, -4.799024192303113e-08,  2.009021334889921e-09, -7.363908905036006e-11,  2.428565705266370e-12,
 -7.337955854405172e-14,  2.057590555478266e-15, -5.405512634812655e-17,  1.340250387275821e-18, -3.152865506376636e-20,  4.364643160671513e-05, -6.025057829065640e-06,
  4.932312250492817e-07, -3.028619880995065e-08,  1.529963390575215e-09, -6.674298730393508e-11,  2.589672437042178e-12, -9.115185113497599e-14,  2.951610725111899e-15,
 -8.885015252698107e-17,  2.506421754316628e-18, -6.664203444957556e-20,  9.431240272184779e-06, -1.697427265859556e-06,  1.746065380146800e-07, -1.315541261213986e-08,
  8.009483704894528e-10, -4.150814676149187e-11,  1.890285450780706e-12, -7.728071845764825e-14,  2.879995282297234e-15, -9.895492044557885e-17,  3.162505451471454e-18,
 -9.459819932729043e-20,  1.517120339817272e-06, -3.530260507659308e-07,  4.552460236501537e-08, -4.201725753260451e-09,  3.077237978153862e-10, -1.889848770280075e-11,
  1.007031913835351e-12, -4.764470113943737e-14,  2.034789883071862e-15, -7.942224369122687e-17,  2.860615884993925e-18, -9.571966247120567e-20,  2.036029361574120e-07,
 -6.011390265453238e-08,  9.623236684426421e-09, -1.079546725378559e-09,  9.440264849700477e-11, -6.818694735013096e-12,  4.217999833330969e-13, -2.290346731784986e-14,
  1.111264778698650e-15, -4.883043576513155e-17,  1.963687503456299e-18, -7.279949252830554e-20,  2.705097905280098e-08, -9.748811556796730e-09,  1.883681257014580e-09,
 -2.507227036582789e-10,  2.560532091096905e-11, -2.130008901967960e-12,  1.498961692648049e-13, -9.159547722490581e-15,  4.953133608311676e-16, -2.404801275317116e-17,
  1.060216955086988e-18, -4.277933865543307e-20,  3.939572471510581e-09, -1.615874336714856e-09,  3.544840965502796e-10, -5.299960136308467e-11,  6.014056943345413e-12,
 -5.503633142923077e-13,  4.223001777849183e-14, -2.791424423092883e-15,  1.621392919825362e-16, -8.402480989931888e-18,  3.931809825658296e-19, -1.675110993832554e-20,
  4.267212876309954e-05, -1.718104933455816e-06,  4.316866544225837e-08, -8.699837759021539e-10,  1.537328666829808e-11, -2.485939198301383e-13,  3.764281012849328e-15,
 -5.417998226380256e-17,  7.476937104151677e-19, -9.966399120480230e-21,  1.290489760021873e-22, -1.620964834590694e-24,  1.893386810751337e-04, -8.953489493897042e-06,
  2.746367292435699e-07, -6.851189944882360e-09,  1.500842100796949e-10, -2.995788517334704e-12,  5.565420333138400e-14, -9.756588371183777e-16,  1.629230444997164e-17,
 -2.609683630054022e-19,  4.030983802269604e-21, -6.025101660740911e-23,  2.820460495646165e-04, -1.646022330672952e-05,  6.311475509288434e-07, -1.952160537894106e-08,
  5.242758759773318e-10, -1.269274889677651e-11,  2.832948670645125e-13, -5.915730886772941e-15,  1.167753386208182e-16, -2.195661617737149e-18,  3.955196026333566e-20,
 -6.855051544413180e-22,  2.119552460911599e-04, -1.572602601922160e-05,  7.559643269006268e-07, -2.878177052668363e-08,  9.377087872749664e-10, -2.721483391084024e-11,
  7.208763008044374e-13, -1.770915482903173e-14,  4.080724223627839e-16, -8.894315403216980e-18,  1.845471908657632e-19, -3.662387826482518e-21,  9.296532802726807e-05,
 -8.912796056012144e-06,  5.366596074983592e-07, -2.504588338759436e-08,  9.846514298781988e-10, -3.405459744109442e-11,  1.063749472087310e-12, -3.053991313403570e-14,
  8.159133300040367e-16, -2.047195552013033e-17,  4.858246131641719e-19, -1.096054766834730e-20,  2.561308105257309e-05, -3.199946918992501e-06,  2.415821792058971e-07,
 -1.381650760382360e-08,  6.546383668956998e-10, -2.692824373721289e-11,  9.894673468930744e-13, -3.310141822571682e-14,  1.021921504789749e-15, -2.940917404949354e-17,
  7.950712435339036e-19, -2.030510312463411e-20,  4.676286145911864e-06, -7.642703602594509e-07,  7.258532317350442e-08, -5.099907240348301e-09,  2.916669096284635e-10,
 -1.427904427131165e-11,  6.171405596847550e-13, -2.403874174895378e-14,  8.564022223849372e-16, -2.821325530542374e-17,  8.668049417422234e-19, -2.498617863070631e-20,
  6.028987896358190e-07, -1.288171707211951e-07,  1.544462798202893e-08, -1.337372135081824e-09,  9.253091673804397e-11, -5.398341414945701e-12,  2.745213946778339e-13,
 -1.244338564564755e-14,  5.108555449377730e-16, -1.922474904979048e-17,  6.693608016816638e-19, -2.170354676299442e-20,  6.112156582488344e-08, -1.690736422285750e-08,
  2.554347528329581e-09, -2.723086743608466e-10,  2.275818116430516e-11, -1.578458941386872e-12,  9.413232602207234e-14, -4.944313625261787e-15,  2.327400189160784e-16,
 -9.947436706866838e-18,  3.899858762227947e-19, -1.412411057434497e-20,  5.897862580455428e-09, -2.047582083808534e-09,  3.821053366649851e-10, -4.930846472501543e-11,
  4.899092493561216e-12, -3.976669605664419e-13,  2.737733243960127e-14, -1.640185870223372e-15,  8.712575034758014e-17, -4.162141977484729e-18,  1.808170602810853e-19,
 -7.198800139972122e-21,  6.556139419836441e-10, -2.658437049982138e-10,  5.766296001102005e-11, -8.532659952873563e-12,  9.592461854434515e-13, -8.704812058979888e-14,
  6.628685729550702e-15, -4.351443577281586e-16,  2.511678592626090e-17, -1.294154189985039e-18,  6.023934614624982e-20, -2.554045615636900e-21,  3.642973133835134e-05,
 -1.410681645914808e-06,  3.405522314425210e-08, -6.593486668417800e-10,  1.119464103285635e-11, -1.740510593975790e-13,  2.534640909665532e-15, -3.512242035601216e-17,
  4.669093209098736e-19, -5.987427257876645e-21,  7.508362379804300e-23, -9.047597012402231e-25,  1.574503915308278e-04, -7.048554132494774e-06,  2.050653473198049e-07,
 -4.864925208682388e-09,  1.015839622957985e-10, -1.936680299685988e-12,  3.441744576995585e-14, -5.780339831308140e-16,  9.258445120611393e-18, -1.423712024340990e-19,
  2.114472954178769e-21, -3.039211648416688e-23,  2.249984764829123e-04, -1.222262152100363e-05,  4.399007567076734e-07, -1.284417417171820e-08,  3.269026775939849e-10,
 -7.522518304826890e-12,  1.599642666012806e-13, -3.188830041493750e-15,  6.019468812514545e-17, -1.083952396685455e-18,  1.872585774195039e-20, -3.116449592426676e-22,
  1.592714854818150e-04, -1.084077985471061e-05,  4.852822069630994e-07, -1.733816850178831e-08,  5.327918215242345e-10, -1.464025517116618e-11,  3.682850772503009e-13,
 -8.613949238134683e-15,  1.893968631721659e-16, -3.946535016478035e-18,  7.841841474294422e-20, -1.492722418929078e-21,  6.431688874189509e-05, -5.597901895025858e-06,
  3.119694747029079e-07, -1.359829467698648e-08,  5.023754247307248e-10, -1.640271470414848e-11,  4.854848243658387e-13, -1.324746456578107e-14,  3.372745991268247e-16,
 -8.083146195342804e-18,  1.836022792382763e-19, -3.972263732054840e-21,  1.583489970783647e-05, -1.786300634372840e-06,  1.243116850662510e-07, -6.619862809436814e-09,
  2.940972327935941e-10, -1.140334129263452e-11,  3.966503000647641e-13, -1.260602369379948e-14,  3.708521994686195e-16, -1.019723388698896e-17,  2.640338919740140e-19,
 -6.472456040670229e-21,  2.481790232310819e-06, -3.664711185023722e-07,  3.205573703228726e-08, -2.096298459843712e-09,  1.124280098736793e-10, -5.191484218186764e-12,
  2.126258120411970e-13, -7.879356787988615e-15,  2.679626397883814e-16, -8.451956496138486e-18,  2.492767812227901e-19, -6.914688032742520e-21,  2.601628570446760e-07,
 -5.064224219671061e-08,  5.617328326631494e-09, -4.545474593621050e-10,  2.960982015315618e-11, -1.636020681106761e-12,  7.917410869880057e-14, -3.429230512556797e-15,
  1.350008422331908e-16, -4.886748132290656e-18,  1.641084495897576e-19, -5.145207885144608e-21,  2.002084018207890e-08, -5.139176326321573e-09,  7.276058506680210e-10,
 -7.328954005333518e-11,  5.825280688227515e-12, -3.862918832475490e-13,  2.212299252692778e-14, -1.120122603593175e-15,  5.099103972407679e-17, -2.113629408666811e-18,
  8.056547478841222e-20, -2.843364534275417e-21,  1.377361200202776e-09, -4.569441495031094e-10,  8.180838707633586e-11, -1.017824667154895e-11,  9.791955664365026e-13,
 -7.724153282633205e-14,  5.183636524356670e-15, -3.035210914567646e-16,  1.579348581652966e-17, -7.405232107298939e-19,  3.163003523873619e-20, -1.240030235459728e-21,
  1.120590504889923e-10, -4.479091677039998e-11,  9.580815429333118e-12, -1.399988053660733e-12,  1.556269561755565e-13, -1.398115622606033e-14,  1.055081391790346e-15,
 -6.869931123753011e-17,  3.936207316839883e-18, -2.014586708873992e-19,  9.320108942411956e-21, -3.929525590020546e-22,  3.128575293291272e-05, -1.167088283478502e-06,
  2.711271163969298e-08, -5.050837596841820e-10,  8.250226170421639e-12, -1.235126819678015e-13,  1.731707030084612e-15, -2.312008877256509e-17,  2.970550942427189e-19,
 -3.649218781340518e-21,  4.461551236341922e-23, -5.196432787089108e-25,  1.322029500515615e-04, -5.616594164088741e-06,  1.552917679183172e-07, -3.509526269703494e-09,
  6.995442201716819e-11, -1.275613431982426e-12,  2.171258760123076e-14, -3.497420453374609e-16,  5.380843348155562e-18, -7.946815493278135e-20,  1.136599403576506e-21,
 -1.573175785839213e-23,  1.822822413571581e-04, -9.241233584373594e-06,  3.127897153470184e-07, -8.635598301156241e-09,  2.086002711748809e-10, -4.568640659529831e-12,
  9.267174343993430e-14, -1.765504323491702e-15,  3.190192236624998e-17, -5.506856387394895e-19,  9.131093335805507e-21, -1.460345167273589e-22,  1.225339208872819e-04,
 -7.665330329287307e-06,  3.200675792144690e-07, -1.074687122019447e-08,  3.118907614912511e-10, -8.123277204607713e-12,  1.942571901215373e-13, -4.329647225129646e-15,
  9.090241258930823e-17, -1.812113630332369e-18,  3.450108830220442e-20, -6.302441661454077e-22,  4.604787477789229e-05, -3.639584845007065e-06,  1.879444782589894e-07,
 -7.658829541784353e-09,  2.661148302595114e-10, -8.208186534525569e-12,  2.303289058627695e-13, -5.976243921039433e-15,  1.450436427678163e-16, -3.321152907756052e-18,
  7.221558281648807e-20, -1.498416106122024e-21,  1.026926337152544e-05, -1.044049771920619e-06,  6.697786328279496e-08, -3.321216992781809e-09,  1.383540512081494e-10,
 -5.056444950770238e-12,  1.664740447994331e-13, -5.025159116584028e-15,  1.408307801468727e-16, -3.698621497077334e-18,  9.168241153288076e-20, -2.156225409102716e-21,
  1.404134254445734e-06, -1.864691504090938e-07,  1.499531733240379e-08, -9.114281622602852e-10,  4.578295515030722e-11, -1.991655577234756e-12,  7.721019917115181e-14,
 -2.718893779773736e-15,  8.816253681291118e-17, -2.659256763568303e-18,  7.520051736962863e-20, -2.004922238059566e-21,  1.216997748252922e-07, -2.141649667382900e-08,
  2.188114338127418e-09, -1.648848314936016e-10,  1.008224959095584e-11, -5.261539859961996e-13,  2.417091617880996e-14, -9.979920851031062e-16,  3.758940080162739e-17,
 -1.305957188048836e-18,  4.221298765906402e-20, -1.277163686290897e-21,  7.183168062161143e-09, -1.693528825731710e-09,  2.231015067115231e-10, -2.111164288177803e-11,
  1.588082627432945e-12, -1.002549779981128e-13,  5.492608339235511e-15, -2.671330882479055e-16,  1.172242244954873e-17, -4.698424115258038e-19,  1.736413529503130e-20,
 -5.956490899152110e-22,  3.479523297793389e-10, -1.092371840313417e-10,  1.861849032298203e-11, -2.219207383179073e-12,  2.056201351035738e-13, -1.568981224919614e-14,
  1.022262760007121e-15, -5.829438596232482e-17,  2.961981863684443e-18, -1.359286897085923e-19,  5.693959228893357e-21, -2.193175890528720e-22,  1.979386953504988e-11,
 -7.768806728186629e-12,  1.633123267072141e-12, -2.349728817425099e-13,  2.576503145267356e-14, -2.286724027601464e-15,  1.707088479979807e-16, -1.100811676264617e-17,
  6.252459981568280e-19, -3.174938814590748e-20,  1.458354210896428e-21, -6.108825127609228e-23,  2.701575462282374e-05, -9.723606368758074e-07,  2.176896655339206e-08,
 -3.907862440239287e-10,  6.148223634981260e-12, -8.875601018321891e-14,  1.199893998056742e-15, -1.541220156959325e-17,  1.929475718556477e-19, -2.252411819050082e-21,
  2.668936421693466e-23, -3.173044423721574e-25,  1.119790369802483e-04, -4.525459879627451e-06,  1.191345633612653e-07, -2.569050959333802e-09,  4.895034257976472e-11,
 -8.549277561469264e-13,  1.395585761947558e-14, -2.157486077333979e-16,  3.195311639421858e-18, -4.531341716187287e-20,  6.243624614508319e-22, -8.368532774569576e-24,
  1.497374803502878e-04, -7.102920286329313e-06,  2.265229098535073e-07, -5.923076804629402e-09,  1.359912326020607e-10, -2.838448028611479e-12,  5.498753893286709e-14,
 -1.002233687275087e-15,  1.735308996119919e-17, -2.874138417403055e-19,  4.577929434516872e-21, -7.041341108524593e-23,  9.628225497782713e-05, -5.546689902250543e-06,
  2.164059160337874e-07, -6.839024580453346e-09,  1.877011033911449e-10, -4.639107398147269e-12,  1.055695249185397e-13, -2.244328181606798e-15,  4.502781031567591e-17,
 -8.594183436509324e-19,  1.568819904992605e-20, -2.751385301295844e-22,  3.400246904080180e-05, -2.442043217167010e-06,  1.170055789122585e-07, -4.462652758770563e-09,
  1.459811966616801e-10, -4.257160084616101e-12,  1.133347167925081e-13, -2.797856775925464e-15,  6.475938426018882e-17, -1.417300598860632e-18,  2.951025175836486e-20,
 -5.873389931243286e-22,  6.956818121078955e-06, -6.364935092037461e-07,  3.765952359062379e-08, -1.739538003985210e-09,  6.797090450734505e-11, -2.341944654613618e-12,
  7.298755371777530e-14, -2.092631234648913e-15,  5.586316734024135e-17, -1.401076448871925e-18,  3.324102489591921e-20, -7.497997896525001e-22,  8.431946146988220e-07,
 -1.002839966064956e-07,  7.405952459827544e-09, -4.179903967002789e-10,  1.964986428407952e-11, -8.046638228464387e-13,  2.950208645351758e-14, -9.863732193692581e-16,
  3.046850851143225e-17, -8.780434162157007e-19,  2.378441588631508e-20, -6.088641047558721e-22,  6.153988617730229e-08, -9.717531172809155e-09,  9.111373727767247e-10,
 -6.375035952475094e-11,  3.649937240014125e-12, -1.794908265362534e-13,  7.810287951994093e-15, -3.067762608143734e-16,  1.103289964163726e-17, -3.671893286751107e-19,
  1.140229432119281e-20, -3.322921058271428e-22,  2.829339827654483e-09, -6.060746246916374e-10,  7.377948937748771e-11, -6.522742793430433e-12,  4.621865491176367e-13,
 -2.766180758630943e-14,  1.444333665830340e-15, -6.724344749591904e-17,  2.835430660936934e-18, -1.095638630584791e-19,  3.915132435546424e-21, -1.301999003439166e-22,
  9.604657729216768e-11, -2.820548541298486e-11,  4.536780993377642e-12, -5.144011358258262e-13,  4.563057115867123e-14, -3.350864298089575e-15,  2.110199665009005e-16,
 -1.167310938000224e-17,  5.771476651452433e-19, -2.584175464007291e-20,  1.058627569035624e-21, -3.996002415822796e-23,  3.642240684030773e-12, -1.396314508995401e-12,
  2.871688838041163e-13, -4.053091823601864e-14,  4.370140005629346e-15, -3.821736412687083e-16,  2.815988758897158e-17, -1.794921365327063e-18,  1.008964690601519e-19,
 -5.075876777549920e-21,  2.311979912529840e-22, -9.611121980771225e-24,  2.344711081055760e-05, -8.154197515546636e-07,  1.761587783679128e-08, -3.051860297624881e-10,
  4.629435753396756e-12, -6.450754745377274e-14,  8.439247035544076e-16, -1.035431180772344e-17,  1.280440147511896e-19, -1.428725361850749e-21,  1.523894723536631e-23,
 -2.142127443746515e-25,  9.560532369443114e-05, -3.683573996895877e-06,  9.249473135666438e-08, -1.906299275887536e-09,  3.476576782227687e-11, -5.822757336777492e-13,
  9.131758166657139e-15, -1.354180352907837e-16,  1.936959661661938e-18, -2.640969896526089e-20,  3.481252836321161e-22, -4.592703787318015e-24,  1.245470783780687e-04,
 -5.541946840416506e-06,  1.668364414790165e-07, -4.138188481218265e-09,  9.043410157890481e-11, -1.801181045146120e-12,  3.336447417101228e-14, -5.824200944537292e-16,
  9.672304726482347e-18, -1.538623241715570e-19,  2.356141682656835e-21, -3.487606824673479e-23,  7.710201471814879e-05, -4.098913444202038e-06,  1.496889928220546e-07,
 -4.459165933199218e-09,  1.158997445383771e-10, -2.721491442761938e-12,  5.899305553550537e-14, -1.197606626320098e-15,  2.297510460773025e-17, -4.201926528094137e-19,
  7.361617647291399e-21, -1.239555596954244e-22,  2.581581569166151e-05, -1.686126749197623e-06,  7.507313168624678e-08, -2.683266043222708e-09,  8.272903678726318e-11,
 -2.283133814710725e-12,  5.770860610079752e-14, -1.356533636730315e-15,  2.995818310956503e-17, -6.269918990568929e-19,  1.250726875146734e-20, -2.388070348437968e-22,
  4.903272895015013e-06, -4.032544389969224e-07,  2.202606333674262e-08, -9.483444825174028e-10,  3.477804921037909e-11, -1.130175254261643e-12,  3.335135581848131e-14,
 -9.084619228353286e-16,  2.310225319472352e-17, -5.533439022888600e-19,  1.256487540745390e-20, -2.717780508481246e-22,  5.349858623178638e-07, -5.676799695323195e-08,
  3.848404140956915e-09, -2.015947099604597e-10,  8.865759644388346e-12, -3.416031493458272e-13,  1.183899135138158e-14, -3.756070085408819e-16,  1.104548645879993e-17,
 -3.039072901513099e-19,  7.879795712230303e-21, -1.935306149816247e-22,  3.351340838311747e-08, -4.714370432894744e-09,  4.045135485524955e-10, -2.621835585406802e-11,
  1.402707402523984e-12, -6.488095294525981e-14,  2.669383911854413e-15, -9.957111076167032e-17,  3.413417438822695e-18, -1.086415308579559e-19,  3.235646177663163e-21,
 -9.067786440464940e-23,  1.224102450262479e-09, -2.355890238132346e-10,  2.633150013376525e-11, -2.163840555522451e-12,  1.438010841915091e-13, -8.127869445628348e-15,
  4.030387920133307e-16, -1.790383362463197e-17,  7.232210088315865e-19, -2.686513894011850e-20,  9.257056392511182e-22, -2.976832771655440e-23,  2.925008009007138e-11,
 -7.926768989801811e-12,  1.191729600577737e-12, -1.275556686259083e-13,  1.076349920664975e-14, -7.564975135465275e-16,  4.582472830753492e-17, -2.448531012715460e-18,
  1.173527633484805e-19, -5.109113888951325e-21,  2.040518948123390e-22, -7.527152336094715e-24,  7.054133079492969e-13, -2.622409450914540e-13,  5.245021128448115e-14,
 -7.226659328091818e-15,  7.631463585826225e-16, -6.554048508193165e-17,  4.753228087551857e-18, -2.987602220351521e-19,  1.658650868555524e-20, -8.252212495825381e-22,
  3.721503962413184e-23, -1.533270153487659e-24,  2.044574858925445e-05, -6.879738110582318e-07,  1.435881053343265e-08, -2.404266013116766e-10,  3.520548281646263e-12,
 -4.731314889269195e-14,  6.043734457358979e-16, -6.979419314171328e-18,  8.549443268758454e-20, -9.877311495656694e-22,  7.277216617362608e-24, -1.492523124190517e-25,
  8.221833805448683e-05, -3.026475842312856e-06,  7.260768238225081e-08, -1.432476843676202e-09,  2.503753777418553e-11, -4.024013435412100e-13,  6.081964852517553e-15,
 -8.631253324965627e-17,  1.194512611696018e-18, -1.584749813274868e-20,  1.944808162941129e-22, -2.588029779734526e-24,  1.047656141812021e-04, -4.383770592991132e-06,
  1.247982391643369e-07, -2.940899648574548e-09,  6.125821294180961e-11, -1.165686741736524e-12,  2.067137056238708e-14, -3.459676468939109e-16,  5.515816550614644e-18,
 -8.435450030043454e-20,  1.243168084296434e-21, -1.771792293870986e-23,  6.280210696759640e-05, -3.087604713071236e-06,  1.057304713417430e-07, -2.973349209962060e-09,
  7.328875521498554e-11, -1.637157230920732e-12,  3.382967763658117e-14, -6.567790430136101e-16,  1.205582409062896e-17, -2.113103263736222e-19,  3.561143010868594e-21,
 -5.753271457330324e-23,  2.009628926677913e-05, -1.194874657844472e-06,  4.952170366018195e-08, -1.660852913033017e-09,  4.832227374865730e-11, -1.263446123474084e-12,
  3.033896903745960e-14, -6.798257609536220e-16,  1.433232117646365e-17, -2.869260903664633e-19,  5.489633444959254e-21, -1.005440833048235e-22,  3.581997857699603e-06,
 -2.645797113382918e-07,  1.335911633348522e-08, -5.365849321763936e-10,  1.848309525594115e-11, -5.668889633438744e-13,  1.584578923731270e-14, -4.102836664374519e-16,
  9.941204849586390e-18, -2.274173773618865e-19,  4.943663361197250e-21, -1.025276863330224e-22,  3.569947353717070e-07, -3.367998678028190e-08,  2.096644995851072e-09,
 -1.019291868530702e-10,  4.193468802401710e-12, -1.520167254173623e-13,  4.978797625854015e-15, -1.498535260218815e-16,  4.193619024991985e-18, -1.101117860976039e-19,
  2.731454262931021e-21, -6.432415917782847e-23,  1.956782821852478e-08, -2.435152600943344e-09,  1.908659430730710e-10, -1.143979630660079e-11,  5.710912773577538e-13,
 -2.481099829784438e-14,  9.638290021032932e-16, -3.409526594645952e-17,  1.112583644028196e-18, -3.381702907108375e-20,  9.646103454065222e-22, -2.595889507956837e-23,
  5.809877320413971e-10, -9.931567437825348e-11,  1.013518433699757e-11, -7.706740831658067e-13,  4.785097570154702e-14, -2.545408642647277e-15,  1.194882660089822e-16,
 -5.049453245746293e-18,  1.948489802291457e-19, -6.939354013216645e-21,  2.299822081048865e-22, -7.133929690833216e-24,  9.911224355239315e-12, -2.440464200023694e-12,
  3.394855985957631e-13, -3.402772493232254e-14,  2.713225380810982e-15, -1.814644965051546e-16,  1.051985679253264e-17, -5.405037098398912e-19,  2.500995605663984e-20,
 -1.054849711824197e-21,  4.093681778230096e-23, -1.471284335510494e-24,  1.457180283130748e-13, -5.200471549373923e-14,  1.003572224515095e-14, -1.341384033433403e-15,
  1.380298213581382e-16, -1.159273384425123e-17,  8.246061569851660e-19, -5.095754740412352e-20,  2.787017388956416e-21, -1.368317319615506e-22,  6.098015619618022e-24,
 -2.485906155213182e-25,  1.790658503974165e-05, -5.837533189497383e-07,  1.178282110534919e-08, -1.909411152277424e-10,  2.704970258791232e-12, -3.487526620301881e-14,
  4.422377549597120e-16, -4.767960003818771e-18,  5.378424511589297e-20, -8.063978596956569e-22,  2.405667186340315e-24, -6.360147268437019e-26,  7.117415764801288e-05,
 -2.508126970929410e-06,  5.757959737869952e-08, -1.089079821919903e-09,  1.827369076319619e-11, -2.815943797296241e-13,  4.124121745278603e-15, -5.591371925543781e-17,
  7.401727170246120e-19, -9.959973639759366e-21,  1.084599409032146e-22, -1.403535263094968e-24,  8.902518464677526e-05, -3.511497354614520e-06,  9.469798680417125e-08,
 -2.123290270035800e-09,  4.221326308436344e-11, -7.683708952485958e-13,  1.305934783700235e-14, -2.097926804404200e-16,  3.213785362383292e-18, -4.728792379270401e-20,
  6.715243059915325e-22, -9.226031385357393e-24,  5.194258977318333e-05, -2.366777179252855e-06,  7.613299934517996e-08, -2.024109871037459e-09,  4.737385179299183e-11,
 -1.008484906656896e-12,  1.986792862878659e-14, -3.694977771612770e-16,  6.502121404111899e-18, -1.089348935386677e-19,  1.773921280942789e-21, -2.753978729079908e-23,
  1.599922553748829e-05, -8.669704440851573e-07,  3.350900562758497e-08, -1.055934321249056e-09,  2.902510050196015e-11, -7.201253610956106e-13,  1.643040316858093e-14,
 -3.514363308595560e-16,  7.081922110992490e-18, -1.354639377353032e-19,  2.491657886833990e-21, -4.379902225651809e-23,  2.702754118878449e-06, -1.791799460642800e-07,
  8.377957431811570e-09, -3.142389246066468e-10,  1.017580968013535e-11, -2.948887799425776e-13,  7.809059563520660e-15, -1.923501965662402e-16,  4.443379494073510e-18,
 -9.705537285570251e-20,  2.021391294435005e-21, -4.019878911114509e-23,  2.494257895647737e-07, -2.085380692889015e-08,  1.193436673952879e-09, -5.385825560607538e-11,
  2.073366863314711e-12, -7.073864915745500e-14,  2.189109687415645e-15, -6.251147003784413e-17,  1.664598427126927e-18, -4.169459476258749e-20,  9.893453315258681e-22,
 -2.233024891529313e-23,  1.218984666504155e-08, -1.332906227000819e-09,  9.536957153263604e-11, -5.279640182135589e-12,  2.456980293289728e-13, -1.001718248740207e-14,
  3.670357525178321e-16, -1.230102680571312e-17,  3.816808544591435e-19, -1.106640840043130e-20,  3.019843220262470e-22, -7.794636659484204e-24,  3.016258520562913e-10,
 -4.526362890242018e-11,  4.199317653898474e-12, -2.943408769614470e-13,  1.701983218657224e-14, -8.495795564981091e-16,  3.765004308369193e-17, -1.509609316049011e-18,
  5.550727852700764e-20, -1.890662365302493e-21,  6.012526519694468e-23, -1.794950287140430e-24,  3.760738272640928e-12, -8.268321101430275e-13,  1.053528803951796e-13,
 -9.810104945697557e-15,  7.342276685956648e-16, -4.645963018434110e-17,  2.564427868220194e-18, -1.261128647062737e-19,  5.610272509836961e-21, -2.283656766500684e-22,
  8.581566386947427e-24, -2.995374805443819e-25,  3.264781800202302e-14, -1.102968344117353e-14,  2.032496013929490e-15, -2.614310540477485e-16,  2.604549499335798e-17,
 -2.127996058526498e-18,  1.478130661688865e-19, -8.947529343577279e-21,  4.805889564797528e-22, -2.322136626832592e-23,  1.020323811336300e-24, -4.107328516231517e-26,
  1.574655865574496e-05, -4.979696478118575e-07,  9.729938864819625e-09, -1.527071854427224e-10,  2.103681658157941e-12, -2.569536419261336e-14,  3.285780532847615e-16,
 -3.495903757008177e-18,  2.617693324153791e-20, -7.246014579187670e-22,  2.893894887111164e-24,  1.026442901502959e-25,  6.198664704487714e-05, -2.095191124402056e-06,
  4.609513461005501e-08, -8.368661323226432e-10,  1.351730680199254e-11, -1.990300568573688e-13,  2.841583878731539e-15, -3.723193774919796e-17,  4.473478657469196e-19,
 -6.581055724583941e-21,  6.710830958564040e-23, -4.905030002226056e-25,  7.634779124838637e-05, -2.845415801863922e-06,  7.281402032664260e-08, -1.555594633616282e-09,
  2.955827992902355e-11, -5.152213853780693e-13,  8.401830812869877e-15, -1.297063650588754e-16,  1.910942861573841e-18, -2.706879345374897e-20,  3.705171224530786e-22,
 -4.926056557677643e-24,  4.355613985934316e-05, -1.843365240233455e-06,  5.580120727938859e-08, -1.404714690607546e-09,  3.124218151815718e-11, -6.354810773751315e-13,
  1.193082311091914e-14, -2.125455668430306e-16,  3.611231338061438e-18, -5.737644558144486e-20,  9.032283398609125e-22, -1.378693295762159e-23,  1.299709645673483e-05,
 -6.426587321136981e-07,  2.321017664010582e-08, -6.882641032997736e-10,  1.788429215672616e-11, -4.221714085071285e-13,  9.147785524308908e-15, -1.868314458249859e-16,
  3.615620014415354e-18, -6.578604924145723e-20,  1.164765560122879e-21, -1.983394137056021e-23,  2.099589549099154e-06, -1.248620531324921e-07,  5.417939059768776e-09,
 -1.900037417308460e-10,  5.787083071795530e-12, -1.587793744699619e-13,  3.982622284392880e-15, -9.336541852671128e-17,  2.060731427898970e-18, -4.290843603317887e-20,
  8.569343536045253e-22, -1.638175653612196e-23,  1.816869532316736e-07, -1.341909978186777e-08,  7.073407704092166e-10, -2.965020155094057e-11,  1.068287201345968e-12,
 -3.433958850777005e-14,  1.003916300596173e-15, -2.720233285398908e-17,  6.896620134921212e-19, -1.646846920300756e-20,  3.738261664101622e-22, -8.088341903517288e-24,
  8.060467364205368e-09, -7.691538505993749e-10,  5.027086376415367e-11, -2.568891744779047e-12,  1.113725574674134e-13, -4.260131839318602e-15,  1.471130662935882e-16,
 -4.668027005597700e-18,  1.376362222320624e-19, -3.803033256923865e-21,  9.919965870840444e-23, -2.453613490210691e-24,  1.705530503765788e-10, -2.219950078342619e-11,
  1.867389011371652e-12, -1.202893486609561e-13,  6.460966064133464e-15, -3.019524447123832e-16,  1.260343509081838e-17, -4.784224167646624e-19,  1.672601605390571e-20,
 -5.437101887250597e-22,  1.655661754223567e-23, -4.747140910722167e-25,  1.603863800248117e-12, -3.088338017657930e-13,  3.571100895163306e-14, -3.065839822157094e-15,
  2.140219320001371e-16, -1.274186221707970e-17,  6.663075531891768e-19, -3.122135775062923e-20,  1.329770388679924e-21, -5.203826053389401e-23,  1.886800055461981e-24,
 -6.375013446907243e-26,  8.097956247858450e-15, -2.539709986514030e-15,  4.410099058574152e-16, -5.404056921704369e-17,  5.171141465448527e-18, -4.083496479360595e-19,
  2.754999568618032e-20, -1.626226852398955e-21,  8.545350283626886e-23, -4.050326594513833e-24,  1.749708324756503e-25, -6.938326872875149e-27,  1.389951297262230e-05,
 -4.269243129804042e-07,  8.083747562404878e-09, -1.227629480583578e-10,  1.661095136917607e-12, -1.891247110189563e-14,  2.387284948477704e-16, -3.040441451804431e-18,
  3.873225648346331e-21, -4.513905986884007e-22,  1.240719211619349e-23,  3.218214615343543e-25,  5.428462297421113e-05, -1.763203016945029e-06,  3.723014130536328e-08,
 -6.490565806595893e-10,  1.014173976400915e-11, -1.419255147343341e-13,  1.967409757027817e-15, -2.621624318202188e-17,  2.558775824332829e-19, -4.074425653975489e-21,
  6.417113464480843e-23,  3.144178178960395e-25,  6.602332779671294e-05, -2.330249948455508e-06,  5.667682487627815e-08, -1.155262679721736e-09,  2.100834963419950e-11,
 -3.510565587364705e-13,  5.497835043619528e-15, -8.166344532423386e-17,  1.158161483236275e-18, -1.581882076598504e-20,  2.082179123426336e-22, -2.680720123462069e-24,
  3.697957951323166e-05, -1.456758036698624e-06,  4.156984670417939e-08, -9.927696766127763e-10,  2.097411291282620e-11, -4.091844128256425e-13,  7.330399145971582e-15,
 -1.241082997148491e-16,  2.070685268155386e-18, -3.116374429494418e-20,  4.529819487625337e-22, -7.460510549627075e-24,  1.075162571090587e-05, -4.857216326233847e-07,
  1.642355756769266e-08, -4.593027330862869e-10,  1.127192907325998e-11, -2.542304972569568e-13,  5.235656646320715e-15, -1.015059812873718e-16,  1.910303335132478e-18,
 -3.297831421580495e-20,  5.500072754123248e-22, -9.501444536548270e-24,  1.674329826341616e-06, -8.927616296300522e-08,  3.603340770018264e-09, -1.183927544890751e-10,
  3.388787411506181e-12, -8.833717286663972e-14,  2.099465130404805e-15, -4.671424398588422e-17,  9.915301353809966e-19, -1.964624695036838e-20,  3.737619743392641e-22,
 -6.974844760552588e-24,  1.374253345753478e-07, -8.937825249290411e-09,  4.350572595532823e-10, -1.696305692305960e-11,  5.716311939038955e-13, -1.735134339623693e-14,
  4.792353831950238e-16, -1.230954439787141e-17,  2.978661531856126e-19, -6.774622467690922e-21,  1.468935572244553e-22, -3.057728904427118e-24,  5.628518277672316e-09,
 -4.654186371463999e-10,  2.784271499379547e-11, -1.313589498804493e-12,  5.301045238400502e-14, -1.903759582216124e-15,  6.192756930541440e-17, -1.859085716753235e-18,
  5.209624007860817e-20, -1.370588799056372e-21,  3.414574995952336e-23, -8.092360309975343e-25,  1.044785673401090e-10, -1.164796541531152e-11,  8.878645264395511e-13,
 -5.245147935637523e-14,  2.611390816769670e-15, -1.140970547447994e-16,  4.477260527526443e-18, -1.606104474324591e-19,  5.329997843565276e-21, -1.650471140166383e-22,
  4.803917978797737e-24, -1.320577825741615e-25,  7.692055101240882e-13, -1.270029258029566e-13,  1.322823238045910e-14, -1.039995282700190e-15,  6.732919417543191e-17,
 -3.752581324649873e-18,  1.850462170890486e-19, -8.226308468300012e-21,  3.341170097281767e-22, -1.252326329601352e-23,  4.365820329884462e-25, -1.423190248698612e-26,
  2.277105191046608e-15, -6.454092787108873e-16,  1.039031103712835e-16, -1.198222475687915e-17,  1.090756033549609e-18, -8.260329610214484e-20,  5.378109210973433e-21,
 -3.078949392390107e-22,  1.575540243395472e-23, -7.296669419307262e-25,  3.088531083882422e-26, -1.202914328950448e-27,  1.231242803065707e-05, -3.677220037884674e-07,
  6.758504654625714e-09, -9.892896530749380e-11,  1.333268282764103e-12, -1.420144109704377e-14,  1.537400414449137e-16, -3.051517996595129e-18,  1.524182835122348e-22,
  3.401353858467827e-22,  2.634085794497962e-23,  1.951167784916119e-25,  4.778179443596300e-05, -1.493958285001948e-06,  3.032906356434838e-08, -5.071658121860060e-10,
  7.720223198707625e-12, -1.027080833364447e-13,  1.329664801005716e-15, -1.984514322155316e-17,  1.597568520422969e-19, -1.138268940801916e-21,  8.223104468667116e-23,
  2.291226598136110e-25,  5.752877523156980e-05, -1.927064290816210e-06,  4.462004331092661e-08, -8.688372652933403e-10,  1.514108930838995e-11, -2.428334733872410e-13,
  3.654756910955004e-15, -5.231115733515981e-17,  7.140695648664679e-19, -9.432112416815128e-21,  1.201203506778489e-22, -1.438272812342692e-24,  3.174952015103943e-05,
 -1.166712467427393e-06,  3.142809658023161e-08, -7.141535016412533e-10,  1.430294876267910e-11, -2.683938284716280e-13,  4.635931997707717e-15, -7.287257913943543e-17,
  1.206211274823647e-18, -1.849035698212007e-20,  2.060744584020536e-22, -3.923619128027278e-24,  9.040478610302892e-06, -3.736601499303261e-07,  1.184598411041827e-08,
 -3.136562170048096e-10,  7.245199240409785e-12, -1.567365505265173e-13,  3.096882317014419e-15, -5.583917266734350e-17,  1.033887056854922e-18, -1.768191548770645e-20,
  2.498782412159119e-22, -4.623644285485444e-24,  1.367025038569678e-06, -6.532899687021453e-08,  2.457440641190664e-09, -7.595607862033733e-11,  2.036056955603866e-12,
 -5.062416096589235e-14,  1.146882413458438e-15, -2.392811627089474e-17,  4.925138843036427e-19, -9.447261086778687e-21,  1.642187181697912e-22, -3.074218138918857e-24,
  1.075349799057898e-07, -6.138936212877711e-09,  2.766704443714060e-10, -1.006859267666856e-11,  3.164421211495608e-13, -9.099110390982854e-15,  2.381267229440547e-16,
 -5.765633503917131e-18,  1.337592660172354e-19, -2.911620780513177e-21,  5.954174470646626e-23, -1.204592721413680e-24,  4.129603299079407e-09, -2.937553159770027e-10,
  1.613243495543204e-11, -7.040829053864194e-13,  2.639107292615285e-14, -8.914151678676720e-16,  2.733536759549587e-17, -7.746166474425919e-19,  2.066002679728891e-20,
 -5.177375110755602e-22,  1.227939622366676e-23, -2.794696302769275e-25,  6.892030504399331e-11, -6.494310669158839e-12,  4.492742694885146e-13, -2.432788390959082e-14,
  1.120094008635877e-15, -4.573469062271938e-17,  1.685277847406209e-18, -5.702799485272140e-20,  1.794796931169838e-21, -5.286612279694013e-23,  1.468085651809124e-24,
 -3.865212704438770e-26,  4.137277886491258e-13, -5.723551716547811e-14,  5.345524689127882e-15, -3.827729823502715e-16,  2.286540446821769e-17, -1.188119218969394e-18,
  5.502227158109012e-20, -2.311632409406088e-21,  8.921052452182395e-23, -3.191403114929404e-24,  1.066159919500668e-25, -3.342694640633783e-27,  7.441679094454768e-16,
 -1.838988416790494e-16,  2.694520472908008e-17, -2.883521126093822e-18,  2.469693868730458e-19, -1.777593001998078e-20,  1.108525231790781e-21, -6.116120949247220e-23,
  3.031306596156783e-24, -1.365332033676988e-25,  5.639886594238135e-27, -2.149969489942002e-28,  1.094264246970116e-05, -3.180603350766814e-07,  5.690548384600306e-09,
 -7.969724876382894e-11,  1.079294260275915e-12, -1.151766401565950e-14,  7.169232566184310e-17, -2.643459380868129e-18,  3.138624173100557e-20,  1.326664239818125e-21,
  1.537556201960190e-23, -8.321500735958552e-25,  4.225545354555987e-05, -1.273715582876022e-06,  2.492155261511669e-08, -3.985204452510231e-10,  5.943080065866585e-12,
 -7.690155886229804e-14,  8.439247450082379e-16, -1.476081253152577e-17,  1.761329118862293e-19,  1.848071513502274e-21,  5.046036716203228e-23, -2.015716307460164e-24,
  5.047377086736606e-05, -1.608030197339120e-06,  3.550145125818388e-08, -6.611226518097722e-10,  1.105504460706732e-11, -1.703971654708831e-13,  2.464868313311233e-15,
 -3.407568168589426e-17,  4.479247382410854e-19, -5.661666027640141e-21,  7.314787849062988e-23, -7.872304293018775e-25,  2.753624425576656e-05, -9.460484951722561e-07,
  2.407205705663373e-08, -5.228267317925211e-10,  9.902535921068926e-12, -1.778204332546976e-13,  3.045492894757428e-15, -4.361102032177380e-17,  6.565153966724840e-19,
 -1.268145529356401e-20,  1.107005606243441e-22, -3.277992992848869e-25,  7.714034068972169e-06, -2.921914743430321e-07,  8.685977961257466e-09, -2.192437967342850e-10,
  4.744124961031049e-12, -9.796268860578690e-14,  1.912631002930115e-15, -3.134560430153316e-17,  5.377238991973733e-19, -1.072094333357090e-20,  1.227057576936131e-22,
 -1.250208393509611e-24,  1.139946834948978e-06, -4.882980191674398e-08,  1.712308389896124e-09, -5.018287943660806e-11,  1.252573309137878e-12, -2.963261752051718e-14,
  6.541199008458178e-16, -1.256573208589471e-17,  2.440831160550638e-19, -4.939151725508975e-21,  7.500807393556987e-23, -1.160313369087639e-24,  8.674627483345721e-08,
 -4.334847118809002e-09,  1.810947664670178e-10, -6.198143337519355e-12,  1.806750894616068e-13, -4.920314455780294e-15,  1.236160609261350e-16, -2.789663067921480e-18,
  6.152640738529684e-20, -1.326936854125172e-21,  2.497166226340649e-23, -4.697282295129545e-25,  3.167791257284297e-09, -1.924686384876018e-10,  9.726777751832002e-12,
 -3.950285827685229e-13,  1.369010673841069e-14, -4.352769799747365e-16,  1.265793089516399e-17, -3.366648654797984e-19,  8.534701447589800e-21, -2.057813173570727e-22,
  4.602192281232743e-24, -9.995729698068732e-26,  4.863617924876309e-11, -3.820717219473684e-12,  2.405578733464208e-13, -1.197158038215367e-14,  5.078544916008727e-16,
 -1.938226929433715e-17,  6.713595148989034e-19, -2.136803725053007e-20,  6.373622741672457e-22, -1.787257131961568e-23,  4.719149015123233e-25, -1.188680269442873e-26,
  2.481000717744674e-13, -2.805448338187940e-14,  2.346948913359507e-15, -1.525979651723708e-16,  8.370272087907369e-18, -4.042806195761190e-19,  1.752788767335629e-20,
 -6.933919658037767e-22,  2.534981962768024e-23, -8.629554413598979e-25,  2.753526674927645e-26, -8.279848801402829e-28,  2.888284392537301e-16, -5.945194240916337e-17,
  7.784327231608158e-18, -7.615502308108402e-19,  6.063643083500154e-20, -4.107640784835548e-21,  2.433116891832069e-22, -1.284533169825921e-23,  6.128524959222854e-25,
 -2.670268640494762e-26,  1.071438743261117e-27, -3.981494563482315e-29,  9.755784905257050e-06, -2.760848619749620e-07,  4.830432258174785e-09, -6.420041388630541e-11,
  8.609341324020597e-13, -1.052556441945417e-14,  1.924073841668551e-17, -8.492643936328101e-19,  7.823399573534765e-20,  8.815152800022380e-22, -4.289027550925504e-23,
 -1.493469654516496e-24,  3.753118474873045e-05, -1.091966014259283e-06,  2.066229821162010e-08, -3.147631164882613e-10,  4.577699882646881e-12, -6.089993087782442e-14,
  5.210573575984091e-16, -7.893326689654732e-18,  2.503231727573560e-19,  1.332062465110393e-21, -8.885600202069816e-23, -3.601932433277989e-24,  4.456335611086133e-05,
 -1.352985123764641e-06,  2.852639207767431e-08, -5.085887828698076e-10,  8.169026098715540e-12, -1.212397795707244e-13,  1.684437489573343e-15, -2.250130543421746e-17,
  2.891365734838835e-19, -3.356809248586000e-21,  4.308573111628402e-23, -6.420677467890987e-25,  2.410094475183000e-05, -7.761206233332269e-07,  1.864323962387693e-08,
 -3.892436705848992e-10,  6.988726980594891e-12, -1.173988014479321e-13,  2.056097307548732e-15, -2.902126341904073e-17,  2.850148042884459e-19, -7.618542701217805e-21,
  1.589714644846961e-22,  1.831640358311518e-24,  6.669225474037996e-06, -2.320710047182159e-07,  6.453171500740467e-09, -1.567854341248918e-10,  3.181463967931756e-12,
 -6.097173782360283e-14,  1.224210578901423e-15, -1.942436776075532e-17,  2.342480170759430e-19, -6.132097486298334e-21,  1.217173796175246e-22,  7.415128568476494e-25,
  9.686385925573006e-07, -3.723944909549174e-08,  1.213273501171349e-09, -3.413561716071238e-11,  7.923435856085600e-13, -1.741885585423264e-14,  3.885616926184385e-16,
 -7.098014235595813e-18,  1.113718826671897e-19, -2.599701133653174e-21,  4.917938730151424e-23, -1.803117632358181e-25,  7.189403838514885e-08, -3.141005216155196e-09,
  1.212725620746556e-10, -3.956456422375389e-12,  1.065944786682203e-13, -2.706487079568260e-15,  6.706430248303402e-17, -1.425559640790295e-18,  2.782748067390425e-20,
 -6.280081041318796e-22,  1.224556144640083e-23, -1.562305070070232e-25,  2.528025731748017e-09, -1.304603900699298e-10,  6.059279587909035e-12, -2.318517486722511e-13,
  7.393389556436341e-15, -2.195032570820506e-16,  6.152311184280735e-18, -1.536293776528429e-19,  3.606359202472049e-21, -8.586550073332568e-23,  1.856759307238140e-24,
 -3.540576952184222e-26,  3.645467707599176e-11, -2.357391520898584e-12,  1.352260869269985e-13, -6.240087977541784e-15,  2.426649378970858e-16, -8.630358733454510e-18,
  2.829194916908831e-19, -8.447080742306826e-21,  2.371091110817480e-22, -6.380600838755546e-24,  1.603062942629115e-25, -3.800354132076121e-27,  1.643936834632449e-13,
 -1.482004721800850e-14,  1.111791109631299e-15, -6.575897638505732e-17,  3.293567590742442e-18, -1.474883441681382e-19,  5.982506116106602e-21, -2.220109864485871e-22,
  7.664029523432222e-24, -2.479986381857949e-25,  7.533664171096513e-27, -2.164190859114203e-28,  1.347561190002943e-16, -2.189827909784257e-17,  2.525348085206582e-18,
 -2.227548291234956e-19,  1.628412926752358e-20, -1.028062357013467e-21,  5.734668940733981e-23, -2.874596086205053e-24,  1.311432349762063e-25, -5.495330516773075e-27,
  2.130572221398842e-28, -7.682279145299768e-30,  8.724162829538869e-06, -2.403047041265548e-07,  4.135802070892851e-09, -5.208722718806012e-11,  6.546486212786505e-13,
 -1.005157689160239e-14,  3.227807298899451e-17,  1.724494295022612e-18,  6.691814179371251e-20, -1.696912932594998e-21, -6.901037958222796e-23,  7.849129214853941e-25,
  3.347163644533590e-05, -9.406195831383449e-07,  1.728644152197617e-08, -2.506430370792028e-10,  3.471607253976089e-12, -5.012862629066887e-14,  4.129382773834055e-16,
 -6.245605077066247e-20,  2.042925876016222e-19, -4.377430453162802e-21, -1.575633914913536e-22,  1.633237195093668e-24,  3.957209584813443e-05, -1.147135279279285e-06,
  2.313410706967205e-08, -3.952829499244453e-10,  6.102431024059442e-12, -8.742932731915525e-14,  1.167821584885888e-15, -1.490434608823507e-17,  1.926457249152793e-19,
 -2.177722701901705e-21,  1.713554321173004e-23, -4.564138553445147e-25,  2.126764032575176e-05, -6.439198019461031e-07,  1.457371868739469e-08, -2.937872234779192e-10,
  5.072816061444032e-12, -7.697912698788752e-14,  1.339480607055716e-15, -2.293520858825978e-17,  1.393155797133783e-19, -3.292080323155670e-22,  1.768383644763223e-22,
 -1.992694763417548e-24,  5.833388010615669e-06, -1.871891450937606e-07,  4.841622956292592e-09, -1.142130694775206e-10,  2.215424419861528e-12, -3.743917089010107e-14,
  7.591105340179418e-16, -1.446759412263275e-17,  1.069866208113661e-19, -8.976755351613765e-22,  1.247794615915300e-22, -1.287995568944899e-24,  8.367719865065213e-07,
 -2.897974752137409e-08,  8.696865746049577e-10, -2.379975668114729e-11,  5.228857555315143e-13, -1.014880155332494e-14,  2.282767493507043e-16, -4.664362556969319e-18,
  5.162558834452656e-20, -7.725204206263842e-22,  4.026385624089609e-23, -4.294472791346812e-25,  6.100583763577792e-08, -2.335347480683442e-09,  8.249190813410006e-11,
 -2.608528500234342e-12,  6.576976660662435e-14, -1.493104729050735e-15,  3.682463005158815e-17, -8.133831521026968e-19,  1.271526346539603e-20, -2.421081426138370e-22,
  7.469057667807842e-24, -9.650152878084465e-26,  2.087968894543901e-09, -9.139197933586974e-11,  3.864437110805152e-12, -1.419154346543345e-13,  4.188376672313171e-15,
 -1.128355297316476e-16,  3.088887054698041e-18, -7.585933761811579e-20,  1.555729694460697e-21, -3.451609405432554e-23,  8.597363373722962e-25, -1.458720588021228e-26,
  2.879296718854839e-11, -1.520168300692764e-12,  7.895212586607193e-14, -3.436710010389900e-15,  1.224694683891713e-16, -3.996024774332894e-18,  1.253365349214189e-19,
 -3.561962878933738e-21,  9.171499629041819e-23, -2.352594403865095e-24,  5.904229003916579e-26, -1.285522554396540e-27,  1.189267274678440e-13, -8.368578732148449e-15,
  5.620236488395262e-16, -3.056215502384628e-17,  1.390616646740467e-18, -5.734424212820818e-20,  2.184628020668758e-21, -7.603918115089495e-23,  2.457512658602438e-24,
 -7.558675976179752e-26,  2.196701393523597e-27, -5.970436177228249e-29,  7.531184344663850e-17, -9.143136941137953e-18,  9.208929380754770e-19, -7.262415510478956e-20,
  4.812753229913915e-21, -2.804674274592661e-22,  1.462329820929694e-23, -6.905046262551929e-25,  2.990297659528875e-26, -1.198089579294357e-27,  4.463917730878702e-29,
 -1.553246148510376e-30,  7.825389919967969e-06, -2.095553188204798e-07,  3.567157334140605e-09, -4.315913002307711e-11,  4.662250618484905e-13, -8.528284142497574e-15,
  9.822488274595037e-17,  2.477794430153234e-18, -2.745356867384559e-20, -2.920811546516242e-21,  2.257684563414726e-23,  2.702030982420991e-24,  2.996792940429805e-05,
 -8.134872933140545e-07,  1.458068425107485e-08, -2.025689815249741e-10,  2.571058212403477e-12, -3.968353352830960e-14,  4.718117064506727e-16,  3.007612367838240e-18,
 -3.013091575701042e-20, -7.216649398837491e-21,  5.189121583211367e-23,  6.348389585919794e-24,  3.532583872610418e-05, -9.794997985104246e-07,  1.892341510583747e-08,
 -3.102401509847371e-10,  4.603625976566485e-12, -6.378136553038590e-14,  8.257834247729948e-16, -9.891039599201478e-18,  1.232966839715063e-19, -1.719577689437737e-21,
  1.041798100407700e-23,  1.554941106160002e-25,  1.890461950118107e-05, -5.401587397400390e-07,  1.148953989171921e-08, -2.234011312922459e-10,  3.805407437793798e-12,
 -5.200232665059707e-14,  7.661705101812912e-16, -1.757238750256722e-17,  2.189288580731095e-19,  3.448140637110962e-21, -1.494045339848893e-23, -5.480950177822336e-24,
  5.154200199812498e-06, -1.533869255911636e-07,  3.661883713392581e-09, -8.389751123148804e-11,  1.618000829525556e-12, -2.369410525592325e-14,  4.030052121731529e-16,
 -1.077101483559524e-17,  1.415608761736606e-19,  1.979350946692862e-21,  1.014191829294674e-24, -3.618664044799206e-24,  7.331418326618496e-07, -2.303611818657816e-08,
  6.284387997028899e-10, -1.680099507818870e-11,  3.650098823309525e-13, -6.066461836525548e-15,  1.185563031351507e-16, -3.197117564562608e-18,  4.620013422126112e-20,
  2.417047706356037e-22,  6.214100848615446e-24, -9.704372024544465e-25,  5.280868324932414e-08, -1.784725133201561e-09,  5.665420793482449e-11, -1.754090500188072e-12,
  4.311108141235906e-14, -8.428441345405567e-16,  1.879512143495558e-17, -4.974009005771068e-19,  8.229707247783452e-21, -4.188286714258093e-23,  2.245835097001371e-24,
 -1.319514981651557e-25,  1.774857642065037e-09, -6.629774476678851e-11,  2.500354623658768e-12, -8.956076112336705e-14,  2.525921710284192e-15, -5.950525900230334e-17,
  1.515593869465308e-18, -4.046674168640009e-20,  7.932200745794780e-22, -1.135578276962599e-23,  3.254461853290159e-25, -1.047821424256839e-26,  2.375451587313980e-11,
 -1.025360950957303e-12,  4.728052833439374e-14, -1.981928427321396e-15,  6.598466744057532e-17, -1.917470854215973e-18,  5.665949665090684e-20, -1.618540157436731e-21,
  3.861450330955166e-23, -8.393442147248396e-25,  2.183907676210503e-26, -5.478065984832903e-28,  9.256073859199266e-14, -5.032820999094594e-15,  2.985046736179916e-16,
 -1.522974578995125e-17,  6.327009400199882e-19, -2.359067318381522e-20,  8.439383631593426e-22, -2.805015307031131e-23,  8.414603165751789e-25, -2.397862129111432e-26,
  6.792755423986812e-28, -1.799611478548058e-29,  4.936414172862427e-17, -4.281504863999189e-18,  3.738979083211101e-19, -2.646558895168812e-20,  1.572763218765120e-21,
 -8.358350697297889e-23,  4.053189570983162e-24, -1.793989242773276e-25,  7.309438083722107e-27, -2.779861078070072e-28,  9.921865874301585e-30, -3.315950317224327e-31,
  7.041126185612157e-06, -1.829749101631356e-07,  3.088849256453647e-09, -3.691530698847328e-11,  3.239675946666126e-13, -5.523252816178577e-15,  1.419554088388817e-16,
  2.951838909118021e-19, -9.245939616193189e-20, -2.302332438254708e-22,  8.970047741523472e-23, -2.206342111664580e-25,  2.693278888438467e-05, -7.059220001479462e-07,
  1.237254714362581e-08, -1.671423333634538e-10,  1.895954814084570e-12, -2.767165511214199e-14,  5.092063429444649e-16, -1.228938336565172e-18, -1.957826681650825e-19,
 -8.739263594301966e-22,  2.139114597634042e-22, -3.936721325234947e-25,  3.168868417545819e-05, -8.418422076459894e-07,  1.560363428392949e-08, -2.457971746573848e-10,
  3.505827129713296e-12, -4.689399196857734e-14,  5.954444997007691e-16, -6.836778245058342e-18,  7.127744534159588e-20, -1.100752272885172e-21,  2.017081637261576e-23,
  1.120247521921145e-25,  1.691220299657879e-05, -4.580039245819422e-07,  9.142540350583878e-09, -1.699876032414404e-10,  2.913915602450910e-12, -3.862710963557054e-14,
  3.875850191323738e-16, -9.112058523327922e-18,  2.834395232804151e-19, -8.275772630316544e-22, -1.557916994550787e-22,  1.805807983710564e-25,  4.593443983248558e-06,
 -1.277119098776541e-07,  2.796249572121840e-09, -6.136757878524443e-11,  1.219313765219250e-12, -1.707024623444588e-14,  1.739426773399551e-16, -5.373077020050077e-18,
  1.805084178869876e-19, -4.916045431242212e-22, -9.781047024416642e-23, -9.788056988774943e-26,  6.499046076307760e-07, -1.872412801331091e-08,  4.582890252266024e-10,
 -1.180420030110808e-11,  2.657804968602436e-13, -4.120482272911961e-15,  5.093338081833254e-17, -1.607821448867381e-18,  5.032140620332397e-20, -2.055128068590621e-22,
 -2.202953178926001e-23, -1.067571713532752e-25,  4.645797920786061e-08, -1.405104874373323e-09,  3.925521893484256e-11, -1.178873183426068e-12,  2.978619837746239e-14,
 -5.301696238058817e-16,  8.389995476239099e-18, -2.513040955556603e-19,  7.090266747158909e-21, -4.912775899312798e-23, -1.838778131532590e-24, -2.970102846531158e-26,
  1.543730499247203e-09, -4.998609909462132e-11,  1.634304879862635e-12, -5.702828358505425e-14,  1.621260658323704e-15, -3.416832010392585e-17,  6.895200851157296e-19,
 -1.992982969915971e-20,  5.210147068294094e-22, -5.989162938620766e-24, -6.202850822524658e-27, -3.591006728336693e-27,  2.028095173037207e-11, -7.268033761580774e-13,
  2.876898316658576e-14, -1.172288307329843e-15,  3.818438140726641e-17, -9.847789736777648e-19,  2.505862627805160e-20, -7.383226574546656e-22,  1.930064021406940e-23,
 -3.411280391125801e-25,  5.525507075048568e-27, -2.078521430809498e-28,  7.625136891626706e-14, -3.233558755686524e-15,  1.638650206270201e-16, -8.001477816782604e-18,
  3.127314419053166e-19, -1.036108156617044e-20,  3.356440623522550e-22, -1.094306999165867e-23,  3.202288509117286e-25, -8.064478328288692e-27,  2.034034102550044e-28,
 -5.769161023984750e-30,  3.668035829054815e-17, -2.232476617651653e-18,  1.655167205703024e-19, -1.071795942843581e-20,  5.724333956617765e-22, -2.723534658906923e-23,
  1.215895371491589e-24, -5.065478293757370e-26,  1.937704229572369e-27, -6.887027980806490e-29,  2.332433023447069e-30, -7.539198492686764e-32,  6.355957408007598e-06,
 -1.599551344629098e-07,  2.673914188311825e-09, -3.243350748747236e-11,  2.465661898675195e-13, -2.335999457136933e-15,  1.120769345225011e-16, -2.182946845586217e-18,
 -4.736934847293860e-20,  2.245598949960617e-21,  1.896754974379793e-23, -2.242203472992415e-24,  2.429503671574808e-05, -6.144866116067844e-07,  1.053267608355305e-08,
 -1.405947703223879e-10,  1.458366058843345e-12, -1.654520533434451e-14,  3.932081910227729e-16, -6.524346322991571e-18, -9.867428047442858e-20,  5.128457470861082e-21,
  4.921108152790952e-23, -5.332330900205706e-24,  2.855355115149515e-05, -7.279243528009612e-07,  1.296202512805614e-08, -1.964913823526586e-10,  2.696545325407936e-12,
 -3.467373453262822e-14,  4.311069866485287e-16, -5.034511950749550e-18,  4.585174525127316e-20, -3.595903158642508e-22,  1.321281888702456e-23, -3.675148883531445e-25,
  1.521459411831330e-05, -3.922862095296757e-07,  7.358374054085199e-09, -1.291089441028213e-10,  2.218759025851691e-12, -3.142969508199523e-14,  2.470558207695337e-16,
 -1.588073894504500e-18,  1.607212413298837e-19, -5.103090808277105e-21, -2.799091040406550e-23,  4.189546222162329e-24,  4.123108010278455e-06, -1.079805846485659e-07,
  2.166248647237329e-09, -4.440285123644903e-11,  9.106783121500109e-13, -1.409031377735334e-14,  9.666617570080583e-17, -5.646818503608170e-19,  1.029824312689836e-19,
 -3.277551430121330e-21, -2.048678973366634e-23,  2.702431585074475e-24,  5.815378691836369e-07, -1.555801993796501e-08,  3.396149214745873e-10, -8.156751556180490e-12,
  1.928379908363499e-13, -3.269100030598239e-15,  2.618334403356964e-17, -2.745708838912303e-19,  2.898004995956322e-20, -8.609717925204102e-22, -4.991993964048067e-24,
  6.589590544705474e-25,  4.138650147332195e-08, -1.140292060348599e-09,  2.764826053325396e-11, -7.781378387476272e-13,  2.075010274817388e-14, -3.897668486662546e-16,
  4.160599144070002e-18, -6.694281235069173e-20,  4.057773319021029e-21, -1.092656226882953e-22, -4.234427955725996e-25,  6.940212840014356e-26,  1.366161285459771e-09,
 -3.925494233828495e-11,  1.085525439610776e-12, -3.581435657157104e-14,  1.067047038165143e-15, -2.263799438907551e-17,  3.311117020161409e-19, -6.911801891309893e-21,
  2.855868740571864e-22, -6.983998632006613e-24,  4.191679048246433e-27,  2.782835088459896e-27,  1.775786774956008e-11, -5.438500288360318e-13,  1.780664254771983e-14,
 -6.921328321120173e-16,  2.314529560478907e-17, -5.718288939328376e-19,  1.141129136742002e-20, -2.874617565767551e-22,  9.535040354188163e-24, -2.242166940103596e-25,
  1.920001816302762e-27,  8.584313664474783e-30,  6.543322695106065e-14, -2.234994926196424e-15,  9.220790614026472e-17, -4.304181243841564e-18,  1.662623800592579e-19,
 -5.046938877598236e-21,  1.379056784572161e-22, -4.161191059335183e-24,  1.308622516774333e-25, -3.355106364773420e-27,  6.406630284749123e-29, -1.334698120765753e-30,
  2.975995512079650e-17, -1.300167428072891e-18,  7.794793415237634e-20, -4.711417710122804e-21,  2.330609442547569e-22, -9.845350965754247e-24,  3.914444630722862e-25,
 -1.527031743964506e-26,  5.620392202717052e-28, -1.876297631200215e-29,  5.801254417287313e-31, -1.762473734611345e-32,  5.756545610017370e-06, -1.400562768239563e-07,
  2.307252028052391e-09, -2.873895121267723e-11,  2.212300507605758e-13, -4.754363930676774e-16,  4.190199361916913e-17, -2.432386651678259e-18,  2.657002398076686e-20,
  1.424254633914202e-21, -4.598696008220983e-23, -4.142486437103007e-25,  2.199545853846381e-05, -5.365992204732649e-07,  8.976102767038340e-09, -1.194617014529458e-10,
  1.205929440490409e-12, -9.483668303623049e-15,  1.943272687572519e-16, -6.763016708636196e-18,  7.214996526156226e-20,  3.304896776163274e-21, -1.074561261643550e-22,
 -1.050814861689735e-24,  2.583528310906635e-05, -6.329755558152826e-07,  1.084180917107859e-08, -1.583773605444036e-10,  2.095934845776925e-12, -2.586208191122167e-14,
  3.092755791079968e-16, -3.704641765380241e-18,  3.849042074998674e-20, -1.476078842145222e-22, -1.220985565259458e-24, -1.916226247058660e-25,  1.375416259037856e-05,
 -3.390586642319169e-07,  6.002346647890004e-09, -9.832223527248566e-11,  1.648139010917266e-12, -2.562190457350720e-14,  2.473602989017156e-16,  7.246523188282113e-19,
 -4.613774255430759e-21, -3.261249818350557e-21,  9.364972930242698e-23,  7.540560054333120e-25,  3.722793522561356e-06, -9.255483053022684e-08,  1.711946624431700e-09,
 -3.196047993869265e-11,  6.522501919641863e-13, -1.169691222437142e-14,  1.093819701079896e-16,  8.972041059850046e-19, -4.511238077664933e-21, -2.147503855317216e-21,
  6.038730003934837e-23,  5.501843670298196e-25,  5.241874847835291e-07, -1.318492652049096e-08,  2.581959314201281e-10, -5.561354747076294e-12,  1.335366538166432e-13,
 -2.656838111528854e-15,  2.685460355673516e-17,  1.709468519458154e-19,  6.610686336172723e-22, -5.742530106880287e-22,  1.537518124820948e-23,  1.484452192127543e-25,
  3.721579550192762e-08, -9.513720153239584e-10,  2.006173703581196e-11, -5.034933229226189e-13,  1.386193326885892e-14, -3.013395652807341e-16,  3.522862598048795e-18,
  2.381163827193352e-21,  4.992187509961111e-22, -7.312578320664143e-23,  1.824720787426981e-24,  1.739618172260120e-26,  1.224155624774790e-09, -3.203145710781256e-11,
  7.445057727278118e-13, -2.198205014800016e-14,  6.824530318220958e-16, -1.620608237805349e-17,  2.293713964300833e-19, -1.521677368361591e-21,  6.635795140022626e-23,
 -4.511745450531254e-24,  1.034815549968334e-25,  7.864554429299855e-28,  1.582262151283440e-11, -4.291076298906619e-13,  1.138760955403678e-14, -4.006267519803009e-16,
  1.394405541783707e-17, -3.669563891060299e-19,  6.535603007940768e-21, -9.498425589925324e-23,  3.062382773372132e-24, -1.289321009854150e-25,  2.778747830508742e-27,
  3.884569156139849e-30,  5.769645448043597e-14, -1.665378603897315e-15,  5.367990266666870e-17, -2.304039652515654e-18,  9.101235659450325e-20, -2.758331235750177e-21,
  6.487739969613719e-23, -1.495811155231536e-24,  4.647688520038969e-26, -1.518747745258620e-27,  3.439286694009699e-29, -3.768599288194701e-31,  2.552159642995589e-17,
 -8.515849367378642e-19,  3.861636025427779e-20, -2.162736338663095e-21,  1.038048971104956e-22, -4.043855342965734e-24,  1.390677197252489e-25, -4.774672500401081e-27,
  1.694301960842294e-28, -5.689665364722927e-30,  1.669238329694543e-31, -4.361964934959708e-33,  5.231136691812980e-06, -1.229180295792574e-07,  1.983427861520552e-09,
 -2.524164829255064e-11,  2.169115743473032e-13, -1.565418619239101e-16, -9.160254007296097e-18, -1.118414007885581e-18,  4.535466042457658e-20, -2.574095536824511e-22,
 -2.889473662001357e-23,  8.398847033089255e-25,  1.998404599462899e-05, -4.702096126401135e-07,  7.652731043163271e-09, -1.014893952168399e-10,  1.049260302720805e-12,
 -6.751696057738685e-15,  4.914380914860491e-17, -3.388860078675162e-18,  1.146672583171931e-19, -6.613413123123321e-22, -6.856148583496009e-23,  1.985126659000255e-24,
  2.346556926343313e-05, -5.533099568182313e-07,  9.126637509914549e-09, -1.286098735342462e-10,  1.645213503899242e-12, -1.955058048792770e-14,  2.218597803668129e-16,
 -2.577438221015991e-18,  3.122974958521933e-20, -2.623934421395734e-22, -2.442938310718078e-24,  8.699649306933531e-26,  1.248707720443359e-05, -2.953478851945470e-07,
  4.964851178802168e-09, -7.572349064102086e-11,  1.196259992662236e-12, -1.954072815956634e-14,  2.531376765543588e-16, -5.786565043945283e-19, -5.618388418793060e-20,
  1.492162986473167e-22,  5.924760688300130e-23, -1.646911719556620e-24,  3.377764587906906e-06, -8.023276259458891e-08,  1.383799923822516e-09, -2.324584830479147e-11,
  4.462730939432689e-13, -8.841016661633168e-15,  1.242416149163412e-16, -1.381868781268434e-20, -3.889068154411011e-20,  8.570249211751746e-23,  3.934539822750084e-23,
 -1.071380090923192e-24,  4.752025002248006e-07, -1.135378547363019e-08,  2.026432165112624e-10, -3.813375435083311e-12,  8.717985658190402e-14, -1.967250810157273e-15,
  2.969450335093809e-17, -1.821401116845936e-20, -8.996300472443594e-21,  9.630926666912448e-25,  1.029290176407968e-23, -2.711226214101886e-25,  3.369778662022172e-08,
 -8.117033913806274e-10,  1.516664159382861e-11, -3.252938365015859e-13,  8.686920150322947e-15, -2.161012807934273e-16,  3.520238819461029e-18, -9.439022675455196e-21,
 -8.214424934009243e-22, -4.388135921426703e-24,  1.251316556580152e-24, -3.141507477134270e-26,  1.106503212102951e-09, -2.696767230933086e-11,  5.364767049988575e-13,
 -1.336848011319172e-14,  4.106385619521990e-16, -1.109351937517956e-17,  1.978529110096828e-19, -1.192535914036122e-21, -2.243989453904518e-23, -6.515803308812279e-25,
  7.123899625417938e-26, -1.675348095669321e-27,  1.426262929013802e-11, -3.539503066900606e-13,  7.702037097407414e-15, -2.284649474250268e-16,  7.999840111006971e-18,
 -2.344764655147232e-19,  4.699842368168760e-21, -5.052212530202364e-23,  3.052231431045711e-25, -3.105970296015809e-26,  1.790841105527239e-27, -3.917808961908762e-29,
  5.174875100904563e-14, -1.325481344859073e-15,  3.318929038723164e-17, -1.216351424370892e-18,  4.870999858787039e-20, -1.577627879933603e-21,  3.730370251666692e-23,
 -6.500248541681249e-25,  1.258745000556003e-26, -4.748828982804936e-28,  1.764794552847773e-29, -3.807590154447335e-31,  2.260176147900403e-17, -6.233870619950078e-19,
  2.044510926261599e-20, -1.003997937541898e-21,  4.798052237587273e-23, -1.848851506025436e-24,  5.789204449223313e-26, -1.639751834761127e-27,  4.981714406527400e-29,
 -1.683855654761855e-30,  5.398067147597899e-32, -1.423648904528558e-33,  4.769363885716131e-06, -1.082035628652117e-07,  1.701187222849295e-09, -2.181592526424367e-11,
  2.098336722940744e-13, -6.029304748611479e-16, -2.272619029979993e-17,  3.249343814107762e-20,  2.387524571560695e-20, -7.248241359095316e-22,  2.451443724984543e-24,
  4.501009446641735e-25,  1.821832779580464e-05, -4.135838340239121e-07,  6.531267634290832e-09, -8.574265431125942e-11,  9.203292211119562e-13, -6.332968654283207e-15,
 -7.440081361072371e-19, -4.615784739542938e-19,  6.188565237966324e-20, -1.768542482291618e-21,  6.021442521795351e-24,  1.076268375306229e-24,  2.138917609705325e-05,
 -4.860505838545308e-07,  7.729230868716524e-09, -1.051478675097047e-10,  1.302147398314275e-12, -1.498823512406713e-14,  1.621762760268220e-16, -1.739685953831944e-18,
  2.106289127882758e-20, -2.745059456013982e-22,  1.637596544872761e-24,  6.534677208694242e-26,  1.137979115265823e-05, -2.589660194795481e-07,  4.159159182592364e-09,
 -5.938872330931779e-11,  8.639054584937086e-13, -1.384518623220409e-14,  2.150213543056199e-16, -1.972197929753020e-18, -2.500151410929780e-20,  1.168724276907630e-21,
 -2.315681522164176e-24, -8.908146451715387e-25,  3.077362616660456e-06, -7.016917393672994e-08,  1.142375497170189e-09, -1.736056705681183e-11,  2.985568954876465e-13,
 -5.993061142431094e-15,  1.085296263955299e-16, -9.962423949598852e-19, -1.852388302934057e-20,  7.724039841876623e-22, -1.235623196639545e-24, -5.941729435056083e-25,
  4.327696810631812e-07, -9.894710654516616e-09,  1.640771873390052e-10, -2.695271199194480e-12,  5.476069802652601e-14, -1.290940508180853e-15,  2.559070335214776e-17,
 -2.492568782352043e-19, -4.366598121805402e-21,  1.861444487565993e-22, -1.064785439326613e-25, -1.543127662949469e-25,  3.067185646748730e-08, -7.039208317350970e-10,
  1.196893010844458e-11, -2.164312420181590e-13,  5.173413483862747e-15, -1.376255246138177e-16,  2.917318363038952e-18, -3.129400355956262e-20, -4.070657302422171e-22,
  1.917632878788281e-23,  3.045724967174794e-26, -1.841648124640590e-26,  1.006337634625069e-09, -2.322110071047539e-11,  4.089554485231735e-13, -8.328152006219255e-15,
  2.330968380345181e-16, -6.832503884282373e-18,  1.539619950320640e-19, -1.880402826897554e-21, -1.218973841987752e-23,  7.782347744534475e-25,  5.560976884746808e-27,
 -1.009122540899235e-27,  1.295534667122688e-11, -3.014432982074772e-13,  5.592253324257931e-15, -1.323253023357921e-16,  4.326539083679307e-18, -1.381743814918311e-19,
  3.332976967251288e-21, -4.815678610551502e-23,  7.077809276552620e-26,  7.864801817986710e-27,  2.787212704843045e-28, -2.349578570725216e-29,  4.690131857171348e-14,
 -1.107212698381653e-15,  2.237027570487521e-17, -6.462978996269330e-19,  2.481950555749519e-20, -8.669311393228620e-22,  2.296382250565500e-23, -4.151279751484860e-25,
  4.508263712304869e-27, -6.281682996972412e-29,  4.316573992705839e-30, -2.002032386217981e-31,  2.037428708554679e-17, -4.973536217893068e-19,  1.199139591638950e-20,
 -4.695964402860441e-22,  2.191761864388635e-23, -8.739955336179434e-25,  2.755353978577970e-26, -6.997093491662168e-28,  1.616735580031828e-29, -4.397789849429325e-31,
  1.495290681827824e-32, -4.856335168627190e-34,  4.362189752993323e-06, -9.558525691780708e-08,  1.459050158468596e-09, -1.858312364136353e-11,  1.927433079841935e-13,
 -1.073783337496812e-15, -1.473665413823785e-17,  4.260050938488727e-19,  2.723877114720079e-21, -4.011690040097022e-22,  1.016654617130978e-23, -3.381421307667363e-26,
  1.666231699724571e-05, -3.652086512145700e-07,  5.586520588366204e-09, -7.203272224204140e-11,  7.933633489832868e-13, -6.337487630724055e-15,  5.226831829526686e-18,
  6.137563076397481e-19,  1.015762478642675e-20, -9.876738054125644e-22,  2.449419895736799e-23, -8.098357672083407e-26,  1.956112184243784e-05, -4.289311356623673e-07,
  6.583213207628044e-09, -8.651545203493372e-11,  1.037716276153609e-12, -1.161294566238101e-14,  1.215303199423933e-16, -1.207142298112289e-18,  1.280872517989208e-20,
 -1.777922989373262e-22,  2.624239435178605e-24, -1.186878626365181e-26,  1.040626624778513e-05, -2.283277436189655e-07,  3.521145688026721e-09, -4.752100059032945e-11,
  6.338243509499736e-13, -9.401010402288207e-15,  1.544554429209333e-16, -2.172925523326054e-18,  9.054855992451730e-21,  6.230398454168770e-22, -1.804113763155854e-23,
  4.956136885819862e-26,  2.813748257815151e-06, -6.179051056340366e-08,  9.591850434309459e-10, -1.341139582019067e-11,  2.022415887203133e-13, -3.765727654420244e-15,
  7.621997065492650e-17, -1.191123413025410e-18,  4.137569761758343e-21,  4.188491986828383e-22, -1.184386972280527e-23,  2.961982311304798e-26,  3.956299315755046e-07,
 -8.698329354658621e-09,  1.362400351699063e-10, -1.994860393286691e-12,  3.446203935270327e-14, -7.704044707148626e-16,  1.759721066674124e-17, -2.923838414294031e-19,
  1.144283358582226e-21,  1.020370929483481e-22, -2.917925913426801e-24,  5.800898887224620e-27,  2.803296727195801e-08, -6.173369560157894e-10,  9.789032533218198e-12,
 -1.521889365793997e-13,  3.045110620670123e-15, -7.898197348322688e-17,  1.957011355591339e-18, -3.421868052093011e-20,  1.707630426085887e-22,  1.070628448206052e-23,
 -3.156964059865576e-25,  3.178579677429247e-28,  9.194409284938005e-10, -2.029497805661379e-11,  3.274857082345933e-13, -5.509398998995032e-15,  1.290147676811723e-16,
 -3.787637766064244e-18,  9.997047350566718e-20, -1.844765721905993e-21,  1.233542351920968e-23,  4.563918886732305e-25, -1.432392846293680e-26, -1.644381509247301e-29,
  1.183041012993304e-11, -2.620640999426942e-13,  4.341347471519531e-15, -8.131245668932287e-17,  2.256323673894584e-18, -7.381044632951522e-20,  2.064807548063481e-21,
 -4.076434490515907e-23,  3.756428620379277e-25,  5.867261012923925e-27, -2.177027826276375e-28, -1.690645948283309e-30,  4.278928939678795e-14, -9.536635669559604e-16,
  1.651206543652222e-17, -3.616266778351796e-19,  1.212924038332237e-20, -4.402361119726442e-22,  1.317604738771666e-23, -2.872712577832364e-25,  3.782774988972980e-27,
 -7.444514984233754e-30, -3.094328111710602e-31, -3.153705344819177e-32,  1.854796865348910e-17, -4.191258767999804e-19,  7.983869662318229e-21, -2.285873478890289e-22,
  9.715868352478265e-24, -4.007193333016791e-25,  1.344989380567030e-26, -3.531626699614445e-28,  7.263065542679626e-30, -1.311154476378951e-31,  3.145795521112723e-33,
 -1.155683040188833e-34,  4.001852939566548e-06, -8.475415606248208e-08,  1.253796276235503e-09, -1.568616426042609e-11,  1.687010844420399e-13, -1.285154640894268e-15,
 -3.234333646390900e-18,  3.542088469077644e-19, -5.253406100552235e-21, -7.387604492165520e-23,  5.558643042240048e-24, -1.267990427206741e-25,  1.528568427897482e-05,
 -3.237678206167061e-07,  4.794146906144933e-09, -6.033994398419668e-11,  6.693340232595993e-13, -5.995521605191146e-15,  2.288263525167467e-17,  5.437147928178317e-19,
 -9.813456333362945e-21, -1.982703633158490e-22,  1.343977115100651e-23, -3.043155494326935e-25,  1.794452997861268e-05, -3.801525888566202e-07,  5.637467799952395e-09,
 -7.162231500339544e-11,  8.321036361468223e-13, -9.060728026744498e-15,  9.264197418593264e-17, -8.810159511136565e-19,  8.088490794526030e-21, -9.155794438796032e-23,
  1.585327668138834e-24, -2.676264741166949e-26,  9.545908084082069e-06, -2.022802664404326e-07,  3.006133951309120e-09, -3.870244163718885e-11,  4.781850201292587e-13,
 -6.375455515938743e-15,  1.001084208613277e-16, -1.652520140885038e-18,  1.999490816864592e-20,  4.252966204113338e-23, -9.709885013829232e-24,  2.345529351132118e-25,
  2.580984771118161e-06, -5.471090035301754e-08,  8.154700501778759e-10, -1.068957885404155e-11,  1.426433709066177e-13, -2.310887941890769e-15,  4.637508274316420e-17,
 -9.017993968091011e-19,  1.165593670303746e-20,  3.656507023035276e-23, -6.410565385792455e-24,  1.542934517882383e-25,  3.628767063191401e-07, -7.695824018087772e-09,
  1.151685829920449e-10, -1.546458949390456e-12,  2.264711735212314e-14, -4.395502020629729e-16,  1.032365546569704e-17, -2.178378580377554e-19,  2.948144246105031e-21,
  7.455341460614350e-24, -1.584915411698867e-24,  3.855820028000886e-26,  2.570970763436084e-08, -5.456065263182504e-10,  8.210379145541996e-12, -1.138632625220192e-13,
  1.861941449306585e-15, -4.262125162627598e-17,  1.116833458553781e-18, -2.485649246668677e-20,  3.525046495342548e-22,  3.909684360808082e-25, -1.726033974012402e-25,
  4.285496342561106e-27,  8.431249896264264e-10, -1.790944515862833e-11,  2.716350653841864e-13, -3.937426580545233e-15,  7.335187764665276e-17, -1.952239961579080e-18,
  5.555562955983690e-20, -1.291511440285823e-21,  1.937791540717792e-23, -2.026918566603859e-26, -7.971055077613524e-27,  2.049855966668914e-28,  1.084617386773941e-11,
 -2.307191174562260e-13,  3.541214634974746e-15, -5.469017493175198e-17,  1.190842814380208e-18, -3.645870110747661e-20,  1.111501003085604e-21, -2.701771800912880e-23,
  4.371419448424346e-25, -1.803598019339787e-27, -1.291622476478736e-28,  3.563255467725118e-30,  3.921524517568873e-14, -8.361960947270790e-16,  1.309516278793853e-17,
 -2.233081354768062e-19,  5.904430915075530e-21, -2.072293141975094e-22,  6.761003473026276e-24, -1.742512483144248e-25,  3.155367012999952e-27, -2.738926272453954e-29,
 -3.725820394139871e-31,  1.331395985453226e-32,  1.698488754120331e-17, -3.640944871509112e-19,  5.957725689839258e-21, -1.226484105467513e-22,  4.248233000300131e-24,
 -1.740077194879991e-25,  6.234970963372273e-27, -1.791888216651544e-28,  3.982548254409145e-30, -6.571063328182001e-32,  8.287155203401304e-34, -1.584819627244436e-35,
  3.681767097182132e-06, -7.543280059407418e-08,  1.080904094105412e-09, -1.319377738036313e-11,  1.429212504650920e-13, -1.263940180128234e-15,  4.176746004631986e-18,
  1.763558464710345e-19, -5.126411877458806e-21,  5.192053171208746e-23,  1.195055412521811e-24, -6.563578824929138e-26,  1.406297879272504e-05, -2.881378002459309e-07,
  4.130475742622471e-09, -5.055555934013032e-11,  5.559487039763731e-13, -5.302636351783199e-15,  3.323440390585484e-17,  1.949838810357243e-19, -1.019246893692840e-20,
  1.075750240399613e-22,  2.965158352190835e-24, -1.576166106950939e-25,  1.650897812244477e-05, -3.382774124586740e-07,  4.852271480645477e-09, -5.964546438247581e-11,
  6.712646573737183e-13, -7.106756092385084e-15,  7.117638807543481e-17, -6.648159198374085e-19,  5.676966391375814e-21, -4.858889114643621e-23,  6.555581923479468e-25,
 -1.453306339063948e-26,  8.782115602015814e-06, -1.799677611056984e-07,  2.583785610580057e-09, -3.195544841681134e-11,  3.713254602329419e-13, -4.456589695816272e-15,
  6.260120297282855e-17, -1.044446206627805e-18,  1.678447321402497e-20, -1.672725598747010e-22, -1.648711599699474e-24,  1.201956232505107e-25,  2.374426873171074e-06,
 -4.866459993475787e-08,  6.995379413314389e-10, -8.724380019719924e-12,  1.057279062068587e-13, -1.458983680660331e-15,  2.626393256130341e-17, -5.449300266703898e-19,
  9.837316137493871e-21, -1.023083193052537e-22, -1.105042452341899e-24,  7.903006010633863e-26,  3.338264908759687e-07, -6.843135539420869e-09,  9.853349760707852e-11,
 -1.242853573170658e-12,  1.589454151347357e-14, -2.544269034023810e-16,  5.516167858740122e-18, -1.283599135566966e-19,  2.445786509542234e-21, -2.653579778931537e-23,
 -2.580727627693250e-25,  1.970597322179594e-26,  2.365063415647154e-08, -4.849388865101529e-10,  6.998762042427037e-12, -8.964918163368948e-14,  1.227679381553865e-15,
 -2.292031848539153e-17,  5.734036706626392e-19, -1.434081902147832e-20,  2.835568235615833e-22, -3.237843876104076e-24, -2.485457330655427e-26,  2.184719303879571e-27,
  7.755589049036427e-10, -1.590796214704490e-11,  2.303432991169902e-13, -3.014771826654758e-15,  4.506389433540260e-17, -9.852392908355726e-19,  2.762291325288777e-20,
 -7.281604462204597e-22,  1.489164796279612e-23, -1.816296151251120e-25, -8.671094228855171e-28,  1.044105208338321e-28,  9.976195037401105e-12, -2.047377851605493e-13,
  2.979249086457293e-15, -4.025051452064178e-17,  6.749614592667909e-19, -1.736824392733990e-20,  5.356742890715509e-22, -1.477539543482746e-23,  3.141495656078769e-25,
 -4.190454952988667e-27, -3.589106369267490e-30,  1.831492728445872e-30,  3.606492705046384e-14, -7.408127321572564e-16,  1.087001212582045e-17, -1.546436274434701e-19,
  3.042103430292681e-21, -9.308894814118346e-23,  3.133550223214739e-24, -9.078061368304515e-26,  2.040981446819125e-27, -3.104830194725877e-29,  1.418505758136051e-31,
  7.494442094783737e-33,  1.561585189342661e-17, -3.213834629055245e-19,  4.801172235173004e-21, -7.586025965369051e-23,  1.923971738271406e-24, -7.215716299298414e-26,
  2.686185282839033e-27, -8.412721108819324e-29,  2.107920819689068e-30, -4.028283878121695e-32,  5.261927559595124e-34, -3.328722514743872e-36,  3.396380035278429e-06,
 -6.738187331418706e-08,  9.354864851305829e-10, -1.110245153416986e-11,  1.189571788091774e-13, -1.121042036101799e-15,  7.137602713604976e-18,  4.689508961559529e-20,
 -2.928135713770271e-21,  5.956035753260519e-23, -4.416156038386274e-25, -1.477916750674636e-26,  1.297287620184926e-05, -2.573772148511492e-07,  3.573824335739507e-09,
 -4.246421953155371e-11,  4.581412093127145e-13, -4.472241450963596e-15,  3.480768202127696e-17, -5.724537143711845e-20, -5.461310011253498e-21,  1.296702384094361e-22,
 -9.700868103733997e-25, -3.571785331708494e-26,  1.522921600768521e-05, -3.021498681689341e-07,  4.196561059068109e-09, -4.995547569714611e-11,  5.448038695808774e-13,
 -5.602835315270095e-15,  5.487175237063712e-17, -5.071179381460093e-19,  4.277371666281023e-21, -3.176911927825364e-23,  2.567661301476930e-25, -4.756793792211213e-27,
  8.101290784121573e-06, -1.607366260650917e-07,  2.233265851332467e-09, -2.665458859093449e-11,  2.951382611754557e-13, -3.250204258556556e-15,  3.992971853725645e-17,
 -6.081528079092658e-19,  1.053951068688108e-20, -1.606323719403421e-22,  1.281131844116282e-24,  2.442499812370665e-26,  2.190335955118852e-06, -4.346032711545110e-08,
  6.041305366513405e-10, -7.236515914778823e-12,  8.178442966647325e-14, -9.797396235303684e-16,  1.483107540102999e-17, -2.921656520237292e-19,  5.991635057013327e-21,
 -9.885819838073502e-23,  8.163705500443544e-25,  1.589724743938679e-26,  3.079416736337527e-07, -6.110546671895613e-09,  8.499752785263834e-11, -1.023130718311522e-12,
  1.188058143671308e-14, -1.572422720581486e-16,  2.868090904652064e-18, -6.602142621446898e-20,  1.461957696538022e-21, -2.503754440352227e-23,  2.168444030308593e-25,
  3.807895025225611e-27,  2.181647633821072e-08, -4.329486108985171e-10,  6.027792019075159e-12, -7.304533632865221e-14,  8.791948469963650e-16, -1.306244702808502e-17,
  2.808979307516784e-19, -7.174890175726749e-21,  1.664294715139164e-22, -2.932637185465875e-24,  2.702263643404754e-26,  3.928269504142169e-28,  7.153990137518058e-10,
 -1.419896171784056e-11,  1.979418128470907e-13, -2.421409024652810e-15,  3.058953601129828e-17, -5.191978351005806e-19,  1.291766092618042e-20, -3.558771397813470e-22,
  8.548421847779592e-24, -1.551131674583936e-25,  1.549492236360928e-27,  1.637366409143813e-29,  9.202082179084043e-12, -1.826747106456227e-13,  2.551499855218265e-15,
 -3.165352380811302e-17,  4.279341326729833e-19, -8.477779317233571e-21,  2.405615857583134e-22, -7.042058272307327e-24,  1.747987541739609e-25, -3.291363218616507e-27,
  3.662971677191954e-29,  2.027936252857112e-31,  3.326485381702191e-14, -6.605668207717392e-16,  9.256058296190304e-18, -1.175222451198852e-19,  1.760429996735632e-21,
 -4.198669915854047e-23,  1.348719196002245e-24, -4.178272634215456e-26,  1.079440233610822e-27, -2.149375430251484e-29,  2.789027636090282e-31, -2.676211329876246e-34,
  1.440199003680970e-17, -2.861824533481272e-19,  4.037380246324358e-21, -5.379862102617099e-23,  9.689252548155479e-25, -2.953502876232029e-26,  1.084263603925152e-27,
 -3.610209541671010e-29,  1.000897510809062e-30, -2.223920893023265e-32,  3.714862883664100e-34, -3.800984219732757e-36  };
  int offset = -11;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 11;
    if (std::isnan(t)) {
      fill_n(rr+offset, 11, 0.5);
      fill_n(ww+offset, 11, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 11; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=11; ++j) {
        const int boxof = it*132+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
