// Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
//     http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/awslabs/amazon-ecr-credential-helper/ecr-login/cache (interfaces: CredentialsCache)

// Package mock_cache is a generated GoMock package.
package mock_cache

import (
	reflect "reflect"

	cache "github.com/awslabs/amazon-ecr-credential-helper/ecr-login/cache"
	gomock "github.com/golang/mock/gomock"
)

// MockCredentialsCache is a mock of CredentialsCache interface
type MockCredentialsCache struct {
	ctrl     *gomock.Controller
	recorder *MockCredentialsCacheMockRecorder
}

// MockCredentialsCacheMockRecorder is the mock recorder for MockCredentialsCache
type MockCredentialsCacheMockRecorder struct {
	mock *MockCredentialsCache
}

// NewMockCredentialsCache creates a new mock instance
func NewMockCredentialsCache(ctrl *gomock.Controller) *MockCredentialsCache {
	mock := &MockCredentialsCache{ctrl: ctrl}
	mock.recorder = &MockCredentialsCacheMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockCredentialsCache) EXPECT() *MockCredentialsCacheMockRecorder {
	return m.recorder
}

// Clear mocks base method
func (m *MockCredentialsCache) Clear() {
	m.ctrl.Call(m, "Clear")
}

// Clear indicates an expected call of Clear
func (mr *MockCredentialsCacheMockRecorder) Clear() *gomock.Call {
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Clear", reflect.TypeOf((*MockCredentialsCache)(nil).Clear))
}

// Get mocks base method
func (m *MockCredentialsCache) Get(arg0 string) *cache.AuthEntry {
	ret := m.ctrl.Call(m, "Get", arg0)
	ret0, _ := ret[0].(*cache.AuthEntry)
	return ret0
}

// Get indicates an expected call of Get
func (mr *MockCredentialsCacheMockRecorder) Get(arg0 interface{}) *gomock.Call {
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Get", reflect.TypeOf((*MockCredentialsCache)(nil).Get), arg0)
}

// List mocks base method
func (m *MockCredentialsCache) List() []*cache.AuthEntry {
	ret := m.ctrl.Call(m, "List")
	ret0, _ := ret[0].([]*cache.AuthEntry)
	return ret0
}

// List indicates an expected call of List
func (mr *MockCredentialsCacheMockRecorder) List() *gomock.Call {
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "List", reflect.TypeOf((*MockCredentialsCache)(nil).List))
}

// Set mocks base method
func (m *MockCredentialsCache) Set(arg0 string, arg1 *cache.AuthEntry) {
	m.ctrl.Call(m, "Set", arg0, arg1)
}

// Set indicates an expected call of Set
func (mr *MockCredentialsCacheMockRecorder) Set(arg0, arg1 interface{}) *gomock.Call {
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Set", reflect.TypeOf((*MockCredentialsCache)(nil).Set), arg0, arg1)
}
