
/* ###--------------------------------------------------------------### */
/* file		: vh_ltype.h						*/
/* date		: Aug 30 1996						*/
/* version	: v3.0							*/
/* author	: Pirouz BAZARGAN SABET					*/
/* contents	: This file contains data structure definitions		*/
/*		  generated by the linker				*/
/* ###--------------------------------------------------------------### */

	/* ###------------------------------------------------------### */
	/*    defines							*/
	/* ###------------------------------------------------------### */

#define MAD_GEXBLK      50		/* magex struct allocation size	*/

#define VHL_CMODEL	 1		/* instance type : C    models	*/
#define VHL_VMODEL	 2		/* instance type : VHDL models	*/

#define VHL_UKNDFN      8
#define VHL_DECDFN      4
#define VHL_REDDFN      2
#define VHL_WRTDFN      1

#define VHL_MODDFN      0
#define VHL_SIGDFN      1
#define VHL_CNBDFN      2
#define VHL_RNBDFN      3
#define VHL_WNBDFN      4
#define VHL_PNTDFN      7

#define VHL_LVLDFN      1

	/* ###------------------------------------------------------### */
	/*    Data Structure Definitions				*/
	/* ###------------------------------------------------------### */

typedef struct lkdfig			/* linked figure		*/
  {
  struct lkdfig *NEXT  ;		/* next figure			*/
  char          *NAME  ;		/* figure's name		*/
  struct lkdins *LKDINS;		/* list of instances		*/
  struct simsig *SIMSIG;		/* list of simple signals	*/
  struct bussig *BUSSIG;		/* list of bused signals	*/
  unsigned int   VALSIZ;		/* # of bytes needed for values	*/
  }
lkdfig_list;

typedef struct lkdins			/* linked instance		*/
  {
  struct lkdins  *NEXT   ;		/* next instance		*/
  char           *INSNAME;		/* instance's name		*/
  struct befig   *BEFIG  ;		/* instance model		*/
  struct wrssig  *WRSSIG ;		/* written output ports		*/
  struct wriaux  *WRIAUX ;		/* written internal signals	*/
  struct wribux  *WRIBUX ;		/* written internal bused sig.	*/
  struct wrbsig  *WRBSIG ;		/* written bused ports		*/
  struct wrireg  *WRIREG ;		/* written registers		*/
  struct wrimsg  *WRIMSG ;		/* written asserts		*/
  struct redlst  *REDLST ;		/* read values			*/
  struct circuit *CIRCUI ;		/* Circuit pointer used for BDDs*/
  unsigned char   LEVEL  ;		/* level			*/
  char            EVAL   ;		/* Evaluation's flag		*/
  char            FLAG   ;		/* model type			*/
  }
lkdins_list;

typedef struct simsig			/* simple signal		*/
  {
  struct simsig *NEXT     ;		/* next simple signal		*/
  struct chain  *NAMECHAIN;		/* signal's name		*/
  struct ptype  *DEPEND   ;		/* dependency list		*/
  unsigned char *CURVAL   ;		/* signal's current value	*/
  unsigned char  PRJVAL   ;		/* signal's projected value	*/
  }
simsig_list;

typedef struct bussig			/* bused signal			*/
  {
  struct bussig *NEXT     ;		/* next simple signal		*/
  struct chain  *NAMECHAIN;		/* signal's name		*/
  struct ptype  *DEPEND   ;		/* dependency list		*/
  unsigned char *CURVAL   ;		/* signal's current value	*/
  struct prjbvl *PRJBVL   ;		/* list of projected bi-values	*/
  char           TYPE     ;		/* signal's type		*/
  char           ERRFLG   ;		/* error flag			*/
  }
bussig_list;

typedef struct wrbsig			/* written bused signal		*/
  {
  struct wrbsig *NEXT     ;		/* next signal			*/
  struct lkdins *LKDINS   ;		/* instance			*/
  struct bebus  *BEBUS    ;		/* formal bused signal (model)	*/
  struct bussig *BUSSIG   ;		/* actual bused signal		*/
  struct prjbvl *PRJBVL   ;		/* list of projected bi-values	*/
  unsigned char  LEVEL    ;		/* level			*/
  char           EVAL     ;		/* evaluation flag		*/
  }
wrbsig_list;

typedef struct wriaux			/* written auxiliary signal 	*/
  {
  struct wriaux *NEXT     ;		/* next auxiliary signal       	*/
  struct ptype  *DEPEND   ;		/* dependency list		*/
  struct lkdins *LKDINS   ;		/* instance			*/
  struct beaux  *BEAUX    ;		/* formal internal sig. (model)	*/
  unsigned char *CURVAL   ;		/* aux. signal current value	*/
  unsigned char  PRJVAL   ;		/* aux. signal projected value  */
  unsigned char  LEVEL    ;		/* level			*/
  char           EVAL     ;		/* evaluation flag		*/
  char           FLAG     ;		/* signal type (delayed)	*/
  }
wriaux_list;

typedef struct wrimsg			/* assert			*/
  {
  struct wrimsg *NEXT     ;		/* next assert			*/
  struct bemsg  *BEMSG    ;		/* formal assert (model)	*/
  struct lkdins *LKDINS   ;		/* instance			*/
  unsigned char  LEVEL    ;		/* level			*/
  char           EVAL     ;		/* evaluation flag		*/
  char           ERRFLG   ;		/* assert violation flag	*/
  }
wrimsg_list;

typedef struct wrireg			/* written register		*/
  {
  struct wrireg *NEXT     ;		/* next register		*/
  struct ptype  *DEPEND   ;		/* dependency list		*/
  struct lkdins *LKDINS   ;		/* instance			*/
  struct bereg  *BEREG    ;		/* formal register (model)	*/
  unsigned char *CURVAL   ;		/* register's current value	*/
  struct prjrvl *PRJRVL   ;		/* list of projected bi-values	*/
  char           EVAL     ;		/* evaluation flag		*/
  char           ERRFLG   ;		/* error flag			*/
  }
wrireg_list;

typedef struct wribux			/* written internal bused sig.	*/
  {
  struct wribux *NEXT     ;		/* next signal			*/
  struct ptype  *DEPEND   ;		/* dependency list		*/
  struct lkdins *LKDINS   ;		/* instance			*/
  struct bebux  *BEBUX    ;		/* formal bused signal (model)	*/
  unsigned char *CURVAL   ;		/* register's current value	*/
  struct prjbvl *PRJBVL   ;		/* list of projected bi-values	*/
  unsigned char  LEVEL    ;		/* level			*/
  char           EVAL     ;		/* evaluation flag		*/
  char           ERRFLG   ;		/* error flag			*/
  }
wribux_list;

typedef struct wrssig			/* written simple signal	*/
  {
  struct wrssig *NEXT     ;		/* next object			*/
  struct beout  *BEOUT    ;		/* formal output port (model)	*/
  struct lkdins *LKDINS   ;		/* instance			*/
  struct simsig *SIMSIG   ;		/* actual signal		*/
  unsigned char  LEVEL    ;		/* level			*/
  char           EVAL     ;		/* evaluation flag		*/
  }
wrssig_list;

typedef struct redlst			/* list of read values		*/
  {
  struct redlst *NEXT;			/* next value			*/
  unsigned char *VALU;			/* pointer on the value		*/
  }
redlst_list;

typedef struct prjbvl			/* projected bi-value		*/
  {
  struct prjbvl *NEXT  ;		/* next bi-value (local)	*/
  struct prjbvl *GLNEXT;		/* next bi-value (global)	*/
  unsigned char  CNDVAL;		/* driver's condition value	*/
  unsigned char  DRVVAL;		/* drove value			*/
  }
prjbvl_list;

typedef struct prjrvl			/* projected bi-value		*/
  {
  struct prjrvl *NEXT  ;		/* next bi-value		*/
  unsigned char  CNDVAL;		/* driver's condition value	*/
  unsigned char  DRVVAL;		/* drove value			*/
  }
prjrvl_list;

typedef struct magex			/* general expression		*/
  {
  struct chain   *OPERAND;		/* operands or NULL for terms	*/
  unsigned int    TERM   ;		/* operator or terminal's index	*/
  unsigned short  TYPE   ;		/* expression's type index	*/
  }
magex_list;

typedef struct lkdmdl			/* list od C models		*/
  {
  struct lkdmdl  *NEXT    ;		/* next model			*/
  char           *NAME    ;		/* model's name			*/
  void          (*FONC) ();		/* pointer of the C function	*/
  }
lkdmdl_list;

typedef struct lkdspy			/* spied signals		*/
  {
  struct lkdspy *NEXT   ;		/* next spy			*/
  unsigned int   IOLNBR ;		/* spy's iol number (ident)	*/
  struct paiol  *PAIOL  ;		/* spied paiol			*/
  }
lkdspy_list;
