// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
/**
 * @type (BaselineView)
 * This is a view class for Baseline
 * Provides functions for showing master pane and its action.
 */
define(['hpsum/model/baseline/BaselineResource',
	'hp/view/MasterPaneView',
	'hpsum/presenter/baseline/BaselinePresenter',
    'hp/core/Localizer',
	'hp/services/IndexService',
	'hp/view/DialogView',
    'jquery',
    'lib/jquery-ui-timepicker-addon',
    'lib/jquery.dateFormat',
    'hp/lib/jquery.hpToggle',
	'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpUtilizationMeter',
    'hp/lib/jquery.hpSafeClone'],
function(resource, MasterPaneView, presenter, localizer, indexService, DialogView) {"use strict";

    var BaselineView = ( function() {
		
		var TYPE = 'baseline';
		var PAGE = '#hpsum-baseline-page';
		var SCHEDULE_DIALOG = '#hpsum-baseline-schedule-information';
		
        /**
         * @constructor
         * @type {BaselineView}
         */
        function BaselineView() {

			var masterPaneView = new MasterPaneView();
			var template = null;
			
			function renderer(indexResult) {
				var i, html, uri, location_id;
                var item = template.hpSafeClone();
                item.attr('id', '');
                item.show();
                
                $('.hp-status', item).hpStatus(indexResult.status, indexResult.changing);
                $('.hp-master-item-name', item).html(indexResult.name);
                $('.baseline-item-version', item).html('<label class="hp-label">' + localizer.getString("hpsum.baseline.version") + '<label> ' + indexResult.attributes.version);
               	$('.baseline-item-location', item).html( '<div style="max-width:140px; word-wrap:break-word;">' + localizer.getString("hpsum.common.locationStr") +  ': ' + indexResult.location + '</div>');
                $('.baseline-item-size', item).html(indexResult.attributes.size);
                
                var locations = indexService.getLocations();
                
                //This baseline is just added (as per status value), so start InventoryBaseline on it
                // the inventory should happen for local and UNC. For PFW bundles the
                // automatic inventory need not to happen
                if (indexResult.state === "inventory_needed")
                { 
		   if (indexResult.location_type.match(/local|Unc/i))
                   {
                		presenter.startInventory(indexResult);
                   }
                                      
                }
                
                
                html = '<li data-id="all" class="hp-selected">' + localizer.getString("hpsum.common.all") + '</li>';
                
                for(i = 0; i < locations.length; i += 1)
                {
                	html = html + '<li data-id="' + locations[i].location_uri + '">' + locations[i].location_uri + '</li>';
                }
                
                $('#locations', PAGE).html(html);
                
               //Should not use BASELINE_TO_NODE as it affects the filter functionality
               //Currently resource is created with out any options such as BASELINE_TO_NODE
               //need to resolve this later 
                /*
                if (indexResult.children.BASELINE_TO_NODE) {
                    $('.baseline-item-nodes a', item).attr('href', '#/type/show?' +
                        'f_suri=' + indexResult.uri +
                        '&f_an=BASELINE_TO_DEVICE').text(
                            indexResult.children.BASELINE_TO_NODES.length + ' nodes');
                } else {
                    $('.baseline-item-nodes a', item).replaceWith('0 nodes');
                }
                */
                return item;
            }
			
            /**
             * @public
             */
            this.init = function() {
                presenter.init();
			
				template = $('#hpsum-baseline-item-template').detach();			
				
								
				masterPaneView.init({
                    routePrefix: '/' + TYPE,
                    resource: resource,
                    page: $(PAGE),
				    addLink: presenter.getAddLink(),
                    multiSelect: true,
                    dataTableOptions:  {
                        aoColumns : [
                            {fnRender: function (oObj) {
                                return '<div>' + oObj.aData.status +
                                    (oObj.aData.changing ? ' *' : '') +
                                    '</div>';
                            }, mDataProp: 'location'},
                            {fnRender: function (oObj) {
                                return '<a href="#/' + TYPE + '/show/r' + oObj.aData.uri +
                                    '">' + oObj.aData.name +
                                    '</a>';
                            }, mDataProp: 'name'}//, sWidth: '180px'},
                            //{mDataProp: 'attributes.model', sWidth: '80px'}
                        ],
                        aaSorting: [[ 1, "asc" ]],
                        fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0) > div', nRow).hpStatus();
                            return nRow;
                        }
                    },
                    gridItemRenderer: renderer
                });
                
                $('#hpsum-baselines-utilization').hpUtilizationMeter();
                $('#hpsum-baselines-utilization').hpUtilizationMeter(65,0,100);
            };

            /**
             * @public
             */
            this.pause = function() {
				masterPaneView.pause();
            };

            /**
             * @public
             */
            this.resume = function() {
				masterPaneView.resume();
            };
        }

        return new BaselineView();
    }());

    return BaselineView;
});
