// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
define(['hp/model/Resource', 'hpsum/presenter/generic/GenericPresenter',
    'hp/core/Router', 'hpsum/model/HpsumMock'],
function(Resource, GenericPresenter, router, mock) { "use strict";

    var HpsumGenerator = (function() {
      
        var PAGE_CONTAINER = '#hp-page-container';
        var DETAILS_CONTAINER = '#tour-generic-page .hp-details-pane';
        var CHANGE_CONTAINER = '#hp-change-page-container';

        function HpsumGenerator() {
          
            var types = {};
            
            function registerSubRoutes(type, data) {
                router.map(type + ' show', '/' + type + '/show(/.*|$)', {
                    container: DETAILS_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/generic/show.html',
                            'hpsum/view/generic/GenericShowView'],
                        function (page, GenericShowView) {
                            if (! data.showView) {
                                data.showView = new GenericShowView();
                                data.showView.setPresenter(data.presenter);
                            }
                            result.load(page, data.showView);
                        });
                    }
                });

                router.map(type + ' add', '/' + type + '/add(/.*|$)', {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/generic/add.html',
                            'hpsum/view/generic/GenericAddView'],
                        function (page, GenericAddView) {
                            if (! data.addView) {
                                data.addView = new GenericAddView();
                                data.addView.setPresenter(data.presenter);
                            }
                            result.load(page, data.addView);
                        });
                    }
                });

                router.map(type + ' edit', '/' + type + '/edit(/.*|$)', {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/generic/edit.html',
                            'hpsum/view/generic/GenericEditView'],
                        function (page, GenericEditView) {
                            if (! data.editView) {
                                data.editView = new GenericEditView();
                                data.editView.setPresenter(data.presenter);
                            }
                            result.load(page, data.editView);
                        });
                    }
                });

                router.filter(type + ' default redirector',
                    '/' + type + '($|/$|/r/)', {
                    check: function (location, result) {
                        result.replaceWith('/' + type + '/show');
                    }
                });

                router.map(type + ' no route', '/' + type + '/.+', {
                    container: DETAILS_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }

            this.add = function (label, type, count, relations) {
                // generate items via HpsumMock
                mock.generate(type, count);
                if (relations) {
                    $.each(relations, function (index, child) {
                        mock.associate(type.toUpperCase() + '_TO_' + child.toUpperCase(),
                            type, child, 2, false);
                    });
                }
                
                // create a Resource and Presenter
                var resource = new Resource(type);
                var presenter = new GenericPresenter();
                presenter.init(resource);
                
                types[type] = {label: label, resource: resource, presenter: presenter};
            };
              
            this.registerRoutes = function () {  
                // set up routes
                $.each(types, function (type, data) {
                  
                    router.map(type, '^/' + type + '(/.*|$)', {
                        menu: {
                          section: 'Generated',
                          label: data.label,
                          location: '/' + type,
                          resourceUriPattern: '^/' + type + '/.+',
                          indexCategory: type
                        },
                        container: PAGE_CONTAINER,
                        enter: function (location, result) {
                            require(['text!hpsumpages/generic/index.html',
                                'hpsum/view/generic/GenericView'],
                            function (page, GenericView) {
                                if (! data.view) {
                                    data.view = new GenericView();
                                    data.view.setPresenter(data.presenter);
                                }
                                result.load(page, data.view);
                                //result.noAction();
                            });
                        }
                    });
                    
                    registerSubRoutes(type, data);
                });
                
            };
        }

        return new HpsumGenerator();
    }());
    
    return HpsumGenerator;
});
