// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
define(['hp/services/EulaService','hp/core/EventDispatcher'],
function(eulaService, EventDispatcher) {"use strict";

    var EulaPresenter = (function() {
        function EulaPresenter() {
            var dispatcher = new EventDispatcher();

            function isSupportEnabledSucess(data) {
                var result = data;
                dispatcher.fire("isSupportEnabledSucess", result);
            }

            function isSupportEnabledError(data) {
                var result = data;
                dispatcher.fire("isSupportEnabledFailure", result);
            }

            this.checkIsSupportEnabled = function() {
                eulaService.getServiceAccess({
                    success : isSupportEnabledSucess,
                    error : isSupportEnabledError
                });
            };

            function saveEulaStatusSucess(data) {
                dispatcher.fire("saveEulaSucess", data);
            }

            function saveEulaStatusFailure(data) {
                dispatcher.fire("saveEulaFailed", data);
            }

            this.saveEulaStatus = function(isSupportEnabled) {
                eulaService.postEulaData(isSupportEnabled,{
                    success : saveEulaStatusSucess,
                    error : saveEulaStatusFailure
                });
            };

            function enableServiceSucess(data) {
                dispatcher.fire("enableServiceSucess", data);
            }

            function enableServiceFailure(data) {
                dispatcher.fire("enableServiceFailure", data);
            }

            this.updateServiceAccess = function(enableService) {
                eulaService.updateServiceAccess(enableService,{
                    success : enableServiceSucess,
                    error : enableServiceFailure
                });
            };

            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };

            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };
        }

    return new EulaPresenter();
    }());

    return EulaPresenter;
});