// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
/**
 * @type {MapRow}
 */
define(['hp/model/map/MapNode', 'hp/core/StatusState', 'hp/core/Style', 'hp/core/Localizer'],
function (MapNode, statusState, style, localizer) { "use strict";

    var MapRow = ( function() {
      
        var SUMMARY_THRESHOLD;

        function MapRow() {

            var self = this;
            var map;
            var category;
            var index;
            var column;
            var nodes = [];
            var nodeIndex = {}; // uri -> MapNode
            var summary = {ok: 0, warning: 0, error: 0, disabled: 0,
                unknown: 0, total: 0, uriIndex: {}};
            var collapsed = false;
            var summaryThreshold;
            
            function collapse(summaryNode) {
                var length, i, node;
                length = nodes.length;
                for (i=0; i<length; i++) {
                    node = nodes[i];
                    // point uri to summary node now
                    nodeIndex[node.resource.uri] = summaryNode;
                    // change links to refer to summary node
                    node.relinkAs(summaryNode);
                }
                nodes = [summaryNode];
                collapsed = true;
            }
            
            this.category = function () {
                return category;
            };
            
            this.index = function () {
                return index;
            };
            
            this.setIndex = function (indexArg) {
                index = indexArg;
            };
            
            this.column = function () {
                return column;
            };
            
            this.setColumn = function (columnArg) {
                column = columnArg;
            };
            
            this.nodes = function () {
                return nodes;
            };
            
            this.singleNode = function () {
                if (nodes.length === 1) {
                    return nodes[0];
                }
                return null;
            };
            
            this.getOrCreateNode = function(treeNode, associationParams,
                primaryAssociation) {
                var resource = treeNode.resource;
                var node = nodeIndex[resource.uri];
              
                // keep the summary up to date in case we cross the threshold
                if (associationParams && (! summary.associationParams || primaryAssociation)) {
                    summary.associationParams = associationParams;
                    summary.category = category;
                }
                
                // don't double count in case there multiple associations 
                if (! node) {
                    summary.total += 1;
                    summary[statusState.getHealthStatus(resource.status)] += 1;
                    summary.uriIndex[resource.uri] = true;
                }
                
                if (! collapsed && nodes.length < summaryThreshold) {
                    // below threshold
                    if (! node) {
                        node = new MapNode();
                        node.init(resource, self);
                        nodes.push(node);
                        nodeIndex[resource.uri] = node;
                    }
                } else if (nodes.length === summaryThreshold) {
                    // we've reached the summary threshold, collapse
                    node = new MapNode();
                    node.init(null, self, summary);
                    
                    // remove prior nodes
                    collapse(node);
                    
                    nodeIndex[resource.uri] = node;
                } else {
                    // over threshold
                    node = nodes[0];
                    nodeIndex[resource.uri] = node;
                }
                
                return node;
            };
            
            this.toString = function () {
                return category;
            };
            
            this.init = function(mapArg, categoryArg) {
                map = mapArg;
                category = categoryArg;
                summaryThreshold = SUMMARY_THRESHOLD ? SUMMARY_THRESHOLD :
                    style.related().summaryThreshold;
            };
            
            this.destroy = function() {
                var length, i;
                length = nodes.length;
                for (i=0; i<length; i++) {
                    nodes[i].destroy();
                }
                nodes = null;
                map = null;
            };
            
            // for testing
            this.setSummaryThreshold = function (summaryThresholdArg) {
                SUMMARY_THRESHOLD = summaryThresholdArg;
            };
        }

        return MapRow;
    }());

    return MapRow;
});
