// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
define(['hp/core/Localizer',
    'jquery',
    'hp/lib/date',
    'lib/jquery.dateFormat',
    'hp/lib/interval'],
function (localizer) {
"use strict";
    (function ($) {
        // jQuery plugin definition
        $.fn.hpTimestamp = function (arg) {
          
            var MILLISECONDS_PER_DAY = (1000 * 60 * 60 * 24);
            var ret;
            
            function formatInterval(interval) {
                var days = (interval.years * 365) + interval.days;
                if (days) {
                    return localizer.getString('core.duration.dhms',
                        [days, interval.hours, interval.minutes, interval.seconds]);
                } else if (interval.hours) {
                    return localizer.getString('core.duration.hms',
                        [interval.hours, interval.minutes, interval.seconds]);
                } else if (interval.minutes) {
                    return localizer.getString('core.duration.ms',
                        [interval.minutes, interval.seconds]);
                } else {
                    return localizer.getString('core.duration.s', [interval.seconds]);
                }
            }
            
            function formatTime(date) {
                var today = new Date();
                today.setHours(0, 0, 0, 0);
                var yesterday = new Date(today.getTime() - MILLISECONDS_PER_DAY);
                
                if (date.getTime() > today.getTime()) {
                    return localizer.getString('core.date.today',
                        [$.format.date(date,
                            localizer.getString('core.date.todayFormat'))]);
                } else if (date.getTime() > yesterday.getTime()) {
                     return localizer.getString('core.date.yesterday',
                        [$.format.date(date,
                            localizer.getString('core.date.yesterdayFormat'))]);
                } else if (date.getFullYear() >= today.getFullYear()) {
                    return $.format.date(date,
                        localizer.getString('core.date.thisYearFormat'));
                } else {
                    return $.format.date(date,
                        localizer.getString('core.date.priorYearFormat'));
                }
            }

            this.each(function() {
                var elem = $(this);
                var date = null;
                var endDate = null;
                var original = null;
                var elements = null;
                var interval = null;
                
                if (! arg) {
                    // no date given, use element contents
                    // see if we've already built this before
                    if (elem.attr('date-timestamp')) {
                        original = elem.attr('date-timestamp');
                    } else {
                        // use element text
                        original = $(elem).text();
                    }
                } else if ('string' === typeof(arg)) {
                    original = arg;
                }

                if (original) {
                    elements = original.split('/');
                    date = Date.parseISOString(elements[0]);
                    if (elements.length > 1) {
                        // this is an interval
                        if (elements[1][0] === "P") {
                            // ISO 8601 duration format
                            // sonar requires reference to window. 
                            interval = window.Interval.parseISODuration(elements[1]);
                        } else {
                            endDate = Date.parseISOString(elements[1]);
                            if (!isNaN(date.getTime()) &&
                                !isNaN(endDate.getTime())) {
                                interval = window.Interval.between(date, endDate);
                            }
                        }
                    }
                    
                    if (!isNaN(date.getTime())) {
                        if (endDate && !isNaN(endDate.getTime())) {
                            elem.attr('date-timestamp', date.toISOString() + '/' +
                                endDate.toISOString());
                        } else if (interval) {
                            elem.attr('date-timestamp', date.toISOString() + '/' +
                                interval.toISODuration());
                        } else {
                            elem.attr('date-timestamp', date.toISOString());
                        }
                    
                        if (endDate || interval) {
                            elem.text(formatInterval(interval));
                        } else {
                            elem.text(formatTime(date));
                        }
                    }
                }
               
                ret = ret ? ret.add(elem) : elem;
            });
            return ret;
        };
    }(jQuery));
});
