// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
define(['hp/core/Localizer',
        'fs/presenter/status/StatusPresenter',
        'hp/lib/jquery.hpProgressBar'],

function(Localizer, statusPresenter) {"use strict";

    var StatusStartingView = ( function() {
        
        var STILL_GETTING_503_ERRORS = "#cic-status-starting-spinner";
        var NOW_GETTING_PROGRESS_DATA = "#cic-status-starting-progress-bar";
        
        var PROGRESS_BAR = '#hp-starting-progress';
        
        /**
         * @class View script for the /status/starting page
         */
        function StatusStartingView() {
            /**
             * Update the restore progress bar
             */
            function updateProgressBar(startingProgress) {
                var percentComplete = (startingProgress.current / startingProgress.target) * 100;
                $(PROGRESS_BAR).hpProgressBar(percentComplete);
            }
            
            function showSpinner() {
                $(NOW_GETTING_PROGRESS_DATA).hide();
                $(STILL_GETTING_503_ERRORS).show();
            }
            
            function showProgress() {
                $(STILL_GETTING_503_ERRORS).hide();
                $(NOW_GETTING_PROGRESS_DATA).show();
            }
            
            /**
             * Monitor the starting progress              
             */
            function monitorStartingProgress() {
                statusPresenter.monitorStartingProgress({
                    waiting : function() {
                        showSpinner();
                    },
                    progress : function(startingProgress) {
                        updateProgressBar(startingProgress);
                        showProgress();
                    },
                    error : function(startingProgress) {
                        showSpinner();
                    }
                });
            }

            this.init = function() {
                $(STILL_GETTING_503_ERRORS).hide();
                $(NOW_GETTING_PROGRESS_DATA).hide();
                
                $(PROGRESS_BAR).hpProgressBar(0);
                
                monitorStartingProgress();
            };

            this.pause = function() {
                // nothing
            };

            this.resume = this.init;
        }

        return new StatusStartingView();

    }());

    return StatusStartingView;

});
