// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
define(['hp/core/Localizer', 'hp/core/Router',
    'hp/view/DialogView', 'text!hpPages/login/eula-confirmation.html',
    'hp/core/Banner', 'fs/presenter/settings/ApplianceUpdatePresenter',
    'jquery', 'hp/lib/jquery.hpToggle', 'lib/jquery.validate'],

function(localizer, router, DialogView, eulaconfirmation,
    banner, updatePresenter) { "use strict";

    var ApplianceUpdateEulaView = (function() {

        var AGREE_BUTTON = "#hp-eula-agree-button",
            OK_BUTTON = "#hp-eula-ok-button",
            DISAGREE_BUTTON = "#hp-eula-disagree-button",
            EULA_HEADER_TITLE_TWO = "#hp-header-eula-type",
            EULA_WRITTEN_OFFER = "#hp-eula-partnercontent-body",
            EULA_CONTENT_BODY = "#hp-eula-contents-body";
        var APPLIANCE_NAME = '#hp-header-eula-name';
        var CONFIRMATION_APPLIANCE_NAME = '#hp-eula-confirmation-appliance-name';
        var EULA_IFRAME_MAIN = "#iframe-eula-content";
        var EULA_IFRAME_UPGRADE = "#iframe-eula-upgrade";

        function ApplianceUpdateEulaView() {

            function clear() {
                $(EULA_CONTENT_BODY).empty();
                $(EULA_WRITTEN_OFFER).empty();
            }

            function onOkButtonClick() {
                updatePresenter.setUpdateState(1);
                router.go('/settings/update/appliance');
            }
            
            function loadEulaHtml() {
                $(EULA_IFRAME_UPGRADE).attr('src', '/ui-js/pages/upgrade/eula_content.html');
            }

            function onLoadSupportSuccess(data, status, xhr) {
                var writtenOfferHtml = $(data).filter('#hp-eula-partner-content');
                var writtenOfferText = $.trim(writtenOfferHtml.text());
                if (writtenOfferText.length == 0) {
                    onOkButtonClick();
                } else {
                    $(EULA_IFRAME_UPGRADE).hide();
                    $(EULA_HEADER_TITLE_TWO).text(localizer.getString
                        ('fs.settings.eula.config.end_user_support_title'));
                    $(EULA_WRITTEN_OFFER).html(writtenOfferHtml);
                    $(AGREE_BUTTON).hide();
                    $(DISAGREE_BUTTON).hide();
                    $(OK_BUTTON).show();
                }
            }
            
            function onLoadSupportError(jqXHR, textStats, errorThrown) {
                onOkButtonClick();
            }

            function onAgreeButtonClick(){
               $.ajax({
                   url: '/ui-js/pages/upgrade/support_access_and_written_offer.html',
                   type: 'GET',
                   async: true,
                   dataType: "html",
                   success: onLoadSupportSuccess,
                   error: onLoadSupportError
               });
            }

            function onDisagreeButtonClick(){
                var dialogView = null;
                dialogView = new DialogView({
                contents:eulaconfirmation,
                    ok : function(){
                        router.go('/settings/update/appliance','to setting update page');
                    }
                });
                $(CONFIRMATION_APPLIANCE_NAME).html(banner.getApplicationTitle());
            }

            this.resume = function(){
                $(EULA_IFRAME_MAIN).hide();
                clear();
                loadEulaHtml();
                $(EULA_HEADER_TITLE_TWO).text(localizer.getString
                        ('fs.settings.eula.config.end_user_title'));
                $(OK_BUTTON).hide();
                $(DISAGREE_BUTTON).show();
                $(AGREE_BUTTON).show();
            };

            this.init = function() {
                $(EULA_IFRAME_MAIN).hide();
                clear();
                loadEulaHtml();
                $(APPLIANCE_NAME).text(banner.getApplicationTitle());
                $(AGREE_BUTTON).click(onAgreeButtonClick);
                $(DISAGREE_BUTTON).click(function(ev) {
                    onDisagreeButtonClick();
                    ev.preventDefault();
                });
                $(OK_BUTTON).click(onOkButtonClick);
            };
        }

        return new ApplianceUpdateEulaView();

    }());

    return ApplianceUpdateEulaView;

});