// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.

define(['fs/presenter/activity/ActivityPresenter',
    'hp/view/MasterPaneView',
    'hp/core/StatusState',
    'hp/core/LinkTargetBuilder',
    'jquery',
    'hp/lib/jquery.hpDropMenu',
    'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpTimestamp',
    'hp/lib/jquery.hpProgressBar'],
function(presenter, MasterPaneView, statusState, linkTargetBuilder) { "use strict";

    var ActivityView = (function() {
      
        var TYPE = 'activity';
        var PAGE = '#hp-activity-page';
      
        /**
         * Constructor
         */
        function ActivityView() {
          
            var masterPaneView = new MasterPaneView();
            
            function renderStatus(oObj) {
                var data = oObj.aData;
                var status = 'unknown';
                var changing = false;
                if (data.attributes.hasOwnProperty('severity')) {
                    // Alert
                    status = data.attributes.severity;
                } else if (data.attributes.hasOwnProperty('taskState')) {
                    // Task
                    status = data.attributes.taskState;
                    if ('Running' === status) {
                        changing = true;
                    }
                }
                return '<div>' +
                    statusState.getHealthStatus(status) +
                    (changing ? ' *' : '') +
                    '</div>';
            }
            
            function renderName(oObj) {
                var data = oObj.aData;
                if (data.name) {
                    return data.name;
                } else {
                    return data.description;
                }
            }
            
            function renderSource(oObj) {
                var attributes = oObj.aData.attributes;
                if (attributes.hasOwnProperty('associatedResourceUri')) {
                    return linkTargetBuilder.makeLink(attributes.associatedResourceName,
                        attributes.associatedResourceUri);
                } else if (attributes.hasOwnProperty('resourceUri')) {
                    return linkTargetBuilder.makeLink(attributes.resourceUri,
                        attributes.resourceUri);
                } else {
                    return '<div class="hp-unset">not set</div>';
                }
            }
            
            function renderState(oObj) {
                var attributes = oObj.aData.attributes;
                if (attributes.hasOwnProperty('alertState')) {
                    return attributes.alertState;
                } else if (attributes.hasOwnProperty('taskState')) {
                    if ('Running' !== attributes.taskState) {
                        return attributes.taskState;
                    } else {
                        return '<div class="hp-progress" style="width: 50px">' +
                            '</div><div class="hp-duration">' +
                            oObj.aData.created + '/' + (new Date()).toISOString() +
                            '</div>';
                    }
                } else {
                    return '<div class="hp-unset">not set</div>';
                }
            }
            
            function renderOwner(oObj) {
                var attributes = oObj.aData.attributes;
                if (attributes.hasOwnProperty('assignedToUser')) {
                    return attributes.assignedToUser;
                } else if (attributes.hasOwnProperty('taskOwner')) {
                    return attributes.taskOwner;
                } else {
                    return '<div class="hp-unset">none</div>';
                }
            }
                
            /**
             * @public
             */
            this.pause = function () {
                masterPaneView.pause();
            };
            
            this.resume = function () {
                masterPaneView.resume();
            };
            
            this.init = function () {
                
                presenter.init();
                
                $('#hp-activity-actions').hpDropMenu();
                
                masterPaneView.init({
                    routePrefix: '/' + TYPE,
                    resource: presenter.resource(),
                    page: $(PAGE),
                    multiSelect: true,
                    dataTableOptions:  {
                        aoColumns : [
                            // expand/collapse
                            {fnRender: function (oObj) {
                                return '<div class="hp-collapser"></div>';
                              },
                              sWidth: 20, sClass: "hp-icon", sDefaultContent: ''},
                            // status
                            {fnRender: renderStatus, sDefaultContent: '',
                              sWidth: 20, sClass: "hp-icon"},
                            // name
                            {fnRender: renderName, sDefaultContent: '',
                              mDataProp: 'name'},
                            // source
                            {fnRender: renderSource, sDefaultContent: ''},
                            // date
                            {mDataProp: 'created'},
                            // state
                            {fnRender: renderState, sDefaultContent: '', sWidth: 120},
                            // owner
                            {fnRender: renderOwner, sDefaultContent: ''},
                            // clear
                            {fnRender: function (oObj) {
                                return '<div class="hp-delete"></div>';
                              },
                              sWidth: 20, sClass: "hp-icon", sDefaultContent: ''}
                        ],
                        aaSorting: [[ 4, "asc" ]],
                        fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(1) > div', nRow).hpStatus();
                            $('td:eq(4), td:eq(5) .hp-duration', nRow).hpTimestamp();
                            $('td:eq(5) .hp-progress', nRow).hpProgressBar(aData.percentComplete);
                            return nRow;
                        }
                    }
                });
                
                this.resume();
            };
        }

        return new ActivityView();
    }());
    
    return ActivityView;
});
