// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
define(['hp/services/REST'],
function(REST) {"use strict";
    var SettingsService = ( function() {
        /**
         * @class Singleton class that handles communication with the
         * server-side Settings service.
         */
        function SettingsService() {
            var BASE_URI = '/settings/rest/resources';
            
            /**
             * Retrieves the value of a setting, given its name.
             *
             * @param {string} name The name of the setting.
             * @param {{success:function(Object):void,
             *          error:function(string):void}} handlers
             *     The success and error handler functions.
             */
            this.getSetting = function(name, handlers) {
                REST.getURI(BASE_URI + '/' + name + '/', handlers);
            };
            
            /**
             * Sets the value of a setting.
             *
             * @param {Object} setting The Setting object to be saved.
             * @param {{success:function(Object):void,
             *          error:function(string):void}} handlers
             *     The success and error handler functions.
             */
            this.setSetting = function(setting, handlers) {
                REST.postObject(BASE_URI, setting, handlers);
            };
            
            /**
             * Sets the values of multiple settings.
             *
             * @param {Array.<Object>} settings The Setting objects to be saved.
             * @param {{success:function(Array.<Object>):void,
             *          error:function(string):void}} handlers
             *     The success and error handler functions.
             */
            this.setSettings = function(settings, handlers) {
                REST.postObject(BASE_URI + '?multiResource=true', settings, handlers);
            };
            
            /**
             * Deletes a setting, given its name.
             *
             * @param {string} name The name of the setting.
             * @param {{success:function():void,
             *          error:function(string):void}} handlers
             *     The success and error handler functions.
             */
            this.deleteSetting = function(name, handlers) {
                REST.deleteURI(BASE_URI + '/' + name, handlers);
            };
        }
        return new SettingsService();
    }());
    return SettingsService;
});
