// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/host/HostPresenter',
    'hp/view/FormStateView',
    'hp/core/Notifications',
    'jquery'],
function(presenter, FormStateView, notifications) { "use strict";

    var HostEditView = (function() {
      
        var TITLE = '#tour-host-edit-title';
        var FORM = '#tour-host-edit-form';
        var OK = '#tour-host-ok';
        var CANCEL = '#tour-host-edit-cancel';
        var NAME = '#tour-host-name';
            
        /**
         * Constructor
         */
        function HostEditView() {
          
            var formStateView = new FormStateView();
            var updateInProgress = false;
          
            function onItemChange(item) {
                if (item) {
                    $(TITLE).text(item.name);
                    $(NAME).val(item.name);
                } else {
                    $(TITLE).text('');
                }
                formStateView.reset();
            }
            
            function onItemError(errorMessage) {
                formStateView.noItem(errorMessage);
            }
            
            function onSelectionChange(selection) {
            }
            
            function onItemUpdateSuccess(item) {
                updateInProgress = false;
                formStateView.reset();
                $(CANCEL).trigger('click');
            }

            /**
             * @private
             */
            function onItemUpdateError(errorMessage) {
                notifications.show(errorMessage);
                updateInProgress = false;
            }
            
            function onUpdateItem() {
                if (! updateInProgress) {
                    updateInProgress = true;
                    presenter.updateSelectedItems({name: $(NAME).val()}, {
                        success : onItemUpdateSuccess,
                        error : onItemUpdateError
                    });
                }
            }
          
            /**
             * @public
             */
            this.resume = function () {
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("itemChange", onItemChange);
                presenter.on("itemError", onItemError);
            };
            
            this.pause = function () {
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
            };
            
            this.init = function() {
              
                formStateView.init({form: FORM, autoTrack: true});
                
                $(OK).on('click', function(ev) {
                    onUpdateItem();
                    ev.preventDefault();
                });
                
                this.resume();
            };
        }

        return new HostEditView();
    }());
    
    return HostEditView;
});
