// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {VmwareShowRoutes}
 * This is used to provide route map for each Vc action.
 * This also provides default redirector and shows default error page if no matching URI identified.
 */

define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { 
	"use strict";
	// Constructor
	var VmwareShowRoutes = ( function() {
		var CONTAINER = '#hpsum-vmware-page .hp-details-show-view';
		var CHANGE_CONTAINER = '#hp-change-page-container';
		function VmwareShowRoutes(){
			
			var registered = false;
			this.register = function() {
				if(registered) return;
				registered =true;
				 
			router.map('vmware show overview', '/vmware/show/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/server/overview.html',
						'hpsum/view/server/ServerShowOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
				

				router.map(' vmware show overview multi',
                   '/vmware/show/(unknown|host|windows|linux|vmware|hpux|ilo|ilo2|ilo3|ilo4| \
                     integrityilo2|integrityilo3|ipdu|switch|fc_switch|sas_switch|oa|sd2|virtual_connect)/overview' +
                    urlFragment.viewMultiPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/overview_multi.html',
                            'hpsum/view/node/NodeShowOverviewMultiView'],
                        function (page, view) {
                            result.load(page, view);
                        });
						}
					});
				
				router.map('vmware vmware overview', '/vmware/show/vmware/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/server/overview.html',
						'hpsum/view/server/ServerShowOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}				
					
				});
				
				router.filter ('vmware show default redirector',
					'/vmware/show' + urlFragment.viewPatternTerminal, {
					 check: function (location, result) {
					 	result.replaceWith(urlFragment.replaceView(location, 'show/overview'));
					 }
				});	

				router.map('vmware show no route', '/vmware/show/.+',
				{
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpPages/core/no_details.html'],
						function (page){
							result.load(page);
						});
					}
					
				});
			}
		}
		
		return new VmwareShowRoutes();
		
	}());
	
	return VmwareShowRoutes;

});