// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {EnclosureShowRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var ipduShowRoutes = ( function() {

        var CONTAINER = '#hpsum-ipdu-page .hp-details-show-view';

        function ipduShowRoutes() {

            var registered = false;
            var activityView = null;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('pdu show overview',
                    '/pdu/show/overview' +
                    urlFragment.viewSinglePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/ipdu/ipduOverview.html',
                            'hpsum/view/ipdu/ipduOverviewView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map(' ipdu show overview multi',
                   '/ipdu/show/(unknown|host|windows|linux|vmware|hpux|ilo|ilo2|ilo3|ilo4| \
                     integrityilo2|integrityilo3|ipdu|switch|fc_switch|sas_switch|oa|sd2|virtual_connect)/overview' +
                    urlFragment.viewMultiPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/overview_multi.html',
                            'hpsum/view/node/NodeShowOverviewMultiView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        }
                    });
                
                
				router.map('pdu ipdu overview', '/pdu/show/ipdu/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/ipdu/ipduOverview.html',
						'hpsum/view/ipdu/ipduOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});

                router.filter('pdu show default redirector',
                    '/pdu/show' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show/overview'));
                    }
                });

                router.map('pdu show no route', '/pdu/show/.*', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new ipduShowRoutes();
    }());

    return ipduShowRoutes;
});
