// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define([ 'hp/presenter/settings/SupportDumpPresenter', 'hp/core/Localizer',
         'hp/core/Notifications', 'hp/core/Router', 'jquery',
         'hp/lib/jquery.hpCollapsible' ],
function(presenter, Localizer, notifications, router) { "use strict";

    var SupportDumpCreateView = (function() {

        // buttons/links in the form
        var CREATE_DUMP_BUTTON_FINAL = '#hp-details-create-dump',
            CANCEL_DUMP = '#hp-details-cancel-dump';

        /**
         * Constructor
         */
        function SupportDumpCreateView() {
            
            var dumpCount = 0;
            var dumpId;
            var eCode = {
                errorCode : 'CI'
            };// This will be added in Dump File Name

            function gotoSettingsPage(){
                router.go("/settings/", 'create support dump finished');
            }

            function onCreateDumpError(errorInfo) {
                var errorCreatingDump = {
                    summary : Localizer.getString('fs.settings.supportdump.error_creating_dump'),
                    status : "error",
                    uri : dumpId,
                    errorMessage: errorInfo,
                    changing: false
                };
                notifications.add(errorCreatingDump, true);
                presenter.clear();
            }

            function getDump(data){
                var link = document.getElementById("hiddenDownloader");
                if (link == null)
                {
                    link = document.createElement('a');
                    link.setAttribute('id', "hiddenDownloader");
                    link.style.display = 'none';
                    link.setAttribute('type', "application/octet-stream");
                    document.getElementsByTagName('body')[0].appendChild(link);
                }
                link.setAttribute('href', data);
                link.click();
            }

            function onCreateDumpSuccess(data) {
                var dumpCreated = {
                    summary : Localizer.getString('fs.settings.supportdump.dump_created'),
                    status : "ok",
                    uri : dumpId,
                    changing : false
                };
                notifications.add(dumpCreated, true);
                getDump(data);
                presenter.clear();
            }

            function createDump() {
                dumpId = "supportDump" + dumpCount++;
                var creatingDump = {
                    summary : Localizer.getString('fs.settings.supportdump.creating_dump'),
                    uri : dumpId,
                    changing : true
                };
                notifications.add(creatingDump, true);
                presenter.createDump(eCode);
            }

            function cancelDump() {
                gotoSettingsPage();
            }
            
            function onCreateDumpRequestSuccess(){
                gotoSettingsPage();
            }

            function registerEvents() {
                presenter.on('createDumpSuccess', onCreateDumpSuccess);
                presenter.on('createDumpError', onCreateDumpError);
                presenter.on('createDumpRequestSuccess', onCreateDumpRequestSuccess);
            }

            this.pause = function() {
            };

            this.resume = function() {
                presenter.resume();
            };

            this.init = function() {
                presenter.init();
                registerEvents();
                $(CREATE_DUMP_BUTTON_FINAL).on('click', createDump);
                $(CANCEL_DUMP).on('click', cancelDump);
            };

        }

        return new SupportDumpCreateView();
    }());

    return SupportDumpCreateView;
});