// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.

define([ 'hp/presenter/settings/FactoryResetPresenter',
         'fs/presenter/status/StatusPresenter',
         'hp/view/FormStateView',
         'hp/core/Localizer',
         'hp/core/Router',
         'jquery',
         'hp/lib/jquery.hpCollapsible' ],
function(presenter, statusPresenter, FormStateView,
         Localizer, router) {"use strict";

         // buttons/links in the form
         var FACTORY_RESET_FORM = '#hp-factory-reset-form',
             FACTORY_RESET_OK = '#hp-start-factory-reset',
             FACTORY_RESET_CANCEL = '#hp-cancel-factory-reset',  
             FACTORY_RESET_OPTIONS = 'factoryResetOptions';

    var FactoryResetView = (function() {

        /**
         * Constructor
         */
        function FactoryResetView() {

            var formStateView = new FormStateView();

            function settingsPage(){
                router.go("/settings", "factory reset confirmation - cancel");
            }

            function onFactoryResetFailure(errorInfo) {
                var factoryResetError = {
                    summary : Localizer.getString('fs.settings.factoryReset.startFailure'),
                    status : "error"
                };
                // Per UX input 3/1/13, error needs to be reported only one way
                // in only one place, so the notifications call is not needed.
                // notifications.add(factoryResetError, true, true, true);
                formStateView.setMessage(factoryResetError);
            }

            function onFactoryResetSuccess(result) {
                formStateView.reset();
                statusPresenter.setFactoryReset(true);
                router.go("/status", "waiting for factory reset to finish"); 
            }

            function startFactoryReset() { 
                var option = $('input:radio[name=' + FACTORY_RESET_OPTIONS + ']:checked').val();                
                presenter.startFactoryReset(option, { 
                    success: function(result) {
                        onFactoryResetSuccess(result);
                    },                
                    error: onFactoryResetFailure
                });                                          
                
                
            }

            this.pause = function() {
            };

            this.resume = function() {
                $('input:radio[name=' + FACTORY_RESET_OPTIONS + ']')[0].checked = true;
                formStateView.reset();
            };

            this.init = function() {
                presenter.init();
                
                formStateView.init({form: FACTORY_RESET_FORM,
                    routePattern : '/settings/reset/factoryReset' + '.*',
                    autoTrack : false}
                );
                
                $('input:radio[name=' + FACTORY_RESET_OPTIONS + ']')[0].checked = true;
                $(FACTORY_RESET_OK).on('click', function() {
                    startFactoryReset();
                });
                $(FACTORY_RESET_CANCEL).on('click', function(){
                    formStateView.reset();
                    settingsPage();
                });
              
            };

        }

        return new FactoryResetView();
    }());

    return FactoryResetView;
});