// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
define([ 'hp/core/EventDispatcher', 'hp/core/Localizer',
        'hp/services/settings/SupportDumpService',
        'hp/model/settings/SupportDumpResource' ],
function(EventDispatcher,
        localizer, service, resource) {
    "use strict";

    var SupportDumpPresenter = (function() {
        function SupportDumpPresenter() {
            var dispatcher = new EventDispatcher();
            
            function onCreateDumpSuccess(value) {
                dispatcher.fire("createDumpSuccess", value);
            }
            
            function onCreateDumpError(value) {
                dispatcher.fire("createDumpError", value);
            }

            this.createDump = function(value) {
                resource.createDump(value);
                dispatcher.fire('createDumpRequestSuccess');
            };

            this.clear = function() {
                resource.off("onCreateDumpSuccess", onCreateDumpSuccess);
                resource.off("onCreateDumpError", onCreateDumpError);
                resource.clear();
            };

            this.resume = function() {
                resource.on("onCreateDumpSuccess", onCreateDumpSuccess);
                resource.on("onCreateDumpError", onCreateDumpError);
            };

            this.init = function() {
                resource.on("onCreateDumpSuccess", onCreateDumpSuccess);
                resource.on("onCreateDumpError", onCreateDumpError);
            };
            
            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };

            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };
        }

        return new SupportDumpPresenter();

    }());

    return SupportDumpPresenter;
});
