// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
define(['jquery'], function() {"use strict";
    (function($) {
        // jQuery plugin definition
        $.fn.hpStatus = function (statusArg, changing) {
          
            var ret;

            this.each(function() {
                var elem = $(this);
                var status = statusArg;
                var statusContent;
                var classAttribute;
                var classes = [];
                var statusClasses = ['hp-status']; // used if not changing
                var containerClasses = ['hp-status']; // used if changing
                var contentClasses = ['hp-status-value']; // used if changing
                var value;
                
                // figure out what status to use, and whether it's changing
                if (! status) {
                    // no status given, use element contents
                    // see if we've already built this before
                    status = $('.hp-value', elem).html();
                    if (status) {
                        changing = ($('.hp-status-changing', elem).length > 0);
                    } else {
                        statusContent = elem.contents().eq(0);
                        if (statusContent) {
                            // e.g. 'warning' or 'warning *'
                            var array = statusContent.text().split(' ');
                            status = array[0];
                            changing = (array[1] ? true : false);
                        }
                    }
                }
                
                value = $('<span class="hp-value">' + status + '</span>');
                
                // preserve non-status classes
                classAttribute = $(elem).attr('class');
                if (classAttribute) {
                    classes = $.grep(classAttribute.split(' '), function (name) {
                        return (! name.match("^hp-status") && ! name.match("^hp-changing"));
                    });
                }
                
                // Determine what the current content is.
                // Avoid modifying in case we aren't changing anything
                if (status) {
                    if (status === 'changing') {
                        elem.append('<div class="hp-status-changing"></div>');
                    } else if (changing) {
                        contentClasses.push('hp-status-' + status);
                        if ($('> .hp-status-value', elem).attr('class') !== contentClasses) {
                            value = value.wrap('<div class="' + contentClasses.join(' ') + '"></div>').parent();
                            elem.empty();
                            containerClasses.push('hp-changing');
                            classAttribute = classes.concat(containerClasses).join(' ');
                            elem.attr('class', classAttribute).append(value).
                                append('<div class="hp-status-changing"></div>');
                        }
                    } else {
                        statusClasses.push('hp-status-' + status);
                        classAttribute = classes.concat(statusClasses).join(' ');
                        if (elem.attr('class') !== classAttribute) {
                            elem.empty();
                            elem.attr('class', classAttribute).append(value);
                        }
                    }
                } else {
                    classAttribute = classes.concat(statusClasses).join(' ');
                    if (elem.attr('class') !== classAttribute) {
                        elem.empty();
                        elem.attr('class', classAttribute);
                    }
                }
                
                ret = ret ? ret.add(elem) : elem;
            });
            return ret;
        };
    }(jQuery));
});
