// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
define(['hp/core/Localizer',
        'hp/core/Router',
        'fs/presenter/settings/BackupStatusPresenter',
        'jquery',
        'lib/jquery.dateFormat',
        'hp/lib/jquery.hpStackedPanels',
        'hp/lib/jquery.hpTimestamp'],
function(localizer, router, backupStatusPresenter) { "use strict";

    var BackupStatusView = (function() {

        var PANELS = '#fs-settings-appliance-panels',
            UNSET = 'hp-unset',
            ADD_NOTIFICATION = 'addNotification';
        
        // variables for backup li list
        var ID_PREFIX = '#fs-settings-appliance-backup',
            BACKUP_LI1 = ID_PREFIX + '-li1',
            BACKUP_LI2 = ID_PREFIX + '-li2',
            BACKUP_LI3 = ID_PREFIX + '-li3',
            BACKUP_LI4 = ID_PREFIX + '-li4',
            BACKUP_LI5 = ID_PREFIX + '-li5';
       
        // variables for backup labels list
        var BACKUP_LABEL1 = ID_PREFIX + '-label1',
            BACKUP_LABEL2 = ID_PREFIX + '-label2',
            BACKUP_LABEL3 = ID_PREFIX + '-label3';
        
        // variables for backup label values list
        var STATUS = ID_PREFIX + '-status',
            START_DOWNLOAD = ID_PREFIX + '-startordownload',
            FILENAME = ID_PREFIX + '-filename',
            ERROR = ID_PREFIX + '-error',
            RESOLUTION = ID_PREFIX + '-resolution';
            
        /**
         * Constructor Service to display the backup status taken last 
         * in Settings general view
         */
        function BackupStatusView() {

            // Displays an error in the Notifications view.  This is done by posting
            // a jQuery event that bubbles up the element stack to the SettingsView,
            // which owns the notifications area.
            function showError(error) {
                $(PANELS).trigger(ADD_NOTIFICATION, {
                    summary: error.errorMessage,
                    details: error.resolution,
                    status: 'error'
                }, true);
            }

            function formatTime(timeToBeFormated) {
                var formatedTime = $.format.date(Date.parseISOString(timeToBeFormated), 'MMM d, yyyy hh:mm a');
                return formatedTime;
            }
            
            function showBackupSucceeded(resource) {
                var createdLabel = localizer.getString('fs.settings.appliance.backup.created'),
                    downloadedLabel = localizer.getString('fs.settings.appliance.backup.downloaded'),
                    filenameLabel = localizer.getString('fs.settings.appliance.backup.filename');
                    
                var createTime = formatTime(resource.created),
                    createStr = localizer.getString('fs.settings.appliance.backup.by', [ createTime, resource.userName ]),
                    filename = resource.id + '.bkp',
                    downloadTime,
                    downloadStr;
                               
               if (resource.downloadStatus === 'NOT_DOWNLOADED') {
                    downloadStr = localizer.getString('fs.settings.appliance.backup.never');
                } else {
                    downloadTime = formatTime(resource.downloadTime);
                    downloadStr = localizer.getString('fs.settings.appliance.backup.by', 
                        [ downloadTime, resource.downloadUserName ]);
                } 
                                   
                $(BACKUP_LABEL1).html(createdLabel);
                $(BACKUP_LABEL2).html(downloadedLabel);
                $(BACKUP_LABEL3).html(filenameLabel);
                $(STATUS).text(createStr).removeClass(UNSET);
                $(START_DOWNLOAD).text(downloadStr).removeClass(UNSET); 
                $(FILENAME).text(filename).removeClass(UNSET); 
            }
         
            function showBackupFailed(resource) {
                var failedStr = localizer.getString('fs.settings.appliance.backup.failed'),
                    startedLabel = localizer.getString('fs.settings.appliance.backup.started'),
                    startTime = formatTime(resource.backupStartTime),
                    startStr = localizer.getString('fs.settings.appliance.backup.by', [ startTime, resource.userName ]);
                
                $(BACKUP_LI3).hide(); 
                $(BACKUP_LI4).show(); 
                $(BACKUP_LI5).show(); 
                
                $(BACKUP_LABEL1).html(failedStr);
                $(BACKUP_LABEL2).html(startedLabel);
                
                $(STATUS).text('').removeClass(UNSET);
                $(START_DOWNLOAD).text(startStr).removeClass(UNSET); 
                $(ERROR).text(resource.errorMessage).removeClass(UNSET);  
                $(RESOLUTION).text(resource.resolutionMessage).removeClass(UNSET);
            }
            
            function showBackupProgress(resource) {
                var startedLabel = localizer.getString('fs.settings.appliance.backup.started'),
                    filenameLabel = localizer.getString('fs.settings.appliance.backup.filename');
                    
                var startTime = formatTime(resource.backupStartTime),
                    filename = resource.id + '.bkp',
                    startStr = localizer.getString('fs.settings.appliance.backup.by', [ startTime, resource.userName ]),
                    progressStr;
                
                if (resource.status === 'IN_PROGRESS') {
                    progressStr = localizer.getString('fs.settings.appliance.backup.progress');
                } else {
                    progressStr = localizer.getString('fs.settings.appliance.backup.cancelprogress');
                }
                
                $(BACKUP_LABEL1).html(progressStr);
                $(BACKUP_LABEL2).html(startedLabel);
                $(BACKUP_LABEL3).html(filenameLabel);
                $(STATUS).text('').removeClass(UNSET);
                $(START_DOWNLOAD).text(startStr).removeClass(UNSET); 
                $(FILENAME).text(filename).removeClass(UNSET);    
            }
            
            function showBackupNone(resource) {
                var noneStr = localizer.getString('fs.settings.appliance.backup.none');
                $(BACKUP_LI1).html(noneStr);
                $(STATUS).text('').removeClass(UNSET);
                $(BACKUP_LI2).hide();
                $(BACKUP_LI3).hide();
            }
            
            function showBackupStatus(resource) {
                var status;
                
                if (!resource) {
                    status = 'NONE';
                } else {
                    status = resource.status;
                }
                
                var actions = {
                    'SUCCEEDED': showBackupSucceeded,
                    'FAILED' : showBackupFailed,
                    'IN_PROGRESS': showBackupProgress,
                    'CANCEL_IN_PROGRESS': showBackupProgress,
                    'CANCELED': showBackupNone,
                    'NONE':  showBackupNone
                };
                    
                if (actions[status])  {
                    actions[status](resource);
                } 
            }
            
            function getBackupStatusFromPresenter() {
                backupStatusPresenter.getLastBackupStatus({
                    success: showBackupStatus,
                    error: showError
                }); 
            }
            
            this.init = function() {
                getBackupStatusFromPresenter();
            };
            
            this.resume = function() {
                getBackupStatusFromPresenter();
            };
              
        }
        
        return new BackupStatusView();
    }());

    return BackupStatusView;
});
