// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.

define(['fs/presenter/settings/ApplianceUpdatePresenter',
        'hp/core/Localizer',
        'hp/core/Notifications',
        'hp/view/DialogView',
        'hp/services/Log',
        'hp/model/Session',
        'hp/view/UploaderView',
        'hp/view/FormStateView',
        'hp/core/Router',
        'jquery',
        'hp/lib/jquery.hpCollapsible', 'hp/lib/jquery.hpProgressBar'],
function(presenter, localizer, notifications, DialogView, log, session, UploaderView, FormStateView, router ) {"use strict";


    var ApplianceUpdateView = ( function() {

        var uploader = null;
        var updateDialogContents = null;
        var updateDialog = null;
        var formStateView = null;
        var checkForUpdateFlag = true;
        var docType = "release";

        // buttons/links in the form
        var APPLY_WARNING = '#cic-settings-update-warning',
            INSTALL_BOX_VERSION = '#cic-settings-update-install-box-version',
            INSTALL_BOX_FILENAME = '#cic-settings-update-install-box-filename',
            REMOVE_FILE_LINK = '#cic-settings-update-install-box-remove',
            APPLY_USERS_LOGGED_IN_COLLAPSE = '#cic-settings-update-apply-loggedInUsers-collapse',
            APPLY_USERS_LOGGED_IN_COUNT = '#cic-settings-update-apply-warning-usersCount',
            APPLY_USERS_LOGGED_IN = '#cic-settings-update-apply-warning-usersLoggedIn',
            UPGRADE_ESTIMATE = '#cic-settings-update-timeEstimate',
            UPDATE_INSTALL_BOX = '#cic-settings-update-install-box',
            REBOOT_REQUIRED = '#cic-settings-update-rebootRequired',
            DISMISS = "#cic-settings-update-notify-dismiss_link",
            RELEASE_NOTES_LINK = '#cic-settings-update-release-notes',
            RELEASE_NOTES_OVERLAY = '#cic-settings-update-releaseNotes-overlay',
            ERROR_MSG='#cic-settings-update-appliance-error',
            UPLOADER = '#cic-update-fileupload',
            INSTALL_UPDATE_BUTTON = '#cic-settings-update-installUpdate',
            NEW_PROGRESS_BAR = '#cic-settings-update-progress-bar',
            UPDATE_DIALOG = '#cic-settings-update-dialog',
            UPDATE_FORM = "#cic-settings-update-form",
            APPLY_USERS = "#cic-settings-update-apply-users-list",
            CANCEL = "#cic-settings-update-cancel",
            CHECK_UPDATE = "#cic-settings-update-check-box";

        /**
         * Constructor
         */
        function ApplianceUpdateView() {



            function resetProgress() {
                $(NEW_PROGRESS_BAR).hpProgressBar(0);
            }

            function formatError(errorInfo) {
                var failureNotificationDetails = errorInfo.message + "  " +
                    (errorInfo.recommendedActions ? errorInfo.recommendedActions.join(' ') : "");
                return failureNotificationDetails;
            }

            function displayError(message) {
                formStateView.setMessage({
                    summary : message,
                    status : "error"
                });
            }

            function error(errorInfo){
                var failureNotificationDetails = formatError(errorInfo);
                displayError(failureNotificationDetails);
            }

            function clearError() {
                formStateView.reset();
            }

            function reset() {

                $(REBOOT_REQUIRED).hide();
                updateDialog.clearMessage();
                resetProgress();
                clearError();
                presenter.clear();
                uploader.reset();
                $(UPGRADE_ESTIMATE).html('');
                $(UPDATE_INSTALL_BOX).hide();
                $(RELEASE_NOTES_OVERLAY).html('');

                $(APPLY_USERS_LOGGED_IN_COUNT).html('');
                $(APPLY_USERS_LOGGED_IN).html('');
                $(ERROR_MSG).html('');
                $(ERROR_MSG).hide();
            }

            function getOtherUsersLoggedIn() {
                $(APPLY_USERS_LOGGED_IN_COUNT).html('');
                $(APPLY_USERS_LOGGED_IN).html('');

                var list = presenter.getOtherUsersLoggedInList();

                var count = list.length;
                if(count > 1){
                    for ( var i = 0; i < count; i++) {
                        var node = $('<div/>');
                        node.html(list[i]);
                        $(APPLY_USERS_LOGGED_IN).append(node);
                    }
                    $(APPLY_USERS_LOGGED_IN_COUNT)
                    .html(localizer.getString('fs.settings.appliance.update.applyBoxUsersLoggedIn', [ count ]));
                }
                else if (count == 1) {
                    $(APPLY_USERS_LOGGED_IN_COUNT)
                    .html(localizer.getString('fs.settings.appliance.update.applyBoxOneUserLoggedIn', [ list[0] ]));
                }
            }

            function createSuccessContent() {
                $(UPDATE_INSTALL_BOX).show();
                return [$(UPDATE_INSTALL_BOX)];
            }

            function onUploadSuccess(data) {
                resetProgress();
                presenter.usersLoggedIn();
                clearError();
                updateDialog.clearMessage();
                $(UPGRADE_ESTIMATE).html(localizer.getString('fs.settings.appliance.update.timeEstimate',
                    [data.estimatedUpgradeTime]));
                $(INSTALL_BOX_VERSION).html(localizer.getString('fs.settings.appliance.versionReady',
                    [data.version]));
                $(INSTALL_BOX_FILENAME).html(localizer.getString('fs.settings.appliance.fileName', [data.fileName]));
                $(REMOVE_FILE_LINK).off('click');
                $(REMOVE_FILE_LINK).on('click', function(){
                    presenter.removeFile();
                    $(INSTALL_UPDATE_BUTTON).attr('disabled','true');
                });

                presenter.setFileName(data.fileName);
                presenter.setEstimatedUpgradeTime(data.estimatedUpgradeTime);

                $(RELEASE_NOTES_LINK).off('click');
                $(RELEASE_NOTES_LINK).on('click', function(){
                    presenter.releaseNotes(data.fileName, docType, {
                        success : function(releaseNotesData){
                            var my_window = window.open("","_blank","scrollbars=1");//"", "mywindow1", "scrollbars=1"
                            my_window.document.write(releaseNotesData);
                        },
                        error : function(releaseNotesErrorInfo){
                            error(releaseNotesErrorInfo);
                        }
                    });
                });

                presenter.setRebootRequired(data.rebootRequired);

                if(data.rebootRequired) {
                    $(REBOOT_REQUIRED).show();
                }
                $(UPDATE_INSTALL_BOX).show();
                createSuccessContent();
                $(APPLY_WARNING).text(localizer.getString('fs.settings.appliance.update.applyWarning',
                        [data.estimatedUpgradeTime]));
                $(INSTALL_UPDATE_BUTTON).removeAttr('disabled');

            }

            function onUploadError(errorInfo) {
                error(errorInfo);
                uploader.reset();
                presenter.clear();
            }

            function onApplySuccess(){
                router.go('/settings/update/progress');
            }

            function onApplyError(errorInfo){
                error(errorInfo);
            }

            function onPendingSuccess(data){
                onUploadSuccess(data);
            }

            function onPendingError(errorInfo) {
                onUploadError(errorInfo);
            }

            function onDeleteSuccess(){
                reset();
            }

            function onDeleteError(errorInfo){
                error(errorInfo);
            }

            function onUpgradePendingError(errorInfo){
                if(errorInfo.errorCode != 'RESOURCE_NOT_FOUND'){
                    error(errorInfo);
                }
            }

            function onUsersLoggedInSuccess() {
                //getOtherUsersLoggedIn(); Calling this at the time of Dialog creation
            }

            function onUsersLoggedInError(errorInfo){
                error(errorInfo);
            }

            function checkPending(){
                var uploading = uploader.isUploading();
                if(!uploading) {
                    uploader.isFilePending();
                }
            }

           function onCancel(errorInfo)
            {
                onUploadError(errorInfo);
                uploader.reset();
            }

            function onBeforeSend(){
                clearError();
                presenter.clear();
            }

            function registerEvents() {
                presenter.on("uploadSuccess", onUploadSuccess);
                presenter.on("uploadError", onUploadError);
                presenter.on("deleteSuccess", onDeleteSuccess);
                presenter.on("deleteError", onDeleteError);
                presenter.on("upgradePendingError", onUpgradePendingError);
                presenter.on("pendingSuccess", onPendingSuccess);
                presenter.on("usersLoggedInSuccess", onUsersLoggedInSuccess);
                presenter.on("usersLoggedInError", onUsersLoggedInError);
                presenter.on("applySuccess", onApplySuccess);
                presenter.on("applyError", onApplyError);
            }

            function removeEvents() {
                presenter.off("uploadSuccess", onUploadSuccess);
                presenter.off("uploadError", onUploadError);
                presenter.off("deleteSuccess", onDeleteSuccess);
                presenter.off("deleteError", onDeleteError);
                presenter.off("upgradePendingError", onUpgradePendingError);
                presenter.off("pendingSuccess", onPendingSuccess);
                presenter.off("usersLoggedInSuccess", onUsersLoggedInSuccess);
                presenter.off("usersLoggedInError", onUsersLoggedInError);
                presenter.off("applySuccess", onApplySuccess);
                presenter.off("applyError", onApplyError);
            }

            this.pause = function() {
                removeEvents();
                if(uploader.isCanceled() || uploader.getError().errorMessage) {
                    reset();
                }
                uploader.pause();
            };

            this.resume = function() {
                registerEvents();
                checkPending();
                uploader.resume();
            };


            /**
             * Initialization.
             */
            this.init = function() {

                presenter.init();
                uploader=new UploaderView();

                formStateView = new FormStateView();
                formStateView.init({form: UPDATE_FORM});

                registerEvents();

                updateDialogContents = $(UPDATE_DIALOG).detach().show();
                updateDialog = new DialogView({contents: updateDialogContents});

                reset();

                uploader.uploadInit({
                    uploadBaseId: UPLOADER ,
                    uploadUri: '/rest/appliance/firmware/image',
                    pendingUri: '/rest/appliance/firmware/pending',
                    beforeSend : onBeforeSend ,
                    onCancel : onCancel,
                    uploadSuccess : onUploadSuccess ,
                    uploadError :  onUploadError,
                    pendingSuccess: onPendingSuccess,
                    pendingError: onPendingError,
                    successContent: createSuccessContent

                });
                if(!checkForUpdateFlag){
                    $(CHECK_UPDATE).hide();
                }

                $(DISMISS).on('click', function(ev){
                    clearError();
                    ev.preventDefault();
                });

                $(CANCEL).on('click', function(){
                   updateDialog.cancel();
                });

                $(INSTALL_UPDATE_BUTTON).off('click');
                $(INSTALL_UPDATE_BUTTON).on('click', function(){
                    if(presenter.getUpdateState() == 0){
                        updateDialog.cancel();
                        router.go('/settings/update/eula');
                    }
                    else if(presenter.getUpdateState() == 1){
                        getOtherUsersLoggedIn();
                        if(presenter.getOtherUsersLoggedInList().length > 0){
                            $(APPLY_USERS_LOGGED_IN_COLLAPSE).show();
                        }
                        updateDialog.setMessage({summary: $(APPLY_WARNING).html(),
                            status: "warning",
                            details: $(APPLY_USERS).html()
                            }, true);
                        presenter.setUpdateState(2);
                    } else if(presenter.getUpdateState() == 2){
                        updateDialog.cancel();
                        presenter.apply(presenter.getFileName());
                    }
                 });

                checkPending();
            };
        }

        return new ApplianceUpdateView();
    }());

    return ApplianceUpdateView;
});
