// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.

define(['fs/presenter/settings/ApplianceUpdatePresenter',
        'hp/core/Localizer',
        'jquery',
        'hp/lib/jquery.hpProgressBar'],
function(presenter, localizer) { "use strict";

var ApplianceUpdateProgressView = ( function() {

    var UPGRADE_STATUS_INTERVAL = 5000;
    //Time interval to refresh the upgrade estimated time
    var ESTIMATED_TIME_INTERVAL = 60000;
    var ONE_MINUTE = 1;
    var STATUS_COMPLETE = 100;
    var STATUS_INTERVAL_ID;
    var EST_TIME_INTERVAL_ID;
    var MAX_STATUS_RETRIES =60;

    //buttons Links in the form
    var INSTALL_BOX_FILENAME = '#cic-settings-update-filename',
        UPDATE_ESTIMATED_TIME = '#cic-settings-appliance-update-estimatedTime',
        ERROR_MSG='#cic-settings-update-appliance-error',
        NEW_PROGRESS_BAR = '#cic-settings-update-progress-bar';

    /**
    * Constructor
    */
    function ApplianceUpdateProgressView() {

        var statusRetryCount = 0;

        function resetProgress() {
            $(NEW_PROGRESS_BAR).hpProgressBar(0);
        }

        function onEstimatedTimeHandler(data) {
            if(data == ONE_MINUTE) {
                $(UPDATE_ESTIMATED_TIME).html(localizer.getString('fs.settings.appliance.update.progressTimeOneMinute',
                        [data]));
                clearInterval(EST_TIME_INTERVAL_ID);
            }
            else {
                $(UPDATE_ESTIMATED_TIME).html(localizer.getString('fs.settings.appliance.update.progressTime', [data]));
            }

        }

        function showError()
        {
            $(ERROR_MSG).html(localizer.getString('fs.settings.appliance.update.failureMessage'));
            $(ERROR_MSG).show();
        }

        function onUpgradeStatusError(errorInfo) {
            //Removing the error as the upgrade process is still running and getting the status only failed
            statusRetryCount++;
            if(statusRetryCount == MAX_STATUS_RETRIES)
            {
                clearInterval(STATUS_INTERVAL_ID);
                window.location.replace('#/settings');
                window.location.reload(true);
            }
        }

        function onGetStatus(data) {

            statusRetryCount = 0;

            var value;
            var percentageData = data.percentageCompletion;
            var error = data.errorMsg;

            if(percentageData)
            {
                if (percentageData.indexOf("%") > 0) {
                    value = $.trim(percentageData.substring(0, percentageData.indexOf("%")));
                    $(NEW_PROGRESS_BAR).hpProgressBar(parseInt(value, 10));
                    if (value == STATUS_COMPLETE) {
                        clearInterval(STATUS_INTERVAL_ID);
                        //TODO : If UI is not loading with new content we have to identify other than
                        // the polling approach since polling will give undefined for aysnc calls .
                        //window.location.replace(window.location.pathname);
                        window.location.replace('#/settings');
                        window.location.reload(true);
                    }
                }
            }
            if(error) {
                showError();
            }

        }

        function registerEvents() {
            presenter.on("estimatedTime", onEstimatedTimeHandler);
            presenter.on("upgradeStatusSuccess", onGetStatus);
            presenter.on("upgradeStatusError", onUpgradeStatusError);
        }

        function removeEvents() {
            presenter.off("estimatedTime", onEstimatedTimeHandler);
            presenter.off("upgradeStatusSuccess", onGetStatus);
            presenter.off("upgradeStatusError", onUpgradeStatusError);
        }

        this.pause = function() {
            removeEvents();
         };

        this.resume = function() {
            registerEvents();
            resetProgress();
            $(INSTALL_BOX_FILENAME).html(presenter.getFileName());
            presenter.estTimeFlag();
            presenter.estimatedTime();
            STATUS_INTERVAL_ID = setInterval(function(){presenter.currentStatus();}, UPGRADE_STATUS_INTERVAL);
            EST_TIME_INTERVAL_ID = setInterval(function(){presenter.estimatedTime();}, ESTIMATED_TIME_INTERVAL);
        };
        /**
         *  Initialization function

        */
        this.init = function() {
            this.resume();
        };
    }

    return new ApplianceUpdateProgressView();

}());

return ApplianceUpdateProgressView;

});
