# Copyright 2022-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.6.2

EAPI=8

CRATES="
"

RUST_MIN_VER="1.85.0"
LLVM_COMPAT=( {17..20} )
inherit cargo flag-o-matic llvm-r1 multiprocessing

DESCRIPTION="GNU coreutils rewritten in Rust"
HOMEPAGE="https://uutils.github.io/coreutils/ https://github.com/uutils/coreutils"

if [[ ${PV} == 9999 ]] ; then
	EGIT_REPO_URI="https://github.com/uutils/coreutils"
	inherit git-r3
elif [[ ${PV} == *_p* ]] ; then
	COREUTILS_COMMIT=""
	SRC_URI="https://github.com/uutils/coreutils/archive/${COREUTILS_COMMIT}.tar.gz -> ${P}.tar.gz"
	S="${WORKDIR}"/coreutils-${COREUTILS_COMMIT}
else
	SRC_URI="https://github.com/uutils/coreutils/archive/refs/tags/${PV}.tar.gz -> ${P}.tar.gz"
	S="${WORKDIR}"/coreutils-${PV}

	KEYWORDS="~amd64 ~arm64 ~ppc64"
fi

SRC_URI+="
	https://github.com/gentoo-crate-dist/coreutils/releases/download/${PV}/coreutils-${PV}-crates.tar.xz
"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 BSD-2 BSD Boost-1.0 CC0-1.0 ISC MIT Unicode-3.0 ZLIB
"
SLOT="0"
IUSE="debug selinux test"
RESTRICT="!test? ( test )"

DEPEND="
	dev-libs/oniguruma:=
	selinux? ( sys-libs/libselinux )
"
RDEPEND="${DEPEND}"
BDEPEND="
	test? ( dev-util/cargo-nextest )
	selinux? (
		$(llvm_gen_dep '
			llvm-core/clang:${LLVM_SLOT}
		')
	)
"
QA_FLAGS_IGNORED=".*"

src_unpack() {
	if [[ ${PV} == 9999 ]] ; then
		git-r3_src_unpack
		cargo_live_src_unpack
	else
		cargo_src_unpack
	fi
}

src_compile() {
	# normally cargo_src_compile sets this for us, but we don't use it
	filter-lto

	# By default, the crate uses a system version if it can. This just guarantees
	# that it will error out instead of building a vendored copy.
	export RUSTONIG_SYSTEM_LIBONIG=1

	makeargs=(
		# Disable output synchronisation as make calls cargo
		-Onone

		V=1

		PROFILE=$(usex debug debug release)

		PREFIX="${EPREFIX}/usr"
		PROG_PREFIX="uu-"
		MULTICALL=y
		MANDIR="/share/man/man1"

		SELINUX_ENABLED=$(usex selinux 1 0)

		# pinky, uptime, users, and who require utmpx (not available on musl)
		# bug #832868
		# runcon chcon require selinux, but upstream broke the SELINUX_ENABLED logic
		SKIP_UTILS="$(usev elibc_musl "pinky uptime users who") $(usev !selinux "runcon chcon")"
	)

	emake "${makeargs[@]}"
}

src_test() {
	local -x RUST_BACKTRACE=full
	local -x NEXTEST_TEST_THREADS="$(makeopts_jobs)"

	# Nicer output for nextest vs test
	emake "${makeargs[@]}" \
		CARGOFLAGS="${CARGOFLAGS} $(usev !debug --release)" \
		TEST_NO_FAIL_FAST="--no-fail-fast" \
		nextest
}

src_install() {
	emake "${makeargs[@]}" DESTDIR="${D}" install
}
