# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.2

EAPI=8

CRATES=""
inherit eapi9-ver cargo systemd

DESCRIPTION="Push daemon for Nextcloud clients"
HOMEPAGE="https://github.com/nextcloud/notify_push"
SRC_URI="https://github.com/nextcloud/notify_push/archive/refs/tags/v${PV}.tar.gz -> ${P}.tar.gz"
SRC_URI+=" https://github.com/antonfischl1980/nextcloud-notify_push/releases/download/v${PV}/nextcloud-notify_push-${PV}-crates.tar.xz"
S=${WORKDIR}/notify_push-${PV}

LICENSE="AGPL-3"
# Dependent crate licenses
LICENSE+=" Apache-2.0 BSD CDLA-Permissive-2.0 GPL-3 ISC MIT Unicode-3.0 ZLIB"
# ring crate
LICENSE+=" openssl"
SLOT="0"
KEYWORDS="~amd64 ~x86"

DEPEND="dev-db/sqlite:3"
RDEPEND="${DEPEND}"

QA_FLAGS_IGNORED="usr/bin/${PN}"

src_prepare() {
	export LIBSQLITE3_SYS_USE_PKG_CONFIG=1
	default
}

src_install() {
	cargo_src_install
	einstalldocs

	# default name is too generic
	mv "${ED}/usr/bin/notify_push" "${ED}/usr/bin/${PN}" || die

	newconfd "${FILESDIR}/${PN}-r1.confd" "${PN}"
	newinitd "${FILESDIR}/${PN}-r2.init" "${PN}"
	systemd_newunit "${FILESDIR}/${PN}.service-r1" "${PN}.service"
	systemd_install_serviced "${FILESDIR}/${PN}.service.conf" "${PN}"

	# restrict access because conf.d entry could contain
	# database credentials
	fperms 0640 "/etc/conf.d/${PN}"
}

pkg_postinst() {
	if ver_replacing -lt "0.6.6"; then
		ewarn "You are upgrading to ${PVR}"
		ewarn "The systemd unit file for nextcloud-notify_push no longer sources ${EPREFIX}/etc/conf.d/nextcloud-notify_push ."
		ewarn "Configuration is still done via ${EPREFIX}/etc/conf.d/nextcloud-notify_push for OpenRC systems"
		ewarn "while for systemd systems, a systemd drop-in file located at"
		ewarn "${EPREFIX}/etc/systemd/system/nextcloud-notify_push.d/00gentoo.conf"
		ewarn "is used for configuration."
	fi
}
