# Copyright 2023-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.10

EAPI=8

CRATES="
	adler32@1.2.0
	ahash@0.8.11
	aho-corasick@1.1.3
	alloc-no-stdlib@2.0.4
	alloc-stdlib@0.2.2
	allocator-api2@0.2.18
	android-tzdata@0.1.1
	android_system_properties@0.1.5
	anstream@0.6.15
	anstyle-parse@0.2.5
	anstyle-query@1.1.1
	anstyle-wincon@3.0.4
	anstyle@1.0.8
	autocfg@1.3.0
	base64@0.22.1
	bit-set@0.5.3
	bit-vec@0.6.3
	bitflags@1.3.2
	bitflags@2.6.0
	block-buffer@0.10.4
	brotli-decompressor@4.0.1
	brotli@6.0.0
	bumpalo@3.16.0
	byteorder@1.5.0
	cc@1.1.15
	cfg-if@1.0.0
	chrono@0.4.38
	clap@4.5.16
	clap_builder@4.5.15
	clap_lex@0.7.2
	colorchoice@1.0.2
	colored@2.1.0
	core-foundation-sys@0.8.7
	core2@0.4.0
	cpufeatures@0.2.13
	crc32fast@1.4.2
	crypto-common@0.1.6
	curl-sys@0.4.74+curl-8.9.0
	curl@0.4.46
	dary_heap@0.3.6
	digest@0.10.7
	encoding-index-japanese@1.20141219.5
	encoding-index-korean@1.20141219.5
	encoding-index-simpchinese@1.20141219.5
	encoding-index-singlebyte@1.20141219.5
	encoding-index-tradchinese@1.20141219.5
	encoding@0.2.33
	encoding_index_tests@0.1.4
	errno@0.3.9
	fastrand@2.1.1
	float-cmp@0.9.0
	fnv@1.0.7
	form_urlencoded@1.2.1
	generic-array@0.14.7
	getrandom@0.2.15
	glob@0.3.1
	hashbrown@0.14.5
	hex-literal@0.4.1
	hex@0.4.3
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.60
	idna@0.5.0
	is_terminal_polyfill@1.70.1
	itoa@1.0.11
	js-sys@0.3.70
	lazy_static@1.5.0
	libc@0.2.158
	libflate@2.1.0
	libflate_lz77@2.1.0
	libm@0.2.8
	libredox@0.0.2
	libxml@0.3.3
	libz-sys@1.1.20
	linux-raw-sys@0.4.14
	log@0.4.22
	md5@0.7.0
	memchr@2.7.4
	num-traits@0.2.19
	numtoa@0.1.0
	once_cell@1.19.0
	openssl-probe@0.1.5
	openssl-src@300.3.1+3.3.1
	openssl-sys@0.9.103
	percent-encoding@2.3.1
	pkg-config@0.3.30
	ppv-lite86@0.2.20
	proc-macro2@1.0.86
	proptest@1.5.0
	quick-error@1.2.3
	quote@1.0.37
	rand@0.8.5
	rand_chacha@0.3.1
	rand_core@0.6.4
	rand_xorshift@0.3.0
	redox_syscall@0.4.1
	redox_termios@0.1.3
	regex-automata@0.4.7
	regex-syntax@0.8.4
	regex@1.10.6
	rle-decode-fast@1.0.3
	rustix@0.38.35
	rusty-fork@0.3.0
	ryu@1.0.18
	schannel@0.1.23
	serde@1.0.209
	serde_derive@1.0.209
	serde_json@1.0.127
	sha2@0.10.8
	shlex@1.3.0
	similar@2.6.0
	socket2@0.5.7
	strsim@0.11.1
	syn@2.0.76
	tempfile@3.12.0
	terminal_size@0.3.0
	termion@4.0.2
	tinyvec@1.8.0
	tinyvec_macros@0.1.1
	toml@0.5.11
	typenum@1.17.0
	unarray@0.1.4
	unicode-bidi@0.3.15
	unicode-ident@1.0.12
	unicode-normalization@0.1.23
	url@2.5.2
	utf8parse@0.2.2
	uuid@1.10.0
	vcpkg@0.2.15
	version_check@0.9.5
	wait-timeout@0.2.0
	wasi@0.11.0+wasi-snapshot-preview1
	wasm-bindgen-backend@0.2.93
	wasm-bindgen-macro-support@0.2.93
	wasm-bindgen-macro@0.2.93
	wasm-bindgen-shared@0.2.93
	wasm-bindgen@0.2.93
	windows-core@0.52.0
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-targets@0.48.5
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.6
	winres@0.1.12
	xml-rs@0.8.21
	zerocopy-derive@0.7.35
	zerocopy@0.7.35
"

inherit cargo

DESCRIPTION="Hurl, run and test HTTP requests"
HOMEPAGE="https://hurl.dev"
SRC_URI="
	https://github.com/Orange-OpenSource/${PN}/archive/refs/tags/${PV}.tar.gz -> ${PN}-${PV}.tar.gz
	${CARGO_CRATE_URIS}
"

LICENSE="Apache-2.0"
# Dependent crate licenses
LICENSE+=" Apache-2.0 BSD CC0-1.0 MIT MPL-2.0 Unicode-DFS-2016 ZLIB"
SLOT="0"
KEYWORDS="~amd64"

RDEPEND="
	net-misc/curl
	dev-libs/libxml2:=
"
DEPEND="${RDEPEND}"

# Rust.
QA_FLAGS_IGNORED=(
	/usr/bin/hurl
	/usr/bin/hurlfmt
)

QA_PRESTRIPPED="${QA_FLAGS_IGNORED[*]}"

src_install() {
	dobin "$(cargo_target_dir)"/hurl{,fmt}
	doman docs/manual/hurl{,fmt}.1

	dodoc CHANGELOG.md README.md LICENSE
}

src_test() {
	# These need a local HTTP server.. and don't bother setting one up..
	cargo_src_test -- \
				   --skip simple_sample \
				   --skip runner::hurl_file::run
}
