# Copyright 2024-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

CRATES="
	RustyXML@0.3.0
	addr2line@0.24.2
	adler2@2.0.0
	adler32@1.2.0
	aead@0.5.2
	aes-gcm-siv@0.11.1
	aes-gcm@0.10.3
	aes@0.8.4
	ahash@0.8.12
	aho-corasick@1.1.3
	allocator-api2@0.2.21
	android-tzdata@0.1.1
	android_system_properties@0.1.5
	anstream@0.6.18
	anstyle-parse@0.2.6
	anstyle-query@1.1.2
	anstyle-wincon@3.0.7
	anstyle@1.0.10
	anyhow@1.0.98
	arbitrary@1.4.1
	arc-swap@1.7.1
	argon2@0.5.3
	array-init@2.1.0
	arrayref@0.3.9
	arrayvec@0.7.6
	ascii-canvas@3.0.0
	asn1-rs-derive@0.4.0
	asn1-rs-derive@0.5.1
	asn1-rs-derive@0.6.0
	asn1-rs-impl@0.1.0
	asn1-rs-impl@0.2.0
	asn1-rs@0.5.2
	asn1-rs@0.6.2
	asn1-rs@0.7.1
	async-channel@1.9.0
	async-compression@0.4.23
	async-lock@3.4.0
	async-nats@0.40.0
	async-recursion@1.1.1
	async-stream-impl@0.3.6
	async-stream@0.3.6
	async-trait@0.1.88
	atomic-waker@1.1.2
	attohttpc@0.28.5
	autocfg@1.4.0
	aws-creds@0.37.0
	aws-region@0.25.5
	azure_core@0.21.0
	azure_storage@0.21.0
	azure_storage_blobs@0.21.0
	azure_svc_blobstorage@0.21.0
	backtrace@0.3.75
	base16ct@0.2.0
	base32@0.5.1
	base64@0.11.0
	base64@0.13.1
	base64@0.21.7
	base64@0.22.1
	base64ct@1.7.3
	bincode@1.3.3
	bincode@2.0.1
	bincode_derive@2.0.1
	bindgen@0.69.5
	bindgen@0.70.1
	bindgen@0.71.1
	biscuit@0.7.0
	bit-set@0.5.3
	bit-set@0.8.0
	bit-vec@0.6.3
	bit-vec@0.8.0
	bitflags@1.3.2
	bitflags@2.9.1
	bitpacking@0.9.2
	bitvec-nom2@0.2.1
	bitvec@1.0.1
	blake2@0.10.6
	blake3@1.8.2
	block-buffer@0.10.4
	block-buffer@0.9.0
	block-padding@0.3.3
	blowfish@0.7.0
	blowfish@0.9.1
	btoi@0.4.3
	buffered-reader@1.4.0
	bumpalo@3.17.0
	bytecheck@0.8.1
	bytecheck_derive@0.8.1
	bytemuck@1.23.0
	byteorder@1.5.0
	bytes@1.10.1
	bzip2-sys@0.1.13+1.0.8
	bzip2@0.5.2
	calcard@0.1.3
	camellia@0.1.0
	cast5@0.11.1
	castaway@0.2.3
	cbc@0.1.2
	cc@1.2.23
	cedarwood@0.4.6
	cesu8@1.1.0
	cexpr@0.6.0
	cfb-mode@0.8.2
	cfb@0.7.3
	cfg-if@1.0.0
	cfg_aliases@0.1.1
	cfg_aliases@0.2.1
	chrono-tz-build@0.4.1
	chrono-tz@0.10.3
	chrono@0.4.41
	cipher@0.2.5
	cipher@0.4.4
	clang-sys@1.8.1
	clap@4.5.38
	clap_builder@4.5.38
	clap_derive@4.5.32
	clap_lex@0.7.4
	cmac@0.7.2
	cmake@0.1.54
	colorchoice@1.0.3
	combine@4.6.7
	compact_str@0.9.0
	concurrent-queue@2.5.0
	console@0.15.11
	const-oid@0.9.6
	const-random-macro@0.1.16
	const-random@0.1.18
	const_format@0.2.34
	const_format_proc_macros@0.2.34
	const_panic@0.2.12
	constant_time_eq@0.3.1
	core-foundation-sys@0.8.7
	core-foundation@0.10.0
	core-foundation@0.9.4
	core2@0.4.0
	cpufeatures@0.2.17
	crc16@0.4.0
	crc32fast@1.4.2
	critical-section@1.2.0
	crossbeam-channel@0.5.15
	crossbeam-deque@0.8.6
	crossbeam-epoch@0.9.18
	crossbeam-queue@0.3.12
	crossbeam-utils@0.8.21
	crossbeam@0.8.4
	crunchy@0.2.3
	crypto-bigint@0.5.5
	crypto-common@0.1.6
	crypto-mac@0.10.0
	csv-core@0.1.12
	csv@1.3.1
	ctr@0.9.2
	curve25519-dalek-derive@0.1.1
	curve25519-dalek@4.1.3
	darling@0.13.4
	darling@0.20.11
	darling_core@0.13.4
	darling_core@0.20.11
	darling_macro@0.13.4
	darling_macro@0.20.11
	dary_heap@0.3.7
	data-encoding@2.9.0
	dbl@0.3.2
	deadpool-postgres@0.14.1
	deadpool-runtime@0.1.4
	deadpool@0.10.0
	deadpool@0.12.2
	decancer@3.2.8
	deflate64@0.1.9
	der-parser@10.0.0
	der-parser@8.2.0
	der-parser@9.0.0
	der@0.7.10
	deranged@0.4.0
	derive_arbitrary@1.4.1
	des@0.8.1
	digest@0.10.7
	digest@0.9.0
	dirs-next@2.0.0
	dirs-sys-next@0.1.2
	dirs-sys@0.5.0
	dirs@6.0.0
	displaydoc@0.2.5
	dlv-list@0.5.2
	dns-update@0.1.3
	doc-comment@0.3.3
	downcast-rs@2.0.1
	dsa@0.6.3
	dyn-clone@1.0.19
	eax@0.5.0
	ecb@0.1.2
	ecdsa@0.16.9
	ece@2.3.1
	ed25519-dalek@2.1.1
	ed25519@2.2.3
	either@1.15.0
	elasticsearch@8.5.0-alpha.1
	elliptic-curve@0.13.8
	ena@0.14.3
	encode_unicode@1.0.0
	encoding_rs@0.8.35
	endian-type@0.1.2
	enum-as-inner@0.6.1
	equivalent@1.0.2
	erased-serde@0.4.6
	errno@0.3.12
	event-listener-strategy@0.5.4
	event-listener@2.5.3
	event-listener@5.4.0
	fallible-iterator@0.2.0
	fallible-iterator@0.3.0
	fallible-streaming-iterator@0.1.9
	fancy-regex@0.14.0
	farmhash@1.1.5
	fast-float@0.2.0
	fastbloom@0.9.0
	fastrand@1.9.0
	ff@0.13.1
	fiat-crypto@0.2.9
	fixedbitset@0.4.2
	flate2@1.1.1
	flume@0.11.1
	fnv@1.0.7
	foldhash@0.1.5
	foreign-types-shared@0.1.1
	foreign-types@0.3.2
	form-data@0.6.0
	form_urlencoded@1.2.1
	foundationdb-gen@0.9.2
	foundationdb-macros@0.3.2
	foundationdb-sys@0.9.1
	foundationdb-tuple@0.9.1
	foundationdb@0.9.2
	funty@2.0.0
	futures-channel@0.3.31
	futures-core@0.3.31
	futures-executor@0.3.31
	futures-io@0.3.31
	futures-lite@1.13.0
	futures-macro@0.3.31
	futures-sink@0.3.31
	futures-task@0.3.31
	futures-util@0.3.31
	futures@0.3.31
	fxhash@0.2.1
	generator@0.8.5
	generic-array@0.14.7
	generic-array@1.2.0
	gethostname@1.0.2
	getrandom@0.1.16
	getrandom@0.2.16
	getrandom@0.3.3
	ghash@0.5.1
	gimli@0.31.1
	git-version-macro@0.3.9
	git-version@0.3.9
	glob@0.3.2
	group@0.13.0
	h2@0.3.26
	h2@0.4.10
	hashbrown@0.12.3
	hashbrown@0.14.5
	hashbrown@0.15.3
	hashify@0.2.6
	hashlink@0.10.0
	heck@0.4.1
	heck@0.5.0
	hermit-abi@0.3.9
	hermit-abi@0.5.1
	hex@0.4.3
	hickory-client@0.24.4
	hickory-proto@0.24.4
	hickory-proto@0.26.0-alpha.1
	hickory-resolver@0.26.0-alpha.1
	hkdf@0.12.4
	hmac@0.10.1
	hmac@0.12.1
	home@0.5.9
	hostname@0.4.1
	http-body-util@0.1.3
	http-body@0.4.6
	http-body@1.0.1
	http-types@2.12.0
	http@0.2.12
	http@1.3.1
	httparse@1.10.1
	httpdate@1.0.3
	human-size@0.4.3
	humantime@2.2.0
	hyper-rustls@0.24.2
	hyper-rustls@0.27.5
	hyper-timeout@0.5.2
	hyper-util@0.1.11
	hyper@0.14.32
	hyper@1.6.0
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.63
	icu_collections@2.0.0
	icu_locale_core@2.0.0
	icu_normalizer@2.0.0
	icu_normalizer_data@2.0.0
	icu_properties@2.0.0
	icu_properties_data@2.0.0
	icu_provider@2.0.0
	idea@0.5.1
	ident_case@1.0.1
	idna@1.0.3
	idna_adapter@1.2.1
	imagesize@0.14.0
	include-flate-codegen@0.2.0
	include-flate@0.3.0
	indexmap@1.9.3
	indexmap@2.9.0
	indicatif@0.17.11
	infer@0.19.0
	infer@0.2.3
	inout@0.1.4
	instant@0.1.13
	ipconfig@0.3.2
	ipnet@2.11.0
	ipnetwork@0.20.0
	is-terminal@0.4.16
	is_terminal_polyfill@1.70.1
	itertools@0.10.5
	itertools@0.11.0
	itertools@0.12.1
	itertools@0.13.0
	itertools@0.14.0
	itoa@1.0.15
	jemalloc-sys@0.5.4+5.3.0-patched
	jemallocator@0.5.4
	jieba-macros@0.7.1
	jieba-rs@0.7.2
	jmap-client@0.3.2
	jni-sys@0.3.0
	jni@0.21.1
	jobserver@0.1.33
	js-sys@0.3.77
	json5@0.4.1
	keccak@0.1.5
	keyed-set@1.0.0
	keyed_priority_queue@0.4.2
	konst@0.3.16
	konst_kernel@0.3.15
	lalrpop-util@0.20.2
	lalrpop@0.20.2
	lazy_static@1.5.0
	lazycell@1.3.0
	lber@0.4.2
	ldap3@0.11.5
	libc@0.2.172
	libflate@2.1.0
	libflate_lz77@2.1.0
	libloading@0.8.7
	liblzma-sys@0.4.3
	liblzma@0.4.1
	libm@0.2.15
	libredox@0.1.3
	librocksdb-sys@0.17.1+9.9.3
	libsqlite3-sys@0.33.0
	libz-rs-sys@0.5.0
	libz-sys@1.1.22
	linked-hash-map@0.5.6
	linux-raw-sys@0.9.4
	litemap@0.8.0
	lock_api@0.4.12
	log@0.4.27
	loom@0.7.2
	lru-cache@0.1.2
	lru-slab@0.1.2
	lru@0.14.0
	lz4-sys@1.11.1+lz4-1.10.0
	lz4_flex@0.11.3
	mail-auth@0.7.1
	mail-builder@0.4.3
	mail-parser@0.11.0
	mail-send@0.5.1
	maplit@1.0.2
	matchers@0.1.0
	maybe-async@0.2.10
	md-5@0.10.6
	md-5@0.9.1
	md5@0.7.0
	memchr@2.7.4
	memory-stats@1.2.0
	memsec@0.7.0
	mime@0.3.17
	mime_guess@2.0.5
	minimal-lexical@0.2.1
	miniz_oxide@0.8.8
	mio@1.0.3
	moka@0.12.10
	munge@0.4.4
	munge_macro@0.4.4
	mysql-common-derive@0.32.1
	mysql_async@0.36.1
	mysql_common@0.35.4
	nanorand@0.7.0
	new_debug_unreachable@1.0.6
	nibble_vec@0.1.0
	nix@0.28.0
	nkeys@0.4.4
	no-std-net@0.6.0
	nohash@0.2.0
	nom@7.1.3
	nonempty-collections@0.3.0
	nu-ansi-term@0.46.0
	nuid@0.5.0
	num-bigint-dig@0.8.4
	num-bigint@0.4.6
	num-conv@0.1.0
	num-integer@0.1.46
	num-iter@0.1.45
	num-traits@0.2.19
	num_cpus@1.16.0
	num_enum@0.7.3
	num_enum_derive@0.7.3
	number_prefix@0.4.0
	object@0.36.7
	ocb3@0.1.0
	oid-registry@0.6.1
	oid-registry@0.7.1
	oid-registry@0.8.1
	once_cell@1.21.3
	opaque-debug@0.3.1
	openssl-macros@0.1.1
	openssl-probe@0.1.6
	openssl-sys@0.9.108
	openssl@0.10.72
	opentelemetry-http@0.29.0
	opentelemetry-otlp@0.29.0
	opentelemetry-proto@0.29.0
	opentelemetry-semantic-conventions@0.29.0
	opentelemetry@0.29.1
	opentelemetry_sdk@0.29.0
	option-ext@0.2.0
	ordered-multimap@0.7.3
	overload@0.1.1
	p256@0.13.2
	p384@0.13.1
	p521@0.13.3
	parking@2.2.1
	parking_lot@0.12.3
	parking_lot_core@0.9.10
	parse-zoneinfo@0.3.1
	password-hash@0.5.0
	paste@1.0.15
	pbkdf2@0.12.2
	pem-rfc7468@0.7.0
	pem@3.0.5
	percent-encoding@2.3.1
	pest@2.8.0
	pest_derive@2.8.0
	pest_generator@2.8.0
	pest_meta@2.8.0
	petgraph@0.6.5
	phf@0.11.3
	phf_codegen@0.11.3
	phf_generator@0.11.3
	phf_macros@0.11.3
	phf_shared@0.11.3
	pin-project-internal@1.1.10
	pin-project-lite@0.2.16
	pin-project@1.1.10
	pin-utils@0.1.0
	pkcs1@0.7.5
	pkcs8@0.10.2
	pkg-config@0.3.32
	pnet_base@0.35.0
	pnet_datalink@0.35.0
	pnet_sys@0.35.0
	polyval@0.6.2
	portable-atomic@1.11.0
	postgres-protocol@0.6.8
	postgres-types@0.2.9
	potential_utf@0.1.2
	powerfmt@0.2.0
	ppv-lite86@0.2.21
	precomputed-hash@0.1.1
	prettyplease@0.2.32
	prettytable-rs@0.10.0
	primeorder@0.13.6
	privdrop@0.5.5
	proc-macro-crate@3.3.0
	proc-macro-error-attr2@2.0.0
	proc-macro-error2@2.0.1
	proc-macro2@1.0.95
	prometheus@0.14.0
	prost-derive@0.13.5
	prost@0.13.5
	proxy-header@0.1.2
	psl-types@2.0.11
	psl@2.1.109
	ptr_meta@0.3.0
	ptr_meta_derive@0.3.0
	pure-rust-locales@0.8.1
	pwhash@1.0.0
	quick-xml@0.31.0
	quick-xml@0.32.0
	quick-xml@0.37.5
	quick_cache@0.6.14
	quinn-proto@0.11.12
	quinn-udp@0.5.12
	quinn@0.11.8
	quote@1.0.40
	r-efi@5.2.0
	r2d2@0.8.10
	radium@0.7.0
	radix_trie@0.2.1
	rancor@0.1.0
	rand@0.7.3
	rand@0.8.5
	rand@0.9.1
	rand_chacha@0.2.2
	rand_chacha@0.3.1
	rand_chacha@0.9.0
	rand_core@0.5.1
	rand_core@0.6.4
	rand_core@0.9.3
	rand_hc@0.2.0
	rasn-cms@0.10.6
	rasn-derive@0.10.6
	rasn-pkix@0.10.6
	rasn@0.10.6
	rayon-core@1.12.1
	rayon@1.10.0
	rcgen@0.12.1
	rcgen@0.13.2
	rdkafka-sys@4.8.0+2.3.0
	rdkafka@0.37.0
	redis@0.31.0
	redox_syscall@0.5.12
	redox_users@0.4.6
	redox_users@0.5.0
	ref-cast-impl@1.0.24
	ref-cast@1.0.24
	regex-automata@0.1.10
	regex-automata@0.4.9
	regex-syntax@0.6.29
	regex-syntax@0.8.5
	regex@1.11.1
	rend@0.5.2
	reqwest@0.11.27
	reqwest@0.12.15
	resolv-conf@0.7.4
	rev_lines@0.3.0
	rfc6979@0.4.0
	ring@0.16.20
	ring@0.17.14
	ringbuffer-spsc@0.1.13
	ripemd@0.1.3
	rkyv@0.8.10
	rkyv_derive@0.8.10
	rle-decode-fast@1.0.3
	roaring@0.10.12
	rocksdb@0.23.0
	ron@0.8.1
	rpassword@7.4.0
	rsa@0.9.8
	rtoolbox@0.0.3
	rtrb@0.3.2
	rusqlite@0.35.0
	rust-ini@0.21.1
	rust-s3@0.35.1
	rust-stemmers@1.2.0
	rustc-demangle@0.1.24
	rustc-hash@1.1.0
	rustc-hash@2.1.1
	rustc_version@0.2.3
	rustc_version@0.4.1
	rusticata-macros@4.1.0
	rustix@1.0.7
	rustls-native-certs@0.6.3
	rustls-native-certs@0.7.3
	rustls-native-certs@0.8.1
	rustls-pemfile@1.0.4
	rustls-pemfile@2.2.0
	rustls-pki-types@1.12.0
	rustls-platform-verifier-android@0.1.1
	rustls-platform-verifier@0.5.3
	rustls-webpki@0.101.7
	rustls-webpki@0.102.8
	rustls-webpki@0.103.3
	rustls@0.21.12
	rustls@0.22.4
	rustls@0.23.27
	rustversion@1.0.20
	ryu@1.0.20
	safe_arch@0.7.4
	salsa20@0.10.2
	same-file@1.0.6
	saturating@0.1.0
	scc@2.3.4
	schannel@0.1.27
	scheduled-thread-pool@0.2.7
	schemars@0.8.22
	schemars_derive@0.8.22
	scoped-tls@1.0.1
	scopeguard@1.2.0
	scrypt@0.11.0
	sct@0.7.1
	sdd@3.0.8
	sec1@0.7.3
	secrecy@0.8.0
	security-framework-sys@2.14.0
	security-framework@2.11.1
	security-framework@3.2.0
	semver-parser@0.7.0
	semver@0.9.0
	semver@1.0.26
	sequoia-openpgp@2.0.0
	serde@1.0.219
	serde_bytes@0.11.17
	serde_derive@1.0.219
	serde_derive_internals@0.29.1
	serde_json@1.0.140
	serde_nanos@0.1.4
	serde_qs@0.8.5
	serde_repr@0.1.20
	serde_urlencoded@0.7.1
	serde_with@1.14.0
	serde_with@3.12.0
	serde_with_macros@1.5.2
	serde_with_macros@3.12.0
	serde_yaml@0.9.34+deprecated
	serial_test@3.2.0
	serial_test_derive@3.2.0
	sha-1@0.9.8
	sha1@0.10.6
	sha1_smol@1.0.1
	sha1collisiondetection@0.3.4
	sha2@0.10.9
	sha2@0.9.9
	sha3@0.10.8
	sharded-slab@0.1.7
	shellexpand@3.1.1
	shlex@1.3.0
	sieve-rs@0.7.0
	signal-hook-registry@1.4.5
	signatory@0.27.1
	signature@2.2.0
	simd-adler32@0.3.7
	simdutf8@0.1.5
	siphasher@1.0.1
	slab@0.4.9
	smallvec@1.15.0
	smtp-proto@0.1.6
	snafu-derive@0.7.5
	snafu@0.7.5
	socket2@0.5.9
	spin@0.10.0
	spin@0.5.2
	spin@0.9.8
	spki@0.7.3
	stable_deref_trait@1.2.0
	static_assertions@1.1.0
	string_cache@0.8.9
	stringprep@0.1.5
	strsim@0.10.0
	strsim@0.11.1
	subtle@2.6.1
	syn@1.0.109
	syn@2.0.101
	sync_wrapper@0.1.2
	sync_wrapper@1.0.2
	synstructure@0.12.6
	synstructure@0.13.2
	system-configuration-sys@0.5.0
	system-configuration@0.5.1
	tagptr@0.2.0
	tap@1.0.1
	term@0.7.0
	termcolor@1.4.1
	thiserror-impl@1.0.69
	thiserror-impl@2.0.12
	thiserror@1.0.69
	thiserror@2.0.12
	thread_local@1.1.8
	time-core@0.1.4
	time-macros@0.2.22
	time@0.3.41
	tiny-keccak@2.0.2
	tinystr@0.8.1
	tinyvec@1.9.0
	tinyvec_macros@0.1.1
	tls-listener@0.11.0
	token-cell@1.5.0
	tokio-macros@2.5.0
	tokio-postgres@0.7.13
	tokio-rustls@0.24.1
	tokio-rustls@0.25.0
	tokio-rustls@0.26.2
	tokio-stream@0.1.17
	tokio-tungstenite@0.21.0
	tokio-tungstenite@0.26.2
	tokio-util@0.7.15
	tokio-websockets@0.10.1
	tokio@1.45.0
	toml_datetime@0.6.9
	toml_edit@0.22.26
	tonic@0.12.3
	totp-rs@5.7.0
	tower-layer@0.3.3
	tower-service@0.3.3
	tower@0.4.13
	tower@0.5.2
	tracing-attributes@0.1.28
	tracing-core@0.1.33
	tracing-log@0.2.0
	tracing-serde@0.2.0
	tracing-subscriber@0.3.19
	tracing@0.1.41
	trim-in-place@0.1.7
	try-lock@0.2.5
	try_map@0.3.1
	tryhard@0.5.1
	tungstenite@0.21.0
	tungstenite@0.26.2
	twofish@0.7.1
	twox-hash@1.6.3
	twox-hash@2.1.0
	typeid@1.0.3
	typenum@1.18.0
	typewit@1.11.0
	typewit_proc_macros@1.8.1
	ucd-trie@0.1.7
	uhlc@0.8.1
	unicase@2.8.1
	unicode-bidi@0.3.18
	unicode-ident@1.0.18
	unicode-normalization@0.1.24
	unicode-properties@0.1.3
	unicode-script@0.5.7
	unicode-security@0.1.2
	unicode-width@0.1.14
	unicode-width@0.2.0
	unicode-xid@0.2.6
	universal-hash@0.5.1
	unsafe-libyaml@0.2.11
	untrusted@0.7.1
	untrusted@0.9.0
	unty@0.0.4
	unzip-n@0.1.2
	url@2.5.4
	urlencoding@2.1.3
	utf-8@0.7.6
	utf8_iter@1.0.4
	utf8parse@0.2.2
	uuid@1.16.0
	validated_struct@2.1.1
	validated_struct_macros@2.1.1
	valuable@0.1.1
	vcpkg@0.2.15
	vec_map@0.8.2
	version_check@0.9.5
	virtue@0.0.18
	void@1.0.2
	waker-fn@1.2.0
	walkdir@2.5.0
	want@0.3.1
	wasi@0.11.0+wasi-snapshot-preview1
	wasi@0.14.2+wasi-0.2.4
	wasi@0.9.0+wasi-snapshot-preview1
	wasite@0.1.0
	wasm-bindgen-backend@0.2.100
	wasm-bindgen-futures@0.4.50
	wasm-bindgen-macro-support@0.2.100
	wasm-bindgen-macro@0.2.100
	wasm-bindgen-shared@0.2.100
	wasm-bindgen@0.2.100
	wasm-streams@0.4.2
	web-sys@0.3.77
	web-time@1.1.0
	webpki-root-certs@0.26.11
	webpki-root-certs@1.0.0
	webpki-roots@0.25.4
	webpki-roots@0.26.11
	webpki-roots@1.0.0
	whatlang@0.16.4
	whoami@1.6.0
	wide@0.7.32
	widestring@1.2.0
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.9
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-collections@0.2.0
	windows-core@0.61.1
	windows-future@0.2.1
	windows-implement@0.60.0
	windows-interface@0.59.1
	windows-link@0.1.1
	windows-numerics@0.2.0
	windows-registry@0.4.0
	windows-result@0.3.3
	windows-strings@0.3.1
	windows-strings@0.4.1
	windows-sys@0.45.0
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-targets@0.42.2
	windows-targets@0.48.5
	windows-targets@0.52.6
	windows-targets@0.53.0
	windows-threading@0.1.0
	windows@0.61.1
	windows_aarch64_gnullvm@0.42.2
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_gnullvm@0.53.0
	windows_aarch64_msvc@0.42.2
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.6
	windows_aarch64_msvc@0.53.0
	windows_i686_gnu@0.42.2
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.6
	windows_i686_gnu@0.53.0
	windows_i686_gnullvm@0.52.6
	windows_i686_gnullvm@0.53.0
	windows_i686_msvc@0.42.2
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.6
	windows_i686_msvc@0.53.0
	windows_x86_64_gnu@0.42.2
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnu@0.53.0
	windows_x86_64_gnullvm@0.42.2
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_gnullvm@0.53.0
	windows_x86_64_msvc@0.42.2
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.6
	windows_x86_64_msvc@0.53.0
	winnow@0.7.10
	winreg@0.50.0
	wit-bindgen-rt@0.39.0
	writeable@0.6.1
	wyz@0.5.1
	x25519-dalek@2.0.1
	x509-parser@0.15.1
	x509-parser@0.16.0
	x509-parser@0.17.0
	xml-rs@0.8.26
	xxhash-rust@0.8.15
	yasna@0.5.2
	yoke-derive@0.8.0
	yoke@0.8.0
	zenoh-buffers@1.3.4
	zenoh-codec@1.3.4
	zenoh-collections@1.3.4
	zenoh-config@1.3.4
	zenoh-core@1.3.4
	zenoh-crypto@1.3.4
	zenoh-keyexpr@1.3.4
	zenoh-link-commons@1.3.4
	zenoh-link-quic@1.3.4
	zenoh-link-tcp@1.3.4
	zenoh-link-tls@1.3.4
	zenoh-link-udp@1.3.4
	zenoh-link@1.3.4
	zenoh-macros@1.3.4
	zenoh-plugin-trait@1.3.4
	zenoh-protocol@1.3.4
	zenoh-result@1.3.4
	zenoh-runtime@1.3.4
	zenoh-sync@1.3.4
	zenoh-task@1.3.4
	zenoh-transport@1.3.4
	zenoh-util@1.3.4
	zenoh@1.3.4
	zerocopy-derive@0.8.25
	zerocopy@0.8.25
	zerofrom-derive@0.1.6
	zerofrom@0.1.6
	zeroize@1.8.1
	zeroize_derive@1.4.2
	zerotrie@0.2.2
	zerovec-derive@0.11.1
	zerovec@0.11.2
	zip@4.0.0
	zlib-rs@0.5.0
	zopfli@0.8.2
	zstd-safe@7.2.4
	zstd-sys@2.0.15+zstd.1.5.7
	zstd@0.13.3
"

RUST_MIN_VER="1.85.0"
inherit cargo systemd

DESCRIPTION="Stalwart Mail Server"
HOMEPAGE="https://stalw.art"
SRC_URI="https://github.com/stalwartlabs/stalwart/archive/refs/tags/v${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"

S="${WORKDIR}/stalwart-${PV}"

LICENSE="|| ( AGPL-3 )"
# Dependent crate licenses
LICENSE+="
	AGPL-3 Apache-2.0 BSD-2 BSD Boost-1.0 CC0-1.0 ISC LGPL-2+ MIT
	MPL-2.0 Unicode-3.0 ZLIB
"

# 0.13.x has breaking changes so avoid installing new server with old cli
DEPEND+="
	!!<net-mail/stalwart-cli-0.13.0
"

RDEPEND="acct-group/stalwart-mail
		 acct-user/stalwart-mail"

SLOT="0"
KEYWORDS="~amd64"
IUSE="sqlite postgres mysql +rocks"

DOCS="resources/config README.md SECURITY.md UPGRADING.md CONTRIBUTING.md CHANGELOG.md"

src_unpack() {
	cargo_src_unpack
	sed -i -e "s%__PATH__/etc/%/opt/stalwart-mail/etc/%g" "${S}"/resources/systemd/stalwart-mail.service || die
	sed -i -e "s%__PATH__/bin/%/usr/bin/%g" "${S}"/resources/systemd/stalwart-mail.service || die
}

src_prepare() {
	pushd .
	cd "${WORKDIR}/cargo_home/gentoo/librocksdb-sys-0.17.1+9.9.3/rocksdb"
	eapply "${FILESDIR}/rocksdb-10.1-fixincludes.patch"
	popd
	eapply_user
}

src_configure() {
	local myfeatures=(
		$(usev sqlite)
		$(usev postgres)
		$(usev mysql)
		$(usev rocks)
	)
	# TODO: consider "enterprise" USE flag, which requires a premium license
	cargo_src_configure --no-default-features
}

src_compile() {
	cargo_src_compile --bin stalwart
}

src_install() {
	cargo_src_install --path crates/main

	keepdir /var/run/stalwart-mail
	newinitd "${FILESDIR}"/stalwart-mail.initd stalwart-mail
	systemd_dounit "${S}"/resources/systemd/stalwart-mail.service

	einstalldocs
}

pkg_config() {
	if [[ ! -d ${ROOT}/opt/stalwart-mail ]]; then
		einfo "Initializing standard config in ${ROOT}/opt/stalwart-mail"
		"${ROOT}"/usr/bin/stalwart-mail --init "${ROOT}"/opt/stalwart-mail
	else
		einfo "It appears you already have a config in stalwart-mail."
		einfo "Please remove ${ROOT}/opt/stalwart-mail and run this again"
		einfo "if you want to create a new clean standard config."
	fi
}

pkg_postinst() {
	ewarn "If you are upgrading from v0.11.x or v0.12.x, this version includes"
	ewarn "breaking changes to the database layout and requires a migration."
	ewarn "Please read the UPGRADING.md file for more information on how to"
	ewarn "upgrade from previous versions."
}
