# Copyright 2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.5

EAPI=8

CRATES="
	addr2line@0.17.0
	addr2line@0.24.2
	adler@1.0.2
	ahash@0.8.11
	aho-corasick@0.7.20
	aho-corasick@1.0.1
	allocator-api2@0.2.21
	ambient-authority@0.0.2
	android-tzdata@0.1.1
	android_system_properties@0.1.5
	ansi_term@0.12.1
	anyhow@1.0.95
	arbitrary@1.4.1
	arc-swap@1.5.0
	arrayvec@0.5.2
	arrayvec@0.7.2
	async-attributes@1.1.2
	async-channel@1.8.0
	async-executor@1.4.1
	async-global-executor@2.3.1
	async-io@1.13.0
	async-lock@2.8.0
	async-process@1.4.0
	async-std@1.11.0
	async-task@4.2.0
	async-trait@0.1.80
	atomic-waker@1.0.0
	atomic@0.6.0
	atty@0.2.14
	autocfg@1.1.0
	backtrace-ext@0.2.1
	backtrace@0.3.65
	base64@0.13.0
	base64@0.21.0
	base64@0.22.1
	bit-set@0.5.3
	bit-vec@0.6.3
	bitflags@1.3.2
	bitflags@2.5.0
	block-buffer@0.10.4
	blocking@1.2.0
	bstr@1.5.0
	bumpalo@3.16.0
	bytemuck@1.22.0
	byteorder@1.4.3
	bytes@1.6.0
	cache-padded@1.2.0
	cap-fs-ext@3.4.2
	cap-net-ext@3.4.2
	cap-primitives@3.4.2
	cap-rand@3.4.2
	cap-std@3.4.2
	cap-time-ext@3.4.2
	cassowary@0.3.0
	castaway@0.1.2
	cc@1.0.83
	cfg-if@1.0.0
	cfg_aliases@0.2.1
	chrono@0.4.39
	clap@3.2.4
	clap_complete@3.2.1
	clap_derive@3.2.4
	clap_lex@0.2.2
	close_fds@0.3.2
	cobs@0.2.3
	colored@2.0.0
	colorsys@0.6.5
	concurrent-queue@1.2.2
	concurrent-queue@2.2.0
	console@0.15.0
	core-foundation-sys@0.8.3
	cpp_demangle@0.4.3
	cpufeatures@0.2.2
	cranelift-bforest@0.116.1
	cranelift-bitset@0.116.1
	cranelift-codegen-meta@0.116.1
	cranelift-codegen-shared@0.116.1
	cranelift-codegen@0.116.1
	cranelift-control@0.116.1
	cranelift-entity@0.116.1
	cranelift-frontend@0.116.1
	cranelift-isle@0.116.1
	cranelift-native@0.116.1
	crc32fast@1.4.0
	crossbeam-channel@0.5.4
	crossbeam-deque@0.8.1
	crossbeam-epoch@0.9.8
	crossbeam-queue@0.3.5
	crossbeam-utils@0.8.15
	crossbeam@0.8.1
	crypto-common@0.1.6
	csscolorparser@0.6.2
	ctor@0.1.22
	curl-sys@0.4.68+curl-8.4.0
	curl@0.4.44
	daemonize@0.5.0
	debugid@0.8.0
	deltae@0.3.0
	derivative@2.2.0
	destructure_traitobject@0.2.0
	dialoguer@0.10.4
	digest@0.10.7
	directories-next@2.0.0
	directories@5.0.1
	dirs-sys-next@0.1.2
	dirs-sys@0.3.7
	dirs-sys@0.4.1
	dirs@4.0.0
	dissimilar@1.0.6
	either@1.6.1
	embedded-io@0.4.0
	encode_unicode@0.3.6
	encoding_rs@0.8.34
	equivalent@1.0.1
	erased-serde@0.3.20
	errno@0.3.10
	euclid@0.22.9
	event-listener@2.5.2
	expect-test@1.4.1
	fallible-iterator@0.3.0
	fancy-regex@0.11.0
	fastrand@1.7.0
	fastrand@2.1.0
	fd-lock@4.0.2
	file-id@0.1.0
	filedescriptor@0.8.3
	filetime@0.2.21
	finl_unicode@1.2.0
	fixedbitset@0.4.2
	fnv@1.0.7
	foldhash@0.1.4
	form_urlencoded@1.2.1
	fs-set-times@0.20.1
	fsevent-sys@4.1.0
	futures-channel@0.3.28
	futures-core@0.3.28
	futures-executor@0.3.28
	futures-io@0.3.28
	futures-lite@1.13.0
	futures-macro@0.3.28
	futures-sink@0.3.28
	futures-task@0.3.28
	futures-util@0.3.28
	futures@0.3.28
	fuzzy-matcher@0.3.7
	fxhash@0.2.1
	fxprof-processed-profile@0.6.0
	generic-array@0.14.5
	getopts@0.2.21
	getrandom@0.2.10
	getrandom@0.3.1
	ghost@0.1.4
	gimli@0.26.1
	gimli@0.31.1
	globset@0.4.10
	gloo-timers@0.2.4
	hashbrown@0.11.2
	hashbrown@0.14.5
	hashbrown@0.15.2
	heck@0.3.3
	heck@0.4.0
	heck@0.5.0
	hermit-abi@0.1.19
	hermit-abi@0.3.1
	hex@0.4.3
	highway@0.6.4
	http@0.2.9
	humantime@2.1.0
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.60
	id-arena@2.2.1
	idna@0.5.0
	ignore@0.4.20
	include_dir@0.7.3
	include_dir_macros@0.7.3
	indexmap@1.8.2
	indexmap@2.7.1
	inotify-sys@0.1.5
	inotify@0.9.6
	insta@1.14.0
	instant@0.1.12
	interprocess@1.2.1
	intmap@0.7.1
	inventory@0.2.3
	io-extras@0.18.4
	io-lifetimes@1.0.10
	io-lifetimes@2.0.3
	ipnet@2.9.0
	is-terminal@0.4.7
	is_ci@1.1.1
	isahc@1.7.2
	itertools@0.10.5
	itertools@0.12.1
	itoa@1.0.14
	ittapi-sys@0.4.0
	ittapi@0.4.0
	jobserver@0.1.31
	js-sys@0.3.64
	kdl@4.5.0
	kqueue-sys@1.0.3
	kqueue@1.0.7
	kv-log-macro@1.0.7
	lab@0.11.0
	lazy_static@1.4.0
	leb128@0.2.5
	lev_distance@0.1.1
	libc@0.2.169
	libm@0.2.8
	libnghttp2-sys@0.1.8+1.55.1
	libssh2-sys@0.2.23
	libz-sys@1.1.8
	linked-hash-map@0.5.4
	linux-raw-sys@0.3.7
	linux-raw-sys@0.4.15
	lock_api@0.4.11
	log-mdc@0.1.0
	log4rs@1.2.0
	log@0.4.17
	mac_address@1.1.8
	mach2@0.4.2
	maybe-owned@0.3.4
	memchr@2.5.0
	memfd@0.6.4
	memmem@0.1.1
	memoffset@0.6.5
	memoffset@0.9.1
	miette-derive@5.8.0
	miette@5.8.0
	mime@0.3.17
	minimal-lexical@0.2.1
	miniz_oxide@0.5.3
	mio@0.7.14
	mio@0.8.11
	miow@0.3.7
	multimap@0.8.3
	names@0.14.0
	nix@0.23.1
	nix@0.29.0
	nom@7.1.1
	notify-debouncer-full@0.1.0
	notify@6.0.0
	ntapi@0.3.7
	num-derive@0.4.2
	num-traits@0.2.15
	num_cpus@1.13.1
	object@0.28.4
	object@0.36.7
	once_cell@1.18.0
	openssl-probe@0.1.5
	openssl-src@300.1.6+3.1.4
	openssl-sys@0.9.93
	option-ext@0.2.0
	ordered-float@2.10.0
	ordered-float@4.2.0
	os_str_bytes@6.1.0
	owo-colors@3.4.0
	parking@2.0.0
	parking_lot@0.11.2
	parking_lot@0.12.1
	parking_lot_core@0.8.5
	parking_lot_core@0.9.9
	paste@1.0.7
	percent-encoding@2.3.1
	pest@2.7.15
	pest_derive@2.7.15
	pest_generator@2.7.15
	pest_meta@2.7.15
	petgraph@0.6.3
	phf@0.11.1
	phf_codegen@0.11.2
	phf_generator@0.11.1
	phf_macros@0.11.1
	phf_shared@0.11.1
	pin-project-internal@1.1.3
	pin-project-lite@0.2.14
	pin-project@1.1.3
	pin-utils@0.1.0
	pkg-config@0.3.25
	polling@2.2.0
	postcard@1.0.8
	ppv-lite86@0.2.16
	pretty-bytes@0.2.2
	prettyplease@0.1.25
	proc-macro-error-attr@1.0.4
	proc-macro-error@1.0.4
	proc-macro2@1.0.93
	prost-build@0.11.9
	prost-derive@0.11.9
	prost-types@0.11.9
	prost@0.11.9
	psm@0.1.21
	pulley-interpreter@29.0.1
	quote@1.0.36
	rand@0.8.5
	rand@0.9.0
	rand_chacha@0.3.1
	rand_chacha@0.9.0
	rand_core@0.6.3
	rand_core@0.9.0
	rayon-core@1.9.3
	rayon@1.5.3
	redox_syscall@0.2.13
	redox_syscall@0.4.1
	redox_users@0.4.3
	regalloc2@0.11.1
	regex-syntax@0.7.1
	regex@1.8.1
	rmp-serde@1.3.0
	rmp@0.8.14
	rustc-demangle@0.1.21
	rustc-hash@2.1.0
	rustc_version@0.4.0
	rustix@0.37.28
	rustix@0.38.44
	ryu@1.0.10
	same-file@1.0.6
	schannel@0.1.22
	scopeguard@1.1.0
	semver-parser@0.10.2
	semver@0.11.0
	semver@1.0.17
	serde-value@0.7.0
	serde@1.0.217
	serde_derive@1.0.217
	serde_json@1.0.81
	serde_spanned@0.6.6
	serde_yaml@0.8.24
	sha2@0.10.8
	shell-words@1.1.0
	shellexpand@2.1.2
	shellexpand@3.0.0
	signal-hook-registry@1.4.0
	signal-hook@0.3.14
	similar@2.1.0
	siphasher@0.3.10
	siphasher@1.0.1
	sixel-image@0.1.0
	sixel-tokenizer@0.1.0
	slab@0.4.6
	sluice@0.5.5
	smallvec@1.13.2
	smawk@0.3.1
	socket2@0.4.9
	socket2@0.5.7
	spinning@0.1.0
	sptr@0.3.2
	ssh2@0.9.3
	stable_deref_trait@1.2.0
	strip-ansi-escapes@0.1.1
	strsim@0.10.0
	strsim@0.11.1
	strum@0.20.0
	strum_macros@0.20.1
	suggest@0.4.0
	supports-color@2.0.0
	supports-hyperlinks@2.1.0
	supports-unicode@2.0.0
	syn@1.0.96
	syn@2.0.96
	sysinfo@0.22.5
	system-interface@0.27.2
	target-lexicon@0.13.1
	tempfile@3.10.1
	termcolor@1.4.1
	terminal_size@0.1.17
	terminfo@0.9.0
	termios@0.3.3
	termwiz@0.23.3
	textwrap@0.15.0
	thiserror-impl@1.0.61
	thiserror-impl@2.0.12
	thiserror@1.0.61
	thiserror@2.0.12
	thread-id@4.0.0
	thread_local@1.1.7
	tinyvec@1.6.0
	tinyvec_macros@0.1.0
	to_method@1.1.0
	tokio@1.37.0
	toml@0.5.10
	toml@0.8.13
	toml_datetime@0.6.6
	toml_edit@0.22.13
	tracing-attributes@0.1.21
	tracing-core@0.1.27
	tracing-futures@0.2.5
	tracing@0.1.35
	trait-variant@0.1.2
	typemap-ors@1.0.0
	typenum@1.15.0
	typetag-impl@0.1.8
	typetag@0.1.8
	ucd-trie@0.1.7
	unicode-bidi@0.3.15
	unicode-ident@1.0.1
	unicode-linebreak@0.1.2
	unicode-normalization@0.1.23
	unicode-segmentation@1.12.0
	unicode-width@0.1.10
	unicode-width@0.2.0
	unicode-xid@0.2.4
	unsafe-any-ors@1.0.0
	url@2.5.0
	utf8parse@0.2.0
	uuid@1.16.0
	value-bag@1.0.0-alpha.9
	vcpkg@0.2.15
	version_check@0.9.4
	vte@0.10.1
	vte@0.11.0
	vte_generate_state_changes@0.1.1
	vtparse@0.6.2
	waker-fn@1.1.0
	walkdir@2.3.3
	wasi@0.11.0+wasi-snapshot-preview1
	wasi@0.13.3+wasi-0.2.2
	wasm-bindgen-backend@0.2.87
	wasm-bindgen-futures@0.4.31
	wasm-bindgen-macro-support@0.2.87
	wasm-bindgen-macro@0.2.87
	wasm-bindgen-shared@0.2.87
	wasm-bindgen@0.2.87
	wasm-encoder@0.221.2
	wasm-encoder@0.224.0
	wasmparser@0.221.2
	wasmparser@0.224.0
	wasmprinter@0.221.2
	wasmtime-asm-macros@29.0.1
	wasmtime-cache@29.0.1
	wasmtime-component-macro@29.0.1
	wasmtime-component-util@29.0.1
	wasmtime-cranelift@29.0.1
	wasmtime-environ@29.0.1
	wasmtime-fiber@29.0.1
	wasmtime-jit-debug@29.0.1
	wasmtime-jit-icache-coherence@29.0.1
	wasmtime-math@29.0.1
	wasmtime-slab@29.0.1
	wasmtime-versioned-export-macros@29.0.1
	wasmtime-wasi@29.0.1
	wasmtime-winch@29.0.1
	wasmtime-wit-bindgen@29.0.1
	wasmtime@29.0.1
	wast@224.0.0
	wast@35.0.2
	wat@1.224.0
	web-sys@0.3.58
	wepoll-ffi@0.1.2
	wezterm-bidi@0.2.3
	wezterm-blob-leases@0.1.1
	wezterm-color-types@0.3.0
	wezterm-dynamic-derive@0.1.1
	wezterm-dynamic@0.2.1
	wezterm-input-types@0.1.0
	which@4.2.5
	wiggle-generate@29.0.1
	wiggle-macro@29.0.1
	wiggle@29.0.1
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.5
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	winch-codegen@29.0.1
	windows-core@0.52.0
	windows-sys@0.45.0
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-targets@0.42.2
	windows-targets@0.48.0
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.42.2
	windows_aarch64_gnullvm@0.48.0
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.42.2
	windows_aarch64_msvc@0.48.0
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.42.2
	windows_i686_gnu@0.48.0
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.42.2
	windows_i686_msvc@0.48.0
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.42.2
	windows_x86_64_gnu@0.48.0
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.42.2
	windows_x86_64_gnullvm@0.48.0
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.42.2
	windows_x86_64_msvc@0.48.0
	windows_x86_64_msvc@0.52.6
	winnow@0.6.8
	winx@0.36.3
	wit-bindgen-rt@0.33.0
	wit-parser@0.221.2
	witx@0.9.1
	xflags-macros@0.3.2
	xflags@0.3.2
	xshell-macros@0.2.2
	xshell@0.2.2
	yaml-rust@0.4.5
	zerocopy-derive@0.7.34
	zerocopy-derive@0.8.17
	zerocopy@0.7.34
	zerocopy@0.8.17
	zeroize@1.5.5
	zstd-safe@7.1.0
	zstd-sys@2.0.10+zstd.1.5.6
	zstd@0.13.1
"

inherit cargo desktop shell-completion xdg

DESCRIPTION="A terminal workspace with batteries included"
HOMEPAGE="
	https://zellij.dev/
	https://github.com/zellij-org/zellij
"
SRC_URI="
	https://github.com/zellij-org/${PN}/archive/refs/tags/v${PV}.tar.gz -> ${P}.gh.tar.gz
	${CARGO_CRATE_URIS}
"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 Apache-2.0-with-LLVM-exceptions BSD CC0-1.0 ISC MIT
	MPL-2.0 Unicode-DFS-2016 WTFPL-2 ZLIB
"

SLOT="0"
KEYWORDS="~amd64"
IUSE="man"

RDEPEND="
	net-misc/curl
"
DEPEND="${RDEPEND}"
BDEPEND="
	man? ( dev-go/go-md2man )
"

# rust does not use *FLAGS from make.conf, silence portage warning
# update with proper path to binaries this crate installs, omit leading /
QA_FLAGS_IGNORED="usr/bin/${PN}"
QA_PRESTRIPPED="usr/bin/${PN}"

DOCS=(
	CHANGELOG.md
	CODE_OF_CONDUCT.md
	CONTRIBUTING.md
	GOVERNANCE.md
	README.md
	docs/
)

src_compile() {
	cargo_src_compile
	pushd ${PN}-utils 2>/dev/null || die
	cargo_src_compile
	popd 2>/dev/null || die

	if use man; then
		go-md2man -in docs/MANPAGE.md -out ${PN}.1 || die
	fi

	"$(cargo_target_dir)"/zellij setup --generate-completion bash > zellij.bash || die
	"$(cargo_target_dir)"/zellij setup --generate-completion fish > zellij.fish || die
	"$(cargo_target_dir)"/zellij setup --generate-completion zsh > zellij.zsh || die
}

src_install() {
	cargo_src_install

	dodoc example/*.*

	insinto /usr/share/zellij
	doins -r example/{themes,layouts}
	doins -r ${PN}-utils/assets/{layouts,plugins,config,shell} \
		${PN}-utils/assets/*.wasm ${PN}-utils/assets/README.md

	use man && doman ${PN}.1

	domenu assets/zellij.desktop
	newicon assets/logo.png zellij.png

	newbashcomp zellij.bash zellij
	newfishcomp zellij.fish zellij.fish
	newzshcomp zellij.zsh _zellij
}
