# Copyright 2023-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.10

EAPI=8

CRATES="
	adler32@1.2.0
	ahash@0.8.11
	aho-corasick@1.1.3
	alloc-no-stdlib@2.0.4
	alloc-stdlib@0.2.2
	allocator-api2@0.2.21
	android-tzdata@0.1.1
	android_system_properties@0.1.5
	anstream@0.6.18
	anstyle-parse@0.2.6
	anstyle-query@1.1.2
	anstyle-wincon@3.0.7
	anstyle@1.0.10
	autocfg@1.4.0
	base64@0.22.1
	bit-set@0.8.0
	bit-vec@0.8.0
	bitflags@2.9.0
	block-buffer@0.10.4
	brotli-decompressor@4.0.2
	brotli@7.0.0
	bumpalo@3.17.0
	cc@1.2.17
	cfg-if@1.0.0
	chrono@0.4.40
	clap@4.5.32
	clap_builder@4.5.32
	clap_lex@0.7.4
	colorchoice@1.0.3
	colored@3.0.0
	core-foundation-sys@0.8.7
	core2@0.4.0
	cpufeatures@0.2.17
	crc32fast@1.4.2
	crypto-common@0.1.6
	curl-sys@0.4.80+curl-8.12.1
	curl@0.4.47
	dary_heap@0.3.7
	digest@0.10.7
	displaydoc@0.2.5
	encoding-index-japanese@1.20141219.5
	encoding-index-korean@1.20141219.5
	encoding-index-simpchinese@1.20141219.5
	encoding-index-singlebyte@1.20141219.5
	encoding-index-tradchinese@1.20141219.5
	encoding@0.2.33
	encoding_index_tests@0.1.4
	errno@0.3.10
	fastrand@2.3.0
	fnv@1.0.7
	form_urlencoded@1.2.1
	generic-array@0.14.7
	getrandom@0.2.15
	getrandom@0.3.2
	glob@0.3.2
	hashbrown@0.14.5
	hex@0.4.3
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.62
	icu_collections@1.5.0
	icu_locid@1.5.0
	icu_locid_transform@1.5.0
	icu_locid_transform_data@1.5.0
	icu_normalizer@1.5.0
	icu_normalizer_data@1.5.0
	icu_properties@1.5.1
	icu_properties_data@1.5.0
	icu_provider@1.5.0
	icu_provider_macros@1.5.0
	idna@1.0.3
	idna_adapter@1.2.0
	is_terminal_polyfill@1.70.1
	itoa@1.0.15
	js-sys@0.3.77
	lazy_static@1.5.0
	libc@0.2.171
	libflate@2.1.0
	libflate_lz77@2.1.0
	libredox@0.1.3
	libxml@0.3.3
	libz-sys@1.1.22
	linux-raw-sys@0.9.3
	litemap@0.7.5
	log@0.4.27
	md5@0.7.0
	memchr@2.7.4
	num-traits@0.2.19
	numtoa@0.2.4
	once_cell@1.21.1
	openssl-probe@0.1.6
	openssl-src@300.4.2+3.4.1
	openssl-sys@0.9.106
	percent-encoding@2.3.1
	pkg-config@0.3.32
	ppv-lite86@0.2.21
	proc-macro2@1.0.94
	proptest@1.6.0
	quick-error@1.2.3
	quote@1.0.40
	r-efi@5.2.0
	rand@0.8.5
	rand@0.9.0
	rand_chacha@0.3.1
	rand_chacha@0.9.0
	rand_core@0.6.4
	rand_core@0.9.3
	rand_xorshift@0.3.0
	redox_syscall@0.5.10
	redox_termios@0.1.3
	regex-automata@0.4.9
	regex-syntax@0.8.5
	regex@1.11.1
	rle-decode-fast@1.0.3
	rustix@1.0.3
	rustversion@1.0.20
	rusty-fork@0.3.0
	ryu@1.0.20
	schannel@0.1.27
	serde@1.0.219
	serde_derive@1.0.219
	serde_json@1.0.140
	sha2@0.10.8
	shlex@1.3.0
	similar@2.7.0
	smallvec@1.14.0
	socket2@0.5.8
	stable_deref_trait@1.2.0
	strsim@0.11.1
	syn@2.0.100
	synstructure@0.13.1
	tempfile@3.19.1
	terminal_size@0.4.2
	termion@4.0.4
	tinystr@0.7.6
	toml@0.5.11
	typenum@1.18.0
	unarray@0.1.4
	unicode-ident@1.0.18
	url@2.5.4
	utf16_iter@1.0.5
	utf8_iter@1.0.4
	utf8parse@0.2.2
	uuid@1.16.0
	vcpkg@0.2.15
	version_check@0.9.5
	wait-timeout@0.2.1
	wasi@0.11.0+wasi-snapshot-preview1
	wasi@0.14.2+wasi-0.2.4
	wasm-bindgen-backend@0.2.100
	wasm-bindgen-macro-support@0.2.100
	wasm-bindgen-macro@0.2.100
	wasm-bindgen-shared@0.2.100
	wasm-bindgen@0.2.100
	windows-core@0.52.0
	windows-link@0.1.1
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.52.6
	winres@0.1.12
	wit-bindgen-rt@0.39.0
	write16@1.0.0
	writeable@0.5.5
	xml-rs@0.8.25
	yoke-derive@0.7.5
	yoke@0.7.5
	zerocopy-derive@0.7.35
	zerocopy-derive@0.8.24
	zerocopy@0.7.35
	zerocopy@0.8.24
	zerofrom-derive@0.1.6
	zerofrom@0.1.6
	zerovec-derive@0.10.3
	zerovec@0.10.4
"

inherit shell-completion cargo

DESCRIPTION="Hurl, run and test HTTP requests"
HOMEPAGE="https://hurl.dev"
SRC_URI="
	https://github.com/Orange-OpenSource/${PN}/archive/refs/tags/${PV}.tar.gz -> ${PN}-${PV}.tar.gz
	${CARGO_CRATE_URIS}
"

LICENSE="Apache-2.0"
# Dependent crate licenses
LICENSE+=" Apache-2.0 BSD CC0-1.0 MIT MPL-2.0 Unicode-3.0 ZLIB"
SLOT="0"
KEYWORDS="~amd64"

RDEPEND="
	net-misc/curl
	dev-libs/libxml2:=
"
DEPEND="${RDEPEND}"

# Rust.
QA_FLAGS_IGNORED=(
	/usr/bin/hurl
	/usr/bin/hurlfmt
)

QA_PRESTRIPPED="${QA_FLAGS_IGNORED[*]}"

src_install() {
	dobin "$(cargo_target_dir)"/hurl{,fmt}
	doman docs/manual/hurl{,fmt}.1

	dodoc CHANGELOG.md README.md LICENSE

	newbashcomp completions/hurl.bash hurl
	newbashcomp completions/hurlfmt.bash hurlfmt
	# https://github.com/Orange-OpenSource/hurl/issues/3938
	# newzshcomp completions/_hurl _hurl
	# newzshcomp completions/_hurlfmt _hurlfmt
	newfishcomp completions/hurl.fish hurl.fish
	newfishcomp completions/hurlfmt.fish hurlfmt.fish
}

src_test() {
	# These need a local HTTP server.. and don't bother setting one up..
	cargo_src_test -- \
				   --skip simple_sample \
				   --skip runner::hurl_file::run
}
