# Copyright 2024-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.4

EAPI=8

SYDVER=3.35.0

IUSE="static"

CRATES="
	ahash@0.8.12
	arrayvec@0.7.6
	autocfg@1.4.0
	bitflags@2.9.1
	block-buffer@0.10.4
	btoi@0.5.0
	bumpalo@3.17.0
	cfg-if@1.0.0
	cfg_aliases@0.2.1
	console@0.15.11
	cpufeatures@0.2.17
	crc-catalog@2.4.0
	crc@3.3.0
	crossbeam-deque@0.8.6
	crossbeam-epoch@0.9.18
	crossbeam-utils@0.8.21
	crypto-common@0.1.6
	digest@0.10.7
	either@1.15.0
	encode_unicode@1.0.0
	equivalent@1.0.2
	errno@0.3.12
	fastrand@2.3.0
	generic-array@0.14.7
	getrandom@0.3.3
	hashbrown@0.15.3
	hermit-abi@0.5.1
	hex-conservative@0.3.0
	indexmap@2.9.0
	indicatif@0.17.11
	itoa@1.0.15
	js-sys@0.3.77
	keccak@0.1.5
	lexopt@0.3.1
	libc@0.2.172
	linux-raw-sys@0.9.4
	log@0.4.27
	md5@0.7.0
	memchr@2.7.4
	memoffset@0.9.1
	nix@0.30.1
	num-traits@0.2.19
	num_cpus@1.17.0
	number_prefix@0.4.0
	once_cell@1.21.3
	portable-atomic@1.11.0
	proc-macro2@1.0.95
	quote@1.0.40
	r-efi@5.2.0
	rayon-core@1.12.1
	rayon@1.10.0
	rustix@1.0.7
	ryu@1.0.20
	serde@1.0.219
	serde_derive@1.0.219
	serde_json@1.0.140
	sha1@0.10.6
	sha3@0.10.8
	syn@2.0.101
	tempfile@3.20.0
	typenum@1.18.0
	unicode-ident@1.0.18
	unicode-width@0.2.0
	version_check@0.9.5
	wasi@0.14.2+wasi-0.2.4
	wasm-bindgen-backend@0.2.100
	wasm-bindgen-macro-support@0.2.100
	wasm-bindgen-macro@0.2.100
	wasm-bindgen-shared@0.2.100
	wasm-bindgen@0.2.100
	web-time@1.1.0
	windows-sys@0.59.0
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.52.6
	wit-bindgen-rt@0.39.0
	zerocopy-derive@0.8.25
	zerocopy@0.8.25
"

inherit cargo

DESCRIPTION="Syd's log inspector & profile writer"
HOMEPAGE="https://man.exherbolinux.org"

SRC_URI="https://git.sr.ht/~alip/syd/archive/v${SYDVER}.tar.gz -> syd-${SYDVER}.tar.gz
	${CARGO_CRATE_URIS}
"

LICENSE="GPL-3"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 Apache-2.0-with-LLVM-exceptions BSD-2 BSD CC0-1.0 GPL-2
	ISC MIT MPL-2.0 Unicode-DFS-2016
"
SLOT="0"
KEYWORDS="~amd64"

S=${WORKDIR}/syd-v${SYDVER}/pandora

src_configure() {
	if use static; then
		export RUSTFLAGS+="-Ctarget-feature=+crt-static"
	fi
	cargo_src_configure
}
