# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

KDE_ORG_COMMIT=0796e3c6269bfcf645fda6e4602f4400e4f6208b
ECM_HANDBOOK="optional"
ECM_TEST="forceoptional"
KFMIN=6.13.0
QTMIN=6.8.1
inherit ecm gear.kde.org xdg

DESCRIPTION="Language learning application that helps improving pronunciation skills"
HOMEPAGE="https://apps.kde.org/artikulate/"

LICENSE="GPL-2" # TODO: CHECK
SLOT="0"
KEYWORDS="amd64 arm64 ~riscv ~x86"
IUSE=""

DEPEND="
	dev-libs/libxml2:=
	>=dev-qt/qtbase-${QTMIN}:6[gui,sql,xml]
	>=dev-qt/qtdeclarative-${QTMIN}:6
	>=dev-qt/qtmultimedia-${QTMIN}:6[qml]
	>=kde-frameworks/karchive-${KFMIN}:6
	>=kde-frameworks/kconfig-${KFMIN}:6
	>=kde-frameworks/kconfigwidgets-${KFMIN}:6
	>=kde-frameworks/kcoreaddons-${KFMIN}:6
	>=kde-frameworks/kcrash-${KFMIN}:6
	>=kde-frameworks/ki18n-${KFMIN}:6
	>=kde-frameworks/kirigami-${KFMIN}:6
	>=kde-frameworks/kitemmodels-${KFMIN}:6
	>=kde-frameworks/knewstuff-${KFMIN}:6
	>=kde-frameworks/kwidgetsaddons-${KFMIN}:6
"
RDEPEND="${DEPEND}"

src_configure() {
	local mycmakeargs=(
		-DBUILD_autotests=$(usex test)
	)
	ecm_src_configure
}
