/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr.runtime.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastQueue<T> {
    protected List<T> data = new ArrayList<T>();
    protected int p = 0;

    public void reset() {
        this.p = 0;
        this.data.clear();
    }

    public T remove() {
        T o = this.get(0);
        ++this.p;
        if (this.p == this.data.size()) {
            this.clear();
        }
        return o;
    }

    public void add(T o) {
        this.data.add(o);
    }

    public int size() {
        return this.data.size() - this.p;
    }

    public T head() {
        return this.get(0);
    }

    public T get(int i) {
        if (this.p + i >= this.data.size()) {
            throw new NoSuchElementException("queue index " + (this.p + i) + " > size " + this.data.size());
        }
        return this.data.get(this.p + i);
    }

    public void clear() {
        this.p = 0;
        this.data.clear();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            buf.append(this.get(i));
            if (i + 1 >= n) continue;
            buf.append(" ");
        }
        return buf.toString();
    }
}

