/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.tree.AttributeCollection;
import javax.xml.transform.TransformerConfigurationException;

public class XSLNamespaceAlias
extends StyleElement {
    private short stylesheetURICode;
    private short resultURICode;

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        String string2 = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.STYLESHEET_PREFIX) {
                string = attributeCollection.getValue(n);
            } else if (n3 == standardNames.RESULT_PREFIX) {
                string2 = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("stylesheet-prefix");
            return;
        }
        if (string.equals("#default")) {
            string = "";
        }
        if (string2 == null) {
            this.reportAbsence("result-prefix");
            return;
        }
        if (string2.equals("#default")) {
            string2 = "";
        }
        try {
            this.stylesheetURICode = this.getURICodeForPrefix(string);
            this.resultURICode = this.getURICodeForPrefix(string2);
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
    }

    public void preprocess() throws TransformerConfigurationException {
    }

    public void process(Context context) {
    }

    public short getStylesheetURICode() {
        return this.stylesheetURICode;
    }

    public short getResultURICode() {
        return this.resultURICode;
    }
}

