/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.AbstractNode;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.EmptyEnumeration;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.SingletonEnumeration;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.pattern.NameTest;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.tree.AncestorEnumeration;
import com.icl.saxon.tree.AttributeEnumeration;
import com.icl.saxon.tree.DescendantEnumeration;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.FollowingEnumeration;
import com.icl.saxon.tree.FollowingSiblingEnumeration;
import com.icl.saxon.tree.NamespaceEnumeration;
import com.icl.saxon.tree.ParentNodeImpl;
import com.icl.saxon.tree.PrecedingEnumeration;
import com.icl.saxon.tree.PrecedingOrAncestorEnumeration;
import com.icl.saxon.tree.PrecedingSiblingEnumeration;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class NodeImpl
extends AbstractNode {
    protected static NodeInfo[] emptyArray = new NodeInfo[0];
    protected ParentNodeImpl parent;
    protected int index;

    public void setSystemId(String string) {
        this.getParent().setSystemId(string);
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        return this == nodeInfo;
    }

    public int getNameCode() {
        return -1;
    }

    public int getFingerprint() {
        int n = this.getNameCode();
        if (n == -1) {
            return -1;
        }
        return n & 0xFFFFF;
    }

    public String generateId() {
        return "" + AbstractNode.NODE_LETTER[this.getNodeType()] + this.getSequenceNumber();
    }

    public Node getOriginatingNode() {
        return this;
    }

    public String getSystemId() {
        return this.parent.getSystemId();
    }

    public String getBaseURI() {
        return this.parent.getBaseURI();
    }

    protected long getSequenceNumber() {
        NodeImpl nodeImpl = this;
        int n = 0;
        while (!(nodeImpl instanceof ParentNodeImpl)) {
            nodeImpl = nodeImpl.getPreviousInDocument();
            ++n;
        }
        return nodeImpl.getSequenceNumber() + 65536L + (long)n;
    }

    public final int compareOrder(NodeInfo nodeInfo) {
        long l;
        long l2 = this.getSequenceNumber();
        if (l2 < (l = ((NodeImpl)nodeInfo).getSequenceNumber())) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        return 0;
    }

    public NamePool getNamePool() {
        return this.getDocumentRoot().getNamePool();
    }

    public String getPrefix() {
        int n = this.getNameCode();
        if (n == -1) {
            return "";
        }
        if ((n >> 20 & 0xFF) == 0) {
            return "";
        }
        return this.getNamePool().getPrefix(n);
    }

    public String getURI() {
        int n = this.getNameCode();
        if (n == -1) {
            return null;
        }
        return this.getNamePool().getURI(n);
    }

    public String getDisplayName() {
        int n = this.getNameCode();
        if (n == -1) {
            return "";
        }
        return this.getNamePool().getDisplayName(n);
    }

    public String getLocalName() {
        int n = this.getNameCode();
        if (n == -1) {
            return "";
        }
        return this.getNamePool().getLocalName(n);
    }

    public int getLineNumber() {
        return this.parent.getLineNumber();
    }

    public final NodeInfo getParent() {
        return this.parent;
    }

    public Node getPreviousSibling() {
        return this.parent.getNthChild(this.index - 1);
    }

    public Node getNextSibling() {
        return this.parent.getNthChild(this.index + 1);
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public AxisEnumeration getEnumeration(byte by, NodeTest nodeTest) {
        switch (by) {
            case 0: {
                return new AncestorEnumeration(this, nodeTest, false);
            }
            case 1: {
                return new AncestorEnumeration(this, nodeTest, true);
            }
            case 2: {
                if (this.getNodeType() != 1) {
                    return EmptyEnumeration.getInstance();
                }
                return new AttributeEnumeration(this, nodeTest);
            }
            case 3: {
                if (this instanceof ParentNodeImpl) {
                    return ((ParentNodeImpl)this).enumerateChildren(nodeTest);
                }
                return EmptyEnumeration.getInstance();
            }
            case 4: {
                if (this.getNodeType() == 9 && nodeTest instanceof NameTest && nodeTest.getNodeType() == 1) {
                    return ((DocumentImpl)this).getAllElements(((NameTest)nodeTest).getFingerprint());
                }
                if (this.hasChildNodes()) {
                    return new DescendantEnumeration(this, nodeTest, false);
                }
                return EmptyEnumeration.getInstance();
            }
            case 5: {
                return new DescendantEnumeration(this, nodeTest, true);
            }
            case 6: {
                return new FollowingEnumeration(this, nodeTest);
            }
            case 7: {
                return new FollowingSiblingEnumeration(this, nodeTest);
            }
            case 8: {
                if (this.getNodeType() != 1) {
                    return EmptyEnumeration.getInstance();
                }
                return new NamespaceEnumeration(this, nodeTest);
            }
            case 9: {
                NodeInfo nodeInfo = (NodeInfo)((Object)this.getParentNode());
                if (nodeInfo == null) {
                    return EmptyEnumeration.getInstance();
                }
                if (nodeTest.matches(nodeInfo)) {
                    return new SingletonEnumeration(nodeInfo);
                }
                return EmptyEnumeration.getInstance();
            }
            case 10: {
                return new PrecedingEnumeration(this, nodeTest);
            }
            case 11: {
                return new PrecedingSiblingEnumeration(this, nodeTest);
            }
            case 12: {
                if (nodeTest.matches(this)) {
                    return new SingletonEnumeration(this);
                }
                return EmptyEnumeration.getInstance();
            }
            case 13: {
                return new PrecedingOrAncestorEnumeration(this, nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public boolean hasAttributes() {
        return false;
    }

    public String getAttributeValue(String string, String string2) {
        return null;
    }

    public String getAttributeValue(int n) {
        return null;
    }

    public Element getDocumentElement() {
        return ((DocumentImpl)this.getDocumentRoot()).getDocumentElement();
    }

    public DocumentInfo getDocumentRoot() {
        return this.getParent().getDocumentRoot();
    }

    public NodeImpl getNextInDocument(NodeImpl nodeImpl) {
        NodeImpl nodeImpl2 = (NodeImpl)this.getFirstChild();
        if (nodeImpl2 != null) {
            return nodeImpl2;
        }
        if (this == nodeImpl) {
            return null;
        }
        nodeImpl2 = (NodeImpl)this.getNextSibling();
        if (nodeImpl2 != null) {
            return nodeImpl2;
        }
        NodeImpl nodeImpl3 = this;
        do {
            if ((nodeImpl3 = (NodeImpl)nodeImpl3.getParent()) == null) {
                return null;
            }
            if (nodeImpl3 != nodeImpl) continue;
            return null;
        } while ((nodeImpl2 = (NodeImpl)nodeImpl3.getNextSibling()) == null);
        return nodeImpl2;
    }

    public NodeImpl getPreviousInDocument() {
        NodeImpl nodeImpl = (NodeImpl)this.getPreviousSibling();
        if (nodeImpl != null) {
            return nodeImpl.getLastDescendantOrSelf();
        }
        return (NodeImpl)this.getParentNode();
    }

    private NodeImpl getLastDescendantOrSelf() {
        NodeImpl nodeImpl = (NodeImpl)this.getLastChild();
        if (nodeImpl == null) {
            return this;
        }
        return nodeImpl.getLastDescendantOrSelf();
    }

    public void outputNamespaceNodes(Outputter outputter, boolean bl) throws TransformerException {
    }

    public void removeNode() {
        this.parent.removeChild(this.index);
    }

    public NodeList getChildNodes() {
        try {
            return new NodeSetExtent(EmptyEnumeration.getInstance(), null);
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }
}

