/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.instance.core.internal;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.karaf.instance.core.Instance;
import org.apache.karaf.instance.core.internal.InstanceServiceImpl;

public class InstanceImpl
implements Instance {
    private final InstanceServiceImpl service;
    private String name;

    public InstanceImpl(InstanceServiceImpl service, String name) {
        this.service = service;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void doSetName(String name) {
        this.name = name;
    }

    @Override
    public boolean isRoot() {
        return this.service.isInstanceRoot(this.name);
    }

    @Override
    public String getLocation() {
        return this.service.getInstanceLocation(this.name);
    }

    @Override
    public int getPid() {
        return this.service.getInstancePid(this.name);
    }

    @Override
    public int getSshPort() {
        return this.service.getInstanceSshPort(this.name);
    }

    @Override
    public String getSshHost() {
        return this.service.getInstanceSshHost(this.name);
    }

    @Override
    public void changeSshPort(int port) throws Exception {
        this.service.changeInstanceSshPort(this.name, port);
    }

    @Override
    public int getRmiRegistryPort() {
        return this.service.getInstanceRmiRegistryPort(this.name);
    }

    @Override
    public void changeRmiRegistryPort(int port) throws Exception {
        this.service.changeInstanceRmiRegistryPort(this.name, port);
    }

    @Override
    public String getRmiRegistryHost() {
        return this.service.getInstanceRmiRegistryHost(this.name);
    }

    @Override
    public int getRmiServerPort() {
        return this.service.getInstanceRmiServerPort(this.name);
    }

    @Override
    public void changeRmiServerPort(int port) throws Exception {
        this.service.changeInstanceRmiServerPort(this.name, port);
    }

    @Override
    public String getRmiServerHost() {
        return this.service.getInstanceRmiServerHost(this.name);
    }

    @Override
    public String getJavaOpts() {
        return this.service.getInstanceJavaOpts(this.name);
    }

    @Override
    public void changeJavaOpts(String javaOpts) throws Exception {
        this.service.changeInstanceJavaOpts(this.name, javaOpts);
    }

    @Override
    public void restart(String javaOpts) throws Exception {
        this.service.restartInstance(this.name, javaOpts);
    }

    @Override
    public void start(String javaOpts) throws Exception {
        this.service.startInstance(this.name, javaOpts);
    }

    @Override
    public void stop() throws Exception {
        this.service.stopInstance(this.name);
    }

    @Override
    public void destroy() throws Exception {
        this.service.destroyInstance(this.name);
    }

    @Override
    public String getState() throws Exception {
        return this.service.getInstanceState(this.name);
    }

    @Override
    public void changeSshHost(String host) throws Exception {
        this.service.changeInstanceSshHost(this.name, host);
    }

    @Override
    public void packageInZip(String destination) throws Exception {
        final Path sourcePath = Paths.get(this.getLocation(), new String[0]);
        final Path destinationPath = Paths.get(destination, new String[0]).normalize();
        try (final ZipOutputStream zOut = new ZipOutputStream(new FileOutputStream(destination.toString()));){
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    if (attributes.isSymbolicLink()) {
                        return FileVisitResult.CONTINUE;
                    }
                    String entryName = sourcePath.relativize(file).toString();
                    if (Paths.get(entryName, new String[0]).normalize().equals(destinationPath)) {
                        return FileVisitResult.CONTINUE;
                    }
                    ZipEntry zipEntry = new ZipEntry(entryName);
                    System.out.println(entryName);
                    zOut.putNextEntry(zipEntry);
                    Files.copy(file, zOut);
                    zOut.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

