/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.net.InetAddress;
import javax.servlet.Servlet;
import org.jupnp.transport.Router;
import org.jupnp.transport.impl.ServletStreamServerConfigurationImpl;
import org.jupnp.transport.impl.async.AsyncServlet;
import org.jupnp.transport.impl.async.AsyncUtil;
import org.jupnp.transport.impl.blocking.BlockingServlet;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.StreamServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletStreamServerImpl
implements StreamServer<ServletStreamServerConfigurationImpl> {
    private final Logger logger = LoggerFactory.getLogger(ServletStreamServerImpl.class);
    protected final ServletStreamServerConfigurationImpl configuration;
    protected int localPort;

    public ServletStreamServerImpl(ServletStreamServerConfigurationImpl configuration) {
        this.configuration = configuration;
    }

    @Override
    public ServletStreamServerConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @Override
    public synchronized void init(InetAddress bindAddress, Router router) throws InitializationException {
        try {
            this.logger.debug("Setting executor service on servlet container adapter");
            this.getConfiguration().getServletContainerAdapter().setExecutorService(router.getConfiguration().getStreamServerExecutorService());
            this.logger.debug("Adding connector: {}:{}", (Object)bindAddress, (Object)this.getConfiguration().getListenPort());
            this.localPort = this.getConfiguration().getServletContainerAdapter().addConnector(bindAddress.getHostAddress(), this.getConfiguration().getListenPort());
            String contextPath = router.getConfiguration().getNamespace().getBasePath().getPath();
            Servlet servlet = AsyncUtil.SERVLET3_SUPPORT ? this.createAsyncServlet(router) : this.createBlockingServlet(router);
            this.getConfiguration().getServletContainerAdapter().registerServlet(contextPath, servlet);
        }
        catch (Exception e) {
            throw new InitializationException("Could not initialize " + this.getClass().getSimpleName(), e);
        }
    }

    @Override
    public synchronized int getPort() {
        return this.localPort;
    }

    @Override
    public synchronized void stop() {
        this.getConfiguration().getServletContainerAdapter().stopIfRunning();
    }

    @Override
    public void run() {
        this.getConfiguration().getServletContainerAdapter().startIfNotRunning();
    }

    protected Servlet createAsyncServlet(Router router) {
        return new AsyncServlet(router, this.getConfiguration());
    }

    protected Servlet createBlockingServlet(Router router) {
        return new BlockingServlet(router, this.getConfiguration());
    }
}

