/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// ZeroSSLTargetDetails ZeroSSLTargetDetails
type ZeroSSLTargetDetails struct {
	ApiKey *string `json:"api_key,omitempty"`
	ImapFqdn *string `json:"imap_fqdn,omitempty"`
	ImapPassword *string `json:"imap_password,omitempty"`
	ImapPort *string `json:"imap_port,omitempty"`
	ImapUser *string `json:"imap_user,omitempty"`
	// A Duration represents the elapsed time between two instants as an int64 nanosecond count. The representation limits the largest representable duration to approximately 290 years.
	Timeout *int64 `json:"timeout,omitempty"`
	ValidationEmail *string `json:"validation_email,omitempty"`
}

// NewZeroSSLTargetDetails instantiates a new ZeroSSLTargetDetails object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewZeroSSLTargetDetails() *ZeroSSLTargetDetails {
	this := ZeroSSLTargetDetails{}
	return &this
}

// NewZeroSSLTargetDetailsWithDefaults instantiates a new ZeroSSLTargetDetails object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewZeroSSLTargetDetailsWithDefaults() *ZeroSSLTargetDetails {
	this := ZeroSSLTargetDetails{}
	return &this
}

// GetApiKey returns the ApiKey field value if set, zero value otherwise.
func (o *ZeroSSLTargetDetails) GetApiKey() string {
	if o == nil || o.ApiKey == nil {
		var ret string
		return ret
	}
	return *o.ApiKey
}

// GetApiKeyOk returns a tuple with the ApiKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ZeroSSLTargetDetails) GetApiKeyOk() (*string, bool) {
	if o == nil || o.ApiKey == nil {
		return nil, false
	}
	return o.ApiKey, true
}

// HasApiKey returns a boolean if a field has been set.
func (o *ZeroSSLTargetDetails) HasApiKey() bool {
	if o != nil && o.ApiKey != nil {
		return true
	}

	return false
}

// SetApiKey gets a reference to the given string and assigns it to the ApiKey field.
func (o *ZeroSSLTargetDetails) SetApiKey(v string) {
	o.ApiKey = &v
}

// GetImapFqdn returns the ImapFqdn field value if set, zero value otherwise.
func (o *ZeroSSLTargetDetails) GetImapFqdn() string {
	if o == nil || o.ImapFqdn == nil {
		var ret string
		return ret
	}
	return *o.ImapFqdn
}

// GetImapFqdnOk returns a tuple with the ImapFqdn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ZeroSSLTargetDetails) GetImapFqdnOk() (*string, bool) {
	if o == nil || o.ImapFqdn == nil {
		return nil, false
	}
	return o.ImapFqdn, true
}

// HasImapFqdn returns a boolean if a field has been set.
func (o *ZeroSSLTargetDetails) HasImapFqdn() bool {
	if o != nil && o.ImapFqdn != nil {
		return true
	}

	return false
}

// SetImapFqdn gets a reference to the given string and assigns it to the ImapFqdn field.
func (o *ZeroSSLTargetDetails) SetImapFqdn(v string) {
	o.ImapFqdn = &v
}

// GetImapPassword returns the ImapPassword field value if set, zero value otherwise.
func (o *ZeroSSLTargetDetails) GetImapPassword() string {
	if o == nil || o.ImapPassword == nil {
		var ret string
		return ret
	}
	return *o.ImapPassword
}

// GetImapPasswordOk returns a tuple with the ImapPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ZeroSSLTargetDetails) GetImapPasswordOk() (*string, bool) {
	if o == nil || o.ImapPassword == nil {
		return nil, false
	}
	return o.ImapPassword, true
}

// HasImapPassword returns a boolean if a field has been set.
func (o *ZeroSSLTargetDetails) HasImapPassword() bool {
	if o != nil && o.ImapPassword != nil {
		return true
	}

	return false
}

// SetImapPassword gets a reference to the given string and assigns it to the ImapPassword field.
func (o *ZeroSSLTargetDetails) SetImapPassword(v string) {
	o.ImapPassword = &v
}

// GetImapPort returns the ImapPort field value if set, zero value otherwise.
func (o *ZeroSSLTargetDetails) GetImapPort() string {
	if o == nil || o.ImapPort == nil {
		var ret string
		return ret
	}
	return *o.ImapPort
}

// GetImapPortOk returns a tuple with the ImapPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ZeroSSLTargetDetails) GetImapPortOk() (*string, bool) {
	if o == nil || o.ImapPort == nil {
		return nil, false
	}
	return o.ImapPort, true
}

// HasImapPort returns a boolean if a field has been set.
func (o *ZeroSSLTargetDetails) HasImapPort() bool {
	if o != nil && o.ImapPort != nil {
		return true
	}

	return false
}

// SetImapPort gets a reference to the given string and assigns it to the ImapPort field.
func (o *ZeroSSLTargetDetails) SetImapPort(v string) {
	o.ImapPort = &v
}

// GetImapUser returns the ImapUser field value if set, zero value otherwise.
func (o *ZeroSSLTargetDetails) GetImapUser() string {
	if o == nil || o.ImapUser == nil {
		var ret string
		return ret
	}
	return *o.ImapUser
}

// GetImapUserOk returns a tuple with the ImapUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ZeroSSLTargetDetails) GetImapUserOk() (*string, bool) {
	if o == nil || o.ImapUser == nil {
		return nil, false
	}
	return o.ImapUser, true
}

// HasImapUser returns a boolean if a field has been set.
func (o *ZeroSSLTargetDetails) HasImapUser() bool {
	if o != nil && o.ImapUser != nil {
		return true
	}

	return false
}

// SetImapUser gets a reference to the given string and assigns it to the ImapUser field.
func (o *ZeroSSLTargetDetails) SetImapUser(v string) {
	o.ImapUser = &v
}

// GetTimeout returns the Timeout field value if set, zero value otherwise.
func (o *ZeroSSLTargetDetails) GetTimeout() int64 {
	if o == nil || o.Timeout == nil {
		var ret int64
		return ret
	}
	return *o.Timeout
}

// GetTimeoutOk returns a tuple with the Timeout field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ZeroSSLTargetDetails) GetTimeoutOk() (*int64, bool) {
	if o == nil || o.Timeout == nil {
		return nil, false
	}
	return o.Timeout, true
}

// HasTimeout returns a boolean if a field has been set.
func (o *ZeroSSLTargetDetails) HasTimeout() bool {
	if o != nil && o.Timeout != nil {
		return true
	}

	return false
}

// SetTimeout gets a reference to the given int64 and assigns it to the Timeout field.
func (o *ZeroSSLTargetDetails) SetTimeout(v int64) {
	o.Timeout = &v
}

// GetValidationEmail returns the ValidationEmail field value if set, zero value otherwise.
func (o *ZeroSSLTargetDetails) GetValidationEmail() string {
	if o == nil || o.ValidationEmail == nil {
		var ret string
		return ret
	}
	return *o.ValidationEmail
}

// GetValidationEmailOk returns a tuple with the ValidationEmail field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ZeroSSLTargetDetails) GetValidationEmailOk() (*string, bool) {
	if o == nil || o.ValidationEmail == nil {
		return nil, false
	}
	return o.ValidationEmail, true
}

// HasValidationEmail returns a boolean if a field has been set.
func (o *ZeroSSLTargetDetails) HasValidationEmail() bool {
	if o != nil && o.ValidationEmail != nil {
		return true
	}

	return false
}

// SetValidationEmail gets a reference to the given string and assigns it to the ValidationEmail field.
func (o *ZeroSSLTargetDetails) SetValidationEmail(v string) {
	o.ValidationEmail = &v
}

func (o ZeroSSLTargetDetails) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ApiKey != nil {
		toSerialize["api_key"] = o.ApiKey
	}
	if o.ImapFqdn != nil {
		toSerialize["imap_fqdn"] = o.ImapFqdn
	}
	if o.ImapPassword != nil {
		toSerialize["imap_password"] = o.ImapPassword
	}
	if o.ImapPort != nil {
		toSerialize["imap_port"] = o.ImapPort
	}
	if o.ImapUser != nil {
		toSerialize["imap_user"] = o.ImapUser
	}
	if o.Timeout != nil {
		toSerialize["timeout"] = o.Timeout
	}
	if o.ValidationEmail != nil {
		toSerialize["validation_email"] = o.ValidationEmail
	}
	return json.Marshal(toSerialize)
}

type NullableZeroSSLTargetDetails struct {
	value *ZeroSSLTargetDetails
	isSet bool
}

func (v NullableZeroSSLTargetDetails) Get() *ZeroSSLTargetDetails {
	return v.value
}

func (v *NullableZeroSSLTargetDetails) Set(val *ZeroSSLTargetDetails) {
	v.value = val
	v.isSet = true
}

func (v NullableZeroSSLTargetDetails) IsSet() bool {
	return v.isSet
}

func (v *NullableZeroSSLTargetDetails) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableZeroSSLTargetDetails(val *ZeroSSLTargetDetails) *NullableZeroSSLTargetDetails {
	return &NullableZeroSSLTargetDetails{value: val, isSet: true}
}

func (v NullableZeroSSLTargetDetails) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableZeroSSLTargetDetails) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


