/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// UpdateItem struct for UpdateItem
type UpdateItem struct {
	ProviderType *string `json:"ProviderType,omitempty"`
	// for personal password manager
	Accessibility *string `json:"accessibility,omitempty"`
	// List of the new tags that will be attached to this item
	AddTag *[]string `json:"add-tag,omitempty"`
	// PEM Certificate in a Base64 format. Used for updating RSA keys' certificates.
	CertFileData *string `json:"cert-file-data,omitempty"`
	CertificateFormat *string `json:"certificate-format,omitempty"`
	// Trigger an event when a secret value changed [true/false] (Relevant only for Static Secret)
	ChangeEvent *string `json:"change-event,omitempty"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// How many days before the expiration of the certificate would you like to be notified.
	ExpirationEventIn *[]string `json:"expiration-event-in,omitempty"`
	// Host provider type [explicit/target], Default Host provider is explicit, Relevant only for Secure Remote Access of ssh cert issuer, ldap rotated secret and ldap dynamic secret
	HostProvider *string `json:"host-provider,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Current item name
	Name string `json:"name"`
	// Deprecated - use description
	NewMetadata *string `json:"new-metadata,omitempty"`
	// New item name
	NewName *string `json:"new-name,omitempty"`
	// List of the existent tags that will be removed from this item
	RmTag *[]string `json:"rm-tag,omitempty"`
	// Rotate the value of the secret after SRA session ends [true/false]
	RotateAfterDisconnect *string `json:"rotate-after-disconnect,omitempty"`
	// List of the new hosts that will be attached to SRA servers host
	SecureAccessAddHost *[]string `json:"secure-access-add-host,omitempty"`
	// Allow providing external user for a domain users [true/false]
	SecureAccessAllowExternalUser *string `json:"secure-access-allow-external-user,omitempty"`
	// Enable Port forwarding while using CLI access (relevant only for EKS/GKE/K8s Dynamic-Secret)
	SecureAccessAllowPortForwading *bool `json:"secure-access-allow-port-forwading,omitempty"`
	// The AWS account id (relevant only for aws)
	SecureAccessAwsAccountId *string `json:"secure-access-aws-account-id,omitempty"`
	// The AWS native cli (relevant only for aws)
	SecureAccessAwsNativeCli *bool `json:"secure-access-aws-native-cli,omitempty"`
	// The AWS region (relevant only for aws)
	SecureAccessAwsRegion *string `json:"secure-access-aws-region,omitempty"`
	// Bastion's SSH control API endpoint. E.g. https://my.bastion:9900 (relevant only for ssh cert issuer)
	SecureAccessBastionApi *string `json:"secure-access-bastion-api,omitempty"`
	// Path to the SSH Certificate Issuer for your Akeyless Bastion
	SecureAccessBastionIssuer *string `json:"secure-access-bastion-issuer,omitempty"`
	// Bastion's SSH server. E.g. my.bastion:22 (relevant only for ssh cert issuer)
	SecureAccessBastionSsh *string `json:"secure-access-bastion-ssh,omitempty"`
	// The K8s cluster endpoint URL (relevant only for EKS/GKE/K8s Dynamic-Secret)
	SecureAccessClusterEndpoint *string `json:"secure-access-cluster-endpoint,omitempty"`
	// The K8s dashboard url (relevant only for k8s)
	SecureAccessDashboardUrl *string `json:"secure-access-dashboard-url,omitempty"`
	// The DB name (relevant only for DB Dynamic-Secret)
	SecureAccessDbName *string `json:"secure-access-db-name,omitempty"`
	// The DB schema (relevant only for DB Dynamic-Secret)
	SecureAccessDbSchema *string `json:"secure-access-db-schema,omitempty"`
	// Enable/Disable secure remote access [true/false]
	SecureAccessEnable *string `json:"secure-access-enable,omitempty"`
	// Target servers for connections (In case of Linked Target association, host(s) will inherit Linked Target hosts - Relevant only for Dynamic Secrets/producers)
	SecureAccessHost *[]string `json:"secure-access-host,omitempty"`
	// RD Gateway server (relevant only for rdp)
	SecureAccessRdGatewayServer *string `json:"secure-access-rd-gateway-server,omitempty"`
	// Required when the Dynamic Secret is used for a domain user (relevant only for RDP Dynamic-Secret)
	SecureAccessRdpDomain *string `json:"secure-access-rdp-domain,omitempty"`
	// Override the RDP Domain username
	SecureAccessRdpUser *string `json:"secure-access-rdp-user,omitempty"`
	// List of the existent hosts that will be removed from SRA servers host
	SecureAccessRmHost *[]string `json:"secure-access-rm-host,omitempty"`
	// Secret values contains SSH Credentials, either Private Key or Password [password/private-key] (relevant only for Static-Secret or Rotated-secret)
	SecureAccessSshCreds *string `json:"secure-access-ssh-creds,omitempty"`
	// SSH username to connect to target server, must be in 'Allowed Users' list (relevant only for ssh cert issuer)
	SecureAccessSshCredsUser *string `json:"secure-access-ssh-creds-user,omitempty"`
	// Destination URL to inject secrets
	SecureAccessUrl *string `json:"secure-access-url,omitempty"`
	// Use internal SSH Bastion
	SecureAccessUseInternalBastion *bool `json:"secure-access-use-internal-bastion,omitempty"`
	// Secure browser via Akeyless Web Access Bastion
	SecureAccessWebBrowsing *bool `json:"secure-access-web-browsing,omitempty"`
	// Web-Proxy via Akeyless Web Access Bastion
	SecureAccessWebProxy *bool `json:"secure-access-web-proxy,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewUpdateItem instantiates a new UpdateItem object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateItem(name string, ) *UpdateItem {
	this := UpdateItem{}
	var accessibility string = "regular"
	this.Accessibility = &accessibility
	var description string = "default_metadata"
	this.Description = &description
	var json bool = false
	this.Json = &json
	this.Name = name
	var newMetadata string = "default_metadata"
	this.NewMetadata = &newMetadata
	var rotateAfterDisconnect string = "false"
	this.RotateAfterDisconnect = &rotateAfterDisconnect
	var secureAccessWebBrowsing bool = false
	this.SecureAccessWebBrowsing = &secureAccessWebBrowsing
	var secureAccessWebProxy bool = false
	this.SecureAccessWebProxy = &secureAccessWebProxy
	return &this
}

// NewUpdateItemWithDefaults instantiates a new UpdateItem object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateItemWithDefaults() *UpdateItem {
	this := UpdateItem{}
	var accessibility string = "regular"
	this.Accessibility = &accessibility
	var description string = "default_metadata"
	this.Description = &description
	var json bool = false
	this.Json = &json
	var newMetadata string = "default_metadata"
	this.NewMetadata = &newMetadata
	var rotateAfterDisconnect string = "false"
	this.RotateAfterDisconnect = &rotateAfterDisconnect
	var secureAccessWebBrowsing bool = false
	this.SecureAccessWebBrowsing = &secureAccessWebBrowsing
	var secureAccessWebProxy bool = false
	this.SecureAccessWebProxy = &secureAccessWebProxy
	return &this
}

// GetProviderType returns the ProviderType field value if set, zero value otherwise.
func (o *UpdateItem) GetProviderType() string {
	if o == nil || o.ProviderType == nil {
		var ret string
		return ret
	}
	return *o.ProviderType
}

// GetProviderTypeOk returns a tuple with the ProviderType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetProviderTypeOk() (*string, bool) {
	if o == nil || o.ProviderType == nil {
		return nil, false
	}
	return o.ProviderType, true
}

// HasProviderType returns a boolean if a field has been set.
func (o *UpdateItem) HasProviderType() bool {
	if o != nil && o.ProviderType != nil {
		return true
	}

	return false
}

// SetProviderType gets a reference to the given string and assigns it to the ProviderType field.
func (o *UpdateItem) SetProviderType(v string) {
	o.ProviderType = &v
}

// GetAccessibility returns the Accessibility field value if set, zero value otherwise.
func (o *UpdateItem) GetAccessibility() string {
	if o == nil || o.Accessibility == nil {
		var ret string
		return ret
	}
	return *o.Accessibility
}

// GetAccessibilityOk returns a tuple with the Accessibility field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetAccessibilityOk() (*string, bool) {
	if o == nil || o.Accessibility == nil {
		return nil, false
	}
	return o.Accessibility, true
}

// HasAccessibility returns a boolean if a field has been set.
func (o *UpdateItem) HasAccessibility() bool {
	if o != nil && o.Accessibility != nil {
		return true
	}

	return false
}

// SetAccessibility gets a reference to the given string and assigns it to the Accessibility field.
func (o *UpdateItem) SetAccessibility(v string) {
	o.Accessibility = &v
}

// GetAddTag returns the AddTag field value if set, zero value otherwise.
func (o *UpdateItem) GetAddTag() []string {
	if o == nil || o.AddTag == nil {
		var ret []string
		return ret
	}
	return *o.AddTag
}

// GetAddTagOk returns a tuple with the AddTag field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetAddTagOk() (*[]string, bool) {
	if o == nil || o.AddTag == nil {
		return nil, false
	}
	return o.AddTag, true
}

// HasAddTag returns a boolean if a field has been set.
func (o *UpdateItem) HasAddTag() bool {
	if o != nil && o.AddTag != nil {
		return true
	}

	return false
}

// SetAddTag gets a reference to the given []string and assigns it to the AddTag field.
func (o *UpdateItem) SetAddTag(v []string) {
	o.AddTag = &v
}

// GetCertFileData returns the CertFileData field value if set, zero value otherwise.
func (o *UpdateItem) GetCertFileData() string {
	if o == nil || o.CertFileData == nil {
		var ret string
		return ret
	}
	return *o.CertFileData
}

// GetCertFileDataOk returns a tuple with the CertFileData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetCertFileDataOk() (*string, bool) {
	if o == nil || o.CertFileData == nil {
		return nil, false
	}
	return o.CertFileData, true
}

// HasCertFileData returns a boolean if a field has been set.
func (o *UpdateItem) HasCertFileData() bool {
	if o != nil && o.CertFileData != nil {
		return true
	}

	return false
}

// SetCertFileData gets a reference to the given string and assigns it to the CertFileData field.
func (o *UpdateItem) SetCertFileData(v string) {
	o.CertFileData = &v
}

// GetCertificateFormat returns the CertificateFormat field value if set, zero value otherwise.
func (o *UpdateItem) GetCertificateFormat() string {
	if o == nil || o.CertificateFormat == nil {
		var ret string
		return ret
	}
	return *o.CertificateFormat
}

// GetCertificateFormatOk returns a tuple with the CertificateFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetCertificateFormatOk() (*string, bool) {
	if o == nil || o.CertificateFormat == nil {
		return nil, false
	}
	return o.CertificateFormat, true
}

// HasCertificateFormat returns a boolean if a field has been set.
func (o *UpdateItem) HasCertificateFormat() bool {
	if o != nil && o.CertificateFormat != nil {
		return true
	}

	return false
}

// SetCertificateFormat gets a reference to the given string and assigns it to the CertificateFormat field.
func (o *UpdateItem) SetCertificateFormat(v string) {
	o.CertificateFormat = &v
}

// GetChangeEvent returns the ChangeEvent field value if set, zero value otherwise.
func (o *UpdateItem) GetChangeEvent() string {
	if o == nil || o.ChangeEvent == nil {
		var ret string
		return ret
	}
	return *o.ChangeEvent
}

// GetChangeEventOk returns a tuple with the ChangeEvent field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetChangeEventOk() (*string, bool) {
	if o == nil || o.ChangeEvent == nil {
		return nil, false
	}
	return o.ChangeEvent, true
}

// HasChangeEvent returns a boolean if a field has been set.
func (o *UpdateItem) HasChangeEvent() bool {
	if o != nil && o.ChangeEvent != nil {
		return true
	}

	return false
}

// SetChangeEvent gets a reference to the given string and assigns it to the ChangeEvent field.
func (o *UpdateItem) SetChangeEvent(v string) {
	o.ChangeEvent = &v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *UpdateItem) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *UpdateItem) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *UpdateItem) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *UpdateItem) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *UpdateItem) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *UpdateItem) SetDescription(v string) {
	o.Description = &v
}

// GetExpirationEventIn returns the ExpirationEventIn field value if set, zero value otherwise.
func (o *UpdateItem) GetExpirationEventIn() []string {
	if o == nil || o.ExpirationEventIn == nil {
		var ret []string
		return ret
	}
	return *o.ExpirationEventIn
}

// GetExpirationEventInOk returns a tuple with the ExpirationEventIn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetExpirationEventInOk() (*[]string, bool) {
	if o == nil || o.ExpirationEventIn == nil {
		return nil, false
	}
	return o.ExpirationEventIn, true
}

// HasExpirationEventIn returns a boolean if a field has been set.
func (o *UpdateItem) HasExpirationEventIn() bool {
	if o != nil && o.ExpirationEventIn != nil {
		return true
	}

	return false
}

// SetExpirationEventIn gets a reference to the given []string and assigns it to the ExpirationEventIn field.
func (o *UpdateItem) SetExpirationEventIn(v []string) {
	o.ExpirationEventIn = &v
}

// GetHostProvider returns the HostProvider field value if set, zero value otherwise.
func (o *UpdateItem) GetHostProvider() string {
	if o == nil || o.HostProvider == nil {
		var ret string
		return ret
	}
	return *o.HostProvider
}

// GetHostProviderOk returns a tuple with the HostProvider field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetHostProviderOk() (*string, bool) {
	if o == nil || o.HostProvider == nil {
		return nil, false
	}
	return o.HostProvider, true
}

// HasHostProvider returns a boolean if a field has been set.
func (o *UpdateItem) HasHostProvider() bool {
	if o != nil && o.HostProvider != nil {
		return true
	}

	return false
}

// SetHostProvider gets a reference to the given string and assigns it to the HostProvider field.
func (o *UpdateItem) SetHostProvider(v string) {
	o.HostProvider = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *UpdateItem) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *UpdateItem) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *UpdateItem) SetJson(v bool) {
	o.Json = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *UpdateItem) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *UpdateItem) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *UpdateItem) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *UpdateItem) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *UpdateItem) SetName(v string) {
	o.Name = v
}

// GetNewMetadata returns the NewMetadata field value if set, zero value otherwise.
func (o *UpdateItem) GetNewMetadata() string {
	if o == nil || o.NewMetadata == nil {
		var ret string
		return ret
	}
	return *o.NewMetadata
}

// GetNewMetadataOk returns a tuple with the NewMetadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetNewMetadataOk() (*string, bool) {
	if o == nil || o.NewMetadata == nil {
		return nil, false
	}
	return o.NewMetadata, true
}

// HasNewMetadata returns a boolean if a field has been set.
func (o *UpdateItem) HasNewMetadata() bool {
	if o != nil && o.NewMetadata != nil {
		return true
	}

	return false
}

// SetNewMetadata gets a reference to the given string and assigns it to the NewMetadata field.
func (o *UpdateItem) SetNewMetadata(v string) {
	o.NewMetadata = &v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *UpdateItem) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *UpdateItem) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *UpdateItem) SetNewName(v string) {
	o.NewName = &v
}

// GetRmTag returns the RmTag field value if set, zero value otherwise.
func (o *UpdateItem) GetRmTag() []string {
	if o == nil || o.RmTag == nil {
		var ret []string
		return ret
	}
	return *o.RmTag
}

// GetRmTagOk returns a tuple with the RmTag field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetRmTagOk() (*[]string, bool) {
	if o == nil || o.RmTag == nil {
		return nil, false
	}
	return o.RmTag, true
}

// HasRmTag returns a boolean if a field has been set.
func (o *UpdateItem) HasRmTag() bool {
	if o != nil && o.RmTag != nil {
		return true
	}

	return false
}

// SetRmTag gets a reference to the given []string and assigns it to the RmTag field.
func (o *UpdateItem) SetRmTag(v []string) {
	o.RmTag = &v
}

// GetRotateAfterDisconnect returns the RotateAfterDisconnect field value if set, zero value otherwise.
func (o *UpdateItem) GetRotateAfterDisconnect() string {
	if o == nil || o.RotateAfterDisconnect == nil {
		var ret string
		return ret
	}
	return *o.RotateAfterDisconnect
}

// GetRotateAfterDisconnectOk returns a tuple with the RotateAfterDisconnect field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetRotateAfterDisconnectOk() (*string, bool) {
	if o == nil || o.RotateAfterDisconnect == nil {
		return nil, false
	}
	return o.RotateAfterDisconnect, true
}

// HasRotateAfterDisconnect returns a boolean if a field has been set.
func (o *UpdateItem) HasRotateAfterDisconnect() bool {
	if o != nil && o.RotateAfterDisconnect != nil {
		return true
	}

	return false
}

// SetRotateAfterDisconnect gets a reference to the given string and assigns it to the RotateAfterDisconnect field.
func (o *UpdateItem) SetRotateAfterDisconnect(v string) {
	o.RotateAfterDisconnect = &v
}

// GetSecureAccessAddHost returns the SecureAccessAddHost field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessAddHost() []string {
	if o == nil || o.SecureAccessAddHost == nil {
		var ret []string
		return ret
	}
	return *o.SecureAccessAddHost
}

// GetSecureAccessAddHostOk returns a tuple with the SecureAccessAddHost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessAddHostOk() (*[]string, bool) {
	if o == nil || o.SecureAccessAddHost == nil {
		return nil, false
	}
	return o.SecureAccessAddHost, true
}

// HasSecureAccessAddHost returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessAddHost() bool {
	if o != nil && o.SecureAccessAddHost != nil {
		return true
	}

	return false
}

// SetSecureAccessAddHost gets a reference to the given []string and assigns it to the SecureAccessAddHost field.
func (o *UpdateItem) SetSecureAccessAddHost(v []string) {
	o.SecureAccessAddHost = &v
}

// GetSecureAccessAllowExternalUser returns the SecureAccessAllowExternalUser field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessAllowExternalUser() string {
	if o == nil || o.SecureAccessAllowExternalUser == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessAllowExternalUser
}

// GetSecureAccessAllowExternalUserOk returns a tuple with the SecureAccessAllowExternalUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessAllowExternalUserOk() (*string, bool) {
	if o == nil || o.SecureAccessAllowExternalUser == nil {
		return nil, false
	}
	return o.SecureAccessAllowExternalUser, true
}

// HasSecureAccessAllowExternalUser returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessAllowExternalUser() bool {
	if o != nil && o.SecureAccessAllowExternalUser != nil {
		return true
	}

	return false
}

// SetSecureAccessAllowExternalUser gets a reference to the given string and assigns it to the SecureAccessAllowExternalUser field.
func (o *UpdateItem) SetSecureAccessAllowExternalUser(v string) {
	o.SecureAccessAllowExternalUser = &v
}

// GetSecureAccessAllowPortForwading returns the SecureAccessAllowPortForwading field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessAllowPortForwading() bool {
	if o == nil || o.SecureAccessAllowPortForwading == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessAllowPortForwading
}

// GetSecureAccessAllowPortForwadingOk returns a tuple with the SecureAccessAllowPortForwading field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessAllowPortForwadingOk() (*bool, bool) {
	if o == nil || o.SecureAccessAllowPortForwading == nil {
		return nil, false
	}
	return o.SecureAccessAllowPortForwading, true
}

// HasSecureAccessAllowPortForwading returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessAllowPortForwading() bool {
	if o != nil && o.SecureAccessAllowPortForwading != nil {
		return true
	}

	return false
}

// SetSecureAccessAllowPortForwading gets a reference to the given bool and assigns it to the SecureAccessAllowPortForwading field.
func (o *UpdateItem) SetSecureAccessAllowPortForwading(v bool) {
	o.SecureAccessAllowPortForwading = &v
}

// GetSecureAccessAwsAccountId returns the SecureAccessAwsAccountId field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessAwsAccountId() string {
	if o == nil || o.SecureAccessAwsAccountId == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessAwsAccountId
}

// GetSecureAccessAwsAccountIdOk returns a tuple with the SecureAccessAwsAccountId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessAwsAccountIdOk() (*string, bool) {
	if o == nil || o.SecureAccessAwsAccountId == nil {
		return nil, false
	}
	return o.SecureAccessAwsAccountId, true
}

// HasSecureAccessAwsAccountId returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessAwsAccountId() bool {
	if o != nil && o.SecureAccessAwsAccountId != nil {
		return true
	}

	return false
}

// SetSecureAccessAwsAccountId gets a reference to the given string and assigns it to the SecureAccessAwsAccountId field.
func (o *UpdateItem) SetSecureAccessAwsAccountId(v string) {
	o.SecureAccessAwsAccountId = &v
}

// GetSecureAccessAwsNativeCli returns the SecureAccessAwsNativeCli field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessAwsNativeCli() bool {
	if o == nil || o.SecureAccessAwsNativeCli == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessAwsNativeCli
}

// GetSecureAccessAwsNativeCliOk returns a tuple with the SecureAccessAwsNativeCli field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessAwsNativeCliOk() (*bool, bool) {
	if o == nil || o.SecureAccessAwsNativeCli == nil {
		return nil, false
	}
	return o.SecureAccessAwsNativeCli, true
}

// HasSecureAccessAwsNativeCli returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessAwsNativeCli() bool {
	if o != nil && o.SecureAccessAwsNativeCli != nil {
		return true
	}

	return false
}

// SetSecureAccessAwsNativeCli gets a reference to the given bool and assigns it to the SecureAccessAwsNativeCli field.
func (o *UpdateItem) SetSecureAccessAwsNativeCli(v bool) {
	o.SecureAccessAwsNativeCli = &v
}

// GetSecureAccessAwsRegion returns the SecureAccessAwsRegion field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessAwsRegion() string {
	if o == nil || o.SecureAccessAwsRegion == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessAwsRegion
}

// GetSecureAccessAwsRegionOk returns a tuple with the SecureAccessAwsRegion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessAwsRegionOk() (*string, bool) {
	if o == nil || o.SecureAccessAwsRegion == nil {
		return nil, false
	}
	return o.SecureAccessAwsRegion, true
}

// HasSecureAccessAwsRegion returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessAwsRegion() bool {
	if o != nil && o.SecureAccessAwsRegion != nil {
		return true
	}

	return false
}

// SetSecureAccessAwsRegion gets a reference to the given string and assigns it to the SecureAccessAwsRegion field.
func (o *UpdateItem) SetSecureAccessAwsRegion(v string) {
	o.SecureAccessAwsRegion = &v
}

// GetSecureAccessBastionApi returns the SecureAccessBastionApi field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessBastionApi() string {
	if o == nil || o.SecureAccessBastionApi == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessBastionApi
}

// GetSecureAccessBastionApiOk returns a tuple with the SecureAccessBastionApi field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessBastionApiOk() (*string, bool) {
	if o == nil || o.SecureAccessBastionApi == nil {
		return nil, false
	}
	return o.SecureAccessBastionApi, true
}

// HasSecureAccessBastionApi returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessBastionApi() bool {
	if o != nil && o.SecureAccessBastionApi != nil {
		return true
	}

	return false
}

// SetSecureAccessBastionApi gets a reference to the given string and assigns it to the SecureAccessBastionApi field.
func (o *UpdateItem) SetSecureAccessBastionApi(v string) {
	o.SecureAccessBastionApi = &v
}

// GetSecureAccessBastionIssuer returns the SecureAccessBastionIssuer field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessBastionIssuer() string {
	if o == nil || o.SecureAccessBastionIssuer == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessBastionIssuer
}

// GetSecureAccessBastionIssuerOk returns a tuple with the SecureAccessBastionIssuer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessBastionIssuerOk() (*string, bool) {
	if o == nil || o.SecureAccessBastionIssuer == nil {
		return nil, false
	}
	return o.SecureAccessBastionIssuer, true
}

// HasSecureAccessBastionIssuer returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessBastionIssuer() bool {
	if o != nil && o.SecureAccessBastionIssuer != nil {
		return true
	}

	return false
}

// SetSecureAccessBastionIssuer gets a reference to the given string and assigns it to the SecureAccessBastionIssuer field.
func (o *UpdateItem) SetSecureAccessBastionIssuer(v string) {
	o.SecureAccessBastionIssuer = &v
}

// GetSecureAccessBastionSsh returns the SecureAccessBastionSsh field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessBastionSsh() string {
	if o == nil || o.SecureAccessBastionSsh == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessBastionSsh
}

// GetSecureAccessBastionSshOk returns a tuple with the SecureAccessBastionSsh field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessBastionSshOk() (*string, bool) {
	if o == nil || o.SecureAccessBastionSsh == nil {
		return nil, false
	}
	return o.SecureAccessBastionSsh, true
}

// HasSecureAccessBastionSsh returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessBastionSsh() bool {
	if o != nil && o.SecureAccessBastionSsh != nil {
		return true
	}

	return false
}

// SetSecureAccessBastionSsh gets a reference to the given string and assigns it to the SecureAccessBastionSsh field.
func (o *UpdateItem) SetSecureAccessBastionSsh(v string) {
	o.SecureAccessBastionSsh = &v
}

// GetSecureAccessClusterEndpoint returns the SecureAccessClusterEndpoint field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessClusterEndpoint() string {
	if o == nil || o.SecureAccessClusterEndpoint == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessClusterEndpoint
}

// GetSecureAccessClusterEndpointOk returns a tuple with the SecureAccessClusterEndpoint field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessClusterEndpointOk() (*string, bool) {
	if o == nil || o.SecureAccessClusterEndpoint == nil {
		return nil, false
	}
	return o.SecureAccessClusterEndpoint, true
}

// HasSecureAccessClusterEndpoint returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessClusterEndpoint() bool {
	if o != nil && o.SecureAccessClusterEndpoint != nil {
		return true
	}

	return false
}

// SetSecureAccessClusterEndpoint gets a reference to the given string and assigns it to the SecureAccessClusterEndpoint field.
func (o *UpdateItem) SetSecureAccessClusterEndpoint(v string) {
	o.SecureAccessClusterEndpoint = &v
}

// GetSecureAccessDashboardUrl returns the SecureAccessDashboardUrl field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessDashboardUrl() string {
	if o == nil || o.SecureAccessDashboardUrl == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessDashboardUrl
}

// GetSecureAccessDashboardUrlOk returns a tuple with the SecureAccessDashboardUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessDashboardUrlOk() (*string, bool) {
	if o == nil || o.SecureAccessDashboardUrl == nil {
		return nil, false
	}
	return o.SecureAccessDashboardUrl, true
}

// HasSecureAccessDashboardUrl returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessDashboardUrl() bool {
	if o != nil && o.SecureAccessDashboardUrl != nil {
		return true
	}

	return false
}

// SetSecureAccessDashboardUrl gets a reference to the given string and assigns it to the SecureAccessDashboardUrl field.
func (o *UpdateItem) SetSecureAccessDashboardUrl(v string) {
	o.SecureAccessDashboardUrl = &v
}

// GetSecureAccessDbName returns the SecureAccessDbName field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessDbName() string {
	if o == nil || o.SecureAccessDbName == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessDbName
}

// GetSecureAccessDbNameOk returns a tuple with the SecureAccessDbName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessDbNameOk() (*string, bool) {
	if o == nil || o.SecureAccessDbName == nil {
		return nil, false
	}
	return o.SecureAccessDbName, true
}

// HasSecureAccessDbName returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessDbName() bool {
	if o != nil && o.SecureAccessDbName != nil {
		return true
	}

	return false
}

// SetSecureAccessDbName gets a reference to the given string and assigns it to the SecureAccessDbName field.
func (o *UpdateItem) SetSecureAccessDbName(v string) {
	o.SecureAccessDbName = &v
}

// GetSecureAccessDbSchema returns the SecureAccessDbSchema field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessDbSchema() string {
	if o == nil || o.SecureAccessDbSchema == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessDbSchema
}

// GetSecureAccessDbSchemaOk returns a tuple with the SecureAccessDbSchema field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessDbSchemaOk() (*string, bool) {
	if o == nil || o.SecureAccessDbSchema == nil {
		return nil, false
	}
	return o.SecureAccessDbSchema, true
}

// HasSecureAccessDbSchema returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessDbSchema() bool {
	if o != nil && o.SecureAccessDbSchema != nil {
		return true
	}

	return false
}

// SetSecureAccessDbSchema gets a reference to the given string and assigns it to the SecureAccessDbSchema field.
func (o *UpdateItem) SetSecureAccessDbSchema(v string) {
	o.SecureAccessDbSchema = &v
}

// GetSecureAccessEnable returns the SecureAccessEnable field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessEnable() string {
	if o == nil || o.SecureAccessEnable == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessEnable
}

// GetSecureAccessEnableOk returns a tuple with the SecureAccessEnable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessEnableOk() (*string, bool) {
	if o == nil || o.SecureAccessEnable == nil {
		return nil, false
	}
	return o.SecureAccessEnable, true
}

// HasSecureAccessEnable returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessEnable() bool {
	if o != nil && o.SecureAccessEnable != nil {
		return true
	}

	return false
}

// SetSecureAccessEnable gets a reference to the given string and assigns it to the SecureAccessEnable field.
func (o *UpdateItem) SetSecureAccessEnable(v string) {
	o.SecureAccessEnable = &v
}

// GetSecureAccessHost returns the SecureAccessHost field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessHost() []string {
	if o == nil || o.SecureAccessHost == nil {
		var ret []string
		return ret
	}
	return *o.SecureAccessHost
}

// GetSecureAccessHostOk returns a tuple with the SecureAccessHost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessHostOk() (*[]string, bool) {
	if o == nil || o.SecureAccessHost == nil {
		return nil, false
	}
	return o.SecureAccessHost, true
}

// HasSecureAccessHost returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessHost() bool {
	if o != nil && o.SecureAccessHost != nil {
		return true
	}

	return false
}

// SetSecureAccessHost gets a reference to the given []string and assigns it to the SecureAccessHost field.
func (o *UpdateItem) SetSecureAccessHost(v []string) {
	o.SecureAccessHost = &v
}

// GetSecureAccessRdGatewayServer returns the SecureAccessRdGatewayServer field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessRdGatewayServer() string {
	if o == nil || o.SecureAccessRdGatewayServer == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessRdGatewayServer
}

// GetSecureAccessRdGatewayServerOk returns a tuple with the SecureAccessRdGatewayServer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessRdGatewayServerOk() (*string, bool) {
	if o == nil || o.SecureAccessRdGatewayServer == nil {
		return nil, false
	}
	return o.SecureAccessRdGatewayServer, true
}

// HasSecureAccessRdGatewayServer returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessRdGatewayServer() bool {
	if o != nil && o.SecureAccessRdGatewayServer != nil {
		return true
	}

	return false
}

// SetSecureAccessRdGatewayServer gets a reference to the given string and assigns it to the SecureAccessRdGatewayServer field.
func (o *UpdateItem) SetSecureAccessRdGatewayServer(v string) {
	o.SecureAccessRdGatewayServer = &v
}

// GetSecureAccessRdpDomain returns the SecureAccessRdpDomain field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessRdpDomain() string {
	if o == nil || o.SecureAccessRdpDomain == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessRdpDomain
}

// GetSecureAccessRdpDomainOk returns a tuple with the SecureAccessRdpDomain field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessRdpDomainOk() (*string, bool) {
	if o == nil || o.SecureAccessRdpDomain == nil {
		return nil, false
	}
	return o.SecureAccessRdpDomain, true
}

// HasSecureAccessRdpDomain returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessRdpDomain() bool {
	if o != nil && o.SecureAccessRdpDomain != nil {
		return true
	}

	return false
}

// SetSecureAccessRdpDomain gets a reference to the given string and assigns it to the SecureAccessRdpDomain field.
func (o *UpdateItem) SetSecureAccessRdpDomain(v string) {
	o.SecureAccessRdpDomain = &v
}

// GetSecureAccessRdpUser returns the SecureAccessRdpUser field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessRdpUser() string {
	if o == nil || o.SecureAccessRdpUser == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessRdpUser
}

// GetSecureAccessRdpUserOk returns a tuple with the SecureAccessRdpUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessRdpUserOk() (*string, bool) {
	if o == nil || o.SecureAccessRdpUser == nil {
		return nil, false
	}
	return o.SecureAccessRdpUser, true
}

// HasSecureAccessRdpUser returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessRdpUser() bool {
	if o != nil && o.SecureAccessRdpUser != nil {
		return true
	}

	return false
}

// SetSecureAccessRdpUser gets a reference to the given string and assigns it to the SecureAccessRdpUser field.
func (o *UpdateItem) SetSecureAccessRdpUser(v string) {
	o.SecureAccessRdpUser = &v
}

// GetSecureAccessRmHost returns the SecureAccessRmHost field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessRmHost() []string {
	if o == nil || o.SecureAccessRmHost == nil {
		var ret []string
		return ret
	}
	return *o.SecureAccessRmHost
}

// GetSecureAccessRmHostOk returns a tuple with the SecureAccessRmHost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessRmHostOk() (*[]string, bool) {
	if o == nil || o.SecureAccessRmHost == nil {
		return nil, false
	}
	return o.SecureAccessRmHost, true
}

// HasSecureAccessRmHost returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessRmHost() bool {
	if o != nil && o.SecureAccessRmHost != nil {
		return true
	}

	return false
}

// SetSecureAccessRmHost gets a reference to the given []string and assigns it to the SecureAccessRmHost field.
func (o *UpdateItem) SetSecureAccessRmHost(v []string) {
	o.SecureAccessRmHost = &v
}

// GetSecureAccessSshCreds returns the SecureAccessSshCreds field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessSshCreds() string {
	if o == nil || o.SecureAccessSshCreds == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessSshCreds
}

// GetSecureAccessSshCredsOk returns a tuple with the SecureAccessSshCreds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessSshCredsOk() (*string, bool) {
	if o == nil || o.SecureAccessSshCreds == nil {
		return nil, false
	}
	return o.SecureAccessSshCreds, true
}

// HasSecureAccessSshCreds returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessSshCreds() bool {
	if o != nil && o.SecureAccessSshCreds != nil {
		return true
	}

	return false
}

// SetSecureAccessSshCreds gets a reference to the given string and assigns it to the SecureAccessSshCreds field.
func (o *UpdateItem) SetSecureAccessSshCreds(v string) {
	o.SecureAccessSshCreds = &v
}

// GetSecureAccessSshCredsUser returns the SecureAccessSshCredsUser field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessSshCredsUser() string {
	if o == nil || o.SecureAccessSshCredsUser == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessSshCredsUser
}

// GetSecureAccessSshCredsUserOk returns a tuple with the SecureAccessSshCredsUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessSshCredsUserOk() (*string, bool) {
	if o == nil || o.SecureAccessSshCredsUser == nil {
		return nil, false
	}
	return o.SecureAccessSshCredsUser, true
}

// HasSecureAccessSshCredsUser returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessSshCredsUser() bool {
	if o != nil && o.SecureAccessSshCredsUser != nil {
		return true
	}

	return false
}

// SetSecureAccessSshCredsUser gets a reference to the given string and assigns it to the SecureAccessSshCredsUser field.
func (o *UpdateItem) SetSecureAccessSshCredsUser(v string) {
	o.SecureAccessSshCredsUser = &v
}

// GetSecureAccessUrl returns the SecureAccessUrl field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessUrl() string {
	if o == nil || o.SecureAccessUrl == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessUrl
}

// GetSecureAccessUrlOk returns a tuple with the SecureAccessUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessUrlOk() (*string, bool) {
	if o == nil || o.SecureAccessUrl == nil {
		return nil, false
	}
	return o.SecureAccessUrl, true
}

// HasSecureAccessUrl returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessUrl() bool {
	if o != nil && o.SecureAccessUrl != nil {
		return true
	}

	return false
}

// SetSecureAccessUrl gets a reference to the given string and assigns it to the SecureAccessUrl field.
func (o *UpdateItem) SetSecureAccessUrl(v string) {
	o.SecureAccessUrl = &v
}

// GetSecureAccessUseInternalBastion returns the SecureAccessUseInternalBastion field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessUseInternalBastion() bool {
	if o == nil || o.SecureAccessUseInternalBastion == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessUseInternalBastion
}

// GetSecureAccessUseInternalBastionOk returns a tuple with the SecureAccessUseInternalBastion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessUseInternalBastionOk() (*bool, bool) {
	if o == nil || o.SecureAccessUseInternalBastion == nil {
		return nil, false
	}
	return o.SecureAccessUseInternalBastion, true
}

// HasSecureAccessUseInternalBastion returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessUseInternalBastion() bool {
	if o != nil && o.SecureAccessUseInternalBastion != nil {
		return true
	}

	return false
}

// SetSecureAccessUseInternalBastion gets a reference to the given bool and assigns it to the SecureAccessUseInternalBastion field.
func (o *UpdateItem) SetSecureAccessUseInternalBastion(v bool) {
	o.SecureAccessUseInternalBastion = &v
}

// GetSecureAccessWebBrowsing returns the SecureAccessWebBrowsing field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessWebBrowsing() bool {
	if o == nil || o.SecureAccessWebBrowsing == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessWebBrowsing
}

// GetSecureAccessWebBrowsingOk returns a tuple with the SecureAccessWebBrowsing field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessWebBrowsingOk() (*bool, bool) {
	if o == nil || o.SecureAccessWebBrowsing == nil {
		return nil, false
	}
	return o.SecureAccessWebBrowsing, true
}

// HasSecureAccessWebBrowsing returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessWebBrowsing() bool {
	if o != nil && o.SecureAccessWebBrowsing != nil {
		return true
	}

	return false
}

// SetSecureAccessWebBrowsing gets a reference to the given bool and assigns it to the SecureAccessWebBrowsing field.
func (o *UpdateItem) SetSecureAccessWebBrowsing(v bool) {
	o.SecureAccessWebBrowsing = &v
}

// GetSecureAccessWebProxy returns the SecureAccessWebProxy field value if set, zero value otherwise.
func (o *UpdateItem) GetSecureAccessWebProxy() bool {
	if o == nil || o.SecureAccessWebProxy == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessWebProxy
}

// GetSecureAccessWebProxyOk returns a tuple with the SecureAccessWebProxy field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetSecureAccessWebProxyOk() (*bool, bool) {
	if o == nil || o.SecureAccessWebProxy == nil {
		return nil, false
	}
	return o.SecureAccessWebProxy, true
}

// HasSecureAccessWebProxy returns a boolean if a field has been set.
func (o *UpdateItem) HasSecureAccessWebProxy() bool {
	if o != nil && o.SecureAccessWebProxy != nil {
		return true
	}

	return false
}

// SetSecureAccessWebProxy gets a reference to the given bool and assigns it to the SecureAccessWebProxy field.
func (o *UpdateItem) SetSecureAccessWebProxy(v bool) {
	o.SecureAccessWebProxy = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *UpdateItem) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *UpdateItem) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *UpdateItem) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *UpdateItem) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateItem) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *UpdateItem) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *UpdateItem) SetUidToken(v string) {
	o.UidToken = &v
}

func (o UpdateItem) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ProviderType != nil {
		toSerialize["ProviderType"] = o.ProviderType
	}
	if o.Accessibility != nil {
		toSerialize["accessibility"] = o.Accessibility
	}
	if o.AddTag != nil {
		toSerialize["add-tag"] = o.AddTag
	}
	if o.CertFileData != nil {
		toSerialize["cert-file-data"] = o.CertFileData
	}
	if o.CertificateFormat != nil {
		toSerialize["certificate-format"] = o.CertificateFormat
	}
	if o.ChangeEvent != nil {
		toSerialize["change-event"] = o.ChangeEvent
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.ExpirationEventIn != nil {
		toSerialize["expiration-event-in"] = o.ExpirationEventIn
	}
	if o.HostProvider != nil {
		toSerialize["host-provider"] = o.HostProvider
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewMetadata != nil {
		toSerialize["new-metadata"] = o.NewMetadata
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.RmTag != nil {
		toSerialize["rm-tag"] = o.RmTag
	}
	if o.RotateAfterDisconnect != nil {
		toSerialize["rotate-after-disconnect"] = o.RotateAfterDisconnect
	}
	if o.SecureAccessAddHost != nil {
		toSerialize["secure-access-add-host"] = o.SecureAccessAddHost
	}
	if o.SecureAccessAllowExternalUser != nil {
		toSerialize["secure-access-allow-external-user"] = o.SecureAccessAllowExternalUser
	}
	if o.SecureAccessAllowPortForwading != nil {
		toSerialize["secure-access-allow-port-forwading"] = o.SecureAccessAllowPortForwading
	}
	if o.SecureAccessAwsAccountId != nil {
		toSerialize["secure-access-aws-account-id"] = o.SecureAccessAwsAccountId
	}
	if o.SecureAccessAwsNativeCli != nil {
		toSerialize["secure-access-aws-native-cli"] = o.SecureAccessAwsNativeCli
	}
	if o.SecureAccessAwsRegion != nil {
		toSerialize["secure-access-aws-region"] = o.SecureAccessAwsRegion
	}
	if o.SecureAccessBastionApi != nil {
		toSerialize["secure-access-bastion-api"] = o.SecureAccessBastionApi
	}
	if o.SecureAccessBastionIssuer != nil {
		toSerialize["secure-access-bastion-issuer"] = o.SecureAccessBastionIssuer
	}
	if o.SecureAccessBastionSsh != nil {
		toSerialize["secure-access-bastion-ssh"] = o.SecureAccessBastionSsh
	}
	if o.SecureAccessClusterEndpoint != nil {
		toSerialize["secure-access-cluster-endpoint"] = o.SecureAccessClusterEndpoint
	}
	if o.SecureAccessDashboardUrl != nil {
		toSerialize["secure-access-dashboard-url"] = o.SecureAccessDashboardUrl
	}
	if o.SecureAccessDbName != nil {
		toSerialize["secure-access-db-name"] = o.SecureAccessDbName
	}
	if o.SecureAccessDbSchema != nil {
		toSerialize["secure-access-db-schema"] = o.SecureAccessDbSchema
	}
	if o.SecureAccessEnable != nil {
		toSerialize["secure-access-enable"] = o.SecureAccessEnable
	}
	if o.SecureAccessHost != nil {
		toSerialize["secure-access-host"] = o.SecureAccessHost
	}
	if o.SecureAccessRdGatewayServer != nil {
		toSerialize["secure-access-rd-gateway-server"] = o.SecureAccessRdGatewayServer
	}
	if o.SecureAccessRdpDomain != nil {
		toSerialize["secure-access-rdp-domain"] = o.SecureAccessRdpDomain
	}
	if o.SecureAccessRdpUser != nil {
		toSerialize["secure-access-rdp-user"] = o.SecureAccessRdpUser
	}
	if o.SecureAccessRmHost != nil {
		toSerialize["secure-access-rm-host"] = o.SecureAccessRmHost
	}
	if o.SecureAccessSshCreds != nil {
		toSerialize["secure-access-ssh-creds"] = o.SecureAccessSshCreds
	}
	if o.SecureAccessSshCredsUser != nil {
		toSerialize["secure-access-ssh-creds-user"] = o.SecureAccessSshCredsUser
	}
	if o.SecureAccessUrl != nil {
		toSerialize["secure-access-url"] = o.SecureAccessUrl
	}
	if o.SecureAccessUseInternalBastion != nil {
		toSerialize["secure-access-use-internal-bastion"] = o.SecureAccessUseInternalBastion
	}
	if o.SecureAccessWebBrowsing != nil {
		toSerialize["secure-access-web-browsing"] = o.SecureAccessWebBrowsing
	}
	if o.SecureAccessWebProxy != nil {
		toSerialize["secure-access-web-proxy"] = o.SecureAccessWebProxy
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableUpdateItem struct {
	value *UpdateItem
	isSet bool
}

func (v NullableUpdateItem) Get() *UpdateItem {
	return v.value
}

func (v *NullableUpdateItem) Set(val *UpdateItem) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateItem) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateItem) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateItem(val *UpdateItem) *NullableUpdateItem {
	return &NullableUpdateItem{value: val, isSet: true}
}

func (v NullableUpdateItem) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateItem) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


