/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// UpdateGroup struct for UpdateGroup
type UpdateGroup struct {
	// Description of the object
	Description *string `json:"description,omitempty"`
	// A short group alias
	GroupAlias string `json:"group-alias"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Group name
	Name string `json:"name"`
	// Group new name
	NewName *string `json:"new-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// A json string defining the access permission assignment for this client
	UserAssignment *string `json:"user-assignment,omitempty"`
}

// NewUpdateGroup instantiates a new UpdateGroup object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateGroup(groupAlias string, name string, ) *UpdateGroup {
	this := UpdateGroup{}
	this.GroupAlias = groupAlias
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewUpdateGroupWithDefaults instantiates a new UpdateGroup object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateGroupWithDefaults() *UpdateGroup {
	this := UpdateGroup{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *UpdateGroup) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGroup) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *UpdateGroup) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *UpdateGroup) SetDescription(v string) {
	o.Description = &v
}

// GetGroupAlias returns the GroupAlias field value
func (o *UpdateGroup) GetGroupAlias() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.GroupAlias
}

// GetGroupAliasOk returns a tuple with the GroupAlias field value
// and a boolean to check if the value has been set.
func (o *UpdateGroup) GetGroupAliasOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.GroupAlias, true
}

// SetGroupAlias sets field value
func (o *UpdateGroup) SetGroupAlias(v string) {
	o.GroupAlias = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *UpdateGroup) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGroup) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *UpdateGroup) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *UpdateGroup) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *UpdateGroup) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *UpdateGroup) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *UpdateGroup) SetName(v string) {
	o.Name = v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *UpdateGroup) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGroup) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *UpdateGroup) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *UpdateGroup) SetNewName(v string) {
	o.NewName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *UpdateGroup) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGroup) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *UpdateGroup) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *UpdateGroup) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *UpdateGroup) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGroup) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *UpdateGroup) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *UpdateGroup) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUserAssignment returns the UserAssignment field value if set, zero value otherwise.
func (o *UpdateGroup) GetUserAssignment() string {
	if o == nil || o.UserAssignment == nil {
		var ret string
		return ret
	}
	return *o.UserAssignment
}

// GetUserAssignmentOk returns a tuple with the UserAssignment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateGroup) GetUserAssignmentOk() (*string, bool) {
	if o == nil || o.UserAssignment == nil {
		return nil, false
	}
	return o.UserAssignment, true
}

// HasUserAssignment returns a boolean if a field has been set.
func (o *UpdateGroup) HasUserAssignment() bool {
	if o != nil && o.UserAssignment != nil {
		return true
	}

	return false
}

// SetUserAssignment gets a reference to the given string and assigns it to the UserAssignment field.
func (o *UpdateGroup) SetUserAssignment(v string) {
	o.UserAssignment = &v
}

func (o UpdateGroup) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if true {
		toSerialize["group-alias"] = o.GroupAlias
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UserAssignment != nil {
		toSerialize["user-assignment"] = o.UserAssignment
	}
	return json.Marshal(toSerialize)
}

type NullableUpdateGroup struct {
	value *UpdateGroup
	isSet bool
}

func (v NullableUpdateGroup) Get() *UpdateGroup {
	return v.value
}

func (v *NullableUpdateGroup) Set(val *UpdateGroup) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateGroup) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateGroup) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateGroup(val *UpdateGroup) *NullableUpdateGroup {
	return &NullableUpdateGroup{value: val, isSet: true}
}

func (v NullableUpdateGroup) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateGroup) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


