/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// TargetCreateSalesforce targetCreateSalesforce is a command that creates a new Salesforce target
type TargetCreateSalesforce struct {
	// Base64 encoded PEM of the connected app private key (relevant for JWT auth only)
	AppPrivateKeyData *string `json:"app-private-key-data,omitempty"`
	// type of the auth flow ('jwt' / 'user-password')
	AuthFlow string `json:"auth-flow"`
	// Base64 encoded PEM cert to use when uploading a new key to Salesforce
	CaCertData *string `json:"ca-cert-data,omitempty"`
	// name of the certificate in Salesforce tenant to use when uploading new key
	CaCertName *string `json:"ca-cert-name,omitempty"`
	// Client ID of the oauth2 app to use for connecting to Salesforce
	ClientId string `json:"client-id"`
	// Client secret of the oauth2 app to use for connecting to Salesforce (required for password flow)
	ClientSecret *string `json:"client-secret,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// The email of the user attached to the oauth2 app used for connecting to Salesforce
	Email string `json:"email"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	// The password of the user attached to the oauth2 app used for connecting to Salesforce (required for user-password flow)
	Password *string `json:"password,omitempty"`
	// The security token of the user attached to the oauth2 app used for connecting to Salesforce  (required for user-password flow)
	SecurityToken *string `json:"security-token,omitempty"`
	// Url of the Salesforce tenant
	TenantUrl string `json:"tenant-url"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewTargetCreateSalesforce instantiates a new TargetCreateSalesforce object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTargetCreateSalesforce(authFlow string, clientId string, email string, name string, tenantUrl string, ) *TargetCreateSalesforce {
	this := TargetCreateSalesforce{}
	this.AuthFlow = authFlow
	this.ClientId = clientId
	this.Email = email
	var json bool = false
	this.Json = &json
	this.Name = name
	this.TenantUrl = tenantUrl
	return &this
}

// NewTargetCreateSalesforceWithDefaults instantiates a new TargetCreateSalesforce object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTargetCreateSalesforceWithDefaults() *TargetCreateSalesforce {
	this := TargetCreateSalesforce{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetAppPrivateKeyData returns the AppPrivateKeyData field value if set, zero value otherwise.
func (o *TargetCreateSalesforce) GetAppPrivateKeyData() string {
	if o == nil || o.AppPrivateKeyData == nil {
		var ret string
		return ret
	}
	return *o.AppPrivateKeyData
}

// GetAppPrivateKeyDataOk returns a tuple with the AppPrivateKeyData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetAppPrivateKeyDataOk() (*string, bool) {
	if o == nil || o.AppPrivateKeyData == nil {
		return nil, false
	}
	return o.AppPrivateKeyData, true
}

// HasAppPrivateKeyData returns a boolean if a field has been set.
func (o *TargetCreateSalesforce) HasAppPrivateKeyData() bool {
	if o != nil && o.AppPrivateKeyData != nil {
		return true
	}

	return false
}

// SetAppPrivateKeyData gets a reference to the given string and assigns it to the AppPrivateKeyData field.
func (o *TargetCreateSalesforce) SetAppPrivateKeyData(v string) {
	o.AppPrivateKeyData = &v
}

// GetAuthFlow returns the AuthFlow field value
func (o *TargetCreateSalesforce) GetAuthFlow() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.AuthFlow
}

// GetAuthFlowOk returns a tuple with the AuthFlow field value
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetAuthFlowOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.AuthFlow, true
}

// SetAuthFlow sets field value
func (o *TargetCreateSalesforce) SetAuthFlow(v string) {
	o.AuthFlow = v
}

// GetCaCertData returns the CaCertData field value if set, zero value otherwise.
func (o *TargetCreateSalesforce) GetCaCertData() string {
	if o == nil || o.CaCertData == nil {
		var ret string
		return ret
	}
	return *o.CaCertData
}

// GetCaCertDataOk returns a tuple with the CaCertData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetCaCertDataOk() (*string, bool) {
	if o == nil || o.CaCertData == nil {
		return nil, false
	}
	return o.CaCertData, true
}

// HasCaCertData returns a boolean if a field has been set.
func (o *TargetCreateSalesforce) HasCaCertData() bool {
	if o != nil && o.CaCertData != nil {
		return true
	}

	return false
}

// SetCaCertData gets a reference to the given string and assigns it to the CaCertData field.
func (o *TargetCreateSalesforce) SetCaCertData(v string) {
	o.CaCertData = &v
}

// GetCaCertName returns the CaCertName field value if set, zero value otherwise.
func (o *TargetCreateSalesforce) GetCaCertName() string {
	if o == nil || o.CaCertName == nil {
		var ret string
		return ret
	}
	return *o.CaCertName
}

// GetCaCertNameOk returns a tuple with the CaCertName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetCaCertNameOk() (*string, bool) {
	if o == nil || o.CaCertName == nil {
		return nil, false
	}
	return o.CaCertName, true
}

// HasCaCertName returns a boolean if a field has been set.
func (o *TargetCreateSalesforce) HasCaCertName() bool {
	if o != nil && o.CaCertName != nil {
		return true
	}

	return false
}

// SetCaCertName gets a reference to the given string and assigns it to the CaCertName field.
func (o *TargetCreateSalesforce) SetCaCertName(v string) {
	o.CaCertName = &v
}

// GetClientId returns the ClientId field value
func (o *TargetCreateSalesforce) GetClientId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ClientId
}

// GetClientIdOk returns a tuple with the ClientId field value
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetClientIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ClientId, true
}

// SetClientId sets field value
func (o *TargetCreateSalesforce) SetClientId(v string) {
	o.ClientId = v
}

// GetClientSecret returns the ClientSecret field value if set, zero value otherwise.
func (o *TargetCreateSalesforce) GetClientSecret() string {
	if o == nil || o.ClientSecret == nil {
		var ret string
		return ret
	}
	return *o.ClientSecret
}

// GetClientSecretOk returns a tuple with the ClientSecret field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetClientSecretOk() (*string, bool) {
	if o == nil || o.ClientSecret == nil {
		return nil, false
	}
	return o.ClientSecret, true
}

// HasClientSecret returns a boolean if a field has been set.
func (o *TargetCreateSalesforce) HasClientSecret() bool {
	if o != nil && o.ClientSecret != nil {
		return true
	}

	return false
}

// SetClientSecret gets a reference to the given string and assigns it to the ClientSecret field.
func (o *TargetCreateSalesforce) SetClientSecret(v string) {
	o.ClientSecret = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *TargetCreateSalesforce) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *TargetCreateSalesforce) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *TargetCreateSalesforce) SetDescription(v string) {
	o.Description = &v
}

// GetEmail returns the Email field value
func (o *TargetCreateSalesforce) GetEmail() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Email
}

// GetEmailOk returns a tuple with the Email field value
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetEmailOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Email, true
}

// SetEmail sets field value
func (o *TargetCreateSalesforce) SetEmail(v string) {
	o.Email = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *TargetCreateSalesforce) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *TargetCreateSalesforce) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *TargetCreateSalesforce) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *TargetCreateSalesforce) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *TargetCreateSalesforce) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *TargetCreateSalesforce) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *TargetCreateSalesforce) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *TargetCreateSalesforce) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *TargetCreateSalesforce) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *TargetCreateSalesforce) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *TargetCreateSalesforce) SetName(v string) {
	o.Name = v
}

// GetPassword returns the Password field value if set, zero value otherwise.
func (o *TargetCreateSalesforce) GetPassword() string {
	if o == nil || o.Password == nil {
		var ret string
		return ret
	}
	return *o.Password
}

// GetPasswordOk returns a tuple with the Password field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetPasswordOk() (*string, bool) {
	if o == nil || o.Password == nil {
		return nil, false
	}
	return o.Password, true
}

// HasPassword returns a boolean if a field has been set.
func (o *TargetCreateSalesforce) HasPassword() bool {
	if o != nil && o.Password != nil {
		return true
	}

	return false
}

// SetPassword gets a reference to the given string and assigns it to the Password field.
func (o *TargetCreateSalesforce) SetPassword(v string) {
	o.Password = &v
}

// GetSecurityToken returns the SecurityToken field value if set, zero value otherwise.
func (o *TargetCreateSalesforce) GetSecurityToken() string {
	if o == nil || o.SecurityToken == nil {
		var ret string
		return ret
	}
	return *o.SecurityToken
}

// GetSecurityTokenOk returns a tuple with the SecurityToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetSecurityTokenOk() (*string, bool) {
	if o == nil || o.SecurityToken == nil {
		return nil, false
	}
	return o.SecurityToken, true
}

// HasSecurityToken returns a boolean if a field has been set.
func (o *TargetCreateSalesforce) HasSecurityToken() bool {
	if o != nil && o.SecurityToken != nil {
		return true
	}

	return false
}

// SetSecurityToken gets a reference to the given string and assigns it to the SecurityToken field.
func (o *TargetCreateSalesforce) SetSecurityToken(v string) {
	o.SecurityToken = &v
}

// GetTenantUrl returns the TenantUrl field value
func (o *TargetCreateSalesforce) GetTenantUrl() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.TenantUrl
}

// GetTenantUrlOk returns a tuple with the TenantUrl field value
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetTenantUrlOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.TenantUrl, true
}

// SetTenantUrl sets field value
func (o *TargetCreateSalesforce) SetTenantUrl(v string) {
	o.TenantUrl = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *TargetCreateSalesforce) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *TargetCreateSalesforce) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *TargetCreateSalesforce) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *TargetCreateSalesforce) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateSalesforce) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *TargetCreateSalesforce) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *TargetCreateSalesforce) SetUidToken(v string) {
	o.UidToken = &v
}

func (o TargetCreateSalesforce) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AppPrivateKeyData != nil {
		toSerialize["app-private-key-data"] = o.AppPrivateKeyData
	}
	if true {
		toSerialize["auth-flow"] = o.AuthFlow
	}
	if o.CaCertData != nil {
		toSerialize["ca-cert-data"] = o.CaCertData
	}
	if o.CaCertName != nil {
		toSerialize["ca-cert-name"] = o.CaCertName
	}
	if true {
		toSerialize["client-id"] = o.ClientId
	}
	if o.ClientSecret != nil {
		toSerialize["client-secret"] = o.ClientSecret
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if true {
		toSerialize["email"] = o.Email
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Password != nil {
		toSerialize["password"] = o.Password
	}
	if o.SecurityToken != nil {
		toSerialize["security-token"] = o.SecurityToken
	}
	if true {
		toSerialize["tenant-url"] = o.TenantUrl
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableTargetCreateSalesforce struct {
	value *TargetCreateSalesforce
	isSet bool
}

func (v NullableTargetCreateSalesforce) Get() *TargetCreateSalesforce {
	return v.value
}

func (v *NullableTargetCreateSalesforce) Set(val *TargetCreateSalesforce) {
	v.value = val
	v.isSet = true
}

func (v NullableTargetCreateSalesforce) IsSet() bool {
	return v.isSet
}

func (v *NullableTargetCreateSalesforce) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTargetCreateSalesforce(val *TargetCreateSalesforce) *NullableTargetCreateSalesforce {
	return &NullableTargetCreateSalesforce{value: val, isSet: true}
}

func (v NullableTargetCreateSalesforce) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTargetCreateSalesforce) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


