/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// TargetCreatePing targetCreatePing is a command that creates a new ping target
type TargetCreatePing struct {
	// Ping Federate administrative port
	AdministrativePort *string `json:"administrative-port,omitempty"`
	// Ping Federate authorization port
	AuthorizationPort *string `json:"authorization-port,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	// Ping Federate privileged user password
	Password *string `json:"password,omitempty"`
	// Ping URL
	PingUrl *string `json:"ping-url,omitempty"`
	// Ping Federate privileged user
	PrivilegedUser *string `json:"privileged-user,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewTargetCreatePing instantiates a new TargetCreatePing object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTargetCreatePing(name string, ) *TargetCreatePing {
	this := TargetCreatePing{}
	var administrativePort string = "9999"
	this.AdministrativePort = &administrativePort
	var authorizationPort string = "9031"
	this.AuthorizationPort = &authorizationPort
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewTargetCreatePingWithDefaults instantiates a new TargetCreatePing object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTargetCreatePingWithDefaults() *TargetCreatePing {
	this := TargetCreatePing{}
	var administrativePort string = "9999"
	this.AdministrativePort = &administrativePort
	var authorizationPort string = "9031"
	this.AuthorizationPort = &authorizationPort
	var json bool = false
	this.Json = &json
	return &this
}

// GetAdministrativePort returns the AdministrativePort field value if set, zero value otherwise.
func (o *TargetCreatePing) GetAdministrativePort() string {
	if o == nil || o.AdministrativePort == nil {
		var ret string
		return ret
	}
	return *o.AdministrativePort
}

// GetAdministrativePortOk returns a tuple with the AdministrativePort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreatePing) GetAdministrativePortOk() (*string, bool) {
	if o == nil || o.AdministrativePort == nil {
		return nil, false
	}
	return o.AdministrativePort, true
}

// HasAdministrativePort returns a boolean if a field has been set.
func (o *TargetCreatePing) HasAdministrativePort() bool {
	if o != nil && o.AdministrativePort != nil {
		return true
	}

	return false
}

// SetAdministrativePort gets a reference to the given string and assigns it to the AdministrativePort field.
func (o *TargetCreatePing) SetAdministrativePort(v string) {
	o.AdministrativePort = &v
}

// GetAuthorizationPort returns the AuthorizationPort field value if set, zero value otherwise.
func (o *TargetCreatePing) GetAuthorizationPort() string {
	if o == nil || o.AuthorizationPort == nil {
		var ret string
		return ret
	}
	return *o.AuthorizationPort
}

// GetAuthorizationPortOk returns a tuple with the AuthorizationPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreatePing) GetAuthorizationPortOk() (*string, bool) {
	if o == nil || o.AuthorizationPort == nil {
		return nil, false
	}
	return o.AuthorizationPort, true
}

// HasAuthorizationPort returns a boolean if a field has been set.
func (o *TargetCreatePing) HasAuthorizationPort() bool {
	if o != nil && o.AuthorizationPort != nil {
		return true
	}

	return false
}

// SetAuthorizationPort gets a reference to the given string and assigns it to the AuthorizationPort field.
func (o *TargetCreatePing) SetAuthorizationPort(v string) {
	o.AuthorizationPort = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *TargetCreatePing) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreatePing) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *TargetCreatePing) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *TargetCreatePing) SetDescription(v string) {
	o.Description = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *TargetCreatePing) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreatePing) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *TargetCreatePing) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *TargetCreatePing) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *TargetCreatePing) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreatePing) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *TargetCreatePing) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *TargetCreatePing) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *TargetCreatePing) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreatePing) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *TargetCreatePing) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *TargetCreatePing) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *TargetCreatePing) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *TargetCreatePing) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *TargetCreatePing) SetName(v string) {
	o.Name = v
}

// GetPassword returns the Password field value if set, zero value otherwise.
func (o *TargetCreatePing) GetPassword() string {
	if o == nil || o.Password == nil {
		var ret string
		return ret
	}
	return *o.Password
}

// GetPasswordOk returns a tuple with the Password field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreatePing) GetPasswordOk() (*string, bool) {
	if o == nil || o.Password == nil {
		return nil, false
	}
	return o.Password, true
}

// HasPassword returns a boolean if a field has been set.
func (o *TargetCreatePing) HasPassword() bool {
	if o != nil && o.Password != nil {
		return true
	}

	return false
}

// SetPassword gets a reference to the given string and assigns it to the Password field.
func (o *TargetCreatePing) SetPassword(v string) {
	o.Password = &v
}

// GetPingUrl returns the PingUrl field value if set, zero value otherwise.
func (o *TargetCreatePing) GetPingUrl() string {
	if o == nil || o.PingUrl == nil {
		var ret string
		return ret
	}
	return *o.PingUrl
}

// GetPingUrlOk returns a tuple with the PingUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreatePing) GetPingUrlOk() (*string, bool) {
	if o == nil || o.PingUrl == nil {
		return nil, false
	}
	return o.PingUrl, true
}

// HasPingUrl returns a boolean if a field has been set.
func (o *TargetCreatePing) HasPingUrl() bool {
	if o != nil && o.PingUrl != nil {
		return true
	}

	return false
}

// SetPingUrl gets a reference to the given string and assigns it to the PingUrl field.
func (o *TargetCreatePing) SetPingUrl(v string) {
	o.PingUrl = &v
}

// GetPrivilegedUser returns the PrivilegedUser field value if set, zero value otherwise.
func (o *TargetCreatePing) GetPrivilegedUser() string {
	if o == nil || o.PrivilegedUser == nil {
		var ret string
		return ret
	}
	return *o.PrivilegedUser
}

// GetPrivilegedUserOk returns a tuple with the PrivilegedUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreatePing) GetPrivilegedUserOk() (*string, bool) {
	if o == nil || o.PrivilegedUser == nil {
		return nil, false
	}
	return o.PrivilegedUser, true
}

// HasPrivilegedUser returns a boolean if a field has been set.
func (o *TargetCreatePing) HasPrivilegedUser() bool {
	if o != nil && o.PrivilegedUser != nil {
		return true
	}

	return false
}

// SetPrivilegedUser gets a reference to the given string and assigns it to the PrivilegedUser field.
func (o *TargetCreatePing) SetPrivilegedUser(v string) {
	o.PrivilegedUser = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *TargetCreatePing) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreatePing) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *TargetCreatePing) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *TargetCreatePing) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *TargetCreatePing) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreatePing) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *TargetCreatePing) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *TargetCreatePing) SetUidToken(v string) {
	o.UidToken = &v
}

func (o TargetCreatePing) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AdministrativePort != nil {
		toSerialize["administrative-port"] = o.AdministrativePort
	}
	if o.AuthorizationPort != nil {
		toSerialize["authorization-port"] = o.AuthorizationPort
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Password != nil {
		toSerialize["password"] = o.Password
	}
	if o.PingUrl != nil {
		toSerialize["ping-url"] = o.PingUrl
	}
	if o.PrivilegedUser != nil {
		toSerialize["privileged-user"] = o.PrivilegedUser
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableTargetCreatePing struct {
	value *TargetCreatePing
	isSet bool
}

func (v NullableTargetCreatePing) Get() *TargetCreatePing {
	return v.value
}

func (v *NullableTargetCreatePing) Set(val *TargetCreatePing) {
	v.value = val
	v.isSet = true
}

func (v NullableTargetCreatePing) IsSet() bool {
	return v.isSet
}

func (v *NullableTargetCreatePing) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTargetCreatePing(val *TargetCreatePing) *NullableTargetCreatePing {
	return &NullableTargetCreatePing{value: val, isSet: true}
}

func (v NullableTargetCreatePing) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTargetCreatePing) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


