/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// SignEcDsa signEcDsa Calculates the signature of a given message using ECDSA and a sha hash algorithm matching the key size
type SignEcDsa struct {
	// for personal password manager
	Accessibility *string `json:"accessibility,omitempty"`
	// The display id of the EC key to use for the signing process
	DisplayId *string `json:"display-id,omitempty"`
	// The item id of the EC key to use for the signing process
	ItemId *int64 `json:"item-id,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of the EC key to use for the signing process
	KeyName *string `json:"key-name,omitempty"`
	// The input message to sign in a base64 format
	Message string `json:"message"`
	// Markes that the message is already hashed
	Prehashed *bool `json:"prehashed,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// The version of the key to use for signing
	Version *int32 `json:"version,omitempty"`
}

// NewSignEcDsa instantiates a new SignEcDsa object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSignEcDsa(message string, ) *SignEcDsa {
	this := SignEcDsa{}
	var accessibility string = "regular"
	this.Accessibility = &accessibility
	var json bool = false
	this.Json = &json
	this.Message = message
	return &this
}

// NewSignEcDsaWithDefaults instantiates a new SignEcDsa object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSignEcDsaWithDefaults() *SignEcDsa {
	this := SignEcDsa{}
	var accessibility string = "regular"
	this.Accessibility = &accessibility
	var json bool = false
	this.Json = &json
	return &this
}

// GetAccessibility returns the Accessibility field value if set, zero value otherwise.
func (o *SignEcDsa) GetAccessibility() string {
	if o == nil || o.Accessibility == nil {
		var ret string
		return ret
	}
	return *o.Accessibility
}

// GetAccessibilityOk returns a tuple with the Accessibility field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignEcDsa) GetAccessibilityOk() (*string, bool) {
	if o == nil || o.Accessibility == nil {
		return nil, false
	}
	return o.Accessibility, true
}

// HasAccessibility returns a boolean if a field has been set.
func (o *SignEcDsa) HasAccessibility() bool {
	if o != nil && o.Accessibility != nil {
		return true
	}

	return false
}

// SetAccessibility gets a reference to the given string and assigns it to the Accessibility field.
func (o *SignEcDsa) SetAccessibility(v string) {
	o.Accessibility = &v
}

// GetDisplayId returns the DisplayId field value if set, zero value otherwise.
func (o *SignEcDsa) GetDisplayId() string {
	if o == nil || o.DisplayId == nil {
		var ret string
		return ret
	}
	return *o.DisplayId
}

// GetDisplayIdOk returns a tuple with the DisplayId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignEcDsa) GetDisplayIdOk() (*string, bool) {
	if o == nil || o.DisplayId == nil {
		return nil, false
	}
	return o.DisplayId, true
}

// HasDisplayId returns a boolean if a field has been set.
func (o *SignEcDsa) HasDisplayId() bool {
	if o != nil && o.DisplayId != nil {
		return true
	}

	return false
}

// SetDisplayId gets a reference to the given string and assigns it to the DisplayId field.
func (o *SignEcDsa) SetDisplayId(v string) {
	o.DisplayId = &v
}

// GetItemId returns the ItemId field value if set, zero value otherwise.
func (o *SignEcDsa) GetItemId() int64 {
	if o == nil || o.ItemId == nil {
		var ret int64
		return ret
	}
	return *o.ItemId
}

// GetItemIdOk returns a tuple with the ItemId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignEcDsa) GetItemIdOk() (*int64, bool) {
	if o == nil || o.ItemId == nil {
		return nil, false
	}
	return o.ItemId, true
}

// HasItemId returns a boolean if a field has been set.
func (o *SignEcDsa) HasItemId() bool {
	if o != nil && o.ItemId != nil {
		return true
	}

	return false
}

// SetItemId gets a reference to the given int64 and assigns it to the ItemId field.
func (o *SignEcDsa) SetItemId(v int64) {
	o.ItemId = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *SignEcDsa) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignEcDsa) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *SignEcDsa) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *SignEcDsa) SetJson(v bool) {
	o.Json = &v
}

// GetKeyName returns the KeyName field value if set, zero value otherwise.
func (o *SignEcDsa) GetKeyName() string {
	if o == nil || o.KeyName == nil {
		var ret string
		return ret
	}
	return *o.KeyName
}

// GetKeyNameOk returns a tuple with the KeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignEcDsa) GetKeyNameOk() (*string, bool) {
	if o == nil || o.KeyName == nil {
		return nil, false
	}
	return o.KeyName, true
}

// HasKeyName returns a boolean if a field has been set.
func (o *SignEcDsa) HasKeyName() bool {
	if o != nil && o.KeyName != nil {
		return true
	}

	return false
}

// SetKeyName gets a reference to the given string and assigns it to the KeyName field.
func (o *SignEcDsa) SetKeyName(v string) {
	o.KeyName = &v
}

// GetMessage returns the Message field value
func (o *SignEcDsa) GetMessage() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Message
}

// GetMessageOk returns a tuple with the Message field value
// and a boolean to check if the value has been set.
func (o *SignEcDsa) GetMessageOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Message, true
}

// SetMessage sets field value
func (o *SignEcDsa) SetMessage(v string) {
	o.Message = v
}

// GetPrehashed returns the Prehashed field value if set, zero value otherwise.
func (o *SignEcDsa) GetPrehashed() bool {
	if o == nil || o.Prehashed == nil {
		var ret bool
		return ret
	}
	return *o.Prehashed
}

// GetPrehashedOk returns a tuple with the Prehashed field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignEcDsa) GetPrehashedOk() (*bool, bool) {
	if o == nil || o.Prehashed == nil {
		return nil, false
	}
	return o.Prehashed, true
}

// HasPrehashed returns a boolean if a field has been set.
func (o *SignEcDsa) HasPrehashed() bool {
	if o != nil && o.Prehashed != nil {
		return true
	}

	return false
}

// SetPrehashed gets a reference to the given bool and assigns it to the Prehashed field.
func (o *SignEcDsa) SetPrehashed(v bool) {
	o.Prehashed = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *SignEcDsa) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignEcDsa) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *SignEcDsa) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *SignEcDsa) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *SignEcDsa) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignEcDsa) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *SignEcDsa) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *SignEcDsa) SetUidToken(v string) {
	o.UidToken = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *SignEcDsa) GetVersion() int32 {
	if o == nil || o.Version == nil {
		var ret int32
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SignEcDsa) GetVersionOk() (*int32, bool) {
	if o == nil || o.Version == nil {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *SignEcDsa) HasVersion() bool {
	if o != nil && o.Version != nil {
		return true
	}

	return false
}

// SetVersion gets a reference to the given int32 and assigns it to the Version field.
func (o *SignEcDsa) SetVersion(v int32) {
	o.Version = &v
}

func (o SignEcDsa) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Accessibility != nil {
		toSerialize["accessibility"] = o.Accessibility
	}
	if o.DisplayId != nil {
		toSerialize["display-id"] = o.DisplayId
	}
	if o.ItemId != nil {
		toSerialize["item-id"] = o.ItemId
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.KeyName != nil {
		toSerialize["key-name"] = o.KeyName
	}
	if true {
		toSerialize["message"] = o.Message
	}
	if o.Prehashed != nil {
		toSerialize["prehashed"] = o.Prehashed
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.Version != nil {
		toSerialize["version"] = o.Version
	}
	return json.Marshal(toSerialize)
}

type NullableSignEcDsa struct {
	value *SignEcDsa
	isSet bool
}

func (v NullableSignEcDsa) Get() *SignEcDsa {
	return v.value
}

func (v *NullableSignEcDsa) Set(val *SignEcDsa) {
	v.value = val
	v.isSet = true
}

func (v NullableSignEcDsa) IsSet() bool {
	return v.isSet
}

func (v *NullableSignEcDsa) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSignEcDsa(val *SignEcDsa) *NullableSignEcDsa {
	return &NullableSignEcDsa{value: val, isSet: true}
}

func (v NullableSignEcDsa) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSignEcDsa) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


