/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// ListAcmeAccounts listAcmeAccounts is a command lists acme external accounts for a cert issuer
type ListAcmeAccounts struct {
	// The name of the PKI certificate issuer
	CertIssuerName string `json:"cert-issuer-name"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewListAcmeAccounts instantiates a new ListAcmeAccounts object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewListAcmeAccounts(certIssuerName string, ) *ListAcmeAccounts {
	this := ListAcmeAccounts{}
	this.CertIssuerName = certIssuerName
	var json bool = false
	this.Json = &json
	return &this
}

// NewListAcmeAccountsWithDefaults instantiates a new ListAcmeAccounts object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewListAcmeAccountsWithDefaults() *ListAcmeAccounts {
	this := ListAcmeAccounts{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetCertIssuerName returns the CertIssuerName field value
func (o *ListAcmeAccounts) GetCertIssuerName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.CertIssuerName
}

// GetCertIssuerNameOk returns a tuple with the CertIssuerName field value
// and a boolean to check if the value has been set.
func (o *ListAcmeAccounts) GetCertIssuerNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.CertIssuerName, true
}

// SetCertIssuerName sets field value
func (o *ListAcmeAccounts) SetCertIssuerName(v string) {
	o.CertIssuerName = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *ListAcmeAccounts) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListAcmeAccounts) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *ListAcmeAccounts) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *ListAcmeAccounts) SetJson(v bool) {
	o.Json = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *ListAcmeAccounts) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListAcmeAccounts) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *ListAcmeAccounts) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *ListAcmeAccounts) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *ListAcmeAccounts) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListAcmeAccounts) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *ListAcmeAccounts) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *ListAcmeAccounts) SetUidToken(v string) {
	o.UidToken = &v
}

func (o ListAcmeAccounts) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["cert-issuer-name"] = o.CertIssuerName
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableListAcmeAccounts struct {
	value *ListAcmeAccounts
	isSet bool
}

func (v NullableListAcmeAccounts) Get() *ListAcmeAccounts {
	return v.value
}

func (v *NullableListAcmeAccounts) Set(val *ListAcmeAccounts) {
	v.value = val
	v.isSet = true
}

func (v NullableListAcmeAccounts) IsSet() bool {
	return v.isSet
}

func (v *NullableListAcmeAccounts) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableListAcmeAccounts(val *ListAcmeAccounts) *NullableListAcmeAccounts {
	return &NullableListAcmeAccounts{value: val, isSet: true}
}

func (v NullableListAcmeAccounts) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableListAcmeAccounts) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


